/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.hutool.json.xml;

import org.dromara.hutool.json.JSONException;
import org.dromara.hutool.json.JSONObject;
import org.dromara.hutool.json.xml.JSONXMLParser;
import org.dromara.hutool.json.xml.JSONXMLSerializer;
import org.dromara.hutool.json.xml.ParseConfig;

public class JSONXMLUtil {
    public static JSONObject toJSONObject(String string) throws JSONException {
        return JSONXMLUtil.toJSONObject(string, ParseConfig.of());
    }

    public static JSONObject toJSONObject(String string, ParseConfig parseConfig) throws JSONException {
        return JSONXMLUtil.toJSONObject(string, new JSONObject(), parseConfig);
    }

    public static JSONObject toJSONObject(String xmlStr, JSONObject jo, ParseConfig parseConfig) throws JSONException {
        JSONXMLParser.parseJSONObject(xmlStr, jo, parseConfig);
        return jo;
    }

    public static String toXml(Object object) throws JSONException {
        return JSONXMLUtil.toXml(object, null);
    }

    public static String toXml(Object object, String tagName) throws JSONException {
        return JSONXMLUtil.toXml(object, tagName, "content");
    }

    public static String toXml(Object object, String tagName, String ... contentKeys) throws JSONException {
        return JSONXMLSerializer.toXml(object, tagName, contentKeys);
    }
}

