/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.starter.config;

import cn.hutool.core.util.ObjectUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.dromara.sms4j.api.SmsBlend;
import org.dromara.sms4j.comm.enums.ConfigType;
import org.dromara.sms4j.core.datainterface.SmsReadConfig;
import org.dromara.sms4j.provider.config.SmsConfig;
import org.dromara.sms4j.provider.factory.BaseProviderFactory;
import org.dromara.sms4j.starter.config.SmsBlendsInitializer;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;

public class SupplierConfig {
    @Bean
    @ConfigurationProperties(prefix="sms.blends")
    @ConditionalOnProperty(prefix="sms", name={"config-type"}, havingValue="yaml")
    protected Map<String, Map<String, Object>> blends() {
        return new LinkedHashMap<String, Map<String, Object>>();
    }

    @Bean
    @ConditionalOnBean(value={SmsConfig.class})
    protected List<BaseProviderFactory<? extends SmsBlend, ? extends org.dromara.sms4j.api.universal.SupplierConfig>> factoryList(@Qualifier(value="blends") Map<String, Map<String, Object>> blends, SmsConfig smsConfig) {
        ArrayList<BaseProviderFactory<? extends SmsBlend, ? extends org.dromara.sms4j.api.universal.SupplierConfig>> factoryList = new ArrayList<BaseProviderFactory<? extends SmsBlend, ? extends org.dromara.sms4j.api.universal.SupplierConfig>>();
        if (ConfigType.YAML.equals((Object)smsConfig.getConfigType())) {
            for (String configId : blends.keySet()) {
                Map<String, Object> configMap = blends.get(configId);
                Object factoryPath = configMap.get("factory");
                if (!ObjectUtil.isNotEmpty((Object)factoryPath)) continue;
                Class<?> newClass = Class.forName(factoryPath.toString());
                BaseProviderFactory factory = (BaseProviderFactory)newClass.newInstance();
                factoryList.add((BaseProviderFactory<? extends SmsBlend, ? extends org.dromara.sms4j.api.universal.SupplierConfig>)factory);
            }
        }
        return factoryList;
    }

    @Bean
    protected SmsBlendsInitializer smsBlendsInitializer(List<BaseProviderFactory<? extends SmsBlend, ? extends org.dromara.sms4j.api.universal.SupplierConfig>> factoryList, SmsConfig smsConfig, @Qualifier(value="blends") Map<String, Map<String, Object>> blends, ObjectProvider<SmsReadConfig> extendsSmsConfigs) {
        return new SmsBlendsInitializer(factoryList, smsConfig, blends, extendsSmsConfigs);
    }
}

