/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.impl.authentication;

import org.apache.commons.codec.digest.DigestUtils;
import org.flowable.idm.api.PasswordEncoder;
import org.flowable.idm.api.PasswordSalt;

public class ApacheDigester
implements PasswordEncoder {
    private Digester digester;

    public ApacheDigester(Digester digester) {
        this.digester = digester;
    }

    public String encode(CharSequence rawPassword, PasswordSalt passwordSalt) {
        return this.encodePassword(rawPassword, passwordSalt);
    }

    public boolean isMatches(CharSequence rawPassword, String encodedPassword, PasswordSalt salt) {
        return null == encodedPassword || encodedPassword.equals(this.encodePassword(rawPassword, salt));
    }

    public Digester getDigester() {
        return this.digester;
    }

    private String encodePassword(CharSequence rawPassword, PasswordSalt passwordSalt) {
        String salt = rawPassword + passwordSalt.getSource().getSalt();
        switch (this.digester) {
            case MD5: {
                return DigestUtils.md5Hex((String)salt);
            }
            case SHA: {
                return DigestUtils.sha1Hex((String)salt);
            }
            case SHA256: {
                return DigestUtils.sha256Hex((String)salt);
            }
            case SHA348: {
                return DigestUtils.sha384Hex((String)salt);
            }
            case SHA512: {
                return DigestUtils.sha512Hex((String)salt);
            }
        }
        return null;
    }

    public static enum Digester {
        MD5,
        SHA,
        SHA256,
        SHA348,
        SHA512;

    }
}

