/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.asyncexecutor;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.api.FlowableException;
import org.flowable.common.engine.api.FlowableIllegalArgumentException;
import org.flowable.common.engine.api.delegate.event.FlowableEngineEventType;
import org.flowable.common.engine.api.delegate.event.FlowableEvent;
import org.flowable.common.engine.api.delegate.event.FlowableEventDispatcher;
import org.flowable.common.engine.api.variable.VariableContainer;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.calendar.BusinessCalendar;
import org.flowable.common.engine.impl.cfg.TransactionContext;
import org.flowable.common.engine.impl.cfg.TransactionListener;
import org.flowable.common.engine.impl.cfg.TransactionState;
import org.flowable.common.engine.impl.context.Context;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.common.engine.impl.interceptor.CommandContextCloseListener;
import org.flowable.common.engine.impl.persistence.entity.ByteArrayEntity;
import org.flowable.common.engine.impl.persistence.entity.ByteArrayRef;
import org.flowable.job.api.HistoryJob;
import org.flowable.job.api.Job;
import org.flowable.job.api.JobInfo;
import org.flowable.job.service.HistoryJobHandler;
import org.flowable.job.service.HistoryJobProcessorContext;
import org.flowable.job.service.JobHandler;
import org.flowable.job.service.JobProcessorContext;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.event.impl.FlowableJobEventBuilder;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.job.service.impl.asyncexecutor.AsyncJobAddedNotification;
import org.flowable.job.service.impl.asyncexecutor.JobAddedTransactionListener;
import org.flowable.job.service.impl.asyncexecutor.JobManager;
import org.flowable.job.service.impl.history.async.TriggerAsyncHistoryExecutorTransactionListener;
import org.flowable.job.service.impl.persistence.entity.AbstractJobEntity;
import org.flowable.job.service.impl.persistence.entity.AbstractRuntimeJobEntity;
import org.flowable.job.service.impl.persistence.entity.DeadLetterJobEntity;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntity;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntity;
import org.flowable.job.service.impl.persistence.entity.HistoryJobEntityManager;
import org.flowable.job.service.impl.persistence.entity.JobEntity;
import org.flowable.job.service.impl.persistence.entity.JobInfoEntity;
import org.flowable.job.service.impl.persistence.entity.SuspendedJobEntity;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;
import org.flowable.job.service.impl.util.CommandContextUtil;
import org.flowable.job.service.impl.util.JobProcessorUtil;
import org.flowable.variable.api.delegate.VariableScope;
import org.flowable.variable.service.impl.el.NoExecutionVariableScope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJobManager
implements JobManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultJobManager.class);
    public static final String CYCLE_TYPE = "cycle";
    protected JobServiceConfiguration jobServiceConfiguration;

    public DefaultJobManager(JobServiceConfiguration jobServiceConfiguration) {
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    @Override
    public void createAsyncJob(JobEntity jobEntity, boolean exclusive) {
        if (this.isJobApplicableForExecutorExecution(jobEntity)) {
            this.internalCreateLockedAsyncJob(jobEntity, exclusive);
        } else {
            this.internalCreateAsyncJob(jobEntity, exclusive);
        }
    }

    @Override
    public void scheduleAsyncJob(JobEntity jobEntity) {
        this.callJobProcessors(JobProcessorContext.Phase.BEFORE_CREATE, jobEntity);
        this.jobServiceConfiguration.getJobEntityManager().insert(jobEntity);
        this.triggerExecutorIfNeeded(jobEntity);
    }

    protected void triggerExecutorIfNeeded(JobEntity jobEntity) {
        if (this.isJobApplicableForExecutorExecution(jobEntity)) {
            this.hintAsyncExecutor(jobEntity);
        }
    }

    protected boolean isJobApplicableForExecutorExecution(JobEntity jobEntity) {
        if (!this.isAsyncExecutorActive()) {
            return false;
        }
        List<String> enabledJobCategories = this.jobServiceConfiguration.getEnabledJobCategories();
        if (enabledJobCategories == null || enabledJobCategories.isEmpty()) {
            return true;
        }
        String category = jobEntity.getCategory();
        if (StringUtils.isEmpty((CharSequence)category)) {
            return false;
        }
        return enabledJobCategories.contains(category);
    }

    @Override
    public void scheduleTimerJob(TimerJobEntity timerJob) {
        this.jobServiceConfiguration.getTimerJobScheduler().scheduleTimerJob(timerJob);
    }

    @Override
    public JobEntity moveTimerJobToExecutableJob(TimerJobEntity timerJob) {
        if (timerJob == null) {
            throw new FlowableException("Empty timer job can not be scheduled");
        }
        JobEntity executableJob = this.createExecutableJobFromOtherJob(timerJob);
        boolean insertSuccessful = this.jobServiceConfiguration.getJobEntityManager().insertJobEntity(executableJob);
        if (insertSuccessful) {
            this.jobServiceConfiguration.getTimerJobEntityManager().delete(timerJob);
            this.triggerExecutorIfNeeded(executableJob);
            return executableJob;
        }
        return null;
    }

    @Override
    public void bulkMoveTimerJobsToExecutableJobs(List<TimerJobEntity> timerJobEntities) {
        if (timerJobEntities == null || timerJobEntities.isEmpty()) {
            throw new FlowableException("Empty timer jobs collection can not be scheduled");
        }
        boolean remainingCapacitySufficient = this.isAsyncExecutorRemainingCapacitySufficient(timerJobEntities.size());
        for (TimerJobEntity timerJobEntity : timerJobEntities) {
            JobEntity executableJob = this.createExecutableJobFromOtherJob(timerJobEntity, remainingCapacitySufficient);
            boolean insertSuccessful = this.jobServiceConfiguration.getJobEntityManager().insertJobEntity(executableJob);
            if (!insertSuccessful || !remainingCapacitySufficient) continue;
            this.triggerExecutorIfNeeded(executableJob);
        }
        this.jobServiceConfiguration.getTimerJobEntityManager().bulkDeleteTimerJobsWithoutRevisionCheck(timerJobEntities);
    }

    @Override
    public JobEntity moveExternalWorkerJobToExecutableJob(ExternalWorkerJobEntity externalWorkerJob) {
        if (externalWorkerJob == null) {
            throw new FlowableException("Empty external worker job can not be scheduled");
        }
        JobEntity executableJob = this.createExecutableJobFromOtherJob(externalWorkerJob);
        this.fillDefaultAsyncJobInfo(executableJob, executableJob.isExclusive());
        boolean insertSuccessful = this.jobServiceConfiguration.getJobEntityManager().insertJobEntity(executableJob);
        if (insertSuccessful) {
            this.jobServiceConfiguration.getExternalWorkerJobEntityManager().delete(externalWorkerJob);
            this.triggerExecutorIfNeeded(executableJob);
            return executableJob;
        }
        return null;
    }

    @Override
    public TimerJobEntity moveJobToTimerJob(AbstractRuntimeJobEntity job) {
        TimerJobEntity timerJob = this.createTimerJobFromOtherJob(job);
        boolean insertSuccessful = this.jobServiceConfiguration.getTimerJobEntityManager().insertTimerJobEntity(timerJob);
        if (insertSuccessful) {
            if (job instanceof JobEntity) {
                this.jobServiceConfiguration.getJobEntityManager().delete((JobEntity)job);
            } else if (job instanceof SuspendedJobEntity) {
                this.jobServiceConfiguration.getSuspendedJobEntityManager().delete((SuspendedJobEntity)job);
            }
            return timerJob;
        }
        return null;
    }

    @Override
    public SuspendedJobEntity moveJobToSuspendedJob(AbstractRuntimeJobEntity job) {
        SuspendedJobEntity suspendedJob = this.createSuspendedJobFromOtherJob(job);
        this.jobServiceConfiguration.getSuspendedJobEntityManager().insert(suspendedJob);
        if (job instanceof TimerJobEntity) {
            this.jobServiceConfiguration.getTimerJobEntityManager().delete((TimerJobEntity)job);
        } else if (job instanceof JobEntity) {
            this.jobServiceConfiguration.getJobEntityManager().delete((JobEntity)job);
        } else if (job instanceof ExternalWorkerJobEntity) {
            this.jobServiceConfiguration.getExternalWorkerJobEntityManager().delete((ExternalWorkerJobEntity)job);
        }
        return suspendedJob;
    }

    @Override
    public AbstractRuntimeJobEntity activateSuspendedJob(SuspendedJobEntity job) {
        JobInfoEntity activatedJob = null;
        if ("timer".equals(job.getJobType())) {
            activatedJob = this.createTimerJobFromOtherJob(job);
            this.jobServiceConfiguration.getTimerJobEntityManager().insert(activatedJob);
        } else if ("externalWorker".equals(job.getJobType())) {
            activatedJob = this.createExternalWorkerJobFromOtherJob(job);
            this.jobServiceConfiguration.getExternalWorkerJobEntityManager().insert((ExternalWorkerJobEntity)activatedJob);
        } else {
            activatedJob = this.createExecutableJobFromOtherJob(job);
            JobEntity jobEntity = (JobEntity)activatedJob;
            this.jobServiceConfiguration.getJobEntityManager().insert(jobEntity);
            this.triggerExecutorIfNeeded(jobEntity);
        }
        this.jobServiceConfiguration.getSuspendedJobEntityManager().delete(job);
        return activatedJob;
    }

    @Override
    public DeadLetterJobEntity moveJobToDeadLetterJob(AbstractRuntimeJobEntity job) {
        DeadLetterJobEntity deadLetterJob = this.createDeadLetterJobFromOtherJob(job);
        this.jobServiceConfiguration.getDeadLetterJobEntityManager().insert(deadLetterJob);
        if (job instanceof TimerJobEntity) {
            this.jobServiceConfiguration.getTimerJobEntityManager().delete((TimerJobEntity)job);
        } else if (job instanceof JobEntity) {
            this.jobServiceConfiguration.getJobEntityManager().delete((JobEntity)job);
        } else if (job instanceof ExternalWorkerJobEntity) {
            this.jobServiceConfiguration.getExternalWorkerJobEntityManager().delete((ExternalWorkerJobEntity)job);
        } else {
            throw new FlowableIllegalArgumentException("Cannot move the job to deadletter: the job is not a timer, async job or external worker job");
        }
        return deadLetterJob;
    }

    protected void sendMoveToDeadletterEvent(JobInfo job) {
        FlowableEventDispatcher eventDispatcher = this.jobServiceConfiguration.getEventDispatcher();
        if (eventDispatcher != null && eventDispatcher.isEnabled()) {
            eventDispatcher.dispatchEvent((FlowableEvent)FlowableJobEventBuilder.createEntityEvent(FlowableEngineEventType.JOB_MOVED_TO_DEADLETTER, job), this.jobServiceConfiguration.getEngineName());
        }
    }

    @Override
    public Job moveDeadLetterJobToExecutableJob(DeadLetterJobEntity deadLetterJobEntity, int retries) {
        if (deadLetterJobEntity == null) {
            throw new FlowableIllegalArgumentException("Null job provided");
        }
        if ("historyJob".equals(deadLetterJobEntity.getJobType())) {
            throw new FlowableIllegalArgumentException("Cannot move a history job to an executable job");
        }
        if ("externalWorker".equals(deadLetterJobEntity.getJobType())) {
            ExternalWorkerJobEntity externalWorkerJob = this.createExternalWorkerJobFromOtherJob(deadLetterJobEntity);
            externalWorkerJob.setRetries(retries);
            boolean insertSuccessful = this.jobServiceConfiguration.getExternalWorkerJobEntityManager().insertExternalWorkerJobEntity(externalWorkerJob);
            if (insertSuccessful) {
                this.jobServiceConfiguration.getDeadLetterJobEntityManager().delete(deadLetterJobEntity);
                return externalWorkerJob;
            }
        } else {
            JobEntity executableJob = this.createExecutableJobFromOtherJob(deadLetterJobEntity);
            executableJob.setRetries(retries);
            boolean insertSuccessful = this.jobServiceConfiguration.getJobEntityManager().insertJobEntity(executableJob);
            if (insertSuccessful) {
                this.jobServiceConfiguration.getDeadLetterJobEntityManager().delete(deadLetterJobEntity);
                this.triggerExecutorIfNeeded(executableJob);
                return executableJob;
            }
        }
        return null;
    }

    @Override
    public HistoryJobEntity moveDeadLetterJobToHistoryJob(DeadLetterJobEntity deadLetterJobEntity, int retries) {
        if (deadLetterJobEntity == null) {
            throw new FlowableIllegalArgumentException("Null job provided");
        }
        if (!"historyJob".equals(deadLetterJobEntity.getJobType())) {
            throw new FlowableIllegalArgumentException("Can only move a history job to a history job");
        }
        HistoryJobEntityManager historyJobEntityManager = this.jobServiceConfiguration.getHistoryJobEntityManager();
        HistoryJobEntity historyJobEntity = (HistoryJobEntity)historyJobEntityManager.create();
        this.copyHistoryJobProperties(historyJobEntity, deadLetterJobEntity);
        historyJobEntity.setRetries(retries);
        historyJobEntity.setJobHandlerConfiguration(null);
        ByteArrayEntity byteArrayEntity = (ByteArrayEntity)((AbstractEngineConfiguration)this.getCommandContext().getEngineConfigurations().get(this.jobServiceConfiguration.getEngineName())).getByteArrayEntityManager().findById(deadLetterJobEntity.getJobHandlerConfiguration());
        historyJobEntity.setAdvancedJobHandlerConfigurationBytes(byteArrayEntity.getBytes());
        historyJobEntityManager.insert(historyJobEntity);
        this.jobServiceConfiguration.getDeadLetterJobEntityManager().delete(deadLetterJobEntity);
        return historyJobEntity;
    }

    @Override
    public void execute(JobInfo job) {
        if (job instanceof HistoryJobEntity) {
            this.callHistoryJobProcessors(HistoryJobProcessorContext.Phase.BEFORE_EXECUTE, (HistoryJobEntity)job);
            this.executeHistoryJob((HistoryJobEntity)job);
        } else if (job instanceof JobEntity) {
            this.callJobProcessors(JobProcessorContext.Phase.BEFORE_EXECUTE, (JobEntity)job);
            if ("message".equals(((Job)job).getJobType())) {
                this.executeMessageJob((JobEntity)job);
            } else if ("timer".equals(((Job)job).getJobType())) {
                this.executeTimerJob((JobEntity)job);
            }
        } else {
            throw new FlowableException("Only jobs with type JobEntity are supported to be executed. It was " + job);
        }
    }

    @Override
    public void unacquire(JobInfo job) {
        if (job instanceof HistoryJob) {
            HistoryJobEntity jobEntity = (HistoryJobEntity)this.jobServiceConfiguration.getHistoryJobEntityManager().findById(job.getId());
            if (jobEntity == null) {
                LOGGER.debug("History Job {} does not exist anymore and will not be unacquired. It has most likely been deleted e.g. as part of another concurrent part of a process / case instance.", (Object)job.getId());
                return;
            }
            jobEntity.setLockExpirationTime(null);
            jobEntity.setLockOwner(null);
        } else if (job instanceof JobEntity) {
            JobEntity jobEntity = (JobEntity)this.jobServiceConfiguration.getJobEntityManager().findById(job.getId());
            if (jobEntity == null) {
                LOGGER.debug("Async Job {} does not exist anymore and will not be unacquired. It has most likely been deleted e.g. as part of another concurrent part of a process / case instance.", (Object)job.getId());
                return;
            }
            jobEntity.setLockExpirationTime(null);
            jobEntity.setLockOwner(null);
        } else if (job instanceof ExternalWorkerJobEntity) {
            ExternalWorkerJobEntity jobEntity = (ExternalWorkerJobEntity)this.jobServiceConfiguration.getExternalWorkerJobEntityManager().findById(job.getId());
            if (jobEntity == null) {
                LOGGER.debug("External Worker Job {} does not exist anymore and will not be unacquired. It has most likely been deleted e.g. as part of another concurrent part of a process / case instance.", (Object)job.getId());
                return;
            }
            jobEntity.setLockExpirationTime(null);
            jobEntity.setLockOwner(null);
        } else if (job instanceof TimerJobEntity) {
            this.jobServiceConfiguration.getTimerJobEntityManager().resetExpiredJob(job.getId());
        } else if (job != null) {
            this.jobServiceConfiguration.getJobEntityManager().resetExpiredJob(job.getId());
        } else {
            throw new FlowableException("Programmatic error: null job passed");
        }
    }

    @Override
    public void unacquireWithDecrementRetries(JobInfo job, Throwable exception) {
        if (job instanceof HistoryJob) {
            HistoryJobEntity historyJobEntity = (HistoryJobEntity)job;
            HistoryJobEntity newHistoryJobEntity = (HistoryJobEntity)this.jobServiceConfiguration.getHistoryJobEntityManager().create();
            this.copyHistoryJobInfo(newHistoryJobEntity, historyJobEntity);
            newHistoryJobEntity.setId(null);
            newHistoryJobEntity.setLockExpirationTime(null);
            newHistoryJobEntity.setLockOwner(null);
            newHistoryJobEntity.setCreateTime(this.jobServiceConfiguration.getClock().getCurrentTime());
            if (exception != null) {
                newHistoryJobEntity.setExceptionMessage(exception.getMessage());
                newHistoryJobEntity.setExceptionStacktrace(this.getExceptionStacktrace(exception));
            }
            if (historyJobEntity.getRetries() > 0) {
                newHistoryJobEntity.setRetries(newHistoryJobEntity.getRetries() - 1);
                this.jobServiceConfiguration.getHistoryJobEntityManager().insert(newHistoryJobEntity);
            } else {
                DeadLetterJobEntity deadLetterJob = this.createDeadLetterJobFromHistoryJob(newHistoryJobEntity);
                if (exception != null) {
                    deadLetterJob.setExceptionMessage(exception.getMessage());
                    if (deadLetterJob.getExceptionByteArrayRef() != null) {
                        deadLetterJob.getExceptionByteArrayRef().delete(this.jobServiceConfiguration.getEngineName());
                        deadLetterJob.setExceptionByteArrayRef(null);
                    }
                    deadLetterJob.setExceptionStacktrace(this.getExceptionStacktrace(exception));
                }
                this.jobServiceConfiguration.getDeadLetterJobEntityManager().insert(deadLetterJob);
            }
            this.jobServiceConfiguration.getHistoryJobEntityManager().deleteNoCascade(historyJobEntity);
        } else {
            JobEntity jobEntity = (JobEntity)job;
            JobEntity newJobEntity = (JobEntity)this.jobServiceConfiguration.getJobEntityManager().create();
            this.copyJobInfo(newJobEntity, jobEntity);
            newJobEntity.setId(null);
            newJobEntity.setLockExpirationTime(null);
            newJobEntity.setLockOwner(null);
            if (exception != null) {
                newJobEntity.setExceptionMessage(exception.getMessage());
                newJobEntity.setExceptionStacktrace(this.getExceptionStacktrace(exception));
            }
            if (newJobEntity.getRetries() > 0) {
                newJobEntity.setRetries(newJobEntity.getRetries() - 1);
                this.jobServiceConfiguration.getJobEntityManager().insert(newJobEntity);
            } else {
                DeadLetterJobEntity deadLetterJob = this.createDeadLetterJobFromOtherJob(newJobEntity);
                if (exception != null) {
                    deadLetterJob.setExceptionMessage(exception.getMessage());
                    deadLetterJob.setExceptionStacktrace(this.getExceptionStacktrace(exception));
                }
                this.jobServiceConfiguration.getDeadLetterJobEntityManager().insert(deadLetterJob);
            }
            this.jobServiceConfiguration.getJobEntityManager().delete(jobEntity.getId());
        }
    }

    @Override
    public void deleteExecutableJob(JobInfo job) {
        if (job instanceof JobEntity) {
            this.jobServiceConfiguration.getJobEntityManager().delete((JobEntity)job);
        }
    }

    protected String getExceptionStacktrace(Throwable exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    protected void executeMessageJob(JobEntity jobEntity) {
        this.executeJobHandler(jobEntity);
        if (jobEntity.getId() != null) {
            this.jobServiceConfiguration.getJobEntityManager().delete(jobEntity);
        }
    }

    protected void executeHistoryJob(HistoryJobEntity historyJobEntity) {
        this.executeHistoryJobHandler(historyJobEntity);
        if (historyJobEntity.getId() != null) {
            this.jobServiceConfiguration.getHistoryJobEntityManager().delete(historyJobEntity);
        }
    }

    protected void executeTimerJob(JobEntity timerEntity) {
        NoExecutionVariableScope variableScope = null;
        if (this.jobServiceConfiguration.getInternalJobManager() != null) {
            variableScope = this.jobServiceConfiguration.getInternalJobManager().resolveVariableScope(timerEntity);
        }
        if (variableScope == null) {
            variableScope = NoExecutionVariableScope.getSharedInstance();
        }
        if (this.jobServiceConfiguration.getInternalJobManager() != null) {
            this.jobServiceConfiguration.getInternalJobManager().preTimerJobDelete(timerEntity, (VariableScope)variableScope);
        }
        if (timerEntity.getDuedate() != null && !this.isValidTime(timerEntity, timerEntity.getDuedate(), (VariableScope)variableScope)) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Timer {} fired. but the dueDate is after the endDate.  Deleting timer.", (Object)timerEntity.getId());
            }
            this.jobServiceConfiguration.getJobEntityManager().delete(timerEntity);
            return;
        }
        this.executeJobHandler(timerEntity);
        this.jobServiceConfiguration.getJobEntityManager().delete(timerEntity);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Timer {} fired. Deleting timer.", (Object)timerEntity.getId());
        }
        this.jobServiceConfiguration.getTimerJobScheduler().rescheduleTimerJobAfterExecution(timerEntity, (VariableScope)variableScope);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeJobHandler(JobEntity jobEntity) {
        NoExecutionVariableScope variableScope = null;
        if (this.jobServiceConfiguration.getInternalJobManager() != null) {
            variableScope = this.jobServiceConfiguration.getInternalJobManager().resolveVariableScope(jobEntity);
        }
        if (variableScope == null) {
            variableScope = NoExecutionVariableScope.getSharedInstance();
        }
        Map<String, JobHandler> jobHandlers = this.jobServiceConfiguration.getJobHandlers();
        if (jobEntity.getJobHandlerType() == null) throw new FlowableException(jobEntity + " has no job handler type in job config for engine: " + this.jobServiceConfiguration.getEngineName());
        if (jobHandlers == null) throw new FlowableException("No job handler registered for type " + jobEntity.getJobHandlerType() + " in job config for engine: " + this.jobServiceConfiguration.getEngineName() + " for " + jobEntity);
        JobHandler jobHandler = jobHandlers.get(jobEntity.getJobHandlerType());
        if (jobHandler == null) {
            throw new FlowableException("No job handler registered for type " + jobEntity.getJobHandlerType() + " in job config for engine: " + this.jobServiceConfiguration.getEngineName() + " for " + jobEntity);
        }
        jobHandler.execute(jobEntity, jobEntity.getJobHandlerConfiguration(), (VariableScope)variableScope, this.getCommandContext());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void executeHistoryJobHandler(HistoryJobEntity historyJobEntity) {
        Map<String, HistoryJobHandler> jobHandlers = this.jobServiceConfiguration.getHistoryJobHandlers();
        if (historyJobEntity.getJobHandlerType() == null) throw new FlowableException("Async " + historyJobEntity + " has no job handler type in job config for engine: " + this.jobServiceConfiguration.getEngineName());
        if (jobHandlers == null) throw new FlowableException("No history job handler registered for type " + historyJobEntity.getJobHandlerType() + " in job config for engine: " + this.jobServiceConfiguration.getEngineName() + " for " + historyJobEntity);
        HistoryJobHandler jobHandler = jobHandlers.get(historyJobEntity.getJobHandlerType());
        if (jobHandler == null) {
            throw new FlowableException("No history job handler registered for type " + historyJobEntity.getJobHandlerType() + " in job config for engine: " + this.jobServiceConfiguration.getEngineName() + " for " + historyJobEntity);
        }
        jobHandler.execute(historyJobEntity, historyJobEntity.getJobHandlerConfiguration(), this.getCommandContext(), this.jobServiceConfiguration);
    }

    protected boolean isValidTime(JobEntity timerEntity, Date newTimerDate, VariableScope variableScope) {
        BusinessCalendar businessCalendar = this.jobServiceConfiguration.getBusinessCalendarManager().getBusinessCalendar(this.getBusinessCalendarName(timerEntity, variableScope));
        return businessCalendar.validateDuedate(timerEntity.getRepeat(), timerEntity.getMaxIterations(), timerEntity.getEndDate(), newTimerDate);
    }

    protected void hintAsyncExecutor(JobEntity job) {
        if (job.getLockOwner() == null || job.getLockExpirationTime() == null) {
            this.createAsyncJob(job, job.isExclusive());
        }
        this.createHintListeners(this.getAsyncExecutor(), job);
    }

    protected void createHintListeners(AsyncExecutor asyncExecutor, JobInfoEntity job) {
        CommandContext commandContext = CommandContextUtil.getCommandContext();
        if (Context.getTransactionContext() != null) {
            JobAddedTransactionListener jobAddedTransactionListener = new JobAddedTransactionListener(job, asyncExecutor, this.jobServiceConfiguration.getCommandExecutor());
            Context.getTransactionContext().addTransactionListener(TransactionState.COMMITTED, (TransactionListener)jobAddedTransactionListener);
        } else {
            AsyncJobAddedNotification jobAddedNotification = new AsyncJobAddedNotification(job, asyncExecutor);
            commandContext.addCloseListener((CommandContextCloseListener)jobAddedNotification);
        }
    }

    @Override
    public String getBusinessCalendarName(JobEntity timerEntity, VariableScope variableScope) {
        String calendarValue = null;
        if (StringUtils.isNotEmpty((CharSequence)timerEntity.getJobHandlerConfiguration())) {
            try {
                JsonNode jobConfigNode = this.jobServiceConfiguration.getObjectMapper().readTree(timerEntity.getJobHandlerConfiguration());
                JsonNode calendarNameNode = jobConfigNode.get("calendarName");
                if (calendarNameNode != null && !calendarNameNode.isNull()) {
                    calendarValue = calendarNameNode.asText();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.getBusinessCalendarName(calendarValue, variableScope);
    }

    protected String getBusinessCalendarName(String calendarName, VariableScope variableScope) {
        String businessCalendarName = CYCLE_TYPE;
        if (StringUtils.isNotEmpty((CharSequence)calendarName)) {
            businessCalendarName = (String)this.jobServiceConfiguration.getExpressionManager().createExpression(calendarName).getValue((VariableContainer)variableScope);
        }
        return businessCalendarName;
    }

    @Override
    public HistoryJobEntity scheduleHistoryJob(HistoryJobEntity historyJobEntity, TransactionContext transactionContext) {
        this.callHistoryJobProcessors(HistoryJobProcessorContext.Phase.BEFORE_CREATE, historyJobEntity);
        this.jobServiceConfiguration.getHistoryJobEntityManager().insert(historyJobEntity);
        this.triggerAsyncHistoryExecutorIfNeeded(historyJobEntity, transactionContext);
        return historyJobEntity;
    }

    protected void triggerAsyncHistoryExecutorIfNeeded(HistoryJobEntity historyJobEntity, TransactionContext transactionContext) {
        if (this.isAsyncHistoryExecutorActive()) {
            this.hintAsyncHistoryExecutor(historyJobEntity, transactionContext);
        }
    }

    protected void hintAsyncHistoryExecutor(HistoryJobEntity historyJobEntity, TransactionContext transactionContext) {
        if (historyJobEntity.getLockOwner() == null || historyJobEntity.getLockExpirationTime() == null) {
            this.setLockTimeAndOwner(this.getAsyncHistoryExecutor(), historyJobEntity);
        }
        this.createAsyncHistoryHintListeners(historyJobEntity, transactionContext);
    }

    protected void createAsyncHistoryHintListeners(HistoryJobEntity historyJobEntity, TransactionContext transactionContext) {
        if (transactionContext != null) {
            transactionContext.addTransactionListener(TransactionState.COMMITTED, (TransactionListener)new TriggerAsyncHistoryExecutorTransactionListener(this.jobServiceConfiguration, historyJobEntity));
        }
    }

    protected void internalCreateAsyncJob(JobEntity jobEntity, boolean exclusive) {
        this.fillDefaultAsyncJobInfo(jobEntity, exclusive);
    }

    protected void internalCreateLockedAsyncJob(JobEntity jobEntity, boolean exclusive) {
        this.fillDefaultAsyncJobInfo(jobEntity, exclusive);
        this.setLockTimeAndOwner(this.getAsyncExecutor(), jobEntity);
    }

    protected void setLockTimeAndOwner(AsyncExecutor asyncExecutor, JobInfoEntity jobInfoEntity) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(this.jobServiceConfiguration.getClock().getCurrentTime());
        gregorianCalendar.add(14, asyncExecutor.getAsyncJobLockTimeInMillis());
        jobInfoEntity.setLockExpirationTime(gregorianCalendar.getTime());
        jobInfoEntity.setLockOwner(asyncExecutor.getLockOwner());
    }

    protected void fillDefaultAsyncJobInfo(JobEntity jobEntity, boolean exclusive) {
        jobEntity.setJobType("message");
        jobEntity.setRevision(1);
        jobEntity.setRetries(this.jobServiceConfiguration.getAsyncExecutorNumberOfRetries());
        jobEntity.setExclusive(exclusive);
    }

    @Override
    public JobEntity createExecutableJobFromOtherJob(AbstractRuntimeJobEntity job) {
        return this.createExecutableJobFromOtherJob(job, this.isAsyncExecutorActive());
    }

    protected JobEntity createExecutableJobFromOtherJob(AbstractRuntimeJobEntity job, boolean lockJob) {
        JobEntity executableJob = (JobEntity)this.jobServiceConfiguration.getJobEntityManager().create();
        this.copyJobInfo(executableJob, job);
        if (lockJob) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTime(this.jobServiceConfiguration.getClock().getCurrentTime());
            gregorianCalendar.add(14, this.getAsyncExecutor().getAsyncJobLockTimeInMillis());
            executableJob.setLockExpirationTime(gregorianCalendar.getTime());
            executableJob.setLockOwner(this.getAsyncExecutor().getLockOwner());
        }
        return executableJob;
    }

    @Override
    public TimerJobEntity createTimerJobFromOtherJob(AbstractRuntimeJobEntity otherJob) {
        TimerJobEntity timerJob = (TimerJobEntity)this.jobServiceConfiguration.getTimerJobEntityManager().create();
        this.copyJobInfo(timerJob, otherJob);
        return timerJob;
    }

    @Override
    public SuspendedJobEntity createSuspendedJobFromOtherJob(AbstractRuntimeJobEntity otherJob) {
        SuspendedJobEntity suspendedJob = (SuspendedJobEntity)this.jobServiceConfiguration.getSuspendedJobEntityManager().create();
        this.copyJobInfo(suspendedJob, otherJob);
        return suspendedJob;
    }

    @Override
    public DeadLetterJobEntity createDeadLetterJobFromOtherJob(AbstractRuntimeJobEntity otherJob) {
        DeadLetterJobEntity deadLetterJob = (DeadLetterJobEntity)this.jobServiceConfiguration.getDeadLetterJobEntityManager().create();
        this.copyJobInfo(deadLetterJob, otherJob);
        this.sendMoveToDeadletterEvent((JobInfo)otherJob);
        return deadLetterJob;
    }

    @Override
    public DeadLetterJobEntity createDeadLetterJobFromHistoryJob(HistoryJobEntity historyJobEntity) {
        DeadLetterJobEntity deadLetterJob = (DeadLetterJobEntity)this.jobServiceConfiguration.getDeadLetterJobEntityManager().create();
        deadLetterJob.setJobType("historyJob");
        this.copyHistoryJobProperties(deadLetterJob, historyJobEntity);
        if (historyJobEntity.getAdvancedJobHandlerConfigurationByteArrayRef() != null) {
            deadLetterJob.setJobHandlerConfiguration(historyJobEntity.getAdvancedJobHandlerConfigurationByteArrayRef().getId());
        }
        this.sendMoveToDeadletterEvent(historyJobEntity);
        return deadLetterJob;
    }

    @Override
    public ExternalWorkerJobEntity createExternalWorkerJobFromOtherJob(AbstractRuntimeJobEntity otherJob) {
        ExternalWorkerJobEntity externalWorkerJob = (ExternalWorkerJobEntity)this.jobServiceConfiguration.getExternalWorkerJobEntityManager().create();
        this.copyJobInfo(externalWorkerJob, otherJob);
        return externalWorkerJob;
    }

    @Override
    public AbstractRuntimeJobEntity copyJobInfo(AbstractRuntimeJobEntity copyToJob, AbstractRuntimeJobEntity copyFromJob) {
        copyToJob.setDuedate(copyFromJob.getDuedate());
        copyToJob.setEndDate(copyFromJob.getEndDate());
        copyToJob.setExclusive(copyFromJob.isExclusive());
        copyToJob.setExecutionId(copyFromJob.getExecutionId());
        copyToJob.setId(copyFromJob.getId());
        copyToJob.setProcessDefinitionId(copyFromJob.getProcessDefinitionId());
        copyToJob.setElementId(copyFromJob.getElementId());
        copyToJob.setElementName(copyFromJob.getElementName());
        copyToJob.setProcessInstanceId(copyFromJob.getProcessInstanceId());
        copyToJob.setScopeId(copyFromJob.getScopeId());
        copyToJob.setSubScopeId(copyFromJob.getSubScopeId());
        copyToJob.setScopeType(copyFromJob.getScopeType());
        copyToJob.setScopeDefinitionId(copyFromJob.getScopeDefinitionId());
        copyToJob.setJobHandlerConfiguration(copyFromJob.getJobHandlerConfiguration());
        copyToJob.setCustomValues(copyFromJob.getCustomValues());
        copyToJob.setJobHandlerType(copyFromJob.getJobHandlerType());
        copyToJob.setCategory(copyFromJob.getCategory());
        copyToJob.setJobType(copyFromJob.getJobType());
        copyToJob.setExceptionMessage(copyFromJob.getExceptionMessage());
        copyToJob.setExceptionStacktrace(copyFromJob.getExceptionStacktrace());
        copyToJob.setMaxIterations(copyFromJob.getMaxIterations());
        copyToJob.setRepeat(copyFromJob.getRepeat());
        copyToJob.setRetries(copyFromJob.getRetries());
        copyToJob.setRevision(copyFromJob.getRevision());
        copyToJob.setTenantId(copyFromJob.getTenantId());
        if (copyFromJob.getCorrelationId() != null) {
            copyToJob.setCorrelationId(copyFromJob.getCorrelationId());
        } else {
            copyToJob.setCorrelationId(this.jobServiceConfiguration.getIdGenerator().getNextId());
        }
        return copyToJob;
    }

    protected HistoryJobEntity copyHistoryJobInfo(HistoryJobEntity copyToJob, HistoryJobEntity copyFromJob) {
        this.copyHistoryJobProperties(copyToJob, copyFromJob);
        if (copyFromJob.getAdvancedJobHandlerConfigurationByteArrayRef() != null) {
            ByteArrayRef configurationByteArrayRefCopy = copyFromJob.getAdvancedJobHandlerConfigurationByteArrayRef().copy();
            copyToJob.setAdvancedJobHandlerConfigurationByteArrayRef(configurationByteArrayRefCopy);
        }
        return copyToJob;
    }

    protected AbstractJobEntity copyHistoryJobProperties(AbstractJobEntity copyToJob, AbstractJobEntity copyFromJob) {
        copyToJob.setId(copyFromJob.getId());
        copyToJob.setScopeType(copyFromJob.getScopeType());
        copyToJob.setCreateTime(copyFromJob.getCreateTime());
        copyToJob.setJobHandlerConfiguration(copyFromJob.getJobHandlerConfiguration());
        if (copyFromJob.getExceptionByteArrayRef() != null) {
            ByteArrayRef exceptionByteArrayRefCopy = copyFromJob.getExceptionByteArrayRef();
            copyToJob.setExceptionByteArrayRef(exceptionByteArrayRefCopy);
        }
        if (copyFromJob.getCustomValuesByteArrayRef() != null) {
            ByteArrayRef customValuesByteArrayRefCopy = copyFromJob.getCustomValuesByteArrayRef().copy();
            copyToJob.setCustomValuesByteArrayRef(customValuesByteArrayRefCopy);
        }
        copyToJob.setJobHandlerType(copyFromJob.getJobHandlerType());
        copyToJob.setExceptionMessage(copyFromJob.getExceptionMessage());
        copyToJob.setExceptionStacktrace(copyFromJob.getExceptionStacktrace());
        copyToJob.setCustomValues(copyFromJob.getCustomValues());
        copyToJob.setRetries(copyFromJob.getRetries());
        copyToJob.setRevision(copyFromJob.getRevision());
        copyToJob.setTenantId(copyFromJob.getTenantId());
        return copyToJob;
    }

    public JobServiceConfiguration getJobServiceConfiguration() {
        return this.jobServiceConfiguration;
    }

    @Override
    public void setJobServiceConfiguration(JobServiceConfiguration jobServiceConfiguration) {
        this.jobServiceConfiguration = jobServiceConfiguration;
    }

    protected boolean isAsyncExecutorActive() {
        return this.isExecutorActive(this.jobServiceConfiguration.getAsyncExecutor());
    }

    protected boolean isAsyncExecutorRemainingCapacitySufficient(int neededCapacity) {
        return this.getAsyncExecutor().isActive() && this.getAsyncExecutor().getTaskExecutor().getRemainingCapacity() >= neededCapacity;
    }

    protected boolean isAsyncHistoryExecutorActive() {
        return this.isExecutorActive(this.jobServiceConfiguration.getAsyncHistoryExecutor());
    }

    protected boolean isExecutorActive(AsyncExecutor asyncExecutor) {
        return asyncExecutor != null && asyncExecutor.isActive();
    }

    protected CommandContext getCommandContext() {
        return Context.getCommandContext();
    }

    protected AsyncExecutor getAsyncExecutor() {
        return this.jobServiceConfiguration.getAsyncExecutor();
    }

    protected AsyncExecutor getAsyncHistoryExecutor() {
        return this.jobServiceConfiguration.getAsyncHistoryExecutor();
    }

    protected void callJobProcessors(JobProcessorContext.Phase processorType, AbstractJobEntity abstractJobEntity) {
        JobProcessorUtil.callJobProcessors(this.jobServiceConfiguration, processorType, abstractJobEntity);
    }

    protected void callHistoryJobProcessors(HistoryJobProcessorContext.Phase processorType, HistoryJobEntity historyJobEntity) {
        JobProcessorUtil.callHistoryJobProcessors(this.jobServiceConfiguration, processorType, historyJobEntity);
    }
}

