/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.job.service.impl.cmd;

import java.util.GregorianCalendar;
import java.util.List;
import org.flowable.common.engine.impl.Page;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.JobServiceConfiguration;
import org.flowable.job.service.impl.asyncexecutor.AsyncExecutor;
import org.flowable.job.service.impl.persistence.entity.TimerJobEntity;

public class AcquireTimerJobsWithGlobalAcquireLockCmd
implements Command<List<TimerJobEntity>> {
    protected AsyncExecutor asyncExecutor;

    public AcquireTimerJobsWithGlobalAcquireLockCmd(AsyncExecutor asyncExecutor) {
        this.asyncExecutor = asyncExecutor;
    }

    public List<TimerJobEntity> execute(CommandContext commandContext) {
        JobServiceConfiguration jobServiceConfiguration = this.asyncExecutor.getJobServiceConfiguration();
        List<String> enabledCategories = jobServiceConfiguration.getEnabledJobCategories();
        List<TimerJobEntity> timerJobs = jobServiceConfiguration.getTimerJobEntityManager().findJobsToExecute(enabledCategories, new Page(0, this.asyncExecutor.getMaxTimerJobsPerAcquisition()));
        if (!timerJobs.isEmpty()) {
            GregorianCalendar jobExpirationTime = this.calculateLockExpirationTime(this.asyncExecutor.getTimerLockTimeInMillis(), jobServiceConfiguration);
            jobServiceConfiguration.getTimerJobEntityManager().bulkUpdateJobLockWithoutRevisionCheck(timerJobs, this.asyncExecutor.getLockOwner(), jobExpirationTime.getTime());
        }
        return timerJobs;
    }

    protected GregorianCalendar calculateLockExpirationTime(int lockTimeInMillis, JobServiceConfiguration jobServiceConfiguration) {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime(jobServiceConfiguration.getClock().getCurrentTime());
        gregorianCalendar.add(14, lockTimeInMillis);
        return gregorianCalendar;
    }
}

