/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.validation.validator.impl;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.BaseElement;
import org.flowable.bpmn.model.BpmnModel;
import org.flowable.bpmn.model.Message;
import org.flowable.validation.ValidationError;
import org.flowable.validation.validator.ValidatorImpl;

public class MessageValidator
extends ValidatorImpl {
    @Override
    public void validate(BpmnModel bpmnModel, List<ValidationError> errors) {
        if (bpmnModel.getMessages() != null && !bpmnModel.getMessages().isEmpty()) {
            for (Message message : bpmnModel.getMessages()) {
                if (!StringUtils.isNotEmpty((CharSequence)message.getItemRef()) || bpmnModel.getItemDefinitions().containsKey(message.getItemRef())) continue;
                this.addError(errors, "flowable-message-invalid-item-ref", (BaseElement)message, "Item reference is invalid: not found");
            }
        }
    }
}

