/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.xjc.reader.xmlschema;

import com.sun.tools.xjc.reader.Ring;
import com.sun.tools.xjc.reader.xmlschema.BGMBuilder;
import com.sun.tools.xjc.reader.xmlschema.BindingComponent;
import com.sun.tools.xjc.reader.xmlschema.SimpleTypeBuilder;
import com.sun.tools.xjc.reader.xmlschema.bindinfo.BIDeclaration;
import com.sun.xml.xsom.XSAnnotation;
import com.sun.xml.xsom.XSAttContainer;
import com.sun.xml.xsom.XSAttGroupDecl;
import com.sun.xml.xsom.XSAttributeDecl;
import com.sun.xml.xsom.XSAttributeUse;
import com.sun.xml.xsom.XSComplexType;
import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.XSContentType;
import com.sun.xml.xsom.XSElementDecl;
import com.sun.xml.xsom.XSFacet;
import com.sun.xml.xsom.XSIdentityConstraint;
import com.sun.xml.xsom.XSListSimpleType;
import com.sun.xml.xsom.XSModelGroup;
import com.sun.xml.xsom.XSModelGroupDecl;
import com.sun.xml.xsom.XSNotation;
import com.sun.xml.xsom.XSParticle;
import com.sun.xml.xsom.XSRestrictionSimpleType;
import com.sun.xml.xsom.XSSchema;
import com.sun.xml.xsom.XSSchemaSet;
import com.sun.xml.xsom.XSSimpleType;
import com.sun.xml.xsom.XSUnionSimpleType;
import com.sun.xml.xsom.XSWildcard;
import com.sun.xml.xsom.XSXPath;
import com.sun.xml.xsom.visitor.XSSimpleTypeVisitor;
import com.sun.xml.xsom.visitor.XSVisitor;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class UnusedCustomizationChecker
extends BindingComponent
implements XSVisitor,
XSSimpleTypeVisitor {
    private final BGMBuilder builder = Ring.get(BGMBuilder.class);
    private final SimpleTypeBuilder stb = Ring.get(SimpleTypeBuilder.class);
    private final Set<XSComponent> visitedComponents = new HashSet<XSComponent>();

    UnusedCustomizationChecker() {
    }

    void run() {
        for (XSSchema s : Ring.get(XSSchemaSet.class).getSchemas()) {
            this.schema(s);
            this.run(s.getAttGroupDecls());
            this.run(s.getAttributeDecls());
            this.run(s.getComplexTypes());
            this.run(s.getElementDecls());
            this.run(s.getModelGroupDecls());
            this.run(s.getNotations());
            this.run(s.getSimpleTypes());
        }
    }

    private void run(Map<String, ? extends XSComponent> col) {
        for (XSComponent xSComponent : col.values()) {
            xSComponent.visit((XSVisitor)this);
        }
    }

    private boolean check(XSComponent c) {
        if (!this.visitedComponents.add(c)) {
            return false;
        }
        for (BIDeclaration decl : this.builder.getBindInfo(c).getDecls()) {
            this.check(decl, c);
        }
        this.checkExpectedContentTypes(c);
        return true;
    }

    private void checkExpectedContentTypes(XSComponent c) {
        if (c.getForeignAttribute("http://www.w3.org/2005/05/xmlmime", "expectedContentTypes") == null) {
            return;
        }
        if (c instanceof XSParticle) {
            return;
        }
        if (!this.stb.isAcknowledgedXmimeContentTypes(c)) {
            this.getErrorReporter().warning(c.getLocator(), "UnusedCustomizationChecker.WarnUnusedExpectedContentTypes", new Object[0]);
        }
    }

    private void check(BIDeclaration decl, XSComponent c) {
        if (!decl.isAcknowledged()) {
            this.getErrorReporter().error(decl.getLocation(), "UnusedCustomizationChecker.UnacknolwedgedCustomization", decl.getName().getLocalPart());
            this.getErrorReporter().error(c.getLocator(), "UnusedCustomizationChecker.UnacknolwedgedCustomization.Relevant", new Object[0]);
            decl.markAsAcknowledged();
        }
        for (BIDeclaration d : decl.getChildren()) {
            this.check(d, c);
        }
    }

    public void annotation(XSAnnotation ann) {
    }

    public void attGroupDecl(XSAttGroupDecl decl) {
        if (this.check((XSComponent)decl)) {
            this.attContainer((XSAttContainer)decl);
        }
    }

    public void attributeDecl(XSAttributeDecl decl) {
        if (this.check((XSComponent)decl)) {
            decl.getType().visit((XSSimpleTypeVisitor)this);
        }
    }

    public void attributeUse(XSAttributeUse use) {
        if (this.check((XSComponent)use)) {
            use.getDecl().visit((XSVisitor)this);
        }
    }

    public void complexType(XSComplexType type) {
        if (this.check((XSComponent)type)) {
            type.getContentType().visit((XSVisitor)this);
            this.attContainer((XSAttContainer)type);
        }
    }

    private void attContainer(XSAttContainer cont) {
        Iterator itr = cont.iterateAttGroups();
        while (itr.hasNext()) {
            ((XSAttGroupDecl)itr.next()).visit((XSVisitor)this);
        }
        itr = cont.iterateDeclaredAttributeUses();
        while (itr.hasNext()) {
            ((XSAttributeUse)itr.next()).visit((XSVisitor)this);
        }
        XSWildcard wc = cont.getAttributeWildcard();
        if (wc != null) {
            wc.visit((XSVisitor)this);
        }
    }

    public void schema(XSSchema schema) {
        this.check((XSComponent)schema);
    }

    public void facet(XSFacet facet) {
        this.check((XSComponent)facet);
    }

    public void notation(XSNotation notation) {
        this.check((XSComponent)notation);
    }

    public void wildcard(XSWildcard wc) {
        this.check((XSComponent)wc);
    }

    public void modelGroupDecl(XSModelGroupDecl decl) {
        if (this.check((XSComponent)decl)) {
            decl.getModelGroup().visit((XSVisitor)this);
        }
    }

    public void modelGroup(XSModelGroup group) {
        if (this.check((XSComponent)group)) {
            for (int i = 0; i < group.getSize(); ++i) {
                group.getChild(i).visit((XSVisitor)this);
            }
        }
    }

    public void elementDecl(XSElementDecl decl) {
        if (this.check((XSComponent)decl)) {
            decl.getType().visit((XSVisitor)this);
            for (XSIdentityConstraint id : decl.getIdentityConstraints()) {
                id.visit((XSVisitor)this);
            }
        }
    }

    public void simpleType(XSSimpleType simpleType) {
        if (this.check((XSComponent)simpleType)) {
            simpleType.visit((XSSimpleTypeVisitor)this);
        }
    }

    public void particle(XSParticle particle) {
        if (this.check((XSComponent)particle)) {
            particle.getTerm().visit((XSVisitor)this);
        }
    }

    public void empty(XSContentType empty) {
        this.check((XSComponent)empty);
    }

    public void listSimpleType(XSListSimpleType type) {
        if (this.check((XSComponent)type)) {
            type.getItemType().visit((XSSimpleTypeVisitor)this);
        }
    }

    public void restrictionSimpleType(XSRestrictionSimpleType type) {
        if (this.check((XSComponent)type)) {
            type.getBaseType().visit((XSVisitor)this);
        }
    }

    public void unionSimpleType(XSUnionSimpleType type) {
        if (this.check((XSComponent)type)) {
            for (int i = 0; i < type.getMemberSize(); ++i) {
                type.getMember(i).visit((XSSimpleTypeVisitor)this);
            }
        }
    }

    public void identityConstraint(XSIdentityConstraint id) {
        if (this.check((XSComponent)id)) {
            id.getSelector().visit((XSVisitor)this);
            for (XSXPath xp : id.getFields()) {
                xp.visit((XSVisitor)this);
            }
        }
    }

    public void xpath(XSXPath xp) {
        this.check((XSComponent)xp);
    }
}

