/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.junit;

import com.oracle.mxtool.junit.MxJUnitRequest;
import com.oracle.mxtool.junit.MxJUnitWrapper;
import com.oracle.svm.core.option.HostedOptionKey;
import com.oracle.svm.core.util.VMError;
import java.io.BufferedReader;
import java.io.FileReader;
import junit.runner.Version;
import org.graalvm.compiler.options.Option;
import org.graalvm.nativeimage.ImageSingletons;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.nativeimage.hosted.Feature;
import org.junit.internal.JUnitSystem;
import org.junit.internal.RealSystem;
import org.junit.runner.JUnitCore;
import org.junit.runner.Result;

public class SVMJUnitRunner {
    private final MxJUnitRequest request;

    @Platforms(value={Platform.HOSTED_ONLY.class})
    SVMJUnitRunner(final Feature.FeatureAccess access) {
        MxJUnitRequest.Builder builder = new MxJUnitRequest.Builder(){

            protected Class<?> resolveClass(String name) throws ClassNotFoundException {
                Class ret = access.findClassByName(name);
                if (ret == null) {
                    throw new ClassNotFoundException(name);
                }
                return ret;
            }
        };
        try (BufferedReader br = new BufferedReader(new FileReader((String)Options.TestFile.getValue()));){
            String buf;
            while ((buf = br.readLine()) != null) {
                builder.addTestSpec(buf);
            }
        }
        catch (Exception ex) {
            throw VMError.shouldNotReachHere((Throwable)ex);
        }
        this.request = builder.build();
    }

    private void run(String[] args) {
        RealSystem system = new RealSystem();
        JUnitCore junitCore = new JUnitCore();
        system.out().println("SVMJUnitCore");
        system.out().println("JUnit version " + Version.id());
        MxJUnitWrapper.MxJUnitConfig config = new MxJUnitWrapper.MxJUnitConfig();
        int i = 0;
        while (i < args.length) {
            String arg;
            switch (arg = args[i++]) {
                case "--verbose": {
                    config.verbose = true;
                    break;
                }
                case "--very-verbose": {
                    config.veryVerbose = true;
                    break;
                }
                case "--fail-fast": {
                    config.failFast = true;
                    break;
                }
                case "--enable-timing": {
                    config.enableTiming = true;
                    break;
                }
                case "--color": {
                    config.color = true;
                    break;
                }
                case "--gc-after-test": {
                    config.gcAfterTest = true;
                    break;
                }
                case "--repeat": {
                    if (i < args.length) {
                        String count = args[i++];
                        try {
                            config.repeatCount = Integer.valueOf(count);
                        }
                        catch (NumberFormatException ex) {
                            system.out().println("Invalid argument to --repeat, expected number, but got " + count);
                        }
                        break;
                    }
                    system.out().println("Missing argument to --repeat");
                    break;
                }
                case "--eager-stacktrace": {
                    config.eagerStackTrace = true;
                    break;
                }
                default: {
                    system.out().println("Unknown command line argument: " + arg);
                }
            }
        }
        Result result = MxJUnitWrapper.runRequest((JUnitCore)junitCore, (JUnitSystem)system, (MxJUnitWrapper.MxJUnitConfig)config, (MxJUnitRequest)this.request);
        System.exit(result.wasSuccessful() ? 0 : 1);
    }

    public static void main(String[] args) {
        ((SVMJUnitRunner)ImageSingletons.lookup(SVMJUnitRunner.class)).run(args);
    }

    public static class Options {
        @Option(help={""})
        public static final HostedOptionKey<String> TestFile = new HostedOptionKey((Object)"");
    }
}

