// CheckStyle: start generated
package com.oracle.truffle.host;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.UnsupportedSpecializationException;
import com.oracle.truffle.api.dsl.DSLSupport.SpecializationDataNode;
import com.oracle.truffle.api.dsl.InlineSupport.InlineTarget;
import com.oracle.truffle.api.dsl.InlineSupport.ReferenceField;
import com.oracle.truffle.api.dsl.InlineSupport.StateField;
import com.oracle.truffle.api.dsl.InlineSupport.UnsafeAccessedField;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.ExceptionType;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.InvalidBufferOffsetException;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.host.HostContext.ToGuestValueNode;
import com.oracle.truffle.host.HostContextFactory.ToGuestValueNodeGen;
import com.oracle.truffle.host.HostObject.ArrayGet;
import com.oracle.truffle.host.HostObject.ArraySet;
import com.oracle.truffle.host.HostObject.AsBigInteger;
import com.oracle.truffle.host.HostObject.AsByte;
import com.oracle.truffle.host.HostObject.AsDouble;
import com.oracle.truffle.host.HostObject.AsFloat;
import com.oracle.truffle.host.HostObject.AsInt;
import com.oracle.truffle.host.HostObject.AsLong;
import com.oracle.truffle.host.HostObject.AsShort;
import com.oracle.truffle.host.HostObject.ContainsKeyNode;
import com.oracle.truffle.host.HostObject.FitsInBigInteger;
import com.oracle.truffle.host.HostObject.FitsInByte;
import com.oracle.truffle.host.HostObject.FitsInDouble;
import com.oracle.truffle.host.HostObject.FitsInFloat;
import com.oracle.truffle.host.HostObject.FitsInInt;
import com.oracle.truffle.host.HostObject.FitsInLong;
import com.oracle.truffle.host.HostObject.FitsInShort;
import com.oracle.truffle.host.HostObject.GetArraySize;
import com.oracle.truffle.host.HostObject.GetBufferSize;
import com.oracle.truffle.host.HostObject.GetHashEntriesIterator;
import com.oracle.truffle.host.HostObject.GetHashSize;
import com.oracle.truffle.host.HostObject.GetIterator;
import com.oracle.truffle.host.HostObject.GetIteratorNextElement;
import com.oracle.truffle.host.HostObject.HasArrayElements;
import com.oracle.truffle.host.HostObject.HasBufferElements;
import com.oracle.truffle.host.HostObject.HasHashEntries;
import com.oracle.truffle.host.HostObject.HasIterator;
import com.oracle.truffle.host.HostObject.HasIteratorNextElement;
import com.oracle.truffle.host.HostObject.Instantiate;
import com.oracle.truffle.host.HostObject.IsArrayElementInsertable;
import com.oracle.truffle.host.HostObject.IsArrayElementModifiable;
import com.oracle.truffle.host.HostObject.IsArrayElementReadable;
import com.oracle.truffle.host.HostObject.IsArrayElementRemovable;
import com.oracle.truffle.host.HostObject.IsBufferWritable;
import com.oracle.truffle.host.HostObject.IsHashEntryInsertable;
import com.oracle.truffle.host.HostObject.IsHashEntryReadable;
import com.oracle.truffle.host.HostObject.IsIdenticalOrUndefined;
import com.oracle.truffle.host.HostObject.IsInstantiable;
import com.oracle.truffle.host.HostObject.IsIterator;
import com.oracle.truffle.host.HostObject.IsMemberInternal;
import com.oracle.truffle.host.HostObject.IsMemberInvocable;
import com.oracle.truffle.host.HostObject.IsMemberModifiable;
import com.oracle.truffle.host.HostObject.IsMemberReadable;
import com.oracle.truffle.host.HostObject.IsNumber;
import com.oracle.truffle.host.HostObject.LookupConstructorNode;
import com.oracle.truffle.host.HostObject.LookupFieldNode;
import com.oracle.truffle.host.HostObject.LookupFunctionalMethodNode;
import com.oracle.truffle.host.HostObject.LookupInnerClassNode;
import com.oracle.truffle.host.HostObject.LookupMethodNode;
import com.oracle.truffle.host.HostObject.ReadArrayElement;
import com.oracle.truffle.host.HostObject.ReadBufferByte;
import com.oracle.truffle.host.HostObject.ReadBufferDouble;
import com.oracle.truffle.host.HostObject.ReadBufferFloat;
import com.oracle.truffle.host.HostObject.ReadBufferInt;
import com.oracle.truffle.host.HostObject.ReadBufferLong;
import com.oracle.truffle.host.HostObject.ReadBufferShort;
import com.oracle.truffle.host.HostObject.ReadFieldNode;
import com.oracle.truffle.host.HostObject.ReadHashValue;
import com.oracle.truffle.host.HostObject.RemoveArrayElement;
import com.oracle.truffle.host.HostObject.RemoveHashEntry;
import com.oracle.truffle.host.HostObject.WriteArrayElement;
import com.oracle.truffle.host.HostObject.WriteBufferByte;
import com.oracle.truffle.host.HostObject.WriteBufferDouble;
import com.oracle.truffle.host.HostObject.WriteBufferFloat;
import com.oracle.truffle.host.HostObject.WriteBufferInt;
import com.oracle.truffle.host.HostObject.WriteBufferLong;
import com.oracle.truffle.host.HostObject.WriteBufferShort;
import com.oracle.truffle.host.HostObject.WriteFieldNode;
import com.oracle.truffle.host.HostObject.WriteHashEntry;
import com.oracle.truffle.host.HostObjectFactory.ArrayGetNodeGen;
import com.oracle.truffle.host.HostObjectFactory.ArraySetNodeGen;
import com.oracle.truffle.host.HostObjectFactory.ContainsKeyNodeGen;
import com.oracle.truffle.host.HostObjectFactory.LookupConstructorNodeGen;
import com.oracle.truffle.host.HostObjectFactory.LookupFieldNodeGen;
import com.oracle.truffle.host.HostObjectFactory.LookupFunctionalMethodNodeGen;
import com.oracle.truffle.host.HostObjectFactory.LookupInnerClassNodeGen;
import com.oracle.truffle.host.HostObjectFactory.LookupMethodNodeGen;
import com.oracle.truffle.host.HostObjectFactory.ReadFieldNodeGen;
import com.oracle.truffle.host.HostObjectFactory.WriteFieldNodeGen;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.invoke.MethodHandles.Lookup;
import java.math.BigInteger;
import java.nio.ByteOrder;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.Objects;

@GeneratedBy(HostObject.class)
@SuppressWarnings({"javadoc", "unused"})
final class HostObjectGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(HostObject.class, new InteropLibraryExports());
    }

    private HostObjectGen() {
    }

    @GeneratedBy(HostObject.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, HostObject.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof HostObject;
            InteropLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof HostObject;
            return new Cached();
        }

        @GeneratedBy(HostObject.class)
        private static final class Cached extends InteropLibrary {

            private static final StateField STATE_5_UPDATER = StateField.create(MethodHandles.lookup(), "state_5_");
            private static final StateField STATE_6_UPDATER = StateField.create(MethodHandles.lookup(), "state_6_");
            private static final StateField STATE_5_WriteArrayElement_UPDATER = StateField.create(MethodHandles.lookup(), "state_5_");
            private static final StateField STATE_5_ReadArrayElement_UPDATER = StateField.create(MethodHandles.lookup(), "state_5_");
            private static final StateField STATE_5_GetIteratorNextElement_UPDATER = StateField.create(MethodHandles.lookup(), "state_5_");
            private static final StateField STATE_6_ReadMemberNode__UPDATER = StateField.create(MethodHandles.lookup(), "state_6_");
            private static final StateField READ_MEMBER__READ_MEMBER_NODE__READ_MEMBER_STATE_0_UPDATER = StateField.create(ReadMemberNode_ReadMemberData.lookup_(), "readMember_state_0_");
            private static final StateField STATE_5_ReadMemberNode__UPDATER = StateField.create(MethodHandles.lookup(), "state_5_");
            private static final StateField STATE_6_WriteMemberNode__UPDATER = StateField.create(MethodHandles.lookup(), "state_6_");
            private static final StateField WRITE_MEMBER__WRITE_MEMBER_NODE__WRITE_MEMBER_STATE_0_UPDATER = StateField.create(WriteMemberNode_WriteMemberData.lookup_(), "writeMember_state_0_");
            private static final StateField STATE_5_WriteMemberNode__UPDATER = StateField.create(MethodHandles.lookup(), "state_5_");
            static final ReferenceField<IsMemberReadableCachedData> IS_MEMBER_READABLE_CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "isMemberReadable_cached_cache", IsMemberReadableCachedData.class);
            /**
             * Source Info: <pre>
             *   Specialization: {@link IsArrayElementReadable#doList}
             *   Parameter: {@link InlinedBranchProfile} error
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private static final InlinedBranchProfile INLINED_ERROR = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_5_UPDATER.subUpdater(3, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link WriteArrayElement#doArray}
             *   Parameter: {@link HostToTypeNode} toHostNode
             *   Inline method: {@link HostToTypeNodeGen#inline}</pre>
             */
            private static final HostToTypeNode INLINED_TO_HOST = HostToTypeNodeGen.inline(InlineTarget.create(HostToTypeNode.class, STATE_5_UPDATER.subUpdater(4, 2), ReferenceField.create(MethodHandles.lookup(), "toHost_field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadArrayElement#doArray}
             *   Parameter: {@link ToGuestValueNode} toGuest
             *   Inline method: {@link ToGuestValueNodeGen#inline}</pre>
             */
            private static final ToGuestValueNode INLINED_TO_GUEST = ToGuestValueNodeGen.inline(InlineTarget.create(ToGuestValueNode.class, STATE_5_UPDATER.subUpdater(24, 3), ReferenceField.create(MethodHandles.lookup(), "toGuest_field1_", Object.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadBufferByte#doNonNull}
             *   Parameter: {@link InlinedExactClassProfile} classProfile
             *   Inline method: {@link InlinedExactClassProfile#inline}</pre>
             */
            private static final InlinedExactClassProfile INLINED_CLASS_PROFILE = InlinedExactClassProfile.inline(InlineTarget.create(InlinedExactClassProfile.class, STATE_5_UPDATER.subUpdater(27, 2), ReferenceField.create(MethodHandles.lookup(), "classProfile_field1_", Class.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link IsInstantiable#doObjectCached}
             *   Parameter: {@link LookupConstructorNode} lookupConstructor
             *   Inline method: {@link LookupConstructorNodeGen#inline}</pre>
             */
            private static final LookupConstructorNode INLINED_LOOKUP_CONSTRUCTOR = LookupConstructorNodeGen.inline(InlineTarget.create(LookupConstructorNode.class, STATE_5_UPDATER.subUpdater(29, 2), ReferenceField.create(MethodHandles.lookup(), "lookupConstructor_field1_", Object.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link Instantiate#doObjectCached}
             *   Parameter: {@link HostExecuteNode} executeMethod
             *   Inline method: {@link HostExecuteNodeGen#inline}</pre>
             */
            private static final HostExecuteNode INLINED_HOST_EXECUTE = HostExecuteNodeGen.inline(InlineTarget.create(HostExecuteNode.class, STATE_6_UPDATER.subUpdater(0, 17), ReferenceField.create(MethodHandles.lookup(), "hostExecute_field1_", Node.class), ReferenceField.create(MethodHandles.lookup(), "hostExecute_field2_", Object.class), ReferenceField.create(MethodHandles.lookup(), "hostExecute_field3_", Object.class), ReferenceField.create(MethodHandles.lookup(), "hostExecute_field4_", Node.class), ReferenceField.create(MethodHandles.lookup(), "hostExecute_field5_", Node.class), ReferenceField.create(MethodHandles.lookup(), "hostExecute_field6_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link IsHashEntryReadable#doNonNull}
             *   Parameter: {@link ContainsKeyNode} containsKey
             *   Inline method: {@link ContainsKeyNodeGen#inline}</pre>
             */
            private static final ContainsKeyNode INLINED_CONTAINS_KEY = ContainsKeyNodeGen.inline(InlineTarget.create(ContainsKeyNode.class, STATE_6_UPDATER.subUpdater(17, 5), ReferenceField.create(MethodHandles.lookup(), "containsKey_field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link HostObject#readMember}
             *   Parameter: {@link LookupFieldNode} lookupField
             *   Inline method: {@link LookupFieldNodeGen#inline}</pre>
             */
            private static final LookupFieldNode INLINED_LOOKUP_FIELD = LookupFieldNodeGen.inline(InlineTarget.create(LookupFieldNode.class, STATE_6_UPDATER.subUpdater(22, 2), ReferenceField.create(MethodHandles.lookup(), "lookupField_field1_", Object.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link HostObject#readMember}
             *   Parameter: {@link ReadFieldNode} readField
             *   Inline method: {@link ReadFieldNodeGen#inline}</pre>
             */
            private static final ReadFieldNode INLINED_READ_FIELD = ReadFieldNodeGen.inline(InlineTarget.create(ReadFieldNode.class, STATE_6_UPDATER.subUpdater(24, 2), ReferenceField.create(MethodHandles.lookup(), "readField_field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link HostObject#readMember}
             *   Parameter: {@link LookupMethodNode} lookupMethod
             *   Inline method: {@link LookupMethodNodeGen#inline}</pre>
             */
            private static final LookupMethodNode INLINED_LOOKUP_METHOD = LookupMethodNodeGen.inline(InlineTarget.create(LookupMethodNode.class, STATE_6_UPDATER.subUpdater(26, 2), ReferenceField.create(MethodHandles.lookup(), "lookupMethod_field1_", Object.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link HostObject#isExecutable}
             *   Parameter: {@link LookupFunctionalMethodNode} lookupMethod
             *   Inline method: {@link LookupFunctionalMethodNodeGen#inline}</pre>
             */
            private static final LookupFunctionalMethodNode INLINED_LOOKUP_FUNCTIONAL_METHOD = LookupFunctionalMethodNodeGen.inline(InlineTarget.create(LookupFunctionalMethodNode.class, STATE_6_UPDATER.subUpdater(28, 2), ReferenceField.create(MethodHandles.lookup(), "lookupFunctionalMethod_field1_", Object.class)));
            static final ReferenceField<IsMemberModifiableCachedData> IS_MEMBER_MODIFIABLE_CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "isMemberModifiable_cached_cache", IsMemberModifiableCachedData.class);
            static final ReferenceField<IsMemberInternalCachedData> IS_MEMBER_INTERNAL_CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "isMemberInternal_cached_cache", IsMemberInternalCachedData.class);
            static final ReferenceField<IsMemberInvocableCachedData> IS_MEMBER_INVOCABLE_CACHED_CACHE_UPDATER = ReferenceField.create(MethodHandles.lookup(), "isMemberInvocable_cached_cache", IsMemberInvocableCachedData.class);
            /**
             * Source Info: <pre>
             *   Specialization: {@link WriteArrayElement#doArray}
             *   Parameter: {@link ArraySet} arraySet
             *   Inline method: {@link ArraySetNodeGen#inline}</pre>
             */
            private static final ArraySet INLINED_WRITE_ARRAY_ELEMENT_ARRAY_ARRAY_SET_ = ArraySetNodeGen.inline(InlineTarget.create(ArraySet.class, STATE_5_WriteArrayElement_UPDATER.subUpdater(6, 9)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadArrayElement#doArray}
             *   Parameter: {@link ArrayGet} arrayGet
             *   Inline method: {@link ArrayGetNodeGen#inline}</pre>
             */
            private static final ArrayGet INLINED_READ_ARRAY_ELEMENT_ARRAY_ARRAY_GET_ = ArrayGetNodeGen.inline(InlineTarget.create(ArrayGet.class, STATE_5_ReadArrayElement_UPDATER.subUpdater(15, 9)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link GetIteratorNextElement#doIterator}
             *   Parameter: {@link InlinedBranchProfile} stopIteration
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private static final InlinedBranchProfile INLINED_GET_ITERATOR_NEXT_ELEMENT_ITERATOR_STOP_ITERATION_ = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_5_GetIteratorNextElement_UPDATER.subUpdater(31, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link HostObject#readMember(HostObject, String, Node, LookupFieldNode, ReadFieldNode, LookupMethodNode, LookupInnerClassNode, InlinedBranchProfile)}
             *   Parameter: {@link LookupFieldNode} lookupField
             *   Inline method: {@link LookupFieldNodeGen#inline}</pre>
             */
            private static final LookupFieldNode INLINED_READ_MEMBER_LOOKUP_FIELD = LookupFieldNodeGen.inline(InlineTarget.create(LookupFieldNode.class, STATE_6_ReadMemberNode__UPDATER.subUpdater(22, 2), ReferenceField.create(MethodHandles.lookup(), "lookupField_field1_", Object.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link HostObject#readMember(HostObject, String, Node, LookupFieldNode, ReadFieldNode, LookupMethodNode, LookupInnerClassNode, InlinedBranchProfile)}
             *   Parameter: {@link ReadFieldNode} readField
             *   Inline method: {@link ReadFieldNodeGen#inline}</pre>
             */
            private static final ReadFieldNode INLINED_READ_MEMBER_READ_FIELD = ReadFieldNodeGen.inline(InlineTarget.create(ReadFieldNode.class, STATE_6_ReadMemberNode__UPDATER.subUpdater(24, 2), ReferenceField.create(MethodHandles.lookup(), "readField_field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link HostObject#readMember(HostObject, String, Node, LookupFieldNode, ReadFieldNode, LookupMethodNode, LookupInnerClassNode, InlinedBranchProfile)}
             *   Parameter: {@link LookupMethodNode} lookupMethod
             *   Inline method: {@link LookupMethodNodeGen#inline}</pre>
             */
            private static final LookupMethodNode INLINED_READ_MEMBER_LOOKUP_METHOD = LookupMethodNodeGen.inline(InlineTarget.create(LookupMethodNode.class, STATE_6_ReadMemberNode__UPDATER.subUpdater(26, 2), ReferenceField.create(MethodHandles.lookup(), "lookupMethod_field1_", Object.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link HostObject#readMember(HostObject, String, Node, LookupFieldNode, ReadFieldNode, LookupMethodNode, LookupInnerClassNode, InlinedBranchProfile)}
             *   Parameter: {@link LookupInnerClassNode} lookupInnerClass
             *   Inline method: {@link LookupInnerClassNodeGen#inline}</pre>
             */
            private static final LookupInnerClassNode INLINED_READ_MEMBER_NODE__READ_MEMBER_LOOKUP_INNER_CLASS_ = LookupInnerClassNodeGen.inline(InlineTarget.create(LookupInnerClassNode.class, READ_MEMBER__READ_MEMBER_NODE__READ_MEMBER_STATE_0_UPDATER.subUpdater(0, 2), ReferenceField.create(ReadMemberNode_ReadMemberData.lookup_(), "readMemberNode__readMember_lookupInnerClass__field1_", Object.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link HostObject#readMember(HostObject, String, Node, LookupFieldNode, ReadFieldNode, LookupMethodNode, LookupInnerClassNode, InlinedBranchProfile)}
             *   Parameter: {@link InlinedBranchProfile} error
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private static final InlinedBranchProfile INLINED_READ_MEMBER_ERROR = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_5_ReadMemberNode__UPDATER.subUpdater(3, 1)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link HostObject#writeMember(HostObject, String, Object, Node, LookupFieldNode, WriteFieldNode, InlinedBranchProfile)}
             *   Parameter: {@link LookupFieldNode} lookupField
             *   Inline method: {@link LookupFieldNodeGen#inline}</pre>
             */
            private static final LookupFieldNode INLINED_WRITE_MEMBER_LOOKUP_FIELD = LookupFieldNodeGen.inline(InlineTarget.create(LookupFieldNode.class, STATE_6_WriteMemberNode__UPDATER.subUpdater(22, 2), ReferenceField.create(MethodHandles.lookup(), "lookupField_field1_", Object.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link HostObject#writeMember(HostObject, String, Object, Node, LookupFieldNode, WriteFieldNode, InlinedBranchProfile)}
             *   Parameter: {@link WriteFieldNode} writeField
             *   Inline method: {@link WriteFieldNodeGen#inline}</pre>
             */
            private static final WriteFieldNode INLINED_WRITE_MEMBER_NODE__WRITE_MEMBER_WRITE_FIELD_ = WriteFieldNodeGen.inline(InlineTarget.create(WriteFieldNode.class, WRITE_MEMBER__WRITE_MEMBER_NODE__WRITE_MEMBER_STATE_0_UPDATER.subUpdater(0, 2), ReferenceField.create(WriteMemberNode_WriteMemberData.lookup_(), "writeMemberNode__writeMember_writeField__field1_", Node.class)));
            /**
             * Source Info: <pre>
             *   Specialization: {@link HostObject#writeMember(HostObject, String, Object, Node, LookupFieldNode, WriteFieldNode, InlinedBranchProfile)}
             *   Parameter: {@link InlinedBranchProfile} error
             *   Inline method: {@link InlinedBranchProfile#inline}</pre>
             */
            private static final InlinedBranchProfile INLINED_WRITE_MEMBER_ERROR = InlinedBranchProfile.inline(InlineTarget.create(InlinedBranchProfile.class, STATE_5_WriteMemberNode__UPDATER.subUpdater(3, 1)));

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IsMemberReadable#doCached}
             *   1: SpecializationActive {@link IsMemberReadable#doUncached}
             *   2: SpecializationActive {@link IsMemberModifiable#doCached}
             *   3: SpecializationActive {@link IsMemberModifiable#doUncached}
             *   4: SpecializationActive {@link IsMemberInternal#doCached}
             *   5: SpecializationActive {@link IsMemberInternal#doUncached}
             *   6: SpecializationActive {@link IsMemberInvocable#doCached}
             *   7: SpecializationActive {@link IsMemberInvocable#doUncached}
             *   8: SpecializationActive {@link IsArrayElementReadable#doNull}
             *   9: SpecializationActive {@link IsArrayElementReadable#doArray}
             *   10: SpecializationActive {@link IsArrayElementReadable#doList}
             *   11: SpecializationActive {@link IsArrayElementReadable#doMapEntry}
             *   12: SpecializationActive {@link IsArrayElementReadable#doNotArrayOrList}
             *   13: SpecializationActive {@link IsArrayElementModifiable#doNull}
             *   14: SpecializationActive {@link IsArrayElementModifiable#doArray}
             *   15: SpecializationActive {@link IsArrayElementModifiable#doList}
             *   16: SpecializationActive {@link IsArrayElementModifiable#doMapEntry}
             *   17: SpecializationActive {@link IsArrayElementModifiable#doNotArrayOrList}
             *   18: SpecializationActive {@link IsArrayElementInsertable#doNull}
             *   19: SpecializationActive {@link IsArrayElementInsertable#doNonNull}
             *   20: SpecializationActive {@link WriteArrayElement#doNull}
             *   21: SpecializationActive {@link WriteArrayElement#doArray}
             *   22: SpecializationActive {@link WriteArrayElement#doList}
             *   23: SpecializationActive {@link WriteArrayElement#doMapEntry}
             *   24: SpecializationActive {@link WriteArrayElement#doNotArrayOrList}
             *   25: SpecializationActive {@link IsArrayElementRemovable#doNull}
             *   26: SpecializationActive {@link IsArrayElementRemovable#doList}
             *   27: SpecializationActive {@link IsArrayElementRemovable#doOther}
             *   28: SpecializationActive {@link RemoveArrayElement#doNull}
             *   29: SpecializationActive {@link RemoveArrayElement#doList}
             *   30: SpecializationActive {@link RemoveArrayElement#doOther}
             *   31: SpecializationActive {@link HasArrayElements#doNull}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link HasArrayElements#doNotNull}
             *   1: SpecializationActive {@link ReadArrayElement#doNull}
             *   2: SpecializationActive {@link ReadArrayElement#doArray}
             *   3: SpecializationActive {@link ReadArrayElement#doList}
             *   4: SpecializationActive {@link ReadArrayElement#doMapEntry}
             *   5: SpecializationActive {@link ReadArrayElement#doNotArrayOrList}
             *   6: SpecializationActive {@link GetArraySize#doNull}
             *   7: SpecializationActive {@link GetArraySize#doArray}
             *   8: SpecializationActive {@link GetArraySize#doList}
             *   9: SpecializationActive {@link GetArraySize#doMapEntry}
             *   10: SpecializationActive {@link GetArraySize#doNotArrayOrList}
             *   11: SpecializationActive {@link HasBufferElements#doNull}
             *   12: SpecializationActive {@link HasBufferElements#doNonNull}
             *   13: SpecializationActive {@link IsBufferWritable#doNull}
             *   14: SpecializationActive {@link IsBufferWritable#doNonNull}
             *   15: SpecializationActive {@link GetBufferSize#doNull}
             *   16: SpecializationActive {@link GetBufferSize#doNonNull}
             *   17: SpecializationActive {@link ReadBufferByte#doNull}
             *   18: SpecializationActive {@link ReadBufferByte#doNonNull}
             *   19: SpecializationActive {@link WriteBufferByte#doNull}
             *   20: SpecializationActive {@link WriteBufferByte#doNonNull}
             *   21: SpecializationActive {@link ReadBufferShort#doNull}
             *   22: SpecializationActive {@link ReadBufferShort#doNonNull}
             *   23: SpecializationActive {@link WriteBufferShort#doNull}
             *   24: SpecializationActive {@link WriteBufferShort#doNonNull}
             *   25: SpecializationActive {@link ReadBufferInt#doNull}
             *   26: SpecializationActive {@link ReadBufferInt#doNonNull}
             *   27: SpecializationActive {@link WriteBufferInt#doNull}
             *   28: SpecializationActive {@link WriteBufferInt#doNonNull}
             *   29: SpecializationActive {@link ReadBufferLong#doNull}
             *   30: SpecializationActive {@link ReadBufferLong#doNonNull}
             *   31: SpecializationActive {@link WriteBufferLong#doNull}
             * </pre>
             */
            @CompilationFinal private int state_1_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link WriteBufferLong#doNonNull}
             *   1: SpecializationActive {@link ReadBufferFloat#doNull}
             *   2: SpecializationActive {@link ReadBufferFloat#doNonNull}
             *   3: SpecializationActive {@link WriteBufferFloat#doNull}
             *   4: SpecializationActive {@link WriteBufferFloat#doNonNull}
             *   5: SpecializationActive {@link ReadBufferDouble#doNull}
             *   6: SpecializationActive {@link ReadBufferDouble#doNonNull}
             *   7: SpecializationActive {@link WriteBufferDouble#doNull}
             *   8: SpecializationActive {@link WriteBufferDouble#doNonNull}
             *   9: SpecializationActive {@link IsInstantiable#doUnsupported}
             *   10: SpecializationActive {@link IsInstantiable#doArrayCached}
             *   11: SpecializationActive {@link IsInstantiable#doObjectCached}
             *   12: SpecializationActive {@link Instantiate#doUnsupported}
             *   13: SpecializationActive {@link Instantiate#doArrayCached}
             *   14: SpecializationActive {@link Instantiate#doObjectCached}
             *   15: SpecializationActive {@link IsNumber#doNull}
             *   16: SpecializationActive {@link IsNumber#doBigInteger}
             *   17: SpecializationActive {@link IsNumber#doOther}
             *   18: SpecializationActive {@link FitsInByte#doNull}
             *   19: SpecializationActive {@link FitsInByte#doBigInteger}
             *   20: SpecializationActive {@link FitsInByte#doOther}
             *   21: SpecializationActive {@link FitsInShort#doNull}
             *   22: SpecializationActive {@link FitsInShort#doBigInteger}
             *   23: SpecializationActive {@link FitsInShort#doOther}
             *   24: SpecializationActive {@link FitsInInt#doNull}
             *   25: SpecializationActive {@link FitsInInt#doBigInteger}
             *   26: SpecializationActive {@link FitsInInt#doOther}
             *   27: SpecializationActive {@link FitsInLong#doNull}
             *   28: SpecializationActive {@link FitsInLong#doBigInteger}
             *   29: SpecializationActive {@link FitsInLong#doOther}
             *   30: SpecializationActive {@link FitsInBigInteger#doNull}
             *   31: SpecializationActive {@link FitsInBigInteger#doBigInteger}
             * </pre>
             */
            @CompilationFinal private int state_2_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link FitsInBigInteger#doOther}
             *   1: SpecializationActive {@link FitsInFloat#doNull}
             *   2: SpecializationActive {@link FitsInFloat#doBigInteger}
             *   3: SpecializationActive {@link FitsInFloat#doOther}
             *   4: SpecializationActive {@link FitsInDouble#doNull}
             *   5: SpecializationActive {@link FitsInDouble#doBigInteger}
             *   6: SpecializationActive {@link FitsInDouble#doOther}
             *   7: SpecializationActive {@link AsByte#doNull}
             *   8: SpecializationActive {@link AsByte#doBigInteger}
             *   9: SpecializationActive {@link AsByte#doOther}
             *   10: SpecializationActive {@link AsShort#doNull}
             *   11: SpecializationActive {@link AsShort#doBigInteger}
             *   12: SpecializationActive {@link AsShort#doOther}
             *   13: SpecializationActive {@link AsInt#doNull}
             *   14: SpecializationActive {@link AsInt#doBigInteger}
             *   15: SpecializationActive {@link AsInt#doOther}
             *   16: SpecializationActive {@link AsLong#doNull}
             *   17: SpecializationActive {@link AsLong#doBigInteger}
             *   18: SpecializationActive {@link AsLong#doOther}
             *   19: SpecializationActive {@link AsBigInteger#doNull}
             *   20: SpecializationActive {@link AsBigInteger#doBigInteger}
             *   21: SpecializationActive {@link AsBigInteger#doOther}
             *   22: SpecializationActive {@link AsFloat#doNull}
             *   23: SpecializationActive {@link AsFloat#doBigInteger}
             *   24: SpecializationActive {@link AsFloat#doOther}
             *   25: SpecializationActive {@link AsDouble#doNull}
             *   26: SpecializationActive {@link AsDouble#doBigInteger}
             *   27: SpecializationActive {@link AsDouble#doOther}
             *   28: SpecializationActive {@link HasIterator#doNull}
             *   29: SpecializationActive {@link HasIterator#doNonNull}
             *   30: SpecializationActive {@link GetIterator#doNull}
             *   31: SpecializationActive {@link GetIterator#doArray}
             * </pre>
             */
            @CompilationFinal private int state_3_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link GetIterator#doIterable}
             *   1: SpecializationActive {@link GetIterator#doNotArrayOrIterable}
             *   2: SpecializationActive {@link IsIterator#doNull}
             *   3: SpecializationActive {@link IsIterator#doNonNull}
             *   4: SpecializationActive {@link HasIteratorNextElement#doNull}
             *   5: SpecializationActive {@link HasIteratorNextElement#doIterator}
             *   6: SpecializationActive {@link HasIteratorNextElement#doNotIterator}
             *   7: SpecializationActive {@link GetIteratorNextElement#doNull}
             *   8: SpecializationActive {@link GetIteratorNextElement#doIterator}
             *   9: SpecializationActive {@link GetIteratorNextElement#doNotIterator}
             *   10: SpecializationActive {@link HasHashEntries#doNull}
             *   11: SpecializationActive {@link HasHashEntries#doNonNull}
             *   12: SpecializationActive {@link GetHashSize#doNull}
             *   13: SpecializationActive {@link GetHashSize#doMap}
             *   14: SpecializationActive {@link GetHashSize#doNotMap}
             *   15: SpecializationActive {@link IsHashEntryReadable#doNull}
             *   16: SpecializationActive {@link IsHashEntryReadable#doNonNull}
             *   17: SpecializationActive {@link ReadHashValue#doNull}
             *   18: SpecializationActive {@link ReadHashValue#doMap}
             *   19: SpecializationActive {@link ReadHashValue#doNotMap}
             *   20: SpecializationActive {@link IsHashEntryInsertable#doNull}
             *   21: SpecializationActive {@link IsHashEntryInsertable#doNonNull}
             *   22: SpecializationActive {@link WriteHashEntry#doNull}
             *   23: SpecializationActive {@link WriteHashEntry#doMap}
             *   24: SpecializationActive {@link WriteHashEntry#doNotMap}
             *   25: SpecializationActive {@link RemoveHashEntry#doNull}
             *   26: SpecializationActive {@link RemoveHashEntry#doMap}
             *   27: SpecializationActive {@link RemoveHashEntry#doNotMap}
             *   28: SpecializationActive {@link GetHashEntriesIterator#doNull}
             *   29: SpecializationActive {@link GetHashEntriesIterator#doMap}
             *   30: SpecializationActive {@link GetHashEntriesIterator#doNotMap}
             *   31: SpecializationActive {@link IsIdenticalOrUndefined#doHostObject}
             * </pre>
             */
            @CompilationFinal private int state_4_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IsIdenticalOrUndefined#doOther}
             *   1: SpecializationActive {@link HostObject#invokeMember(HostObject, String, Object[], Node, LookupMethodNode, HostExecuteNode, LookupFieldNode, ReadFieldNode, InteropLibrary, InlinedBranchProfile)}
             *   2: SpecializationActive {@link HostObject#asString(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)}
             *   3: InlinedCache
             *        Specialization: {@link IsArrayElementReadable#doList}
             *        Parameter: {@link InlinedBranchProfile} error
             *        Inline method: {@link InlinedBranchProfile#inline}
             *   4-5: InlinedCache
             *        Specialization: {@link WriteArrayElement#doArray}
             *        Parameter: {@link HostToTypeNode} toHostNode
             *        Inline method: {@link HostToTypeNodeGen#inline}
             *   6-14: InlinedCache
             *        Specialization: {@link WriteArrayElement#doArray}
             *        Parameter: {@link ArraySet} arraySet
             *        Inline method: {@link ArraySetNodeGen#inline}
             *   15-23: InlinedCache
             *        Specialization: {@link ReadArrayElement#doArray}
             *        Parameter: {@link ArrayGet} arrayGet
             *        Inline method: {@link ArrayGetNodeGen#inline}
             *   24-26: InlinedCache
             *        Specialization: {@link ReadArrayElement#doArray}
             *        Parameter: {@link ToGuestValueNode} toGuest
             *        Inline method: {@link ToGuestValueNodeGen#inline}
             *   27-28: InlinedCache
             *        Specialization: {@link ReadBufferByte#doNonNull}
             *        Parameter: {@link InlinedExactClassProfile} classProfile
             *        Inline method: {@link InlinedExactClassProfile#inline}
             *   29-30: InlinedCache
             *        Specialization: {@link IsInstantiable#doObjectCached}
             *        Parameter: {@link LookupConstructorNode} lookupConstructor
             *        Inline method: {@link LookupConstructorNodeGen#inline}
             *   31: InlinedCache
             *        Specialization: {@link GetIteratorNextElement#doIterator}
             *        Parameter: {@link InlinedBranchProfile} stopIteration
             *        Inline method: {@link InlinedBranchProfile#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_5_;
            /**
             * State Info: <pre>
             *   0-16: InlinedCache
             *        Specialization: {@link Instantiate#doObjectCached}
             *        Parameter: {@link HostExecuteNode} executeMethod
             *        Inline method: {@link HostExecuteNodeGen#inline}
             *   17-21: InlinedCache
             *        Specialization: {@link IsHashEntryReadable#doNonNull}
             *        Parameter: {@link ContainsKeyNode} containsKey
             *        Inline method: {@link ContainsKeyNodeGen#inline}
             *   22-23: InlinedCache
             *        Specialization: {@link HostObject#readMember}
             *        Parameter: {@link LookupFieldNode} lookupField
             *        Inline method: {@link LookupFieldNodeGen#inline}
             *   24-25: InlinedCache
             *        Specialization: {@link HostObject#readMember}
             *        Parameter: {@link ReadFieldNode} readField
             *        Inline method: {@link ReadFieldNodeGen#inline}
             *   26-27: InlinedCache
             *        Specialization: {@link HostObject#readMember}
             *        Parameter: {@link LookupMethodNode} lookupMethod
             *        Inline method: {@link LookupMethodNodeGen#inline}
             *   28-29: InlinedCache
             *        Specialization: {@link HostObject#isExecutable}
             *        Parameter: {@link LookupFunctionalMethodNode} lookupMethod
             *        Inline method: {@link LookupFunctionalMethodNodeGen#inline}
             * </pre>
             */
            @CompilationFinal @UnsafeAccessedField private int state_6_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IsArrayElementReadable#doArray}
             *   Parameter: {@link HostClassCache} hostClassCache</pre>
             */
            @CompilationFinal private HostClassCache hostClassCache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link WriteArrayElement#doArray}
             *   Parameter: {@link HostToTypeNode} toHostNode
             *   Inline method: {@link HostToTypeNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node toHost_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadArrayElement#doArray}
             *   Parameter: {@link ToGuestValueNode} toGuest
             *   Inline method: {@link ToGuestValueNodeGen#inline}
             *   Inline field: {@link Object} field1</pre>
             */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Object toGuest_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link ReadBufferByte#doNonNull}
             *   Parameter: {@link InlinedExactClassProfile} classProfile
             *   Inline method: {@link InlinedExactClassProfile#inline}
             *   Inline field: {@link Class} field1</pre>
             */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Class<?> classProfile_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IsInstantiable#doObjectCached}
             *   Parameter: {@link LookupConstructorNode} lookupConstructor
             *   Inline method: {@link LookupConstructorNodeGen#inline}
             *   Inline field: {@link Object} field1</pre>
             */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Object lookupConstructor_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link Instantiate#doObjectCached}
             *   Parameter: {@link HostExecuteNode} executeMethod
             *   Inline method: {@link HostExecuteNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node hostExecute_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link Instantiate#doObjectCached}
             *   Parameter: {@link HostExecuteNode} executeMethod
             *   Inline method: {@link HostExecuteNodeGen#inline}
             *   Inline field: {@link Object} field2</pre>
             */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Object hostExecute_field2_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link Instantiate#doObjectCached}
             *   Parameter: {@link HostExecuteNode} executeMethod
             *   Inline method: {@link HostExecuteNodeGen#inline}
             *   Inline field: {@link Object} field3</pre>
             */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Object hostExecute_field3_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link Instantiate#doObjectCached}
             *   Parameter: {@link HostExecuteNode} executeMethod
             *   Inline method: {@link HostExecuteNodeGen#inline}
             *   Inline field: {@link Node} field4</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node hostExecute_field4_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link Instantiate#doObjectCached}
             *   Parameter: {@link HostExecuteNode} executeMethod
             *   Inline method: {@link HostExecuteNodeGen#inline}
             *   Inline field: {@link Node} field5</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node hostExecute_field5_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link Instantiate#doObjectCached}
             *   Parameter: {@link HostExecuteNode} executeMethod
             *   Inline method: {@link HostExecuteNodeGen#inline}
             *   Inline field: {@link Node} field6</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node hostExecute_field6_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link FitsInByte#doOther}
             *   Parameter: {@link InteropLibrary} numbers</pre>
             */
            @Child private InteropLibrary numbers;
            /**
             * Source Info: <pre>
             *   Specialization: {@link IsHashEntryReadable#doNonNull}
             *   Parameter: {@link ContainsKeyNode} containsKey
             *   Inline method: {@link ContainsKeyNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node containsKey_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HostObject#readMember}
             *   Parameter: {@link LookupFieldNode} lookupField
             *   Inline method: {@link LookupFieldNodeGen#inline}
             *   Inline field: {@link Object} field1</pre>
             */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Object lookupField_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HostObject#readMember}
             *   Parameter: {@link ReadFieldNode} readField
             *   Inline method: {@link ReadFieldNodeGen#inline}
             *   Inline field: {@link Node} field1</pre>
             */
            @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node readField_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HostObject#readMember}
             *   Parameter: {@link LookupMethodNode} lookupMethod
             *   Inline method: {@link LookupMethodNodeGen#inline}
             *   Inline field: {@link Object} field1</pre>
             */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Object lookupMethod_field1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HostObject#isExecutable}
             *   Parameter: {@link LookupFunctionalMethodNode} lookupMethod
             *   Inline method: {@link LookupFunctionalMethodNodeGen#inline}
             *   Inline field: {@link Object} field1</pre>
             */
            @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Object lookupFunctionalMethod_field1_;
            @UnsafeAccessedField @CompilationFinal private IsMemberReadableCachedData isMemberReadable_cached_cache;
            @UnsafeAccessedField @CompilationFinal private IsMemberModifiableCachedData isMemberModifiable_cached_cache;
            @UnsafeAccessedField @CompilationFinal private IsMemberInternalCachedData isMemberInternal_cached_cache;
            @UnsafeAccessedField @CompilationFinal private IsMemberInvocableCachedData isMemberInvocable_cached_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link Instantiate#doArrayCached}
             *   Parameter: {@link InteropLibrary} indexes</pre>
             */
            @Child private InteropLibrary instantiate_arrayCached_indexes_;
            @Child private ReadMemberNode_ReadMemberData readMemberNode__readMember_cache;
            @Child private WriteMemberNode_WriteMemberData writeMemberNode__writeMember_cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HostObject#invokeMember(HostObject, String, Object[], Node, LookupMethodNode, HostExecuteNode, LookupFieldNode, ReadFieldNode, InteropLibrary, InlinedBranchProfile)}
             *   Parameter: {@link InteropLibrary} fieldValues</pre>
             */
            @Child private InteropLibrary invokeMemberNode__invokeMember_fieldValues_;

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof HostObject) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof HostObject;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsMemberReadable#doCached}
             *     Activation probability: 0.00867
             *     With/without class size: 4/10 bytes
             *   Specialization {@link IsMemberReadable#doUncached}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @ExplodeLoop
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[HostObject.IsMemberReadable.doCached(HostObject, String, boolean, Class<>, String, boolean)] || SpecializationActive[HostObject.IsMemberReadable.doUncached(HostObject, String)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[HostObject.IsMemberReadable.doCached(HostObject, String, boolean, Class<>, String, boolean)] */ && (arg0Value.isStaticClass())) {
                        IsMemberReadableCachedData s0_ = this.isMemberReadable_cached_cache;
                        while (s0_ != null) {
                            if ((arg0Value.isStaticClass() == s0_.cachedStatic_) && (arg0Value.getLookupClass() == s0_.cachedClazz_) && (s0_.cachedName_.equals(arg1Value))) {
                                return IsMemberReadable.doCached(arg0Value, arg1Value, s0_.cachedStatic_, s0_.cachedClazz_, s0_.cachedName_, s0_.cachedReadable_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[HostObject.IsMemberReadable.doUncached(HostObject, String)] */) {
                        return IsMemberReadable.doUncached(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberReadableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberReadableAndSpecialize(HostObject arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                if (((state_0 & 0b10)) == 0 /* is-not SpecializationActive[HostObject.IsMemberReadable.doUncached(HostObject, String)] */ && (arg0Value.isStaticClass())) {
                    while (true) {
                        int count0_ = 0;
                        IsMemberReadableCachedData s0_ = IS_MEMBER_READABLE_CACHED_CACHE_UPDATER.getVolatile(this);
                        IsMemberReadableCachedData s0_original = s0_;
                        while (s0_ != null) {
                            if ((arg0Value.isStaticClass() == s0_.cachedStatic_) && (arg0Value.getLookupClass() == s0_.cachedClazz_) && (s0_.cachedName_.equals(arg1Value))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            {
                                boolean cachedStatic__ = (arg0Value.isStaticClass());
                                if ((arg0Value.isStaticClass() == cachedStatic__)) {
                                    Class<?> cachedClazz__ = (arg0Value.getLookupClass());
                                    if ((arg0Value.getLookupClass() == cachedClazz__)) {
                                        // assert (s0_.cachedName_.equals(arg1Value));
                                        if (count0_ < (HostObject.LIMIT)) {
                                            s0_ = new IsMemberReadableCachedData(s0_original);
                                            s0_.cachedStatic_ = cachedStatic__;
                                            s0_.cachedClazz_ = cachedClazz__;
                                            s0_.cachedName_ = (arg1Value);
                                            s0_.cachedReadable_ = (IsMemberReadable.doUncached(arg0Value, arg1Value));
                                            if (!IS_MEMBER_READABLE_CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                                continue;
                                            }
                                            state_0 = state_0 | 0b1 /* add SpecializationActive[HostObject.IsMemberReadable.doCached(HostObject, String, boolean, Class<>, String, boolean)] */;
                                            this.state_0_ = state_0;
                                        }
                                    }
                                }
                            }
                        }
                        if (s0_ != null) {
                            return IsMemberReadable.doCached(arg0Value, arg1Value, s0_.cachedStatic_, s0_.cachedClazz_, s0_.cachedName_, s0_.cachedReadable_);
                        }
                        break;
                    }
                }
                this.isMemberReadable_cached_cache = null;
                state_0 = state_0 & 0xfffffffe /* remove SpecializationActive[HostObject.IsMemberReadable.doCached(HostObject, String, boolean, Class<>, String, boolean)] */;
                state_0 = state_0 | 0b10 /* add SpecializationActive[HostObject.IsMemberReadable.doUncached(HostObject, String)] */;
                this.state_0_ = state_0;
                return IsMemberReadable.doUncached(arg0Value, arg1Value);
            }

            @Override
            public NodeCost getCost() {
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) == 0) {
                    return NodeCost.UNINITIALIZED;
                } else {
                    if (((state_0 & 0b11) & ((state_0 & 0b11) - 1)) == 0 /* is-single  */) {
                        IsMemberReadableCachedData s0_ = this.isMemberReadable_cached_cache;
                        if ((s0_ == null || s0_.next_ == null)) {
                            return NodeCost.MONOMORPHIC;
                        }
                    }
                }
                return NodeCost.POLYMORPHIC;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsMemberModifiable#doCached}
             *     Activation probability: 0.00867
             *     With/without class size: 4/10 bytes
             *   Specialization {@link IsMemberModifiable#doUncached}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @ExplodeLoop
            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1100) != 0 /* is SpecializationActive[HostObject.IsMemberModifiable.doCached(HostObject, String, boolean, Class<>, String, boolean)] || SpecializationActive[HostObject.IsMemberModifiable.doUncached(HostObject, String)] */) {
                    if ((state_0 & 0b100) != 0 /* is SpecializationActive[HostObject.IsMemberModifiable.doCached(HostObject, String, boolean, Class<>, String, boolean)] */ && (arg0Value.isStaticClass())) {
                        IsMemberModifiableCachedData s0_ = this.isMemberModifiable_cached_cache;
                        while (s0_ != null) {
                            if ((arg0Value.isStaticClass() == s0_.cachedStatic_) && (arg0Value.getLookupClass() == s0_.cachedClazz_) && (s0_.cachedName_.equals(arg1Value))) {
                                return IsMemberModifiable.doCached(arg0Value, arg1Value, s0_.cachedStatic_, s0_.cachedClazz_, s0_.cachedName_, s0_.cachedModifiable_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b1000) != 0 /* is SpecializationActive[HostObject.IsMemberModifiable.doUncached(HostObject, String)] */) {
                        return IsMemberModifiable.doUncached(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberModifiableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberModifiableAndSpecialize(HostObject arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                if (((state_0 & 0b1000)) == 0 /* is-not SpecializationActive[HostObject.IsMemberModifiable.doUncached(HostObject, String)] */ && (arg0Value.isStaticClass())) {
                    while (true) {
                        int count0_ = 0;
                        IsMemberModifiableCachedData s0_ = IS_MEMBER_MODIFIABLE_CACHED_CACHE_UPDATER.getVolatile(this);
                        IsMemberModifiableCachedData s0_original = s0_;
                        while (s0_ != null) {
                            if ((arg0Value.isStaticClass() == s0_.cachedStatic_) && (arg0Value.getLookupClass() == s0_.cachedClazz_) && (s0_.cachedName_.equals(arg1Value))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            {
                                boolean cachedStatic__ = (arg0Value.isStaticClass());
                                if ((arg0Value.isStaticClass() == cachedStatic__)) {
                                    Class<?> cachedClazz__ = (arg0Value.getLookupClass());
                                    if ((arg0Value.getLookupClass() == cachedClazz__)) {
                                        // assert (s0_.cachedName_.equals(arg1Value));
                                        if (count0_ < (HostObject.LIMIT)) {
                                            s0_ = new IsMemberModifiableCachedData(s0_original);
                                            s0_.cachedStatic_ = cachedStatic__;
                                            s0_.cachedClazz_ = cachedClazz__;
                                            s0_.cachedName_ = (arg1Value);
                                            s0_.cachedModifiable_ = (IsMemberModifiable.doUncached(arg0Value, arg1Value));
                                            if (!IS_MEMBER_MODIFIABLE_CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                                continue;
                                            }
                                            state_0 = state_0 | 0b100 /* add SpecializationActive[HostObject.IsMemberModifiable.doCached(HostObject, String, boolean, Class<>, String, boolean)] */;
                                            this.state_0_ = state_0;
                                        }
                                    }
                                }
                            }
                        }
                        if (s0_ != null) {
                            return IsMemberModifiable.doCached(arg0Value, arg1Value, s0_.cachedStatic_, s0_.cachedClazz_, s0_.cachedName_, s0_.cachedModifiable_);
                        }
                        break;
                    }
                }
                this.isMemberModifiable_cached_cache = null;
                state_0 = state_0 & 0xfffffffb /* remove SpecializationActive[HostObject.IsMemberModifiable.doCached(HostObject, String, boolean, Class<>, String, boolean)] */;
                state_0 = state_0 | 0b1000 /* add SpecializationActive[HostObject.IsMemberModifiable.doUncached(HostObject, String)] */;
                this.state_0_ = state_0;
                return IsMemberModifiable.doUncached(arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsMemberInternal#doCached}
             *     Activation probability: 0.00867
             *     With/without class size: 4/10 bytes
             *   Specialization {@link IsMemberInternal#doUncached}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @ExplodeLoop
            @Override
            public boolean isMemberInternal(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b110000) != 0 /* is SpecializationActive[HostObject.IsMemberInternal.doCached(HostObject, String, boolean, Class<>, String, boolean)] || SpecializationActive[HostObject.IsMemberInternal.doUncached(HostObject, String)] */) {
                    if ((state_0 & 0b10000) != 0 /* is SpecializationActive[HostObject.IsMemberInternal.doCached(HostObject, String, boolean, Class<>, String, boolean)] */ && (arg0Value.isStaticClass())) {
                        IsMemberInternalCachedData s0_ = this.isMemberInternal_cached_cache;
                        while (s0_ != null) {
                            if ((arg0Value.isStaticClass() == s0_.cachedStatic_) && (arg0Value.getLookupClass() == s0_.cachedClazz_) && (s0_.cachedName_.equals(arg1Value))) {
                                return IsMemberInternal.doCached(arg0Value, arg1Value, s0_.cachedStatic_, s0_.cachedClazz_, s0_.cachedName_, s0_.cachedInternal_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b100000) != 0 /* is SpecializationActive[HostObject.IsMemberInternal.doUncached(HostObject, String)] */) {
                        return IsMemberInternal.doUncached(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberInternalAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInternalAndSpecialize(HostObject arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                if (((state_0 & 0b100000)) == 0 /* is-not SpecializationActive[HostObject.IsMemberInternal.doUncached(HostObject, String)] */ && (arg0Value.isStaticClass())) {
                    while (true) {
                        int count0_ = 0;
                        IsMemberInternalCachedData s0_ = IS_MEMBER_INTERNAL_CACHED_CACHE_UPDATER.getVolatile(this);
                        IsMemberInternalCachedData s0_original = s0_;
                        while (s0_ != null) {
                            if ((arg0Value.isStaticClass() == s0_.cachedStatic_) && (arg0Value.getLookupClass() == s0_.cachedClazz_) && (s0_.cachedName_.equals(arg1Value))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            {
                                boolean cachedStatic__ = (arg0Value.isStaticClass());
                                if ((arg0Value.isStaticClass() == cachedStatic__)) {
                                    Class<?> cachedClazz__ = (arg0Value.getLookupClass());
                                    if ((arg0Value.getLookupClass() == cachedClazz__)) {
                                        // assert (s0_.cachedName_.equals(arg1Value));
                                        if (count0_ < (HostObject.LIMIT)) {
                                            s0_ = new IsMemberInternalCachedData(s0_original);
                                            s0_.cachedStatic_ = cachedStatic__;
                                            s0_.cachedClazz_ = cachedClazz__;
                                            s0_.cachedName_ = (arg1Value);
                                            s0_.cachedInternal_ = (IsMemberInternal.doUncached(arg0Value, arg1Value));
                                            if (!IS_MEMBER_INTERNAL_CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                                continue;
                                            }
                                            state_0 = state_0 | 0b10000 /* add SpecializationActive[HostObject.IsMemberInternal.doCached(HostObject, String, boolean, Class<>, String, boolean)] */;
                                            this.state_0_ = state_0;
                                        }
                                    }
                                }
                            }
                        }
                        if (s0_ != null) {
                            return IsMemberInternal.doCached(arg0Value, arg1Value, s0_.cachedStatic_, s0_.cachedClazz_, s0_.cachedName_, s0_.cachedInternal_);
                        }
                        break;
                    }
                }
                this.isMemberInternal_cached_cache = null;
                state_0 = state_0 & 0xffffffef /* remove SpecializationActive[HostObject.IsMemberInternal.doCached(HostObject, String, boolean, Class<>, String, boolean)] */;
                state_0 = state_0 | 0b100000 /* add SpecializationActive[HostObject.IsMemberInternal.doUncached(HostObject, String)] */;
                this.state_0_ = state_0;
                return IsMemberInternal.doUncached(arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsMemberInvocable#doCached}
             *     Activation probability: 0.00867
             *     With/without class size: 4/10 bytes
             *   Specialization {@link IsMemberInvocable#doUncached}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @ExplodeLoop
            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b11000000) != 0 /* is SpecializationActive[HostObject.IsMemberInvocable.doCached(HostObject, String, boolean, Class<>, String, boolean)] || SpecializationActive[HostObject.IsMemberInvocable.doUncached(HostObject, String)] */) {
                    if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[HostObject.IsMemberInvocable.doCached(HostObject, String, boolean, Class<>, String, boolean)] */ && (arg0Value.isStaticClass())) {
                        IsMemberInvocableCachedData s0_ = this.isMemberInvocable_cached_cache;
                        while (s0_ != null) {
                            if ((arg0Value.isStaticClass() == s0_.cachedStatic_) && (arg0Value.getLookupClass() == s0_.cachedClazz_) && (s0_.cachedName_.equals(arg1Value))) {
                                return IsMemberInvocable.doCached(arg0Value, arg1Value, s0_.cachedStatic_, s0_.cachedClazz_, s0_.cachedName_, s0_.cachedInvokable_);
                            }
                            s0_ = s0_.next_;
                        }
                    }
                    if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[HostObject.IsMemberInvocable.doUncached(HostObject, String)] */) {
                        return IsMemberInvocable.doUncached(arg0Value, arg1Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberInvocableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInvocableAndSpecialize(HostObject arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                if (((state_0 & 0b10000000)) == 0 /* is-not SpecializationActive[HostObject.IsMemberInvocable.doUncached(HostObject, String)] */ && (arg0Value.isStaticClass())) {
                    while (true) {
                        int count0_ = 0;
                        IsMemberInvocableCachedData s0_ = IS_MEMBER_INVOCABLE_CACHED_CACHE_UPDATER.getVolatile(this);
                        IsMemberInvocableCachedData s0_original = s0_;
                        while (s0_ != null) {
                            if ((arg0Value.isStaticClass() == s0_.cachedStatic_) && (arg0Value.getLookupClass() == s0_.cachedClazz_) && (s0_.cachedName_.equals(arg1Value))) {
                                break;
                            }
                            count0_++;
                            s0_ = s0_.next_;
                        }
                        if (s0_ == null) {
                            {
                                boolean cachedStatic__ = (arg0Value.isStaticClass());
                                if ((arg0Value.isStaticClass() == cachedStatic__)) {
                                    Class<?> cachedClazz__ = (arg0Value.getLookupClass());
                                    if ((arg0Value.getLookupClass() == cachedClazz__)) {
                                        // assert (s0_.cachedName_.equals(arg1Value));
                                        if (count0_ < (HostObject.LIMIT)) {
                                            s0_ = new IsMemberInvocableCachedData(s0_original);
                                            s0_.cachedStatic_ = cachedStatic__;
                                            s0_.cachedClazz_ = cachedClazz__;
                                            s0_.cachedName_ = (arg1Value);
                                            s0_.cachedInvokable_ = (IsMemberInvocable.doUncached(arg0Value, arg1Value));
                                            if (!IS_MEMBER_INVOCABLE_CACHED_CACHE_UPDATER.compareAndSet(this, s0_original, s0_)) {
                                                continue;
                                            }
                                            state_0 = state_0 | 0b1000000 /* add SpecializationActive[HostObject.IsMemberInvocable.doCached(HostObject, String, boolean, Class<>, String, boolean)] */;
                                            this.state_0_ = state_0;
                                        }
                                    }
                                }
                            }
                        }
                        if (s0_ != null) {
                            return IsMemberInvocable.doCached(arg0Value, arg1Value, s0_.cachedStatic_, s0_.cachedClazz_, s0_.cachedName_, s0_.cachedInvokable_);
                        }
                        break;
                    }
                }
                this.isMemberInvocable_cached_cache = null;
                state_0 = state_0 & 0xffffffbf /* remove SpecializationActive[HostObject.IsMemberInvocable.doCached(HostObject, String, boolean, Class<>, String, boolean)] */;
                state_0 = state_0 | 0b10000000 /* add SpecializationActive[HostObject.IsMemberInvocable.doUncached(HostObject, String)] */;
                this.state_0_ = state_0;
                return IsMemberInvocable.doUncached(arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsArrayElementReadable#doNull}
             *     Activation probability: 0.00427
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsArrayElementReadable#doArray}
             *     Activation probability: 0.00347
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsArrayElementReadable#doList}
             *     Activation probability: 0.00267
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsArrayElementReadable#doMapEntry}
             *     Activation probability: 0.00187
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsArrayElementReadable#doNotArrayOrList}
             *     Activation probability: 0.00107
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1111100000000) != 0 /* is SpecializationActive[HostObject.IsArrayElementReadable.doNull(HostObject, long)] || SpecializationActive[HostObject.IsArrayElementReadable.doArray(HostObject, long, HostClassCache)] || SpecializationActive[HostObject.IsArrayElementReadable.doList(HostObject, long, Node, HostClassCache, InlinedBranchProfile)] || SpecializationActive[HostObject.IsArrayElementReadable.doMapEntry(HostObject, long, HostClassCache)] || SpecializationActive[HostObject.IsArrayElementReadable.doNotArrayOrList(HostObject, long, HostClassCache)] */) {
                    if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[HostObject.IsArrayElementReadable.doNull(HostObject, long)] */) {
                        if ((arg0Value.isNull())) {
                            return IsArrayElementReadable.doNull(arg0Value, arg1Value);
                        }
                    }
                    if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[HostObject.IsArrayElementReadable.doArray(HostObject, long, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isArray(hostClassCache_))) {
                                    return IsArrayElementReadable.doArray(arg0Value, arg1Value, hostClassCache_);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[HostObject.IsArrayElementReadable.doList(HostObject, long, Node, HostClassCache, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_1 = this.hostClassCache;
                            if (hostClassCache_1 != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isList(hostClassCache_1))) {
                                    Node node__ = (this);
                                    return IsArrayElementReadable.doList(arg0Value, arg1Value, node__, hostClassCache_1, INLINED_ERROR);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[HostObject.IsArrayElementReadable.doMapEntry(HostObject, long, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_2 = this.hostClassCache;
                            if (hostClassCache_2 != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isMapEntry(hostClassCache_2))) {
                                    return IsArrayElementReadable.doMapEntry(arg0Value, arg1Value, hostClassCache_2);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[HostObject.IsArrayElementReadable.doNotArrayOrList(HostObject, long, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_3 = this.hostClassCache;
                            if (hostClassCache_3 != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isList(hostClassCache_3))) && (!(arg0Value.isArray(hostClassCache_3))) && (!(arg0Value.isMapEntry(hostClassCache_3)))) {
                                    return IsArrayElementReadable.doNotArrayOrList(arg0Value, arg1Value, hostClassCache_3);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isArrayElementReadableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementReadableAndSpecialize(HostObject arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                if ((arg0Value.isNull())) {
                    state_0 = state_0 | 0b100000000 /* add SpecializationActive[HostObject.IsArrayElementReadable.doNull(HostObject, long)] */;
                    this.state_0_ = state_0;
                    return IsArrayElementReadable.doNull(arg0Value, arg1Value);
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = (arg0Value.getHostClassCache());
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("Specialization 'doArray(HostObject, long, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if ((arg0Value.isArray(hostClassCache_))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_0 = state_0 | 0b1000000000 /* add SpecializationActive[HostObject.IsArrayElementReadable.doArray(HostObject, long, HostClassCache)] */;
                        this.state_0_ = state_0;
                        return IsArrayElementReadable.doArray(arg0Value, arg1Value, hostClassCache_);
                    }
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        HostClassCache hostClassCache_1;
                        HostClassCache hostClassCache_1_shared = this.hostClassCache;
                        if (hostClassCache_1_shared != null) {
                            hostClassCache_1 = hostClassCache_1_shared;
                        } else {
                            hostClassCache_1 = (arg0Value.getHostClassCache());
                            if (hostClassCache_1 == null) {
                                throw new IllegalStateException("Specialization 'doList(HostObject, long, Node, HostClassCache, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((arg0Value.isList(hostClassCache_1))) {
                            node__ = (this);
                            if (this.hostClassCache == null) {
                                VarHandle.storeStoreFence();
                                this.hostClassCache = hostClassCache_1;
                            }
                            state_0 = state_0 | 0b10000000000 /* add SpecializationActive[HostObject.IsArrayElementReadable.doList(HostObject, long, Node, HostClassCache, InlinedBranchProfile)] */;
                            this.state_0_ = state_0;
                            return IsArrayElementReadable.doList(arg0Value, arg1Value, node__, hostClassCache_1, INLINED_ERROR);
                        }
                    }
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_2;
                    HostClassCache hostClassCache_2_shared = this.hostClassCache;
                    if (hostClassCache_2_shared != null) {
                        hostClassCache_2 = hostClassCache_2_shared;
                    } else {
                        hostClassCache_2 = (arg0Value.getHostClassCache());
                        if (hostClassCache_2 == null) {
                            throw new IllegalStateException("Specialization 'doMapEntry(HostObject, long, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if ((arg0Value.isMapEntry(hostClassCache_2))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_2;
                        }
                        state_0 = state_0 | 0b100000000000 /* add SpecializationActive[HostObject.IsArrayElementReadable.doMapEntry(HostObject, long, HostClassCache)] */;
                        this.state_0_ = state_0;
                        return IsArrayElementReadable.doMapEntry(arg0Value, arg1Value, hostClassCache_2);
                    }
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_3;
                    HostClassCache hostClassCache_3_shared = this.hostClassCache;
                    if (hostClassCache_3_shared != null) {
                        hostClassCache_3 = hostClassCache_3_shared;
                    } else {
                        hostClassCache_3 = (arg0Value.getHostClassCache());
                        if (hostClassCache_3 == null) {
                            throw new IllegalStateException("Specialization 'doNotArrayOrList(HostObject, long, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if ((!(arg0Value.isList(hostClassCache_3))) && (!(arg0Value.isArray(hostClassCache_3))) && (!(arg0Value.isMapEntry(hostClassCache_3)))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_3;
                        }
                        state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[HostObject.IsArrayElementReadable.doNotArrayOrList(HostObject, long, HostClassCache)] */;
                        this.state_0_ = state_0;
                        return IsArrayElementReadable.doNotArrayOrList(arg0Value, arg1Value, hostClassCache_3);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsArrayElementModifiable#doNull}
             *     Activation probability: 0.00427
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsArrayElementModifiable#doArray}
             *     Activation probability: 0.00347
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsArrayElementModifiable#doList}
             *     Activation probability: 0.00267
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsArrayElementModifiable#doMapEntry}
             *     Activation probability: 0.00187
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsArrayElementModifiable#doNotArrayOrList}
             *     Activation probability: 0.00107
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x3e000) != 0 /* is SpecializationActive[HostObject.IsArrayElementModifiable.doNull(HostObject, long)] || SpecializationActive[HostObject.IsArrayElementModifiable.doArray(HostObject, long, HostClassCache)] || SpecializationActive[HostObject.IsArrayElementModifiable.doList(HostObject, long, Node, HostClassCache, InlinedBranchProfile)] || SpecializationActive[HostObject.IsArrayElementModifiable.doMapEntry(HostObject, long, HostClassCache)] || SpecializationActive[HostObject.IsArrayElementModifiable.doNotArrayOrList(HostObject, long, HostClassCache)] */) {
                    if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[HostObject.IsArrayElementModifiable.doNull(HostObject, long)] */) {
                        if ((arg0Value.isNull())) {
                            return IsArrayElementModifiable.doNull(arg0Value, arg1Value);
                        }
                    }
                    if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[HostObject.IsArrayElementModifiable.doArray(HostObject, long, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isArray(hostClassCache_))) {
                                    return IsArrayElementModifiable.doArray(arg0Value, arg1Value, hostClassCache_);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[HostObject.IsArrayElementModifiable.doList(HostObject, long, Node, HostClassCache, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_1 = this.hostClassCache;
                            if (hostClassCache_1 != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isList(hostClassCache_1))) {
                                    Node node__ = (this);
                                    return IsArrayElementModifiable.doList(arg0Value, arg1Value, node__, hostClassCache_1, INLINED_ERROR);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0x10000) != 0 /* is SpecializationActive[HostObject.IsArrayElementModifiable.doMapEntry(HostObject, long, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_2 = this.hostClassCache;
                            if (hostClassCache_2 != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isMapEntry(hostClassCache_2))) {
                                    return IsArrayElementModifiable.doMapEntry(arg0Value, arg1Value, hostClassCache_2);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0x20000) != 0 /* is SpecializationActive[HostObject.IsArrayElementModifiable.doNotArrayOrList(HostObject, long, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_3 = this.hostClassCache;
                            if (hostClassCache_3 != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isList(hostClassCache_3))) && (!(arg0Value.isArray(hostClassCache_3))) && (!(arg0Value.isMapEntry(hostClassCache_3)))) {
                                    return IsArrayElementModifiable.doNotArrayOrList(arg0Value, arg1Value, hostClassCache_3);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isArrayElementModifiableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementModifiableAndSpecialize(HostObject arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                if ((arg0Value.isNull())) {
                    state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[HostObject.IsArrayElementModifiable.doNull(HostObject, long)] */;
                    this.state_0_ = state_0;
                    return IsArrayElementModifiable.doNull(arg0Value, arg1Value);
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = (arg0Value.getHostClassCache());
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("Specialization 'doArray(HostObject, long, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if ((arg0Value.isArray(hostClassCache_))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[HostObject.IsArrayElementModifiable.doArray(HostObject, long, HostClassCache)] */;
                        this.state_0_ = state_0;
                        return IsArrayElementModifiable.doArray(arg0Value, arg1Value, hostClassCache_);
                    }
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        HostClassCache hostClassCache_1;
                        HostClassCache hostClassCache_1_shared = this.hostClassCache;
                        if (hostClassCache_1_shared != null) {
                            hostClassCache_1 = hostClassCache_1_shared;
                        } else {
                            hostClassCache_1 = (arg0Value.getHostClassCache());
                            if (hostClassCache_1 == null) {
                                throw new IllegalStateException("Specialization 'doList(HostObject, long, Node, HostClassCache, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((arg0Value.isList(hostClassCache_1))) {
                            node__ = (this);
                            if (this.hostClassCache == null) {
                                VarHandle.storeStoreFence();
                                this.hostClassCache = hostClassCache_1;
                            }
                            state_0 = state_0 | 0b1000000000000000 /* add SpecializationActive[HostObject.IsArrayElementModifiable.doList(HostObject, long, Node, HostClassCache, InlinedBranchProfile)] */;
                            this.state_0_ = state_0;
                            return IsArrayElementModifiable.doList(arg0Value, arg1Value, node__, hostClassCache_1, INLINED_ERROR);
                        }
                    }
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_2;
                    HostClassCache hostClassCache_2_shared = this.hostClassCache;
                    if (hostClassCache_2_shared != null) {
                        hostClassCache_2 = hostClassCache_2_shared;
                    } else {
                        hostClassCache_2 = (arg0Value.getHostClassCache());
                        if (hostClassCache_2 == null) {
                            throw new IllegalStateException("Specialization 'doMapEntry(HostObject, long, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if ((arg0Value.isMapEntry(hostClassCache_2))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_2;
                        }
                        state_0 = state_0 | 0x10000 /* add SpecializationActive[HostObject.IsArrayElementModifiable.doMapEntry(HostObject, long, HostClassCache)] */;
                        this.state_0_ = state_0;
                        return IsArrayElementModifiable.doMapEntry(arg0Value, arg1Value, hostClassCache_2);
                    }
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_3;
                    HostClassCache hostClassCache_3_shared = this.hostClassCache;
                    if (hostClassCache_3_shared != null) {
                        hostClassCache_3 = hostClassCache_3_shared;
                    } else {
                        hostClassCache_3 = (arg0Value.getHostClassCache());
                        if (hostClassCache_3 == null) {
                            throw new IllegalStateException("Specialization 'doNotArrayOrList(HostObject, long, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if ((!(arg0Value.isList(hostClassCache_3))) && (!(arg0Value.isArray(hostClassCache_3))) && (!(arg0Value.isMapEntry(hostClassCache_3)))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_3;
                        }
                        state_0 = state_0 | 0x20000 /* add SpecializationActive[HostObject.IsArrayElementModifiable.doNotArrayOrList(HostObject, long, HostClassCache)] */;
                        this.state_0_ = state_0;
                        return IsArrayElementModifiable.doNotArrayOrList(arg0Value, arg1Value, hostClassCache_3);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsArrayElementInsertable#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsArrayElementInsertable#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0xc0000) != 0 /* is SpecializationActive[HostObject.IsArrayElementInsertable.doNull(HostObject, long)] || SpecializationActive[HostObject.IsArrayElementInsertable.doNonNull(HostObject, long, Node, HostClassCache, InlinedBranchProfile)] */) {
                    if ((state_0 & 0x40000) != 0 /* is SpecializationActive[HostObject.IsArrayElementInsertable.doNull(HostObject, long)] */) {
                        if ((arg0Value.isNull())) {
                            return IsArrayElementInsertable.doNull(arg0Value, arg1Value);
                        }
                    }
                    if ((state_0 & 0x80000) != 0 /* is SpecializationActive[HostObject.IsArrayElementInsertable.doNonNull(HostObject, long, Node, HostClassCache, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    Node node__ = (this);
                                    return IsArrayElementInsertable.doNonNull(arg0Value, arg1Value, node__, hostClassCache_, INLINED_ERROR);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isArrayElementInsertableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementInsertableAndSpecialize(HostObject arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                if ((arg0Value.isNull())) {
                    state_0 = state_0 | 0x40000 /* add SpecializationActive[HostObject.IsArrayElementInsertable.doNull(HostObject, long)] */;
                    this.state_0_ = state_0;
                    return IsArrayElementInsertable.doNull(arg0Value, arg1Value);
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doNonNull(HostObject, long, Node, HostClassCache, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_0 = state_0 | 0x80000 /* add SpecializationActive[HostObject.IsArrayElementInsertable.doNonNull(HostObject, long, Node, HostClassCache, InlinedBranchProfile)] */;
                        this.state_0_ = state_0;
                        return IsArrayElementInsertable.doNonNull(arg0Value, arg1Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link WriteArrayElement#doNull}
             *     Activation probability: 0.00427
             *     With/without class size: 4/0 bytes
             *   Specialization {@link WriteArrayElement#doArray}
             *     Activation probability: 0.00347
             *     With/without class size: 4/2 bytes
             *   Specialization {@link WriteArrayElement#doList}
             *     Activation probability: 0.00267
             *     With/without class size: 4/0 bytes
             *   Specialization {@link WriteArrayElement#doMapEntry}
             *     Activation probability: 0.00187
             *     With/without class size: 4/0 bytes
             *   Specialization {@link WriteArrayElement#doNotArrayOrList}
             *     Activation probability: 0.00107
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x1f00000) != 0 /* is SpecializationActive[HostObject.WriteArrayElement.doNull(HostObject, long, Object)] || SpecializationActive[HostObject.WriteArrayElement.doArray(HostObject, long, Object, Node, HostToTypeNode, HostClassCache, ArraySet, InlinedBranchProfile)] || SpecializationActive[HostObject.WriteArrayElement.doList(HostObject, long, Object, Node, HostClassCache, HostToTypeNode, InlinedBranchProfile)] || SpecializationActive[HostObject.WriteArrayElement.doMapEntry(HostObject, long, Object, Node, HostClassCache, HostToTypeNode, InlinedBranchProfile)] || SpecializationActive[HostObject.WriteArrayElement.doNotArrayOrList(HostObject, long, Object, HostClassCache)] */) {
                    if ((state_0 & 0x100000) != 0 /* is SpecializationActive[HostObject.WriteArrayElement.doNull(HostObject, long, Object)] */) {
                        if ((arg0Value.isNull())) {
                            WriteArrayElement.doNull(arg0Value, arg1Value, arg2Value);
                            return;
                        }
                    }
                    if ((state_0 & 0x200000) != 0 /* is SpecializationActive[HostObject.WriteArrayElement.doArray(HostObject, long, Object, Node, HostToTypeNode, HostClassCache, ArraySet, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isArray(hostClassCache_))) {
                                    Node node__ = (this);
                                    WriteArrayElement.doArray(arg0Value, arg1Value, arg2Value, node__, INLINED_TO_HOST, hostClassCache_, INLINED_WRITE_ARRAY_ELEMENT_ARRAY_ARRAY_SET_, INLINED_ERROR);
                                    return;
                                }
                            }
                        }
                    }
                    if ((state_0 & 0x400000) != 0 /* is SpecializationActive[HostObject.WriteArrayElement.doList(HostObject, long, Object, Node, HostClassCache, HostToTypeNode, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_1 = this.hostClassCache;
                            if (hostClassCache_1 != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isList(hostClassCache_1))) {
                                    Node node__1 = (this);
                                    WriteArrayElement.doList(arg0Value, arg1Value, arg2Value, node__1, hostClassCache_1, INLINED_TO_HOST, INLINED_ERROR);
                                    return;
                                }
                            }
                        }
                    }
                    if ((state_0 & 0x800000) != 0 /* is SpecializationActive[HostObject.WriteArrayElement.doMapEntry(HostObject, long, Object, Node, HostClassCache, HostToTypeNode, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_2 = this.hostClassCache;
                            if (hostClassCache_2 != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isMapEntry(hostClassCache_2))) {
                                    Node node__2 = (this);
                                    WriteArrayElement.doMapEntry(arg0Value, arg1Value, arg2Value, node__2, hostClassCache_2, INLINED_TO_HOST, INLINED_ERROR);
                                    return;
                                }
                            }
                        }
                    }
                    if ((state_0 & 0x1000000) != 0 /* is SpecializationActive[HostObject.WriteArrayElement.doNotArrayOrList(HostObject, long, Object, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_3 = this.hostClassCache;
                            if (hostClassCache_3 != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isList(hostClassCache_3))) && (!(arg0Value.isArray(hostClassCache_3))) && (!(arg0Value.isMapEntry(hostClassCache_3)))) {
                                    WriteArrayElement.doNotArrayOrList(arg0Value, arg1Value, arg2Value, hostClassCache_3);
                                    return;
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeArrayElementAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeArrayElementAndSpecialize(HostObject arg0Value, long arg1Value, Object arg2Value) throws UnsupportedMessageException, InvalidArrayIndexException, UnsupportedTypeException {
                int state_0 = this.state_0_;
                if ((arg0Value.isNull())) {
                    state_0 = state_0 | 0x100000 /* add SpecializationActive[HostObject.WriteArrayElement.doNull(HostObject, long, Object)] */;
                    this.state_0_ = state_0;
                    WriteArrayElement.doNull(arg0Value, arg1Value, arg2Value);
                    return;
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doArray(HostObject, long, Object, Node, HostToTypeNode, HostClassCache, ArraySet, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((arg0Value.isArray(hostClassCache_))) {
                            node__ = (this);
                            if (this.hostClassCache == null) {
                                VarHandle.storeStoreFence();
                                this.hostClassCache = hostClassCache_;
                            }
                            state_0 = state_0 | 0x200000 /* add SpecializationActive[HostObject.WriteArrayElement.doArray(HostObject, long, Object, Node, HostToTypeNode, HostClassCache, ArraySet, InlinedBranchProfile)] */;
                            this.state_0_ = state_0;
                            WriteArrayElement.doArray(arg0Value, arg1Value, arg2Value, node__, INLINED_TO_HOST, hostClassCache_, INLINED_WRITE_ARRAY_ELEMENT_ARRAY_ARRAY_SET_, INLINED_ERROR);
                            return;
                        }
                    }
                }
                {
                    Node node__1 = null;
                    if ((!(arg0Value.isNull()))) {
                        HostClassCache hostClassCache_1;
                        HostClassCache hostClassCache_1_shared = this.hostClassCache;
                        if (hostClassCache_1_shared != null) {
                            hostClassCache_1 = hostClassCache_1_shared;
                        } else {
                            hostClassCache_1 = (arg0Value.getHostClassCache());
                            if (hostClassCache_1 == null) {
                                throw new IllegalStateException("Specialization 'doList(HostObject, long, Object, Node, HostClassCache, HostToTypeNode, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((arg0Value.isList(hostClassCache_1))) {
                            node__1 = (this);
                            if (this.hostClassCache == null) {
                                VarHandle.storeStoreFence();
                                this.hostClassCache = hostClassCache_1;
                            }
                            state_0 = state_0 | 0x400000 /* add SpecializationActive[HostObject.WriteArrayElement.doList(HostObject, long, Object, Node, HostClassCache, HostToTypeNode, InlinedBranchProfile)] */;
                            this.state_0_ = state_0;
                            WriteArrayElement.doList(arg0Value, arg1Value, arg2Value, node__1, hostClassCache_1, INLINED_TO_HOST, INLINED_ERROR);
                            return;
                        }
                    }
                }
                {
                    Node node__2 = null;
                    if ((!(arg0Value.isNull()))) {
                        HostClassCache hostClassCache_2;
                        HostClassCache hostClassCache_2_shared = this.hostClassCache;
                        if (hostClassCache_2_shared != null) {
                            hostClassCache_2 = hostClassCache_2_shared;
                        } else {
                            hostClassCache_2 = (arg0Value.getHostClassCache());
                            if (hostClassCache_2 == null) {
                                throw new IllegalStateException("Specialization 'doMapEntry(HostObject, long, Object, Node, HostClassCache, HostToTypeNode, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((arg0Value.isMapEntry(hostClassCache_2))) {
                            node__2 = (this);
                            if (this.hostClassCache == null) {
                                VarHandle.storeStoreFence();
                                this.hostClassCache = hostClassCache_2;
                            }
                            state_0 = state_0 | 0x800000 /* add SpecializationActive[HostObject.WriteArrayElement.doMapEntry(HostObject, long, Object, Node, HostClassCache, HostToTypeNode, InlinedBranchProfile)] */;
                            this.state_0_ = state_0;
                            WriteArrayElement.doMapEntry(arg0Value, arg1Value, arg2Value, node__2, hostClassCache_2, INLINED_TO_HOST, INLINED_ERROR);
                            return;
                        }
                    }
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_3;
                    HostClassCache hostClassCache_3_shared = this.hostClassCache;
                    if (hostClassCache_3_shared != null) {
                        hostClassCache_3 = hostClassCache_3_shared;
                    } else {
                        hostClassCache_3 = (arg0Value.getHostClassCache());
                        if (hostClassCache_3 == null) {
                            throw new IllegalStateException("Specialization 'doNotArrayOrList(HostObject, long, Object, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if ((!(arg0Value.isList(hostClassCache_3))) && (!(arg0Value.isArray(hostClassCache_3))) && (!(arg0Value.isMapEntry(hostClassCache_3)))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_3;
                        }
                        state_0 = state_0 | 0x1000000 /* add SpecializationActive[HostObject.WriteArrayElement.doNotArrayOrList(HostObject, long, Object, HostClassCache)] */;
                        this.state_0_ = state_0;
                        WriteArrayElement.doNotArrayOrList(arg0Value, arg1Value, arg2Value, hostClassCache_3);
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsArrayElementRemovable#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsArrayElementRemovable#doList}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsArrayElementRemovable#doOther}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0xe000000) != 0 /* is SpecializationActive[HostObject.IsArrayElementRemovable.doNull(HostObject, long)] || SpecializationActive[HostObject.IsArrayElementRemovable.doList(HostObject, long, Node, HostClassCache, InlinedBranchProfile)] || SpecializationActive[HostObject.IsArrayElementRemovable.doOther(HostObject, long, HostClassCache)] */) {
                    if ((state_0 & 0x2000000) != 0 /* is SpecializationActive[HostObject.IsArrayElementRemovable.doNull(HostObject, long)] */) {
                        if ((arg0Value.isNull())) {
                            return IsArrayElementRemovable.doNull(arg0Value, arg1Value);
                        }
                    }
                    if ((state_0 & 0x4000000) != 0 /* is SpecializationActive[HostObject.IsArrayElementRemovable.doList(HostObject, long, Node, HostClassCache, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isList(hostClassCache_))) {
                                    Node node__ = (this);
                                    return IsArrayElementRemovable.doList(arg0Value, arg1Value, node__, hostClassCache_, INLINED_ERROR);
                                }
                            }
                        }
                    }
                    if ((state_0 & 0x8000000) != 0 /* is SpecializationActive[HostObject.IsArrayElementRemovable.doOther(HostObject, long, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_1 = this.hostClassCache;
                            if (hostClassCache_1 != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isList(hostClassCache_1)))) {
                                    return IsArrayElementRemovable.doOther(arg0Value, arg1Value, hostClassCache_1);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isArrayElementRemovableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementRemovableAndSpecialize(HostObject arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                if ((arg0Value.isNull())) {
                    state_0 = state_0 | 0x2000000 /* add SpecializationActive[HostObject.IsArrayElementRemovable.doNull(HostObject, long)] */;
                    this.state_0_ = state_0;
                    return IsArrayElementRemovable.doNull(arg0Value, arg1Value);
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doList(HostObject, long, Node, HostClassCache, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((arg0Value.isList(hostClassCache_))) {
                            node__ = (this);
                            if (this.hostClassCache == null) {
                                VarHandle.storeStoreFence();
                                this.hostClassCache = hostClassCache_;
                            }
                            state_0 = state_0 | 0x4000000 /* add SpecializationActive[HostObject.IsArrayElementRemovable.doList(HostObject, long, Node, HostClassCache, InlinedBranchProfile)] */;
                            this.state_0_ = state_0;
                            return IsArrayElementRemovable.doList(arg0Value, arg1Value, node__, hostClassCache_, INLINED_ERROR);
                        }
                    }
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = (arg0Value.getHostClassCache());
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("Specialization 'doOther(HostObject, long, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if ((!(arg0Value.isList(hostClassCache_1)))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        state_0 = state_0 | 0x8000000 /* add SpecializationActive[HostObject.IsArrayElementRemovable.doOther(HostObject, long, HostClassCache)] */;
                        this.state_0_ = state_0;
                        return IsArrayElementRemovable.doOther(arg0Value, arg1Value, hostClassCache_1);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link RemoveArrayElement#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link RemoveArrayElement#doList}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link RemoveArrayElement#doOther}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x70000000) != 0 /* is SpecializationActive[HostObject.RemoveArrayElement.doNull(HostObject, long)] || SpecializationActive[HostObject.RemoveArrayElement.doList(HostObject, long, Node, HostClassCache, InlinedBranchProfile)] || SpecializationActive[HostObject.RemoveArrayElement.doOther(HostObject, long, HostClassCache)] */) {
                    if ((state_0 & 0x10000000) != 0 /* is SpecializationActive[HostObject.RemoveArrayElement.doNull(HostObject, long)] */) {
                        if ((arg0Value.isNull())) {
                            RemoveArrayElement.doNull(arg0Value, arg1Value);
                            return;
                        }
                    }
                    if ((state_0 & 0x20000000) != 0 /* is SpecializationActive[HostObject.RemoveArrayElement.doList(HostObject, long, Node, HostClassCache, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isList(hostClassCache_))) {
                                    Node node__ = (this);
                                    RemoveArrayElement.doList(arg0Value, arg1Value, node__, hostClassCache_, INLINED_ERROR);
                                    return;
                                }
                            }
                        }
                    }
                    if ((state_0 & 0x40000000) != 0 /* is SpecializationActive[HostObject.RemoveArrayElement.doOther(HostObject, long, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_1 = this.hostClassCache;
                            if (hostClassCache_1 != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isList(hostClassCache_1)))) {
                                    RemoveArrayElement.doOther(arg0Value, arg1Value, hostClassCache_1);
                                    return;
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                removeArrayElementAndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void removeArrayElementAndSpecialize(HostObject arg0Value, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                int state_0 = this.state_0_;
                if ((arg0Value.isNull())) {
                    state_0 = state_0 | 0x10000000 /* add SpecializationActive[HostObject.RemoveArrayElement.doNull(HostObject, long)] */;
                    this.state_0_ = state_0;
                    RemoveArrayElement.doNull(arg0Value, arg1Value);
                    return;
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doList(HostObject, long, Node, HostClassCache, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((arg0Value.isList(hostClassCache_))) {
                            node__ = (this);
                            if (this.hostClassCache == null) {
                                VarHandle.storeStoreFence();
                                this.hostClassCache = hostClassCache_;
                            }
                            state_0 = state_0 | 0x20000000 /* add SpecializationActive[HostObject.RemoveArrayElement.doList(HostObject, long, Node, HostClassCache, InlinedBranchProfile)] */;
                            this.state_0_ = state_0;
                            RemoveArrayElement.doList(arg0Value, arg1Value, node__, hostClassCache_, INLINED_ERROR);
                            return;
                        }
                    }
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = (arg0Value.getHostClassCache());
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("Specialization 'doOther(HostObject, long, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if ((!(arg0Value.isList(hostClassCache_1)))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        state_0 = state_0 | 0x40000000 /* add SpecializationActive[HostObject.RemoveArrayElement.doOther(HostObject, long, HostClassCache)] */;
                        this.state_0_ = state_0;
                        RemoveArrayElement.doOther(arg0Value, arg1Value, hostClassCache_1);
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HasArrayElements#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link HasArrayElements#doNotNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean hasArrayElements(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_0 = this.state_0_;
                int state_1 = this.state_1_;
                if (((state_0 & 0x80000000) != 0 /* is SpecializationActive[HostObject.HasArrayElements.doNull(HostObject)] */ || (state_1 & 0b1) != 0 /* is SpecializationActive[HostObject.HasArrayElements.doNotNull(HostObject, HostClassCache)] */)) {
                    if ((state_0 & 0x80000000) != 0 /* is SpecializationActive[HostObject.HasArrayElements.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return HasArrayElements.doNull(arg0Value);
                        }
                    }
                    if ((state_1 & 0b1) != 0 /* is SpecializationActive[HostObject.HasArrayElements.doNotNull(HostObject, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    return HasArrayElements.doNotNull(arg0Value, hostClassCache_);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasArrayElementsAndSpecialize(arg0Value);
            }

            private boolean hasArrayElementsAndSpecialize(HostObject arg0Value) {
                int state_0 = this.state_0_;
                int state_1 = this.state_1_;
                if ((arg0Value.isNull())) {
                    state_0 = state_0 | 0x80000000 /* add SpecializationActive[HostObject.HasArrayElements.doNull(HostObject)] */;
                    this.state_0_ = state_0;
                    return HasArrayElements.doNull(arg0Value);
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = (arg0Value.getHostClassCache());
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("Specialization 'doNotNull(HostObject, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    state_1 = state_1 | 0b1 /* add SpecializationActive[HostObject.HasArrayElements.doNotNull(HostObject, HostClassCache)] */;
                    this.state_1_ = state_1;
                    return HasArrayElements.doNotNull(arg0Value, hostClassCache_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ReadArrayElement#doNull}
             *     Activation probability: 0.00427
             *     With/without class size: 4/0 bytes
             *   Specialization {@link ReadArrayElement#doArray}
             *     Activation probability: 0.00347
             *     With/without class size: 4/2 bytes
             *   Specialization {@link ReadArrayElement#doList}
             *     Activation probability: 0.00267
             *     With/without class size: 4/0 bytes
             *   Specialization {@link ReadArrayElement#doMapEntry}
             *     Activation probability: 0.00187
             *     With/without class size: 4/0 bytes
             *   Specialization {@link ReadArrayElement#doNotArrayOrList}
             *     Activation probability: 0.00107
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0b111110) != 0 /* is SpecializationActive[HostObject.ReadArrayElement.doNull(HostObject, long)] || SpecializationActive[HostObject.ReadArrayElement.doArray(HostObject, long, Node, ArrayGet, HostClassCache, ToGuestValueNode, InlinedBranchProfile)] || SpecializationActive[HostObject.ReadArrayElement.doList(HostObject, long, Node, HostClassCache, ToGuestValueNode, InlinedBranchProfile)] || SpecializationActive[HostObject.ReadArrayElement.doMapEntry(HostObject, long, Node, HostClassCache, ToGuestValueNode, InlinedBranchProfile)] || SpecializationActive[HostObject.ReadArrayElement.doNotArrayOrList(HostObject, long, HostClassCache)] */) {
                    if ((state_1 & 0b10) != 0 /* is SpecializationActive[HostObject.ReadArrayElement.doNull(HostObject, long)] */) {
                        if ((arg0Value.isNull())) {
                            return ReadArrayElement.doNull(arg0Value, arg1Value);
                        }
                    }
                    if ((state_1 & 0b100) != 0 /* is SpecializationActive[HostObject.ReadArrayElement.doArray(HostObject, long, Node, ArrayGet, HostClassCache, ToGuestValueNode, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isArray(hostClassCache_))) {
                                    Node node__ = (this);
                                    return ReadArrayElement.doArray(arg0Value, arg1Value, node__, INLINED_READ_ARRAY_ELEMENT_ARRAY_ARRAY_GET_, hostClassCache_, INLINED_TO_GUEST, INLINED_ERROR);
                                }
                            }
                        }
                    }
                    if ((state_1 & 0b1000) != 0 /* is SpecializationActive[HostObject.ReadArrayElement.doList(HostObject, long, Node, HostClassCache, ToGuestValueNode, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_1 = this.hostClassCache;
                            if (hostClassCache_1 != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isList(hostClassCache_1))) {
                                    Node node__1 = (this);
                                    return ReadArrayElement.doList(arg0Value, arg1Value, node__1, hostClassCache_1, INLINED_TO_GUEST, INLINED_ERROR);
                                }
                            }
                        }
                    }
                    if ((state_1 & 0b10000) != 0 /* is SpecializationActive[HostObject.ReadArrayElement.doMapEntry(HostObject, long, Node, HostClassCache, ToGuestValueNode, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_2 = this.hostClassCache;
                            if (hostClassCache_2 != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isMapEntry(hostClassCache_2))) {
                                    Node node__2 = (this);
                                    return ReadArrayElement.doMapEntry(arg0Value, arg1Value, node__2, hostClassCache_2, INLINED_TO_GUEST, INLINED_ERROR);
                                }
                            }
                        }
                    }
                    if ((state_1 & 0b100000) != 0 /* is SpecializationActive[HostObject.ReadArrayElement.doNotArrayOrList(HostObject, long, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_3 = this.hostClassCache;
                            if (hostClassCache_3 != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isArray(hostClassCache_3))) && (!(arg0Value.isList(hostClassCache_3))) && (!(arg0Value.isMapEntry(hostClassCache_3)))) {
                                    return ReadArrayElement.doNotArrayOrList(arg0Value, arg1Value, hostClassCache_3);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readArrayElementAndSpecialize(arg0Value, arg1Value);
            }

            private Object readArrayElementAndSpecialize(HostObject arg0Value, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                int state_1 = this.state_1_;
                if ((arg0Value.isNull())) {
                    state_1 = state_1 | 0b10 /* add SpecializationActive[HostObject.ReadArrayElement.doNull(HostObject, long)] */;
                    this.state_1_ = state_1;
                    return ReadArrayElement.doNull(arg0Value, arg1Value);
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doArray(HostObject, long, Node, ArrayGet, HostClassCache, ToGuestValueNode, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((arg0Value.isArray(hostClassCache_))) {
                            node__ = (this);
                            if (this.hostClassCache == null) {
                                VarHandle.storeStoreFence();
                                this.hostClassCache = hostClassCache_;
                            }
                            state_1 = state_1 | 0b100 /* add SpecializationActive[HostObject.ReadArrayElement.doArray(HostObject, long, Node, ArrayGet, HostClassCache, ToGuestValueNode, InlinedBranchProfile)] */;
                            this.state_1_ = state_1;
                            return ReadArrayElement.doArray(arg0Value, arg1Value, node__, INLINED_READ_ARRAY_ELEMENT_ARRAY_ARRAY_GET_, hostClassCache_, INLINED_TO_GUEST, INLINED_ERROR);
                        }
                    }
                }
                {
                    Node node__1 = null;
                    if ((!(arg0Value.isNull()))) {
                        HostClassCache hostClassCache_1;
                        HostClassCache hostClassCache_1_shared = this.hostClassCache;
                        if (hostClassCache_1_shared != null) {
                            hostClassCache_1 = hostClassCache_1_shared;
                        } else {
                            hostClassCache_1 = (arg0Value.getHostClassCache());
                            if (hostClassCache_1 == null) {
                                throw new IllegalStateException("Specialization 'doList(HostObject, long, Node, HostClassCache, ToGuestValueNode, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((arg0Value.isList(hostClassCache_1))) {
                            node__1 = (this);
                            if (this.hostClassCache == null) {
                                VarHandle.storeStoreFence();
                                this.hostClassCache = hostClassCache_1;
                            }
                            state_1 = state_1 | 0b1000 /* add SpecializationActive[HostObject.ReadArrayElement.doList(HostObject, long, Node, HostClassCache, ToGuestValueNode, InlinedBranchProfile)] */;
                            this.state_1_ = state_1;
                            return ReadArrayElement.doList(arg0Value, arg1Value, node__1, hostClassCache_1, INLINED_TO_GUEST, INLINED_ERROR);
                        }
                    }
                }
                {
                    Node node__2 = null;
                    if ((!(arg0Value.isNull()))) {
                        HostClassCache hostClassCache_2;
                        HostClassCache hostClassCache_2_shared = this.hostClassCache;
                        if (hostClassCache_2_shared != null) {
                            hostClassCache_2 = hostClassCache_2_shared;
                        } else {
                            hostClassCache_2 = (arg0Value.getHostClassCache());
                            if (hostClassCache_2 == null) {
                                throw new IllegalStateException("Specialization 'doMapEntry(HostObject, long, Node, HostClassCache, ToGuestValueNode, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((arg0Value.isMapEntry(hostClassCache_2))) {
                            node__2 = (this);
                            if (this.hostClassCache == null) {
                                VarHandle.storeStoreFence();
                                this.hostClassCache = hostClassCache_2;
                            }
                            state_1 = state_1 | 0b10000 /* add SpecializationActive[HostObject.ReadArrayElement.doMapEntry(HostObject, long, Node, HostClassCache, ToGuestValueNode, InlinedBranchProfile)] */;
                            this.state_1_ = state_1;
                            return ReadArrayElement.doMapEntry(arg0Value, arg1Value, node__2, hostClassCache_2, INLINED_TO_GUEST, INLINED_ERROR);
                        }
                    }
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_3;
                    HostClassCache hostClassCache_3_shared = this.hostClassCache;
                    if (hostClassCache_3_shared != null) {
                        hostClassCache_3 = hostClassCache_3_shared;
                    } else {
                        hostClassCache_3 = (arg0Value.getHostClassCache());
                        if (hostClassCache_3 == null) {
                            throw new IllegalStateException("Specialization 'doNotArrayOrList(HostObject, long, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if ((!(arg0Value.isArray(hostClassCache_3))) && (!(arg0Value.isList(hostClassCache_3))) && (!(arg0Value.isMapEntry(hostClassCache_3)))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_3;
                        }
                        state_1 = state_1 | 0b100000 /* add SpecializationActive[HostObject.ReadArrayElement.doNotArrayOrList(HostObject, long, HostClassCache)] */;
                        this.state_1_ = state_1;
                        return ReadArrayElement.doNotArrayOrList(arg0Value, arg1Value, hostClassCache_3);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link GetArraySize#doNull}
             *     Activation probability: 0.00427
             *     With/without class size: 4/0 bytes
             *   Specialization {@link GetArraySize#doArray}
             *     Activation probability: 0.00347
             *     With/without class size: 4/0 bytes
             *   Specialization {@link GetArraySize#doList}
             *     Activation probability: 0.00267
             *     With/without class size: 4/0 bytes
             *   Specialization {@link GetArraySize#doMapEntry}
             *     Activation probability: 0.00187
             *     With/without class size: 4/0 bytes
             *   Specialization {@link GetArraySize#doNotArrayOrList}
             *     Activation probability: 0.00107
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0b11111000000) != 0 /* is SpecializationActive[HostObject.GetArraySize.doNull(HostObject)] || SpecializationActive[HostObject.GetArraySize.doArray(HostObject, HostClassCache)] || SpecializationActive[HostObject.GetArraySize.doList(HostObject, Node, HostClassCache, InlinedBranchProfile)] || SpecializationActive[HostObject.GetArraySize.doMapEntry(HostObject, HostClassCache)] || SpecializationActive[HostObject.GetArraySize.doNotArrayOrList(HostObject, HostClassCache)] */) {
                    if ((state_1 & 0b1000000) != 0 /* is SpecializationActive[HostObject.GetArraySize.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return GetArraySize.doNull(arg0Value);
                        }
                    }
                    if ((state_1 & 0b10000000) != 0 /* is SpecializationActive[HostObject.GetArraySize.doArray(HostObject, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isArray(hostClassCache_))) {
                                    return GetArraySize.doArray(arg0Value, hostClassCache_);
                                }
                            }
                        }
                    }
                    if ((state_1 & 0b100000000) != 0 /* is SpecializationActive[HostObject.GetArraySize.doList(HostObject, Node, HostClassCache, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_1 = this.hostClassCache;
                            if (hostClassCache_1 != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isList(hostClassCache_1))) {
                                    Node node__ = (this);
                                    return GetArraySize.doList(arg0Value, node__, hostClassCache_1, INLINED_ERROR);
                                }
                            }
                        }
                    }
                    if ((state_1 & 0b1000000000) != 0 /* is SpecializationActive[HostObject.GetArraySize.doMapEntry(HostObject, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_2 = this.hostClassCache;
                            if (hostClassCache_2 != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isMapEntry(hostClassCache_2))) {
                                    return GetArraySize.doMapEntry(arg0Value, hostClassCache_2);
                                }
                            }
                        }
                    }
                    if ((state_1 & 0b10000000000) != 0 /* is SpecializationActive[HostObject.GetArraySize.doNotArrayOrList(HostObject, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_3 = this.hostClassCache;
                            if (hostClassCache_3 != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isArray(hostClassCache_3))) && (!(arg0Value.isList(hostClassCache_3))) && (!(arg0Value.isMapEntry(hostClassCache_3)))) {
                                    return GetArraySize.doNotArrayOrList(arg0Value, hostClassCache_3);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getArraySizeAndSpecialize(arg0Value);
            }

            private long getArraySizeAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_1 = this.state_1_;
                if ((arg0Value.isNull())) {
                    state_1 = state_1 | 0b1000000 /* add SpecializationActive[HostObject.GetArraySize.doNull(HostObject)] */;
                    this.state_1_ = state_1;
                    return GetArraySize.doNull(arg0Value);
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = (arg0Value.getHostClassCache());
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("Specialization 'doArray(HostObject, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if ((arg0Value.isArray(hostClassCache_))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_1 = state_1 | 0b10000000 /* add SpecializationActive[HostObject.GetArraySize.doArray(HostObject, HostClassCache)] */;
                        this.state_1_ = state_1;
                        return GetArraySize.doArray(arg0Value, hostClassCache_);
                    }
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        HostClassCache hostClassCache_1;
                        HostClassCache hostClassCache_1_shared = this.hostClassCache;
                        if (hostClassCache_1_shared != null) {
                            hostClassCache_1 = hostClassCache_1_shared;
                        } else {
                            hostClassCache_1 = (arg0Value.getHostClassCache());
                            if (hostClassCache_1 == null) {
                                throw new IllegalStateException("Specialization 'doList(HostObject, Node, HostClassCache, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((arg0Value.isList(hostClassCache_1))) {
                            node__ = (this);
                            if (this.hostClassCache == null) {
                                VarHandle.storeStoreFence();
                                this.hostClassCache = hostClassCache_1;
                            }
                            state_1 = state_1 | 0b100000000 /* add SpecializationActive[HostObject.GetArraySize.doList(HostObject, Node, HostClassCache, InlinedBranchProfile)] */;
                            this.state_1_ = state_1;
                            return GetArraySize.doList(arg0Value, node__, hostClassCache_1, INLINED_ERROR);
                        }
                    }
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_2;
                    HostClassCache hostClassCache_2_shared = this.hostClassCache;
                    if (hostClassCache_2_shared != null) {
                        hostClassCache_2 = hostClassCache_2_shared;
                    } else {
                        hostClassCache_2 = (arg0Value.getHostClassCache());
                        if (hostClassCache_2 == null) {
                            throw new IllegalStateException("Specialization 'doMapEntry(HostObject, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if ((arg0Value.isMapEntry(hostClassCache_2))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_2;
                        }
                        state_1 = state_1 | 0b1000000000 /* add SpecializationActive[HostObject.GetArraySize.doMapEntry(HostObject, HostClassCache)] */;
                        this.state_1_ = state_1;
                        return GetArraySize.doMapEntry(arg0Value, hostClassCache_2);
                    }
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_3;
                    HostClassCache hostClassCache_3_shared = this.hostClassCache;
                    if (hostClassCache_3_shared != null) {
                        hostClassCache_3 = hostClassCache_3_shared;
                    } else {
                        hostClassCache_3 = (arg0Value.getHostClassCache());
                        if (hostClassCache_3 == null) {
                            throw new IllegalStateException("Specialization 'doNotArrayOrList(HostObject, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if ((!(arg0Value.isArray(hostClassCache_3))) && (!(arg0Value.isList(hostClassCache_3))) && (!(arg0Value.isMapEntry(hostClassCache_3)))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_3;
                        }
                        state_1 = state_1 | 0b10000000000 /* add SpecializationActive[HostObject.GetArraySize.doNotArrayOrList(HostObject, HostClassCache)] */;
                        this.state_1_ = state_1;
                        return GetArraySize.doNotArrayOrList(arg0Value, hostClassCache_3);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HasBufferElements#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link HasBufferElements#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean hasBufferElements(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0b1100000000000) != 0 /* is SpecializationActive[HostObject.HasBufferElements.doNull(HostObject)] || SpecializationActive[HostObject.HasBufferElements.doNonNull(HostObject, HostClassCache)] */) {
                    if ((state_1 & 0b100000000000) != 0 /* is SpecializationActive[HostObject.HasBufferElements.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return HasBufferElements.doNull(arg0Value);
                        }
                    }
                    if ((state_1 & 0b1000000000000) != 0 /* is SpecializationActive[HostObject.HasBufferElements.doNonNull(HostObject, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    return HasBufferElements.doNonNull(arg0Value, hostClassCache_);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasBufferElementsAndSpecialize(arg0Value);
            }

            private boolean hasBufferElementsAndSpecialize(HostObject arg0Value) {
                int state_1 = this.state_1_;
                if ((arg0Value.isNull())) {
                    state_1 = state_1 | 0b100000000000 /* add SpecializationActive[HostObject.HasBufferElements.doNull(HostObject)] */;
                    this.state_1_ = state_1;
                    return HasBufferElements.doNull(arg0Value);
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = (arg0Value.getHostClassCache());
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("Specialization 'doNonNull(HostObject, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    state_1 = state_1 | 0b1000000000000 /* add SpecializationActive[HostObject.HasBufferElements.doNonNull(HostObject, HostClassCache)] */;
                    this.state_1_ = state_1;
                    return HasBufferElements.doNonNull(arg0Value, hostClassCache_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsBufferWritable#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsBufferWritable#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isBufferWritable(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0b110000000000000) != 0 /* is SpecializationActive[HostObject.IsBufferWritable.doNull(HostObject)] || SpecializationActive[HostObject.IsBufferWritable.doNonNull(HostObject, Node, HostClassCache, InlinedBranchProfile)] */) {
                    if ((state_1 & 0b10000000000000) != 0 /* is SpecializationActive[HostObject.IsBufferWritable.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return IsBufferWritable.doNull(arg0Value);
                        }
                    }
                    if ((state_1 & 0b100000000000000) != 0 /* is SpecializationActive[HostObject.IsBufferWritable.doNonNull(HostObject, Node, HostClassCache, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    Node node__ = (this);
                                    return IsBufferWritable.doNonNull(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isBufferWritableAndSpecialize(arg0Value);
            }

            private boolean isBufferWritableAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_1 = this.state_1_;
                if ((arg0Value.isNull())) {
                    state_1 = state_1 | 0b10000000000000 /* add SpecializationActive[HostObject.IsBufferWritable.doNull(HostObject)] */;
                    this.state_1_ = state_1;
                    return IsBufferWritable.doNull(arg0Value);
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doNonNull(HostObject, Node, HostClassCache, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_1 = state_1 | 0b100000000000000 /* add SpecializationActive[HostObject.IsBufferWritable.doNonNull(HostObject, Node, HostClassCache, InlinedBranchProfile)] */;
                        this.state_1_ = state_1;
                        return IsBufferWritable.doNonNull(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link GetBufferSize#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link GetBufferSize#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public long getBufferSize(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0x18000) != 0 /* is SpecializationActive[HostObject.GetBufferSize.doNull(HostObject)] || SpecializationActive[HostObject.GetBufferSize.doNonNull(HostObject, Node, HostClassCache, InlinedBranchProfile)] */) {
                    if ((state_1 & 0b1000000000000000) != 0 /* is SpecializationActive[HostObject.GetBufferSize.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return GetBufferSize.doNull(arg0Value);
                        }
                    }
                    if ((state_1 & 0x10000) != 0 /* is SpecializationActive[HostObject.GetBufferSize.doNonNull(HostObject, Node, HostClassCache, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    Node node__ = (this);
                                    return GetBufferSize.doNonNull(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getBufferSizeAndSpecialize(arg0Value);
            }

            private long getBufferSizeAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_1 = this.state_1_;
                if ((arg0Value.isNull())) {
                    state_1 = state_1 | 0b1000000000000000 /* add SpecializationActive[HostObject.GetBufferSize.doNull(HostObject)] */;
                    this.state_1_ = state_1;
                    return GetBufferSize.doNull(arg0Value);
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doNonNull(HostObject, Node, HostClassCache, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_1 = state_1 | 0x10000 /* add SpecializationActive[HostObject.GetBufferSize.doNonNull(HostObject, Node, HostClassCache, InlinedBranchProfile)] */;
                        this.state_1_ = state_1;
                        return GetBufferSize.doNonNull(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ReadBufferByte#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link ReadBufferByte#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public byte readBufferByte(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0x60000) != 0 /* is SpecializationActive[HostObject.ReadBufferByte.doNull(HostObject, long)] || SpecializationActive[HostObject.ReadBufferByte.doNonNull(HostObject, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                    if ((state_1 & 0x20000) != 0 /* is SpecializationActive[HostObject.ReadBufferByte.doNull(HostObject, long)] */) {
                        if ((arg0Value.isNull())) {
                            return ReadBufferByte.doNull(arg0Value, arg1Value);
                        }
                    }
                    if ((state_1 & 0x40000) != 0 /* is SpecializationActive[HostObject.ReadBufferByte.doNonNull(HostObject, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    Node node__ = (this);
                                    return ReadBufferByte.doNonNull(arg0Value, arg1Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readBufferByteAndSpecialize(arg0Value, arg1Value);
            }

            private byte readBufferByteAndSpecialize(HostObject arg0Value, long arg1Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_1 = this.state_1_;
                if ((arg0Value.isNull())) {
                    state_1 = state_1 | 0x20000 /* add SpecializationActive[HostObject.ReadBufferByte.doNull(HostObject, long)] */;
                    this.state_1_ = state_1;
                    return ReadBufferByte.doNull(arg0Value, arg1Value);
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doNonNull(HostObject, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_1 = state_1 | 0x40000 /* add SpecializationActive[HostObject.ReadBufferByte.doNonNull(HostObject, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */;
                        this.state_1_ = state_1;
                        return ReadBufferByte.doNonNull(arg0Value, arg1Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link WriteBufferByte#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link WriteBufferByte#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeBufferByte(Object arg0Value_, long arg1Value, byte arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0x180000) != 0 /* is SpecializationActive[HostObject.WriteBufferByte.doNull(HostObject, long, byte)] || SpecializationActive[HostObject.WriteBufferByte.doNonNull(HostObject, long, byte, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                    if ((state_1 & 0x80000) != 0 /* is SpecializationActive[HostObject.WriteBufferByte.doNull(HostObject, long, byte)] */) {
                        if ((arg0Value.isNull())) {
                            WriteBufferByte.doNull(arg0Value, arg1Value, arg2Value);
                            return;
                        }
                    }
                    if ((state_1 & 0x100000) != 0 /* is SpecializationActive[HostObject.WriteBufferByte.doNonNull(HostObject, long, byte, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    Node node__ = (this);
                                    WriteBufferByte.doNonNull(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                                    return;
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeBufferByteAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeBufferByteAndSpecialize(HostObject arg0Value, long arg1Value, byte arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_1 = this.state_1_;
                if ((arg0Value.isNull())) {
                    state_1 = state_1 | 0x80000 /* add SpecializationActive[HostObject.WriteBufferByte.doNull(HostObject, long, byte)] */;
                    this.state_1_ = state_1;
                    WriteBufferByte.doNull(arg0Value, arg1Value, arg2Value);
                    return;
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doNonNull(HostObject, long, byte, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_1 = state_1 | 0x100000 /* add SpecializationActive[HostObject.WriteBufferByte.doNonNull(HostObject, long, byte, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */;
                        this.state_1_ = state_1;
                        WriteBufferByte.doNonNull(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ReadBufferShort#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link ReadBufferShort#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public short readBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0x600000) != 0 /* is SpecializationActive[HostObject.ReadBufferShort.doNull(HostObject, ByteOrder, long)] || SpecializationActive[HostObject.ReadBufferShort.doNonNull(HostObject, ByteOrder, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                    if ((state_1 & 0x200000) != 0 /* is SpecializationActive[HostObject.ReadBufferShort.doNull(HostObject, ByteOrder, long)] */) {
                        if ((arg0Value.isNull())) {
                            return ReadBufferShort.doNull(arg0Value, arg1Value, arg2Value);
                        }
                    }
                    if ((state_1 & 0x400000) != 0 /* is SpecializationActive[HostObject.ReadBufferShort.doNonNull(HostObject, ByteOrder, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    Node node__ = (this);
                                    return ReadBufferShort.doNonNull(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readBufferShortAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private short readBufferShortAndSpecialize(HostObject arg0Value, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_1 = this.state_1_;
                if ((arg0Value.isNull())) {
                    state_1 = state_1 | 0x200000 /* add SpecializationActive[HostObject.ReadBufferShort.doNull(HostObject, ByteOrder, long)] */;
                    this.state_1_ = state_1;
                    return ReadBufferShort.doNull(arg0Value, arg1Value, arg2Value);
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doNonNull(HostObject, ByteOrder, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_1 = state_1 | 0x400000 /* add SpecializationActive[HostObject.ReadBufferShort.doNonNull(HostObject, ByteOrder, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */;
                        this.state_1_ = state_1;
                        return ReadBufferShort.doNonNull(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link WriteBufferShort#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link WriteBufferShort#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value, short arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0x1800000) != 0 /* is SpecializationActive[HostObject.WriteBufferShort.doNull(HostObject, ByteOrder, long, short)] || SpecializationActive[HostObject.WriteBufferShort.doNonNull(HostObject, ByteOrder, long, short, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                    if ((state_1 & 0x800000) != 0 /* is SpecializationActive[HostObject.WriteBufferShort.doNull(HostObject, ByteOrder, long, short)] */) {
                        if ((arg0Value.isNull())) {
                            WriteBufferShort.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                            return;
                        }
                    }
                    if ((state_1 & 0x1000000) != 0 /* is SpecializationActive[HostObject.WriteBufferShort.doNonNull(HostObject, ByteOrder, long, short, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    Node node__ = (this);
                                    WriteBufferShort.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                                    return;
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeBufferShortAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
                return;
            }

            private void writeBufferShortAndSpecialize(HostObject arg0Value, ByteOrder arg1Value, long arg2Value, short arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_1 = this.state_1_;
                if ((arg0Value.isNull())) {
                    state_1 = state_1 | 0x800000 /* add SpecializationActive[HostObject.WriteBufferShort.doNull(HostObject, ByteOrder, long, short)] */;
                    this.state_1_ = state_1;
                    WriteBufferShort.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doNonNull(HostObject, ByteOrder, long, short, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_1 = state_1 | 0x1000000 /* add SpecializationActive[HostObject.WriteBufferShort.doNonNull(HostObject, ByteOrder, long, short, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */;
                        this.state_1_ = state_1;
                        WriteBufferShort.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ReadBufferInt#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link ReadBufferInt#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public int readBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0x6000000) != 0 /* is SpecializationActive[HostObject.ReadBufferInt.doNull(HostObject, ByteOrder, long)] || SpecializationActive[HostObject.ReadBufferInt.doNonNull(HostObject, ByteOrder, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                    if ((state_1 & 0x2000000) != 0 /* is SpecializationActive[HostObject.ReadBufferInt.doNull(HostObject, ByteOrder, long)] */) {
                        if ((arg0Value.isNull())) {
                            return ReadBufferInt.doNull(arg0Value, arg1Value, arg2Value);
                        }
                    }
                    if ((state_1 & 0x4000000) != 0 /* is SpecializationActive[HostObject.ReadBufferInt.doNonNull(HostObject, ByteOrder, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    Node node__ = (this);
                                    return ReadBufferInt.doNonNull(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readBufferIntAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private int readBufferIntAndSpecialize(HostObject arg0Value, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_1 = this.state_1_;
                if ((arg0Value.isNull())) {
                    state_1 = state_1 | 0x2000000 /* add SpecializationActive[HostObject.ReadBufferInt.doNull(HostObject, ByteOrder, long)] */;
                    this.state_1_ = state_1;
                    return ReadBufferInt.doNull(arg0Value, arg1Value, arg2Value);
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doNonNull(HostObject, ByteOrder, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_1 = state_1 | 0x4000000 /* add SpecializationActive[HostObject.ReadBufferInt.doNonNull(HostObject, ByteOrder, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */;
                        this.state_1_ = state_1;
                        return ReadBufferInt.doNonNull(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link WriteBufferInt#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link WriteBufferInt#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value, int arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0x18000000) != 0 /* is SpecializationActive[HostObject.WriteBufferInt.doNull(HostObject, ByteOrder, long, int)] || SpecializationActive[HostObject.WriteBufferInt.doNonNull(HostObject, ByteOrder, long, int, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                    if ((state_1 & 0x8000000) != 0 /* is SpecializationActive[HostObject.WriteBufferInt.doNull(HostObject, ByteOrder, long, int)] */) {
                        if ((arg0Value.isNull())) {
                            WriteBufferInt.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                            return;
                        }
                    }
                    if ((state_1 & 0x10000000) != 0 /* is SpecializationActive[HostObject.WriteBufferInt.doNonNull(HostObject, ByteOrder, long, int, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    Node node__ = (this);
                                    WriteBufferInt.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                                    return;
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeBufferIntAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
                return;
            }

            private void writeBufferIntAndSpecialize(HostObject arg0Value, ByteOrder arg1Value, long arg2Value, int arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_1 = this.state_1_;
                if ((arg0Value.isNull())) {
                    state_1 = state_1 | 0x8000000 /* add SpecializationActive[HostObject.WriteBufferInt.doNull(HostObject, ByteOrder, long, int)] */;
                    this.state_1_ = state_1;
                    WriteBufferInt.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doNonNull(HostObject, ByteOrder, long, int, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_1 = state_1 | 0x10000000 /* add SpecializationActive[HostObject.WriteBufferInt.doNonNull(HostObject, ByteOrder, long, int, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */;
                        this.state_1_ = state_1;
                        WriteBufferInt.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ReadBufferLong#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link ReadBufferLong#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public long readBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0x60000000) != 0 /* is SpecializationActive[HostObject.ReadBufferLong.doNull(HostObject, ByteOrder, long)] || SpecializationActive[HostObject.ReadBufferLong.doNonNull(HostObject, ByteOrder, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                    if ((state_1 & 0x20000000) != 0 /* is SpecializationActive[HostObject.ReadBufferLong.doNull(HostObject, ByteOrder, long)] */) {
                        if ((arg0Value.isNull())) {
                            return ReadBufferLong.doNull(arg0Value, arg1Value, arg2Value);
                        }
                    }
                    if ((state_1 & 0x40000000) != 0 /* is SpecializationActive[HostObject.ReadBufferLong.doNonNull(HostObject, ByteOrder, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    Node node__ = (this);
                                    return ReadBufferLong.doNonNull(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readBufferLongAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private long readBufferLongAndSpecialize(HostObject arg0Value, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_1 = this.state_1_;
                if ((arg0Value.isNull())) {
                    state_1 = state_1 | 0x20000000 /* add SpecializationActive[HostObject.ReadBufferLong.doNull(HostObject, ByteOrder, long)] */;
                    this.state_1_ = state_1;
                    return ReadBufferLong.doNull(arg0Value, arg1Value, arg2Value);
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doNonNull(HostObject, ByteOrder, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_1 = state_1 | 0x40000000 /* add SpecializationActive[HostObject.ReadBufferLong.doNonNull(HostObject, ByteOrder, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */;
                        this.state_1_ = state_1;
                        return ReadBufferLong.doNonNull(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link WriteBufferLong#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link WriteBufferLong#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value, long arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_1 = this.state_1_;
                int state_2 = this.state_2_;
                if (((state_1 & 0x80000000) != 0 /* is SpecializationActive[HostObject.WriteBufferLong.doNull(HostObject, ByteOrder, long, long)] */ || (state_2 & 0b1) != 0 /* is SpecializationActive[HostObject.WriteBufferLong.doNonNull(HostObject, ByteOrder, long, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */)) {
                    if ((state_1 & 0x80000000) != 0 /* is SpecializationActive[HostObject.WriteBufferLong.doNull(HostObject, ByteOrder, long, long)] */) {
                        if ((arg0Value.isNull())) {
                            WriteBufferLong.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                            return;
                        }
                    }
                    if ((state_2 & 0b1) != 0 /* is SpecializationActive[HostObject.WriteBufferLong.doNonNull(HostObject, ByteOrder, long, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    Node node__ = (this);
                                    WriteBufferLong.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                                    return;
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeBufferLongAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
                return;
            }

            private void writeBufferLongAndSpecialize(HostObject arg0Value, ByteOrder arg1Value, long arg2Value, long arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_1 = this.state_1_;
                int state_2 = this.state_2_;
                if ((arg0Value.isNull())) {
                    state_1 = state_1 | 0x80000000 /* add SpecializationActive[HostObject.WriteBufferLong.doNull(HostObject, ByteOrder, long, long)] */;
                    this.state_1_ = state_1;
                    WriteBufferLong.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doNonNull(HostObject, ByteOrder, long, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_2 = state_2 | 0b1 /* add SpecializationActive[HostObject.WriteBufferLong.doNonNull(HostObject, ByteOrder, long, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */;
                        this.state_2_ = state_2;
                        WriteBufferLong.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ReadBufferFloat#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link ReadBufferFloat#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public float readBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_2 = this.state_2_;
                if ((state_2 & 0b110) != 0 /* is SpecializationActive[HostObject.ReadBufferFloat.doNull(HostObject, ByteOrder, long)] || SpecializationActive[HostObject.ReadBufferFloat.doNonNull(HostObject, ByteOrder, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                    if ((state_2 & 0b10) != 0 /* is SpecializationActive[HostObject.ReadBufferFloat.doNull(HostObject, ByteOrder, long)] */) {
                        if ((arg0Value.isNull())) {
                            return ReadBufferFloat.doNull(arg0Value, arg1Value, arg2Value);
                        }
                    }
                    if ((state_2 & 0b100) != 0 /* is SpecializationActive[HostObject.ReadBufferFloat.doNonNull(HostObject, ByteOrder, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    Node node__ = (this);
                                    return ReadBufferFloat.doNonNull(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readBufferFloatAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private float readBufferFloatAndSpecialize(HostObject arg0Value, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_2 = this.state_2_;
                if ((arg0Value.isNull())) {
                    state_2 = state_2 | 0b10 /* add SpecializationActive[HostObject.ReadBufferFloat.doNull(HostObject, ByteOrder, long)] */;
                    this.state_2_ = state_2;
                    return ReadBufferFloat.doNull(arg0Value, arg1Value, arg2Value);
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doNonNull(HostObject, ByteOrder, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_2 = state_2 | 0b100 /* add SpecializationActive[HostObject.ReadBufferFloat.doNonNull(HostObject, ByteOrder, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */;
                        this.state_2_ = state_2;
                        return ReadBufferFloat.doNonNull(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link WriteBufferFloat#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link WriteBufferFloat#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value, float arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_2 = this.state_2_;
                if ((state_2 & 0b11000) != 0 /* is SpecializationActive[HostObject.WriteBufferFloat.doNull(HostObject, ByteOrder, long, float)] || SpecializationActive[HostObject.WriteBufferFloat.doNonNull(HostObject, ByteOrder, long, float, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                    if ((state_2 & 0b1000) != 0 /* is SpecializationActive[HostObject.WriteBufferFloat.doNull(HostObject, ByteOrder, long, float)] */) {
                        if ((arg0Value.isNull())) {
                            WriteBufferFloat.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                            return;
                        }
                    }
                    if ((state_2 & 0b10000) != 0 /* is SpecializationActive[HostObject.WriteBufferFloat.doNonNull(HostObject, ByteOrder, long, float, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    Node node__ = (this);
                                    WriteBufferFloat.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                                    return;
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeBufferFloatAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
                return;
            }

            private void writeBufferFloatAndSpecialize(HostObject arg0Value, ByteOrder arg1Value, long arg2Value, float arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_2 = this.state_2_;
                if ((arg0Value.isNull())) {
                    state_2 = state_2 | 0b1000 /* add SpecializationActive[HostObject.WriteBufferFloat.doNull(HostObject, ByteOrder, long, float)] */;
                    this.state_2_ = state_2;
                    WriteBufferFloat.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doNonNull(HostObject, ByteOrder, long, float, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_2 = state_2 | 0b10000 /* add SpecializationActive[HostObject.WriteBufferFloat.doNonNull(HostObject, ByteOrder, long, float, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */;
                        this.state_2_ = state_2;
                        WriteBufferFloat.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ReadBufferDouble#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link ReadBufferDouble#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public double readBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_2 = this.state_2_;
                if ((state_2 & 0b1100000) != 0 /* is SpecializationActive[HostObject.ReadBufferDouble.doNull(HostObject, ByteOrder, long)] || SpecializationActive[HostObject.ReadBufferDouble.doNonNull(HostObject, ByteOrder, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                    if ((state_2 & 0b100000) != 0 /* is SpecializationActive[HostObject.ReadBufferDouble.doNull(HostObject, ByteOrder, long)] */) {
                        if ((arg0Value.isNull())) {
                            return ReadBufferDouble.doNull(arg0Value, arg1Value, arg2Value);
                        }
                    }
                    if ((state_2 & 0b1000000) != 0 /* is SpecializationActive[HostObject.ReadBufferDouble.doNonNull(HostObject, ByteOrder, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    Node node__ = (this);
                                    return ReadBufferDouble.doNonNull(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readBufferDoubleAndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private double readBufferDoubleAndSpecialize(HostObject arg0Value, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_2 = this.state_2_;
                if ((arg0Value.isNull())) {
                    state_2 = state_2 | 0b100000 /* add SpecializationActive[HostObject.ReadBufferDouble.doNull(HostObject, ByteOrder, long)] */;
                    this.state_2_ = state_2;
                    return ReadBufferDouble.doNull(arg0Value, arg1Value, arg2Value);
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doNonNull(HostObject, ByteOrder, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_2 = state_2 | 0b1000000 /* add SpecializationActive[HostObject.ReadBufferDouble.doNonNull(HostObject, ByteOrder, long, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */;
                        this.state_2_ = state_2;
                        return ReadBufferDouble.doNonNull(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link WriteBufferDouble#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link WriteBufferDouble#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value, double arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_2 = this.state_2_;
                if ((state_2 & 0b110000000) != 0 /* is SpecializationActive[HostObject.WriteBufferDouble.doNull(HostObject, ByteOrder, long, double)] || SpecializationActive[HostObject.WriteBufferDouble.doNonNull(HostObject, ByteOrder, long, double, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                    if ((state_2 & 0b10000000) != 0 /* is SpecializationActive[HostObject.WriteBufferDouble.doNull(HostObject, ByteOrder, long, double)] */) {
                        if ((arg0Value.isNull())) {
                            WriteBufferDouble.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                            return;
                        }
                    }
                    if ((state_2 & 0b100000000) != 0 /* is SpecializationActive[HostObject.WriteBufferDouble.doNonNull(HostObject, ByteOrder, long, double, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    Node node__ = (this);
                                    WriteBufferDouble.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                                    return;
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeBufferDoubleAndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
                return;
            }

            private void writeBufferDoubleAndSpecialize(HostObject arg0Value, ByteOrder arg1Value, long arg2Value, double arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                int state_2 = this.state_2_;
                if ((arg0Value.isNull())) {
                    state_2 = state_2 | 0b10000000 /* add SpecializationActive[HostObject.WriteBufferDouble.doNull(HostObject, ByteOrder, long, double)] */;
                    this.state_2_ = state_2;
                    WriteBufferDouble.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doNonNull(HostObject, ByteOrder, long, double, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_2 = state_2 | 0b100000000 /* add SpecializationActive[HostObject.WriteBufferDouble.doNonNull(HostObject, ByteOrder, long, double, Node, HostClassCache, InlinedBranchProfile, InlinedExactClassProfile)] */;
                        this.state_2_ = state_2;
                        WriteBufferDouble.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, node__, hostClassCache_, INLINED_ERROR, INLINED_CLASS_PROFILE);
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsInstantiable#doUnsupported}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsInstantiable#doArrayCached}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsInstantiable#doObjectCached}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isInstantiable(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_2 = this.state_2_;
                if ((state_2 & 0b111000000000) != 0 /* is SpecializationActive[HostObject.IsInstantiable.doUnsupported(HostObject)] || SpecializationActive[HostObject.IsInstantiable.doArrayCached(HostObject)] || SpecializationActive[HostObject.IsInstantiable.doObjectCached(HostObject, Node, LookupConstructorNode)] */) {
                    if ((state_2 & 0b1000000000) != 0 /* is SpecializationActive[HostObject.IsInstantiable.doUnsupported(HostObject)] */) {
                        if ((!(arg0Value.isClass()))) {
                            return IsInstantiable.doUnsupported(arg0Value);
                        }
                    }
                    if ((state_2 & 0b10000000000) != 0 /* is SpecializationActive[HostObject.IsInstantiable.doArrayCached(HostObject)] */) {
                        if ((arg0Value.isArrayClass())) {
                            return IsInstantiable.doArrayCached(arg0Value);
                        }
                    }
                    if ((state_2 & 0b100000000000) != 0 /* is SpecializationActive[HostObject.IsInstantiable.doObjectCached(HostObject, Node, LookupConstructorNode)] */) {
                        if ((arg0Value.isDefaultClass())) {
                            Node node__ = (this);
                            return IsInstantiable.doObjectCached(arg0Value, node__, INLINED_LOOKUP_CONSTRUCTOR);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isInstantiableAndSpecialize(arg0Value);
            }

            private boolean isInstantiableAndSpecialize(HostObject arg0Value) {
                int state_2 = this.state_2_;
                if ((!(arg0Value.isClass()))) {
                    state_2 = state_2 | 0b1000000000 /* add SpecializationActive[HostObject.IsInstantiable.doUnsupported(HostObject)] */;
                    this.state_2_ = state_2;
                    return IsInstantiable.doUnsupported(arg0Value);
                }
                if ((arg0Value.isArrayClass())) {
                    state_2 = state_2 | 0b10000000000 /* add SpecializationActive[HostObject.IsInstantiable.doArrayCached(HostObject)] */;
                    this.state_2_ = state_2;
                    return IsInstantiable.doArrayCached(arg0Value);
                }
                {
                    Node node__ = null;
                    if ((arg0Value.isDefaultClass())) {
                        node__ = (this);
                        state_2 = state_2 | 0b100000000000 /* add SpecializationActive[HostObject.IsInstantiable.doObjectCached(HostObject, Node, LookupConstructorNode)] */;
                        this.state_2_ = state_2;
                        return IsInstantiable.doObjectCached(arg0Value, node__, INLINED_LOOKUP_CONSTRUCTOR);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link Instantiate#doUnsupported}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link Instantiate#doArrayCached}
             *     Activation probability: 0.00444
             *     With/without class size: 4/4 bytes
             *   Specialization {@link Instantiate#doObjectCached}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Object instantiate(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_2 = this.state_2_;
                if ((state_2 & 0b111000000000000) != 0 /* is SpecializationActive[HostObject.Instantiate.doUnsupported(HostObject, Object[])] || SpecializationActive[HostObject.Instantiate.doArrayCached(HostObject, Object[], Node, InteropLibrary, InlinedBranchProfile)] || SpecializationActive[HostObject.Instantiate.doObjectCached(HostObject, Object[], Node, LookupConstructorNode, HostExecuteNode, InlinedBranchProfile)] */) {
                    if ((state_2 & 0b1000000000000) != 0 /* is SpecializationActive[HostObject.Instantiate.doUnsupported(HostObject, Object[])] */) {
                        if ((!(arg0Value.isClass()))) {
                            return Instantiate.doUnsupported(arg0Value, arg1Value);
                        }
                    }
                    if ((state_2 & 0b10000000000000) != 0 /* is SpecializationActive[HostObject.Instantiate.doArrayCached(HostObject, Object[], Node, InteropLibrary, InlinedBranchProfile)] */) {
                        {
                            InteropLibrary indexes__ = this.instantiate_arrayCached_indexes_;
                            if (indexes__ != null) {
                                if ((arg0Value.isArrayClass())) {
                                    Node node__ = (this);
                                    return Instantiate.doArrayCached(arg0Value, arg1Value, node__, indexes__, INLINED_ERROR);
                                }
                            }
                        }
                    }
                    if ((state_2 & 0b100000000000000) != 0 /* is SpecializationActive[HostObject.Instantiate.doObjectCached(HostObject, Object[], Node, LookupConstructorNode, HostExecuteNode, InlinedBranchProfile)] */) {
                        if ((arg0Value.isDefaultClass())) {
                            Node node__1 = (this);
                            return Instantiate.doObjectCached(arg0Value, arg1Value, node__1, INLINED_LOOKUP_CONSTRUCTOR, INLINED_HOST_EXECUTE, INLINED_ERROR);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return instantiateAndSpecialize(arg0Value, arg1Value);
            }

            private Object instantiateAndSpecialize(HostObject arg0Value, Object[] arg1Value) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
                int state_2 = this.state_2_;
                if ((!(arg0Value.isClass()))) {
                    state_2 = state_2 | 0b1000000000000 /* add SpecializationActive[HostObject.Instantiate.doUnsupported(HostObject, Object[])] */;
                    this.state_2_ = state_2;
                    return Instantiate.doUnsupported(arg0Value, arg1Value);
                }
                {
                    Node node__ = null;
                    if ((arg0Value.isArrayClass())) {
                        node__ = (this);
                        InteropLibrary indexes__ = this.insert((INTEROP_LIBRARY_.createDispatched(1)));
                        Objects.requireNonNull(indexes__, "Specialization 'doArrayCached(HostObject, Object[], Node, InteropLibrary, InlinedBranchProfile)' cache 'indexes' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                        VarHandle.storeStoreFence();
                        this.instantiate_arrayCached_indexes_ = indexes__;
                        state_2 = state_2 | 0b10000000000000 /* add SpecializationActive[HostObject.Instantiate.doArrayCached(HostObject, Object[], Node, InteropLibrary, InlinedBranchProfile)] */;
                        this.state_2_ = state_2;
                        return Instantiate.doArrayCached(arg0Value, arg1Value, node__, indexes__, INLINED_ERROR);
                    }
                }
                {
                    Node node__1 = null;
                    if ((arg0Value.isDefaultClass())) {
                        node__1 = (this);
                        state_2 = state_2 | 0b100000000000000 /* add SpecializationActive[HostObject.Instantiate.doObjectCached(HostObject, Object[], Node, LookupConstructorNode, HostExecuteNode, InlinedBranchProfile)] */;
                        this.state_2_ = state_2;
                        return Instantiate.doObjectCached(arg0Value, arg1Value, node__1, INLINED_LOOKUP_CONSTRUCTOR, INLINED_HOST_EXECUTE, INLINED_ERROR);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsNumber#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsNumber#doBigInteger}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsNumber#doOther}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isNumber(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_2 = this.state_2_;
                if ((state_2 & 0x38000) != 0 /* is SpecializationActive[HostObject.IsNumber.doNull(HostObject)] || SpecializationActive[HostObject.IsNumber.doBigInteger(HostObject, HostClassCache)] || SpecializationActive[HostObject.IsNumber.doOther(HostObject, Node, InlinedExactClassProfile)] */) {
                    if ((state_2 & 0b1000000000000000) != 0 /* is SpecializationActive[HostObject.IsNumber.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return IsNumber.doNull(arg0Value);
                        }
                    }
                    if ((state_2 & 0x10000) != 0 /* is SpecializationActive[HostObject.IsNumber.doBigInteger(HostObject, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((arg0Value.isBigInteger())) {
                                    return IsNumber.doBigInteger(arg0Value, hostClassCache_);
                                }
                            }
                        }
                    }
                    if ((state_2 & 0x20000) != 0 /* is SpecializationActive[HostObject.IsNumber.doOther(HostObject, Node, InlinedExactClassProfile)] */) {
                        if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                            Node node__ = (this);
                            return IsNumber.doOther(arg0Value, node__, INLINED_CLASS_PROFILE);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isNumberAndSpecialize(arg0Value);
            }

            private boolean isNumberAndSpecialize(HostObject arg0Value) {
                int state_2 = this.state_2_;
                if ((arg0Value.isNull())) {
                    state_2 = state_2 | 0b1000000000000000 /* add SpecializationActive[HostObject.IsNumber.doNull(HostObject)] */;
                    this.state_2_ = state_2;
                    return IsNumber.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = (arg0Value.getHostClassCache());
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("Specialization 'doBigInteger(HostObject, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    state_2 = state_2 | 0x10000 /* add SpecializationActive[HostObject.IsNumber.doBigInteger(HostObject, HostClassCache)] */;
                    this.state_2_ = state_2;
                    return IsNumber.doBigInteger(arg0Value, hostClassCache_);
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                        node__ = (this);
                        state_2 = state_2 | 0x20000 /* add SpecializationActive[HostObject.IsNumber.doOther(HostObject, Node, InlinedExactClassProfile)] */;
                        this.state_2_ = state_2;
                        return IsNumber.doOther(arg0Value, node__, INLINED_CLASS_PROFILE);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FitsInByte#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link FitsInByte#doBigInteger}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link FitsInByte#doOther}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean fitsInByte(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_2 = this.state_2_;
                if ((state_2 & 0x1c0000) != 0 /* is SpecializationActive[HostObject.FitsInByte.doNull(HostObject)] || SpecializationActive[HostObject.FitsInByte.doBigInteger(HostObject, HostClassCache)] || SpecializationActive[HostObject.FitsInByte.doOther(HostObject, InteropLibrary, InteropLibrary)] */) {
                    if ((state_2 & 0x40000) != 0 /* is SpecializationActive[HostObject.FitsInByte.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return FitsInByte.doNull(arg0Value);
                        }
                    }
                    if ((state_2 & 0x80000) != 0 /* is SpecializationActive[HostObject.FitsInByte.doBigInteger(HostObject, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((arg0Value.isBigInteger())) {
                                    return FitsInByte.doBigInteger(arg0Value, hostClassCache_);
                                }
                            }
                        }
                    }
                    if ((state_2 & 0x100000) != 0 /* is SpecializationActive[HostObject.FitsInByte.doOther(HostObject, InteropLibrary, InteropLibrary)] */) {
                        {
                            InteropLibrary numbers_ = this.numbers;
                            if (numbers_ != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                                    InteropLibrary receiverLibrary__ = (this);
                                    return FitsInByte.doOther(arg0Value, receiverLibrary__, numbers_);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInByteAndSpecialize(arg0Value);
            }

            private boolean fitsInByteAndSpecialize(HostObject arg0Value) {
                int state_2 = this.state_2_;
                if ((arg0Value.isNull())) {
                    state_2 = state_2 | 0x40000 /* add SpecializationActive[HostObject.FitsInByte.doNull(HostObject)] */;
                    this.state_2_ = state_2;
                    return FitsInByte.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = (arg0Value.getHostClassCache());
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("Specialization 'doBigInteger(HostObject, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    state_2 = state_2 | 0x80000 /* add SpecializationActive[HostObject.FitsInByte.doBigInteger(HostObject, HostClassCache)] */;
                    this.state_2_ = state_2;
                    return FitsInByte.doBigInteger(arg0Value, hostClassCache_);
                }
                {
                    InteropLibrary receiverLibrary__ = null;
                    if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                        receiverLibrary__ = (this);
                        InteropLibrary numbers_;
                        InteropLibrary numbers__shared = this.numbers;
                        if (numbers__shared != null) {
                            numbers_ = numbers__shared;
                        } else {
                            numbers_ = this.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                            if (numbers_ == null) {
                                throw new IllegalStateException("Specialization 'doOther(HostObject, InteropLibrary, InteropLibrary)' contains a shared cache with name 'numbers' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.numbers == null) {
                            VarHandle.storeStoreFence();
                            this.numbers = numbers_;
                        }
                        state_2 = state_2 | 0x100000 /* add SpecializationActive[HostObject.FitsInByte.doOther(HostObject, InteropLibrary, InteropLibrary)] */;
                        this.state_2_ = state_2;
                        return FitsInByte.doOther(arg0Value, receiverLibrary__, numbers_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FitsInShort#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link FitsInShort#doBigInteger}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link FitsInShort#doOther}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean fitsInShort(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_2 = this.state_2_;
                if ((state_2 & 0xe00000) != 0 /* is SpecializationActive[HostObject.FitsInShort.doNull(HostObject)] || SpecializationActive[HostObject.FitsInShort.doBigInteger(HostObject, HostClassCache)] || SpecializationActive[HostObject.FitsInShort.doOther(HostObject, InteropLibrary, InteropLibrary)] */) {
                    if ((state_2 & 0x200000) != 0 /* is SpecializationActive[HostObject.FitsInShort.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return FitsInShort.doNull(arg0Value);
                        }
                    }
                    if ((state_2 & 0x400000) != 0 /* is SpecializationActive[HostObject.FitsInShort.doBigInteger(HostObject, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((arg0Value.isBigInteger())) {
                                    return FitsInShort.doBigInteger(arg0Value, hostClassCache_);
                                }
                            }
                        }
                    }
                    if ((state_2 & 0x800000) != 0 /* is SpecializationActive[HostObject.FitsInShort.doOther(HostObject, InteropLibrary, InteropLibrary)] */) {
                        {
                            InteropLibrary numbers_ = this.numbers;
                            if (numbers_ != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                                    InteropLibrary receiverLibrary__ = (this);
                                    return FitsInShort.doOther(arg0Value, receiverLibrary__, numbers_);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInShortAndSpecialize(arg0Value);
            }

            private boolean fitsInShortAndSpecialize(HostObject arg0Value) {
                int state_2 = this.state_2_;
                if ((arg0Value.isNull())) {
                    state_2 = state_2 | 0x200000 /* add SpecializationActive[HostObject.FitsInShort.doNull(HostObject)] */;
                    this.state_2_ = state_2;
                    return FitsInShort.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = (arg0Value.getHostClassCache());
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("Specialization 'doBigInteger(HostObject, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    state_2 = state_2 | 0x400000 /* add SpecializationActive[HostObject.FitsInShort.doBigInteger(HostObject, HostClassCache)] */;
                    this.state_2_ = state_2;
                    return FitsInShort.doBigInteger(arg0Value, hostClassCache_);
                }
                {
                    InteropLibrary receiverLibrary__ = null;
                    if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                        receiverLibrary__ = (this);
                        InteropLibrary numbers_;
                        InteropLibrary numbers__shared = this.numbers;
                        if (numbers__shared != null) {
                            numbers_ = numbers__shared;
                        } else {
                            numbers_ = this.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                            if (numbers_ == null) {
                                throw new IllegalStateException("Specialization 'doOther(HostObject, InteropLibrary, InteropLibrary)' contains a shared cache with name 'numbers' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.numbers == null) {
                            VarHandle.storeStoreFence();
                            this.numbers = numbers_;
                        }
                        state_2 = state_2 | 0x800000 /* add SpecializationActive[HostObject.FitsInShort.doOther(HostObject, InteropLibrary, InteropLibrary)] */;
                        this.state_2_ = state_2;
                        return FitsInShort.doOther(arg0Value, receiverLibrary__, numbers_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FitsInInt#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link FitsInInt#doBigInteger}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link FitsInInt#doOther}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean fitsInInt(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_2 = this.state_2_;
                if ((state_2 & 0x7000000) != 0 /* is SpecializationActive[HostObject.FitsInInt.doNull(HostObject)] || SpecializationActive[HostObject.FitsInInt.doBigInteger(HostObject, HostClassCache)] || SpecializationActive[HostObject.FitsInInt.doOther(HostObject, InteropLibrary, InteropLibrary)] */) {
                    if ((state_2 & 0x1000000) != 0 /* is SpecializationActive[HostObject.FitsInInt.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return FitsInInt.doNull(arg0Value);
                        }
                    }
                    if ((state_2 & 0x2000000) != 0 /* is SpecializationActive[HostObject.FitsInInt.doBigInteger(HostObject, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((arg0Value.isBigInteger())) {
                                    return FitsInInt.doBigInteger(arg0Value, hostClassCache_);
                                }
                            }
                        }
                    }
                    if ((state_2 & 0x4000000) != 0 /* is SpecializationActive[HostObject.FitsInInt.doOther(HostObject, InteropLibrary, InteropLibrary)] */) {
                        {
                            InteropLibrary numbers_ = this.numbers;
                            if (numbers_ != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                                    InteropLibrary receiverLibrary__ = (this);
                                    return FitsInInt.doOther(arg0Value, receiverLibrary__, numbers_);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInIntAndSpecialize(arg0Value);
            }

            private boolean fitsInIntAndSpecialize(HostObject arg0Value) {
                int state_2 = this.state_2_;
                if ((arg0Value.isNull())) {
                    state_2 = state_2 | 0x1000000 /* add SpecializationActive[HostObject.FitsInInt.doNull(HostObject)] */;
                    this.state_2_ = state_2;
                    return FitsInInt.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = (arg0Value.getHostClassCache());
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("Specialization 'doBigInteger(HostObject, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    state_2 = state_2 | 0x2000000 /* add SpecializationActive[HostObject.FitsInInt.doBigInteger(HostObject, HostClassCache)] */;
                    this.state_2_ = state_2;
                    return FitsInInt.doBigInteger(arg0Value, hostClassCache_);
                }
                {
                    InteropLibrary receiverLibrary__ = null;
                    if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                        receiverLibrary__ = (this);
                        InteropLibrary numbers_;
                        InteropLibrary numbers__shared = this.numbers;
                        if (numbers__shared != null) {
                            numbers_ = numbers__shared;
                        } else {
                            numbers_ = this.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                            if (numbers_ == null) {
                                throw new IllegalStateException("Specialization 'doOther(HostObject, InteropLibrary, InteropLibrary)' contains a shared cache with name 'numbers' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.numbers == null) {
                            VarHandle.storeStoreFence();
                            this.numbers = numbers_;
                        }
                        state_2 = state_2 | 0x4000000 /* add SpecializationActive[HostObject.FitsInInt.doOther(HostObject, InteropLibrary, InteropLibrary)] */;
                        this.state_2_ = state_2;
                        return FitsInInt.doOther(arg0Value, receiverLibrary__, numbers_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FitsInLong#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link FitsInLong#doBigInteger}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link FitsInLong#doOther}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean fitsInLong(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_2 = this.state_2_;
                if ((state_2 & 0x38000000) != 0 /* is SpecializationActive[HostObject.FitsInLong.doNull(HostObject)] || SpecializationActive[HostObject.FitsInLong.doBigInteger(HostObject, HostClassCache)] || SpecializationActive[HostObject.FitsInLong.doOther(HostObject, InteropLibrary, InteropLibrary)] */) {
                    if ((state_2 & 0x8000000) != 0 /* is SpecializationActive[HostObject.FitsInLong.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return FitsInLong.doNull(arg0Value);
                        }
                    }
                    if ((state_2 & 0x10000000) != 0 /* is SpecializationActive[HostObject.FitsInLong.doBigInteger(HostObject, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((arg0Value.isBigInteger())) {
                                    return FitsInLong.doBigInteger(arg0Value, hostClassCache_);
                                }
                            }
                        }
                    }
                    if ((state_2 & 0x20000000) != 0 /* is SpecializationActive[HostObject.FitsInLong.doOther(HostObject, InteropLibrary, InteropLibrary)] */) {
                        {
                            InteropLibrary numbers_ = this.numbers;
                            if (numbers_ != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                                    InteropLibrary receiverLibrary__ = (this);
                                    return FitsInLong.doOther(arg0Value, receiverLibrary__, numbers_);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInLongAndSpecialize(arg0Value);
            }

            private boolean fitsInLongAndSpecialize(HostObject arg0Value) {
                int state_2 = this.state_2_;
                if ((arg0Value.isNull())) {
                    state_2 = state_2 | 0x8000000 /* add SpecializationActive[HostObject.FitsInLong.doNull(HostObject)] */;
                    this.state_2_ = state_2;
                    return FitsInLong.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = (arg0Value.getHostClassCache());
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("Specialization 'doBigInteger(HostObject, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    state_2 = state_2 | 0x10000000 /* add SpecializationActive[HostObject.FitsInLong.doBigInteger(HostObject, HostClassCache)] */;
                    this.state_2_ = state_2;
                    return FitsInLong.doBigInteger(arg0Value, hostClassCache_);
                }
                {
                    InteropLibrary receiverLibrary__ = null;
                    if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                        receiverLibrary__ = (this);
                        InteropLibrary numbers_;
                        InteropLibrary numbers__shared = this.numbers;
                        if (numbers__shared != null) {
                            numbers_ = numbers__shared;
                        } else {
                            numbers_ = this.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                            if (numbers_ == null) {
                                throw new IllegalStateException("Specialization 'doOther(HostObject, InteropLibrary, InteropLibrary)' contains a shared cache with name 'numbers' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.numbers == null) {
                            VarHandle.storeStoreFence();
                            this.numbers = numbers_;
                        }
                        state_2 = state_2 | 0x20000000 /* add SpecializationActive[HostObject.FitsInLong.doOther(HostObject, InteropLibrary, InteropLibrary)] */;
                        this.state_2_ = state_2;
                        return FitsInLong.doOther(arg0Value, receiverLibrary__, numbers_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FitsInBigInteger#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link FitsInBigInteger#doBigInteger}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link FitsInBigInteger#doOther}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean fitsInBigInteger(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_2 = this.state_2_;
                int state_3 = this.state_3_;
                if (((state_2 & 0xc0000000) != 0 /* is SpecializationActive[HostObject.FitsInBigInteger.doNull(HostObject)] || SpecializationActive[HostObject.FitsInBigInteger.doBigInteger(HostObject, HostClassCache)] */ || (state_3 & 0b1) != 0 /* is SpecializationActive[HostObject.FitsInBigInteger.doOther(HostObject, InteropLibrary, InteropLibrary)] */)) {
                    if ((state_2 & 0x40000000) != 0 /* is SpecializationActive[HostObject.FitsInBigInteger.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return FitsInBigInteger.doNull(arg0Value);
                        }
                    }
                    if ((state_2 & 0x80000000) != 0 /* is SpecializationActive[HostObject.FitsInBigInteger.doBigInteger(HostObject, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((arg0Value.isBigInteger())) {
                                    return FitsInBigInteger.doBigInteger(arg0Value, hostClassCache_);
                                }
                            }
                        }
                    }
                    if ((state_3 & 0b1) != 0 /* is SpecializationActive[HostObject.FitsInBigInteger.doOther(HostObject, InteropLibrary, InteropLibrary)] */) {
                        {
                            InteropLibrary numbers_ = this.numbers;
                            if (numbers_ != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                                    InteropLibrary receiverLibrary__ = (this);
                                    return FitsInBigInteger.doOther(arg0Value, receiverLibrary__, numbers_);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInBigIntegerAndSpecialize(arg0Value);
            }

            private boolean fitsInBigIntegerAndSpecialize(HostObject arg0Value) {
                int state_2 = this.state_2_;
                int state_3 = this.state_3_;
                if ((arg0Value.isNull())) {
                    state_2 = state_2 | 0x40000000 /* add SpecializationActive[HostObject.FitsInBigInteger.doNull(HostObject)] */;
                    this.state_2_ = state_2;
                    return FitsInBigInteger.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = (arg0Value.getHostClassCache());
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("Specialization 'doBigInteger(HostObject, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    state_2 = state_2 | 0x80000000 /* add SpecializationActive[HostObject.FitsInBigInteger.doBigInteger(HostObject, HostClassCache)] */;
                    this.state_2_ = state_2;
                    return FitsInBigInteger.doBigInteger(arg0Value, hostClassCache_);
                }
                {
                    InteropLibrary receiverLibrary__ = null;
                    if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                        receiverLibrary__ = (this);
                        InteropLibrary numbers_;
                        InteropLibrary numbers__shared = this.numbers;
                        if (numbers__shared != null) {
                            numbers_ = numbers__shared;
                        } else {
                            numbers_ = this.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                            if (numbers_ == null) {
                                throw new IllegalStateException("Specialization 'doOther(HostObject, InteropLibrary, InteropLibrary)' contains a shared cache with name 'numbers' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.numbers == null) {
                            VarHandle.storeStoreFence();
                            this.numbers = numbers_;
                        }
                        state_3 = state_3 | 0b1 /* add SpecializationActive[HostObject.FitsInBigInteger.doOther(HostObject, InteropLibrary, InteropLibrary)] */;
                        this.state_3_ = state_3;
                        return FitsInBigInteger.doOther(arg0Value, receiverLibrary__, numbers_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FitsInFloat#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link FitsInFloat#doBigInteger}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link FitsInFloat#doOther}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean fitsInFloat(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_3 = this.state_3_;
                if ((state_3 & 0b1110) != 0 /* is SpecializationActive[HostObject.FitsInFloat.doNull(HostObject)] || SpecializationActive[HostObject.FitsInFloat.doBigInteger(HostObject, HostClassCache)] || SpecializationActive[HostObject.FitsInFloat.doOther(HostObject, InteropLibrary, InteropLibrary)] */) {
                    if ((state_3 & 0b10) != 0 /* is SpecializationActive[HostObject.FitsInFloat.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return FitsInFloat.doNull(arg0Value);
                        }
                    }
                    if ((state_3 & 0b100) != 0 /* is SpecializationActive[HostObject.FitsInFloat.doBigInteger(HostObject, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((arg0Value.isBigInteger())) {
                                    return FitsInFloat.doBigInteger(arg0Value, hostClassCache_);
                                }
                            }
                        }
                    }
                    if ((state_3 & 0b1000) != 0 /* is SpecializationActive[HostObject.FitsInFloat.doOther(HostObject, InteropLibrary, InteropLibrary)] */) {
                        {
                            InteropLibrary numbers_ = this.numbers;
                            if (numbers_ != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                                    InteropLibrary receiverLibrary__ = (this);
                                    return FitsInFloat.doOther(arg0Value, receiverLibrary__, numbers_);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInFloatAndSpecialize(arg0Value);
            }

            private boolean fitsInFloatAndSpecialize(HostObject arg0Value) {
                int state_3 = this.state_3_;
                if ((arg0Value.isNull())) {
                    state_3 = state_3 | 0b10 /* add SpecializationActive[HostObject.FitsInFloat.doNull(HostObject)] */;
                    this.state_3_ = state_3;
                    return FitsInFloat.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = (arg0Value.getHostClassCache());
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("Specialization 'doBigInteger(HostObject, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    state_3 = state_3 | 0b100 /* add SpecializationActive[HostObject.FitsInFloat.doBigInteger(HostObject, HostClassCache)] */;
                    this.state_3_ = state_3;
                    return FitsInFloat.doBigInteger(arg0Value, hostClassCache_);
                }
                {
                    InteropLibrary receiverLibrary__ = null;
                    if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                        receiverLibrary__ = (this);
                        InteropLibrary numbers_;
                        InteropLibrary numbers__shared = this.numbers;
                        if (numbers__shared != null) {
                            numbers_ = numbers__shared;
                        } else {
                            numbers_ = this.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                            if (numbers_ == null) {
                                throw new IllegalStateException("Specialization 'doOther(HostObject, InteropLibrary, InteropLibrary)' contains a shared cache with name 'numbers' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.numbers == null) {
                            VarHandle.storeStoreFence();
                            this.numbers = numbers_;
                        }
                        state_3 = state_3 | 0b1000 /* add SpecializationActive[HostObject.FitsInFloat.doOther(HostObject, InteropLibrary, InteropLibrary)] */;
                        this.state_3_ = state_3;
                        return FitsInFloat.doOther(arg0Value, receiverLibrary__, numbers_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link FitsInDouble#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link FitsInDouble#doBigInteger}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link FitsInDouble#doOther}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean fitsInDouble(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_3 = this.state_3_;
                if ((state_3 & 0b1110000) != 0 /* is SpecializationActive[HostObject.FitsInDouble.doNull(HostObject)] || SpecializationActive[HostObject.FitsInDouble.doBigInteger(HostObject, HostClassCache)] || SpecializationActive[HostObject.FitsInDouble.doOther(HostObject, InteropLibrary, InteropLibrary)] */) {
                    if ((state_3 & 0b10000) != 0 /* is SpecializationActive[HostObject.FitsInDouble.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return FitsInDouble.doNull(arg0Value);
                        }
                    }
                    if ((state_3 & 0b100000) != 0 /* is SpecializationActive[HostObject.FitsInDouble.doBigInteger(HostObject, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((arg0Value.isBigInteger())) {
                                    return FitsInDouble.doBigInteger(arg0Value, hostClassCache_);
                                }
                            }
                        }
                    }
                    if ((state_3 & 0b1000000) != 0 /* is SpecializationActive[HostObject.FitsInDouble.doOther(HostObject, InteropLibrary, InteropLibrary)] */) {
                        {
                            InteropLibrary numbers_ = this.numbers;
                            if (numbers_ != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                                    InteropLibrary receiverLibrary__ = (this);
                                    return FitsInDouble.doOther(arg0Value, receiverLibrary__, numbers_);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return fitsInDoubleAndSpecialize(arg0Value);
            }

            private boolean fitsInDoubleAndSpecialize(HostObject arg0Value) {
                int state_3 = this.state_3_;
                if ((arg0Value.isNull())) {
                    state_3 = state_3 | 0b10000 /* add SpecializationActive[HostObject.FitsInDouble.doNull(HostObject)] */;
                    this.state_3_ = state_3;
                    return FitsInDouble.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = (arg0Value.getHostClassCache());
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("Specialization 'doBigInteger(HostObject, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    state_3 = state_3 | 0b100000 /* add SpecializationActive[HostObject.FitsInDouble.doBigInteger(HostObject, HostClassCache)] */;
                    this.state_3_ = state_3;
                    return FitsInDouble.doBigInteger(arg0Value, hostClassCache_);
                }
                {
                    InteropLibrary receiverLibrary__ = null;
                    if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                        receiverLibrary__ = (this);
                        InteropLibrary numbers_;
                        InteropLibrary numbers__shared = this.numbers;
                        if (numbers__shared != null) {
                            numbers_ = numbers__shared;
                        } else {
                            numbers_ = this.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                            if (numbers_ == null) {
                                throw new IllegalStateException("Specialization 'doOther(HostObject, InteropLibrary, InteropLibrary)' contains a shared cache with name 'numbers' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.numbers == null) {
                            VarHandle.storeStoreFence();
                            this.numbers = numbers_;
                        }
                        state_3 = state_3 | 0b1000000 /* add SpecializationActive[HostObject.FitsInDouble.doOther(HostObject, InteropLibrary, InteropLibrary)] */;
                        this.state_3_ = state_3;
                        return FitsInDouble.doOther(arg0Value, receiverLibrary__, numbers_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link AsByte#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link AsByte#doBigInteger}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link AsByte#doOther}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public byte asByte(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_3 = this.state_3_;
                if ((state_3 & 0b1110000000) != 0 /* is SpecializationActive[HostObject.AsByte.doNull(HostObject)] || SpecializationActive[HostObject.AsByte.doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)] || SpecializationActive[HostObject.AsByte.doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */) {
                    if ((state_3 & 0b10000000) != 0 /* is SpecializationActive[HostObject.AsByte.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return AsByte.doNull(arg0Value);
                        }
                    }
                    if ((state_3 & 0b100000000) != 0 /* is SpecializationActive[HostObject.AsByte.doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((arg0Value.isBigInteger())) {
                                    Node node__ = (this);
                                    return AsByte.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                                }
                            }
                        }
                    }
                    if ((state_3 & 0b1000000000) != 0 /* is SpecializationActive[HostObject.AsByte.doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */) {
                        {
                            InteropLibrary numbers_ = this.numbers;
                            if (numbers_ != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                                    Node node__1 = (this);
                                    InteropLibrary receiverLibrary__ = (this);
                                    return AsByte.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asByteAndSpecialize(arg0Value);
            }

            private byte asByteAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_3 = this.state_3_;
                if ((arg0Value.isNull())) {
                    state_3 = state_3 | 0b10000000 /* add SpecializationActive[HostObject.AsByte.doNull(HostObject)] */;
                    this.state_3_ = state_3;
                    return AsByte.doNull(arg0Value);
                }
                {
                    Node node__ = null;
                    if ((arg0Value.isBigInteger())) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_3 = state_3 | 0b100000000 /* add SpecializationActive[HostObject.AsByte.doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)] */;
                        this.state_3_ = state_3;
                        return AsByte.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                }
                {
                    InteropLibrary receiverLibrary__ = null;
                    Node node__1 = null;
                    if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                        node__1 = (this);
                        receiverLibrary__ = (this);
                        InteropLibrary numbers_;
                        InteropLibrary numbers__shared = this.numbers;
                        if (numbers__shared != null) {
                            numbers_ = numbers__shared;
                        } else {
                            numbers_ = this.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                            if (numbers_ == null) {
                                throw new IllegalStateException("Specialization 'doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)' contains a shared cache with name 'numbers' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.numbers == null) {
                            VarHandle.storeStoreFence();
                            this.numbers = numbers_;
                        }
                        state_3 = state_3 | 0b1000000000 /* add SpecializationActive[HostObject.AsByte.doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */;
                        this.state_3_ = state_3;
                        return AsByte.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link AsShort#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link AsShort#doBigInteger}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link AsShort#doOther}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public short asShort(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_3 = this.state_3_;
                if ((state_3 & 0b1110000000000) != 0 /* is SpecializationActive[HostObject.AsShort.doNull(HostObject)] || SpecializationActive[HostObject.AsShort.doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)] || SpecializationActive[HostObject.AsShort.doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */) {
                    if ((state_3 & 0b10000000000) != 0 /* is SpecializationActive[HostObject.AsShort.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return AsShort.doNull(arg0Value);
                        }
                    }
                    if ((state_3 & 0b100000000000) != 0 /* is SpecializationActive[HostObject.AsShort.doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((arg0Value.isBigInteger())) {
                                    Node node__ = (this);
                                    return AsShort.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                                }
                            }
                        }
                    }
                    if ((state_3 & 0b1000000000000) != 0 /* is SpecializationActive[HostObject.AsShort.doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */) {
                        {
                            InteropLibrary numbers_ = this.numbers;
                            if (numbers_ != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                                    Node node__1 = (this);
                                    InteropLibrary receiverLibrary__ = (this);
                                    return AsShort.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asShortAndSpecialize(arg0Value);
            }

            private short asShortAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_3 = this.state_3_;
                if ((arg0Value.isNull())) {
                    state_3 = state_3 | 0b10000000000 /* add SpecializationActive[HostObject.AsShort.doNull(HostObject)] */;
                    this.state_3_ = state_3;
                    return AsShort.doNull(arg0Value);
                }
                {
                    Node node__ = null;
                    if ((arg0Value.isBigInteger())) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_3 = state_3 | 0b100000000000 /* add SpecializationActive[HostObject.AsShort.doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)] */;
                        this.state_3_ = state_3;
                        return AsShort.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                }
                {
                    InteropLibrary receiverLibrary__ = null;
                    Node node__1 = null;
                    if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                        node__1 = (this);
                        receiverLibrary__ = (this);
                        InteropLibrary numbers_;
                        InteropLibrary numbers__shared = this.numbers;
                        if (numbers__shared != null) {
                            numbers_ = numbers__shared;
                        } else {
                            numbers_ = this.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                            if (numbers_ == null) {
                                throw new IllegalStateException("Specialization 'doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)' contains a shared cache with name 'numbers' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.numbers == null) {
                            VarHandle.storeStoreFence();
                            this.numbers = numbers_;
                        }
                        state_3 = state_3 | 0b1000000000000 /* add SpecializationActive[HostObject.AsShort.doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */;
                        this.state_3_ = state_3;
                        return AsShort.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link AsInt#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link AsInt#doBigInteger}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link AsInt#doOther}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public int asInt(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_3 = this.state_3_;
                if ((state_3 & 0b1110000000000000) != 0 /* is SpecializationActive[HostObject.AsInt.doNull(HostObject)] || SpecializationActive[HostObject.AsInt.doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)] || SpecializationActive[HostObject.AsInt.doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */) {
                    if ((state_3 & 0b10000000000000) != 0 /* is SpecializationActive[HostObject.AsInt.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return AsInt.doNull(arg0Value);
                        }
                    }
                    if ((state_3 & 0b100000000000000) != 0 /* is SpecializationActive[HostObject.AsInt.doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((arg0Value.isBigInteger())) {
                                    Node node__ = (this);
                                    return AsInt.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                                }
                            }
                        }
                    }
                    if ((state_3 & 0b1000000000000000) != 0 /* is SpecializationActive[HostObject.AsInt.doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */) {
                        {
                            InteropLibrary numbers_ = this.numbers;
                            if (numbers_ != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                                    Node node__1 = (this);
                                    InteropLibrary receiverLibrary__ = (this);
                                    return AsInt.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asIntAndSpecialize(arg0Value);
            }

            private int asIntAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_3 = this.state_3_;
                if ((arg0Value.isNull())) {
                    state_3 = state_3 | 0b10000000000000 /* add SpecializationActive[HostObject.AsInt.doNull(HostObject)] */;
                    this.state_3_ = state_3;
                    return AsInt.doNull(arg0Value);
                }
                {
                    Node node__ = null;
                    if ((arg0Value.isBigInteger())) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_3 = state_3 | 0b100000000000000 /* add SpecializationActive[HostObject.AsInt.doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)] */;
                        this.state_3_ = state_3;
                        return AsInt.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                }
                {
                    InteropLibrary receiverLibrary__ = null;
                    Node node__1 = null;
                    if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                        node__1 = (this);
                        receiverLibrary__ = (this);
                        InteropLibrary numbers_;
                        InteropLibrary numbers__shared = this.numbers;
                        if (numbers__shared != null) {
                            numbers_ = numbers__shared;
                        } else {
                            numbers_ = this.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                            if (numbers_ == null) {
                                throw new IllegalStateException("Specialization 'doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)' contains a shared cache with name 'numbers' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.numbers == null) {
                            VarHandle.storeStoreFence();
                            this.numbers = numbers_;
                        }
                        state_3 = state_3 | 0b1000000000000000 /* add SpecializationActive[HostObject.AsInt.doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */;
                        this.state_3_ = state_3;
                        return AsInt.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link AsLong#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link AsLong#doBigInteger}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link AsLong#doOther}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public long asLong(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_3 = this.state_3_;
                if ((state_3 & 0x70000) != 0 /* is SpecializationActive[HostObject.AsLong.doNull(HostObject)] || SpecializationActive[HostObject.AsLong.doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)] || SpecializationActive[HostObject.AsLong.doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */) {
                    if ((state_3 & 0x10000) != 0 /* is SpecializationActive[HostObject.AsLong.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return AsLong.doNull(arg0Value);
                        }
                    }
                    if ((state_3 & 0x20000) != 0 /* is SpecializationActive[HostObject.AsLong.doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((arg0Value.isBigInteger())) {
                                    Node node__ = (this);
                                    return AsLong.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                                }
                            }
                        }
                    }
                    if ((state_3 & 0x40000) != 0 /* is SpecializationActive[HostObject.AsLong.doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */) {
                        {
                            InteropLibrary numbers_ = this.numbers;
                            if (numbers_ != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                                    Node node__1 = (this);
                                    InteropLibrary receiverLibrary__ = (this);
                                    return AsLong.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asLongAndSpecialize(arg0Value);
            }

            private long asLongAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_3 = this.state_3_;
                if ((arg0Value.isNull())) {
                    state_3 = state_3 | 0x10000 /* add SpecializationActive[HostObject.AsLong.doNull(HostObject)] */;
                    this.state_3_ = state_3;
                    return AsLong.doNull(arg0Value);
                }
                {
                    Node node__ = null;
                    if ((arg0Value.isBigInteger())) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_3 = state_3 | 0x20000 /* add SpecializationActive[HostObject.AsLong.doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)] */;
                        this.state_3_ = state_3;
                        return AsLong.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                }
                {
                    InteropLibrary receiverLibrary__ = null;
                    Node node__1 = null;
                    if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                        node__1 = (this);
                        receiverLibrary__ = (this);
                        InteropLibrary numbers_;
                        InteropLibrary numbers__shared = this.numbers;
                        if (numbers__shared != null) {
                            numbers_ = numbers__shared;
                        } else {
                            numbers_ = this.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                            if (numbers_ == null) {
                                throw new IllegalStateException("Specialization 'doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)' contains a shared cache with name 'numbers' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.numbers == null) {
                            VarHandle.storeStoreFence();
                            this.numbers = numbers_;
                        }
                        state_3 = state_3 | 0x40000 /* add SpecializationActive[HostObject.AsLong.doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */;
                        this.state_3_ = state_3;
                        return AsLong.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link AsBigInteger#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link AsBigInteger#doBigInteger}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link AsBigInteger#doOther}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public BigInteger asBigInteger(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_3 = this.state_3_;
                if ((state_3 & 0x380000) != 0 /* is SpecializationActive[HostObject.AsBigInteger.doNull(HostObject)] || SpecializationActive[HostObject.AsBigInteger.doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)] || SpecializationActive[HostObject.AsBigInteger.doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */) {
                    if ((state_3 & 0x80000) != 0 /* is SpecializationActive[HostObject.AsBigInteger.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return AsBigInteger.doNull(arg0Value);
                        }
                    }
                    if ((state_3 & 0x100000) != 0 /* is SpecializationActive[HostObject.AsBigInteger.doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((arg0Value.isBigInteger())) {
                                    Node node__ = (this);
                                    return AsBigInteger.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                                }
                            }
                        }
                    }
                    if ((state_3 & 0x200000) != 0 /* is SpecializationActive[HostObject.AsBigInteger.doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */) {
                        {
                            InteropLibrary numbers_ = this.numbers;
                            if (numbers_ != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                                    Node node__1 = (this);
                                    InteropLibrary receiverLibrary__ = (this);
                                    return AsBigInteger.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asBigIntegerAndSpecialize(arg0Value);
            }

            private BigInteger asBigIntegerAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_3 = this.state_3_;
                if ((arg0Value.isNull())) {
                    state_3 = state_3 | 0x80000 /* add SpecializationActive[HostObject.AsBigInteger.doNull(HostObject)] */;
                    this.state_3_ = state_3;
                    return AsBigInteger.doNull(arg0Value);
                }
                {
                    Node node__ = null;
                    if ((arg0Value.isBigInteger())) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_3 = state_3 | 0x100000 /* add SpecializationActive[HostObject.AsBigInteger.doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)] */;
                        this.state_3_ = state_3;
                        return AsBigInteger.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                }
                {
                    InteropLibrary receiverLibrary__ = null;
                    Node node__1 = null;
                    if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                        node__1 = (this);
                        receiverLibrary__ = (this);
                        InteropLibrary numbers_;
                        InteropLibrary numbers__shared = this.numbers;
                        if (numbers__shared != null) {
                            numbers_ = numbers__shared;
                        } else {
                            numbers_ = this.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                            if (numbers_ == null) {
                                throw new IllegalStateException("Specialization 'doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)' contains a shared cache with name 'numbers' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.numbers == null) {
                            VarHandle.storeStoreFence();
                            this.numbers = numbers_;
                        }
                        state_3 = state_3 | 0x200000 /* add SpecializationActive[HostObject.AsBigInteger.doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */;
                        this.state_3_ = state_3;
                        return AsBigInteger.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link AsFloat#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link AsFloat#doBigInteger}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link AsFloat#doOther}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public float asFloat(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_3 = this.state_3_;
                if ((state_3 & 0x1c00000) != 0 /* is SpecializationActive[HostObject.AsFloat.doNull(HostObject)] || SpecializationActive[HostObject.AsFloat.doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)] || SpecializationActive[HostObject.AsFloat.doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */) {
                    if ((state_3 & 0x400000) != 0 /* is SpecializationActive[HostObject.AsFloat.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return AsFloat.doNull(arg0Value);
                        }
                    }
                    if ((state_3 & 0x800000) != 0 /* is SpecializationActive[HostObject.AsFloat.doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((arg0Value.isBigInteger())) {
                                    Node node__ = (this);
                                    return AsFloat.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                                }
                            }
                        }
                    }
                    if ((state_3 & 0x1000000) != 0 /* is SpecializationActive[HostObject.AsFloat.doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */) {
                        {
                            InteropLibrary numbers_ = this.numbers;
                            if (numbers_ != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                                    Node node__1 = (this);
                                    InteropLibrary receiverLibrary__ = (this);
                                    return AsFloat.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asFloatAndSpecialize(arg0Value);
            }

            private float asFloatAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_3 = this.state_3_;
                if ((arg0Value.isNull())) {
                    state_3 = state_3 | 0x400000 /* add SpecializationActive[HostObject.AsFloat.doNull(HostObject)] */;
                    this.state_3_ = state_3;
                    return AsFloat.doNull(arg0Value);
                }
                {
                    Node node__ = null;
                    if ((arg0Value.isBigInteger())) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_3 = state_3 | 0x800000 /* add SpecializationActive[HostObject.AsFloat.doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)] */;
                        this.state_3_ = state_3;
                        return AsFloat.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                }
                {
                    InteropLibrary receiverLibrary__ = null;
                    Node node__1 = null;
                    if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                        node__1 = (this);
                        receiverLibrary__ = (this);
                        InteropLibrary numbers_;
                        InteropLibrary numbers__shared = this.numbers;
                        if (numbers__shared != null) {
                            numbers_ = numbers__shared;
                        } else {
                            numbers_ = this.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                            if (numbers_ == null) {
                                throw new IllegalStateException("Specialization 'doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)' contains a shared cache with name 'numbers' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.numbers == null) {
                            VarHandle.storeStoreFence();
                            this.numbers = numbers_;
                        }
                        state_3 = state_3 | 0x1000000 /* add SpecializationActive[HostObject.AsFloat.doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */;
                        this.state_3_ = state_3;
                        return AsFloat.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link AsDouble#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link AsDouble#doBigInteger}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link AsDouble#doOther}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public double asDouble(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_3 = this.state_3_;
                if ((state_3 & 0xe000000) != 0 /* is SpecializationActive[HostObject.AsDouble.doNull(HostObject)] || SpecializationActive[HostObject.AsDouble.doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)] || SpecializationActive[HostObject.AsDouble.doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */) {
                    if ((state_3 & 0x2000000) != 0 /* is SpecializationActive[HostObject.AsDouble.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return AsDouble.doNull(arg0Value);
                        }
                    }
                    if ((state_3 & 0x4000000) != 0 /* is SpecializationActive[HostObject.AsDouble.doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((arg0Value.isBigInteger())) {
                                    Node node__ = (this);
                                    return AsDouble.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                                }
                            }
                        }
                    }
                    if ((state_3 & 0x8000000) != 0 /* is SpecializationActive[HostObject.AsDouble.doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */) {
                        {
                            InteropLibrary numbers_ = this.numbers;
                            if (numbers_ != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                                    Node node__1 = (this);
                                    InteropLibrary receiverLibrary__ = (this);
                                    return AsDouble.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asDoubleAndSpecialize(arg0Value);
            }

            private double asDoubleAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_3 = this.state_3_;
                if ((arg0Value.isNull())) {
                    state_3 = state_3 | 0x2000000 /* add SpecializationActive[HostObject.AsDouble.doNull(HostObject)] */;
                    this.state_3_ = state_3;
                    return AsDouble.doNull(arg0Value);
                }
                {
                    Node node__ = null;
                    if ((arg0Value.isBigInteger())) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_3 = state_3 | 0x4000000 /* add SpecializationActive[HostObject.AsDouble.doBigInteger(HostObject, Node, HostClassCache, InlinedBranchProfile)] */;
                        this.state_3_ = state_3;
                        return AsDouble.doBigInteger(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                    }
                }
                {
                    InteropLibrary receiverLibrary__ = null;
                    Node node__1 = null;
                    if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                        node__1 = (this);
                        receiverLibrary__ = (this);
                        InteropLibrary numbers_;
                        InteropLibrary numbers__shared = this.numbers;
                        if (numbers__shared != null) {
                            numbers_ = numbers__shared;
                        } else {
                            numbers_ = this.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                            if (numbers_ == null) {
                                throw new IllegalStateException("Specialization 'doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)' contains a shared cache with name 'numbers' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.numbers == null) {
                            VarHandle.storeStoreFence();
                            this.numbers = numbers_;
                        }
                        state_3 = state_3 | 0x8000000 /* add SpecializationActive[HostObject.AsDouble.doOther(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */;
                        this.state_3_ = state_3;
                        return AsDouble.doOther(arg0Value, node__1, receiverLibrary__, numbers_, INLINED_ERROR);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HasIterator#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link HasIterator#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean hasIterator(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_3 = this.state_3_;
                if ((state_3 & 0x30000000) != 0 /* is SpecializationActive[HostObject.HasIterator.doNull(HostObject)] || SpecializationActive[HostObject.HasIterator.doNonNull(HostObject, HostClassCache)] */) {
                    if ((state_3 & 0x10000000) != 0 /* is SpecializationActive[HostObject.HasIterator.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return HasIterator.doNull(arg0Value);
                        }
                    }
                    if ((state_3 & 0x20000000) != 0 /* is SpecializationActive[HostObject.HasIterator.doNonNull(HostObject, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    return HasIterator.doNonNull(arg0Value, hostClassCache_);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasIteratorAndSpecialize(arg0Value);
            }

            private boolean hasIteratorAndSpecialize(HostObject arg0Value) {
                int state_3 = this.state_3_;
                if ((arg0Value.isNull())) {
                    state_3 = state_3 | 0x10000000 /* add SpecializationActive[HostObject.HasIterator.doNull(HostObject)] */;
                    this.state_3_ = state_3;
                    return HasIterator.doNull(arg0Value);
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = (arg0Value.getHostClassCache());
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("Specialization 'doNonNull(HostObject, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    state_3 = state_3 | 0x20000000 /* add SpecializationActive[HostObject.HasIterator.doNonNull(HostObject, HostClassCache)] */;
                    this.state_3_ = state_3;
                    return HasIterator.doNonNull(arg0Value, hostClassCache_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link GetIterator#doNull}
             *     Activation probability: 0.00513
             *     With/without class size: 4/0 bytes
             *   Specialization {@link GetIterator#doArray}
             *     Activation probability: 0.00393
             *     With/without class size: 4/0 bytes
             *   Specialization {@link GetIterator#doIterable}
             *     Activation probability: 0.00273
             *     With/without class size: 4/0 bytes
             *   Specialization {@link GetIterator#doNotArrayOrIterable}
             *     Activation probability: 0.00153
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Object getIterator(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_3 = this.state_3_;
                int state_4 = this.state_4_;
                if (((state_3 & 0xc0000000) != 0 /* is SpecializationActive[HostObject.GetIterator.doNull(HostObject)] || SpecializationActive[HostObject.GetIterator.doArray(HostObject, Node, HostClassCache, ToGuestValueNode)] */ || (state_4 & 0b11) != 0 /* is SpecializationActive[HostObject.GetIterator.doIterable(HostObject, Node, HostClassCache, ToGuestValueNode, InlinedBranchProfile)] || SpecializationActive[HostObject.GetIterator.doNotArrayOrIterable(HostObject, HostClassCache)] */)) {
                    if ((state_3 & 0x40000000) != 0 /* is SpecializationActive[HostObject.GetIterator.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return GetIterator.doNull(arg0Value);
                        }
                    }
                    if ((state_3 & 0x80000000) != 0 /* is SpecializationActive[HostObject.GetIterator.doArray(HostObject, Node, HostClassCache, ToGuestValueNode)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isArray(hostClassCache_))) {
                                    Node node__ = (this);
                                    return GetIterator.doArray(arg0Value, node__, hostClassCache_, INLINED_TO_GUEST);
                                }
                            }
                        }
                    }
                    if ((state_4 & 0b1) != 0 /* is SpecializationActive[HostObject.GetIterator.doIterable(HostObject, Node, HostClassCache, ToGuestValueNode, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_1 = this.hostClassCache;
                            if (hostClassCache_1 != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isIterable(hostClassCache_1))) {
                                    Node node__1 = (this);
                                    return GetIterator.doIterable(arg0Value, node__1, hostClassCache_1, INLINED_TO_GUEST, INLINED_ERROR);
                                }
                            }
                        }
                    }
                    if ((state_4 & 0b10) != 0 /* is SpecializationActive[HostObject.GetIterator.doNotArrayOrIterable(HostObject, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_2 = this.hostClassCache;
                            if (hostClassCache_2 != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isArray(hostClassCache_2))) && (!(arg0Value.isIterable(hostClassCache_2)))) {
                                    return GetIterator.doNotArrayOrIterable(arg0Value, hostClassCache_2);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getIteratorAndSpecialize(arg0Value);
            }

            private Object getIteratorAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_3 = this.state_3_;
                int state_4 = this.state_4_;
                if ((arg0Value.isNull())) {
                    state_3 = state_3 | 0x40000000 /* add SpecializationActive[HostObject.GetIterator.doNull(HostObject)] */;
                    this.state_3_ = state_3;
                    return GetIterator.doNull(arg0Value);
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doArray(HostObject, Node, HostClassCache, ToGuestValueNode)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((arg0Value.isArray(hostClassCache_))) {
                            node__ = (this);
                            if (this.hostClassCache == null) {
                                VarHandle.storeStoreFence();
                                this.hostClassCache = hostClassCache_;
                            }
                            state_3 = state_3 | 0x80000000 /* add SpecializationActive[HostObject.GetIterator.doArray(HostObject, Node, HostClassCache, ToGuestValueNode)] */;
                            this.state_3_ = state_3;
                            return GetIterator.doArray(arg0Value, node__, hostClassCache_, INLINED_TO_GUEST);
                        }
                    }
                }
                {
                    Node node__1 = null;
                    if ((!(arg0Value.isNull()))) {
                        HostClassCache hostClassCache_1;
                        HostClassCache hostClassCache_1_shared = this.hostClassCache;
                        if (hostClassCache_1_shared != null) {
                            hostClassCache_1 = hostClassCache_1_shared;
                        } else {
                            hostClassCache_1 = (arg0Value.getHostClassCache());
                            if (hostClassCache_1 == null) {
                                throw new IllegalStateException("Specialization 'doIterable(HostObject, Node, HostClassCache, ToGuestValueNode, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((arg0Value.isIterable(hostClassCache_1))) {
                            node__1 = (this);
                            if (this.hostClassCache == null) {
                                VarHandle.storeStoreFence();
                                this.hostClassCache = hostClassCache_1;
                            }
                            state_4 = state_4 | 0b1 /* add SpecializationActive[HostObject.GetIterator.doIterable(HostObject, Node, HostClassCache, ToGuestValueNode, InlinedBranchProfile)] */;
                            this.state_4_ = state_4;
                            return GetIterator.doIterable(arg0Value, node__1, hostClassCache_1, INLINED_TO_GUEST, INLINED_ERROR);
                        }
                    }
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_2;
                    HostClassCache hostClassCache_2_shared = this.hostClassCache;
                    if (hostClassCache_2_shared != null) {
                        hostClassCache_2 = hostClassCache_2_shared;
                    } else {
                        hostClassCache_2 = (arg0Value.getHostClassCache());
                        if (hostClassCache_2 == null) {
                            throw new IllegalStateException("Specialization 'doNotArrayOrIterable(HostObject, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if ((!(arg0Value.isArray(hostClassCache_2))) && (!(arg0Value.isIterable(hostClassCache_2)))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_2;
                        }
                        state_4 = state_4 | 0b10 /* add SpecializationActive[HostObject.GetIterator.doNotArrayOrIterable(HostObject, HostClassCache)] */;
                        this.state_4_ = state_4;
                        return GetIterator.doNotArrayOrIterable(arg0Value, hostClassCache_2);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsIterator#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsIterator#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isIterator(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_4 = this.state_4_;
                if ((state_4 & 0b1100) != 0 /* is SpecializationActive[HostObject.IsIterator.doNull(HostObject)] || SpecializationActive[HostObject.IsIterator.doNonNull(HostObject, HostClassCache)] */) {
                    if ((state_4 & 0b100) != 0 /* is SpecializationActive[HostObject.IsIterator.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return IsIterator.doNull(arg0Value);
                        }
                    }
                    if ((state_4 & 0b1000) != 0 /* is SpecializationActive[HostObject.IsIterator.doNonNull(HostObject, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    return IsIterator.doNonNull(arg0Value, hostClassCache_);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isIteratorAndSpecialize(arg0Value);
            }

            private boolean isIteratorAndSpecialize(HostObject arg0Value) {
                int state_4 = this.state_4_;
                if ((arg0Value.isNull())) {
                    state_4 = state_4 | 0b100 /* add SpecializationActive[HostObject.IsIterator.doNull(HostObject)] */;
                    this.state_4_ = state_4;
                    return IsIterator.doNull(arg0Value);
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = (arg0Value.getHostClassCache());
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("Specialization 'doNonNull(HostObject, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    state_4 = state_4 | 0b1000 /* add SpecializationActive[HostObject.IsIterator.doNonNull(HostObject, HostClassCache)] */;
                    this.state_4_ = state_4;
                    return IsIterator.doNonNull(arg0Value, hostClassCache_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HasIteratorNextElement#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link HasIteratorNextElement#doIterator}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link HasIteratorNextElement#doNotIterator}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean hasIteratorNextElement(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_4 = this.state_4_;
                if ((state_4 & 0b1110000) != 0 /* is SpecializationActive[HostObject.HasIteratorNextElement.doNull(HostObject)] || SpecializationActive[HostObject.HasIteratorNextElement.doIterator(HostObject, Node, HostClassCache, InlinedBranchProfile)] || SpecializationActive[HostObject.HasIteratorNextElement.doNotIterator(HostObject, HostClassCache)] */) {
                    if ((state_4 & 0b10000) != 0 /* is SpecializationActive[HostObject.HasIteratorNextElement.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return HasIteratorNextElement.doNull(arg0Value);
                        }
                    }
                    if ((state_4 & 0b100000) != 0 /* is SpecializationActive[HostObject.HasIteratorNextElement.doIterator(HostObject, Node, HostClassCache, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isIteratorLocal(hostClassCache_))) {
                                    Node node__ = (this);
                                    return HasIteratorNextElement.doIterator(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                                }
                            }
                        }
                    }
                    if ((state_4 & 0b1000000) != 0 /* is SpecializationActive[HostObject.HasIteratorNextElement.doNotIterator(HostObject, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_1 = this.hostClassCache;
                            if (hostClassCache_1 != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isIteratorLocal(hostClassCache_1)))) {
                                    return HasIteratorNextElement.doNotIterator(arg0Value, hostClassCache_1);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasIteratorNextElementAndSpecialize(arg0Value);
            }

            private boolean hasIteratorNextElementAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_4 = this.state_4_;
                if ((arg0Value.isNull())) {
                    state_4 = state_4 | 0b10000 /* add SpecializationActive[HostObject.HasIteratorNextElement.doNull(HostObject)] */;
                    this.state_4_ = state_4;
                    return HasIteratorNextElement.doNull(arg0Value);
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doIterator(HostObject, Node, HostClassCache, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((arg0Value.isIteratorLocal(hostClassCache_))) {
                            node__ = (this);
                            if (this.hostClassCache == null) {
                                VarHandle.storeStoreFence();
                                this.hostClassCache = hostClassCache_;
                            }
                            state_4 = state_4 | 0b100000 /* add SpecializationActive[HostObject.HasIteratorNextElement.doIterator(HostObject, Node, HostClassCache, InlinedBranchProfile)] */;
                            this.state_4_ = state_4;
                            return HasIteratorNextElement.doIterator(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                        }
                    }
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = (arg0Value.getHostClassCache());
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("Specialization 'doNotIterator(HostObject, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if ((!(arg0Value.isIteratorLocal(hostClassCache_1)))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        state_4 = state_4 | 0b1000000 /* add SpecializationActive[HostObject.HasIteratorNextElement.doNotIterator(HostObject, HostClassCache)] */;
                        this.state_4_ = state_4;
                        return HasIteratorNextElement.doNotIterator(arg0Value, hostClassCache_1);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link GetIteratorNextElement#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link GetIteratorNextElement#doIterator}
             *     Activation probability: 0.00444
             *     With/without class size: 4/1 bytes
             *   Specialization {@link GetIteratorNextElement#doNotIterator}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Object getIteratorNextElement(Object arg0Value_) throws UnsupportedMessageException, StopIterationException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_4 = this.state_4_;
                if ((state_4 & 0b1110000000) != 0 /* is SpecializationActive[HostObject.GetIteratorNextElement.doNull(HostObject)] || SpecializationActive[HostObject.GetIteratorNextElement.doIterator(HostObject, Node, HostClassCache, ToGuestValueNode, InlinedBranchProfile, InlinedBranchProfile)] || SpecializationActive[HostObject.GetIteratorNextElement.doNotIterator(HostObject, HostClassCache)] */) {
                    if ((state_4 & 0b10000000) != 0 /* is SpecializationActive[HostObject.GetIteratorNextElement.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return GetIteratorNextElement.doNull(arg0Value);
                        }
                    }
                    if ((state_4 & 0b100000000) != 0 /* is SpecializationActive[HostObject.GetIteratorNextElement.doIterator(HostObject, Node, HostClassCache, ToGuestValueNode, InlinedBranchProfile, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isIteratorLocal(hostClassCache_))) {
                                    Node node__ = (this);
                                    return GetIteratorNextElement.doIterator(arg0Value, node__, hostClassCache_, INLINED_TO_GUEST, INLINED_ERROR, INLINED_GET_ITERATOR_NEXT_ELEMENT_ITERATOR_STOP_ITERATION_);
                                }
                            }
                        }
                    }
                    if ((state_4 & 0b1000000000) != 0 /* is SpecializationActive[HostObject.GetIteratorNextElement.doNotIterator(HostObject, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_1 = this.hostClassCache;
                            if (hostClassCache_1 != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isIteratorLocal(hostClassCache_1)))) {
                                    return GetIteratorNextElement.doNotIterator(arg0Value, hostClassCache_1);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getIteratorNextElementAndSpecialize(arg0Value);
            }

            private Object getIteratorNextElementAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException, StopIterationException {
                int state_4 = this.state_4_;
                if ((arg0Value.isNull())) {
                    state_4 = state_4 | 0b10000000 /* add SpecializationActive[HostObject.GetIteratorNextElement.doNull(HostObject)] */;
                    this.state_4_ = state_4;
                    return GetIteratorNextElement.doNull(arg0Value);
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doIterator(HostObject, Node, HostClassCache, ToGuestValueNode, InlinedBranchProfile, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((arg0Value.isIteratorLocal(hostClassCache_))) {
                            node__ = (this);
                            if (this.hostClassCache == null) {
                                VarHandle.storeStoreFence();
                                this.hostClassCache = hostClassCache_;
                            }
                            state_4 = state_4 | 0b100000000 /* add SpecializationActive[HostObject.GetIteratorNextElement.doIterator(HostObject, Node, HostClassCache, ToGuestValueNode, InlinedBranchProfile, InlinedBranchProfile)] */;
                            this.state_4_ = state_4;
                            return GetIteratorNextElement.doIterator(arg0Value, node__, hostClassCache_, INLINED_TO_GUEST, INLINED_ERROR, INLINED_GET_ITERATOR_NEXT_ELEMENT_ITERATOR_STOP_ITERATION_);
                        }
                    }
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = (arg0Value.getHostClassCache());
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("Specialization 'doNotIterator(HostObject, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if ((!(arg0Value.isIteratorLocal(hostClassCache_1)))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        state_4 = state_4 | 0b1000000000 /* add SpecializationActive[HostObject.GetIteratorNextElement.doNotIterator(HostObject, HostClassCache)] */;
                        this.state_4_ = state_4;
                        return GetIteratorNextElement.doNotIterator(arg0Value, hostClassCache_1);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HasHashEntries#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link HasHashEntries#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean hasHashEntries(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_4 = this.state_4_;
                if ((state_4 & 0b110000000000) != 0 /* is SpecializationActive[HostObject.HasHashEntries.doNull(HostObject)] || SpecializationActive[HostObject.HasHashEntries.doNonNull(HostObject, HostClassCache)] */) {
                    if ((state_4 & 0b10000000000) != 0 /* is SpecializationActive[HostObject.HasHashEntries.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return HasHashEntries.doNull(arg0Value);
                        }
                    }
                    if ((state_4 & 0b100000000000) != 0 /* is SpecializationActive[HostObject.HasHashEntries.doNonNull(HostObject, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    return HasHashEntries.doNonNull(arg0Value, hostClassCache_);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasHashEntriesAndSpecialize(arg0Value);
            }

            private boolean hasHashEntriesAndSpecialize(HostObject arg0Value) {
                int state_4 = this.state_4_;
                if ((arg0Value.isNull())) {
                    state_4 = state_4 | 0b10000000000 /* add SpecializationActive[HostObject.HasHashEntries.doNull(HostObject)] */;
                    this.state_4_ = state_4;
                    return HasHashEntries.doNull(arg0Value);
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_;
                    HostClassCache hostClassCache__shared = this.hostClassCache;
                    if (hostClassCache__shared != null) {
                        hostClassCache_ = hostClassCache__shared;
                    } else {
                        hostClassCache_ = (arg0Value.getHostClassCache());
                        if (hostClassCache_ == null) {
                            throw new IllegalStateException("Specialization 'doNonNull(HostObject, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.hostClassCache == null) {
                        VarHandle.storeStoreFence();
                        this.hostClassCache = hostClassCache_;
                    }
                    state_4 = state_4 | 0b100000000000 /* add SpecializationActive[HostObject.HasHashEntries.doNonNull(HostObject, HostClassCache)] */;
                    this.state_4_ = state_4;
                    return HasHashEntries.doNonNull(arg0Value, hostClassCache_);
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link GetHashSize#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link GetHashSize#doMap}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link GetHashSize#doNotMap}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public long getHashSize(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_4 = this.state_4_;
                if ((state_4 & 0b111000000000000) != 0 /* is SpecializationActive[HostObject.GetHashSize.doNull(HostObject)] || SpecializationActive[HostObject.GetHashSize.doMap(HostObject, Node, HostClassCache, InlinedBranchProfile)] || SpecializationActive[HostObject.GetHashSize.doNotMap(HostObject, HostClassCache)] */) {
                    if ((state_4 & 0b1000000000000) != 0 /* is SpecializationActive[HostObject.GetHashSize.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return GetHashSize.doNull(arg0Value);
                        }
                    }
                    if ((state_4 & 0b10000000000000) != 0 /* is SpecializationActive[HostObject.GetHashSize.doMap(HostObject, Node, HostClassCache, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isMap(hostClassCache_))) {
                                    Node node__ = (this);
                                    return GetHashSize.doMap(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                                }
                            }
                        }
                    }
                    if ((state_4 & 0b100000000000000) != 0 /* is SpecializationActive[HostObject.GetHashSize.doNotMap(HostObject, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_1 = this.hostClassCache;
                            if (hostClassCache_1 != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isMap(hostClassCache_1)))) {
                                    return GetHashSize.doNotMap(arg0Value, hostClassCache_1);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getHashSizeAndSpecialize(arg0Value);
            }

            private long getHashSizeAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_4 = this.state_4_;
                if ((arg0Value.isNull())) {
                    state_4 = state_4 | 0b1000000000000 /* add SpecializationActive[HostObject.GetHashSize.doNull(HostObject)] */;
                    this.state_4_ = state_4;
                    return GetHashSize.doNull(arg0Value);
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doMap(HostObject, Node, HostClassCache, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((arg0Value.isMap(hostClassCache_))) {
                            node__ = (this);
                            if (this.hostClassCache == null) {
                                VarHandle.storeStoreFence();
                                this.hostClassCache = hostClassCache_;
                            }
                            state_4 = state_4 | 0b10000000000000 /* add SpecializationActive[HostObject.GetHashSize.doMap(HostObject, Node, HostClassCache, InlinedBranchProfile)] */;
                            this.state_4_ = state_4;
                            return GetHashSize.doMap(arg0Value, node__, hostClassCache_, INLINED_ERROR);
                        }
                    }
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = (arg0Value.getHostClassCache());
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("Specialization 'doNotMap(HostObject, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if ((!(arg0Value.isMap(hostClassCache_1)))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        state_4 = state_4 | 0b100000000000000 /* add SpecializationActive[HostObject.GetHashSize.doNotMap(HostObject, HostClassCache)] */;
                        this.state_4_ = state_4;
                        return GetHashSize.doNotMap(arg0Value, hostClassCache_1);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsHashEntryReadable#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsHashEntryReadable#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isHashEntryReadable(Object arg0Value_, Object arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_4 = this.state_4_;
                if ((state_4 & 0x18000) != 0 /* is SpecializationActive[HostObject.IsHashEntryReadable.doNull(HostObject, Object)] || SpecializationActive[HostObject.IsHashEntryReadable.doNonNull(HostObject, Object, Node, ContainsKeyNode, HostClassCache)] */) {
                    if ((state_4 & 0b1000000000000000) != 0 /* is SpecializationActive[HostObject.IsHashEntryReadable.doNull(HostObject, Object)] */) {
                        if ((arg0Value.isNull())) {
                            return IsHashEntryReadable.doNull(arg0Value, arg1Value);
                        }
                    }
                    if ((state_4 & 0x10000) != 0 /* is SpecializationActive[HostObject.IsHashEntryReadable.doNonNull(HostObject, Object, Node, ContainsKeyNode, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    Node node__ = (this);
                                    return IsHashEntryReadable.doNonNull(arg0Value, arg1Value, node__, INLINED_CONTAINS_KEY, hostClassCache_);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isHashEntryReadableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isHashEntryReadableAndSpecialize(HostObject arg0Value, Object arg1Value) {
                int state_4 = this.state_4_;
                if ((arg0Value.isNull())) {
                    state_4 = state_4 | 0b1000000000000000 /* add SpecializationActive[HostObject.IsHashEntryReadable.doNull(HostObject, Object)] */;
                    this.state_4_ = state_4;
                    return IsHashEntryReadable.doNull(arg0Value, arg1Value);
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doNonNull(HostObject, Object, Node, ContainsKeyNode, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_4 = state_4 | 0x10000 /* add SpecializationActive[HostObject.IsHashEntryReadable.doNonNull(HostObject, Object, Node, ContainsKeyNode, HostClassCache)] */;
                        this.state_4_ = state_4;
                        return IsHashEntryReadable.doNonNull(arg0Value, arg1Value, node__, INLINED_CONTAINS_KEY, hostClassCache_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsHashEntryReadable#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsHashEntryReadable#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isHashEntryModifiable(Object arg0Value_, Object arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_4 = this.state_4_;
                if ((state_4 & 0x18000) != 0 /* is SpecializationActive[HostObject.IsHashEntryReadable.doNull(HostObject, Object)] || SpecializationActive[HostObject.IsHashEntryReadable.doNonNull(HostObject, Object, Node, ContainsKeyNode, HostClassCache)] */) {
                    if ((state_4 & 0b1000000000000000) != 0 /* is SpecializationActive[HostObject.IsHashEntryReadable.doNull(HostObject, Object)] */) {
                        if ((arg0Value.isNull())) {
                            return IsHashEntryReadable.doNull(arg0Value, arg1Value);
                        }
                    }
                    if ((state_4 & 0x10000) != 0 /* is SpecializationActive[HostObject.IsHashEntryReadable.doNonNull(HostObject, Object, Node, ContainsKeyNode, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    Node node__ = (this);
                                    return IsHashEntryReadable.doNonNull(arg0Value, arg1Value, node__, INLINED_CONTAINS_KEY, hostClassCache_);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isHashEntryReadableAndSpecialize(arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsHashEntryReadable#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsHashEntryReadable#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isHashEntryRemovable(Object arg0Value_, Object arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_4 = this.state_4_;
                if ((state_4 & 0x18000) != 0 /* is SpecializationActive[HostObject.IsHashEntryReadable.doNull(HostObject, Object)] || SpecializationActive[HostObject.IsHashEntryReadable.doNonNull(HostObject, Object, Node, ContainsKeyNode, HostClassCache)] */) {
                    if ((state_4 & 0b1000000000000000) != 0 /* is SpecializationActive[HostObject.IsHashEntryReadable.doNull(HostObject, Object)] */) {
                        if ((arg0Value.isNull())) {
                            return IsHashEntryReadable.doNull(arg0Value, arg1Value);
                        }
                    }
                    if ((state_4 & 0x10000) != 0 /* is SpecializationActive[HostObject.IsHashEntryReadable.doNonNull(HostObject, Object, Node, ContainsKeyNode, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    Node node__ = (this);
                                    return IsHashEntryReadable.doNonNull(arg0Value, arg1Value, node__, INLINED_CONTAINS_KEY, hostClassCache_);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isHashEntryReadableAndSpecialize(arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link ReadHashValue#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link ReadHashValue#doMap}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link ReadHashValue#doNotMap}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Object readHashValue(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_4 = this.state_4_;
                if ((state_4 & 0xe0000) != 0 /* is SpecializationActive[HostObject.ReadHashValue.doNull(HostObject, Object)] || SpecializationActive[HostObject.ReadHashValue.doMap(HostObject, Object, Node, HostClassCache, HostToTypeNode, ToGuestValueNode, InlinedBranchProfile)] || SpecializationActive[HostObject.ReadHashValue.doNotMap(HostObject, Object, HostClassCache)] */) {
                    if ((state_4 & 0x20000) != 0 /* is SpecializationActive[HostObject.ReadHashValue.doNull(HostObject, Object)] */) {
                        if ((arg0Value.isNull())) {
                            return ReadHashValue.doNull(arg0Value, arg1Value);
                        }
                    }
                    if ((state_4 & 0x40000) != 0 /* is SpecializationActive[HostObject.ReadHashValue.doMap(HostObject, Object, Node, HostClassCache, HostToTypeNode, ToGuestValueNode, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isMap(hostClassCache_))) {
                                    Node node__ = (this);
                                    return ReadHashValue.doMap(arg0Value, arg1Value, node__, hostClassCache_, INLINED_TO_HOST, INLINED_TO_GUEST, INLINED_ERROR);
                                }
                            }
                        }
                    }
                    if ((state_4 & 0x80000) != 0 /* is SpecializationActive[HostObject.ReadHashValue.doNotMap(HostObject, Object, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_1 = this.hostClassCache;
                            if (hostClassCache_1 != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isMap(hostClassCache_1)))) {
                                    return ReadHashValue.doNotMap(arg0Value, arg1Value, hostClassCache_1);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readHashValueAndSpecialize(arg0Value, arg1Value);
            }

            private Object readHashValueAndSpecialize(HostObject arg0Value, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                int state_4 = this.state_4_;
                if ((arg0Value.isNull())) {
                    state_4 = state_4 | 0x20000 /* add SpecializationActive[HostObject.ReadHashValue.doNull(HostObject, Object)] */;
                    this.state_4_ = state_4;
                    return ReadHashValue.doNull(arg0Value, arg1Value);
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doMap(HostObject, Object, Node, HostClassCache, HostToTypeNode, ToGuestValueNode, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((arg0Value.isMap(hostClassCache_))) {
                            node__ = (this);
                            if (this.hostClassCache == null) {
                                VarHandle.storeStoreFence();
                                this.hostClassCache = hostClassCache_;
                            }
                            state_4 = state_4 | 0x40000 /* add SpecializationActive[HostObject.ReadHashValue.doMap(HostObject, Object, Node, HostClassCache, HostToTypeNode, ToGuestValueNode, InlinedBranchProfile)] */;
                            this.state_4_ = state_4;
                            return ReadHashValue.doMap(arg0Value, arg1Value, node__, hostClassCache_, INLINED_TO_HOST, INLINED_TO_GUEST, INLINED_ERROR);
                        }
                    }
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = (arg0Value.getHostClassCache());
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("Specialization 'doNotMap(HostObject, Object, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if ((!(arg0Value.isMap(hostClassCache_1)))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        state_4 = state_4 | 0x80000 /* add SpecializationActive[HostObject.ReadHashValue.doNotMap(HostObject, Object, HostClassCache)] */;
                        this.state_4_ = state_4;
                        return ReadHashValue.doNotMap(arg0Value, arg1Value, hostClassCache_1);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsHashEntryInsertable#doNull}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsHashEntryInsertable#doNonNull}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isHashEntryInsertable(Object arg0Value_, Object arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_4 = this.state_4_;
                if ((state_4 & 0x300000) != 0 /* is SpecializationActive[HostObject.IsHashEntryInsertable.doNull(HostObject, Object)] || SpecializationActive[HostObject.IsHashEntryInsertable.doNonNull(HostObject, Object, Node, ContainsKeyNode, HostClassCache)] */) {
                    if ((state_4 & 0x100000) != 0 /* is SpecializationActive[HostObject.IsHashEntryInsertable.doNull(HostObject, Object)] */) {
                        if ((arg0Value.isNull())) {
                            return IsHashEntryInsertable.doNull(arg0Value, arg1Value);
                        }
                    }
                    if ((state_4 & 0x200000) != 0 /* is SpecializationActive[HostObject.IsHashEntryInsertable.doNonNull(HostObject, Object, Node, ContainsKeyNode, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull()))) {
                                    Node node__ = (this);
                                    return IsHashEntryInsertable.doNonNull(arg0Value, arg1Value, node__, INLINED_CONTAINS_KEY, hostClassCache_);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isHashEntryInsertableAndSpecialize(arg0Value, arg1Value);
            }

            private boolean isHashEntryInsertableAndSpecialize(HostObject arg0Value, Object arg1Value) {
                int state_4 = this.state_4_;
                if ((arg0Value.isNull())) {
                    state_4 = state_4 | 0x100000 /* add SpecializationActive[HostObject.IsHashEntryInsertable.doNull(HostObject, Object)] */;
                    this.state_4_ = state_4;
                    return IsHashEntryInsertable.doNull(arg0Value, arg1Value);
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        node__ = (this);
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doNonNull(HostObject, Object, Node, ContainsKeyNode, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_;
                        }
                        state_4 = state_4 | 0x200000 /* add SpecializationActive[HostObject.IsHashEntryInsertable.doNonNull(HostObject, Object, Node, ContainsKeyNode, HostClassCache)] */;
                        this.state_4_ = state_4;
                        return IsHashEntryInsertable.doNonNull(arg0Value, arg1Value, node__, INLINED_CONTAINS_KEY, hostClassCache_);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link WriteHashEntry#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link WriteHashEntry#doMap}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link WriteHashEntry#doNotMap}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeHashEntry(Object arg0Value_, Object arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownKeyException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_4 = this.state_4_;
                if ((state_4 & 0x1c00000) != 0 /* is SpecializationActive[HostObject.WriteHashEntry.doNull(HostObject, Object, Object)] || SpecializationActive[HostObject.WriteHashEntry.doMap(HostObject, Object, Object, Node, HostClassCache, HostToTypeNode, InlinedBranchProfile)] || SpecializationActive[HostObject.WriteHashEntry.doNotMap(HostObject, Object, Object, HostClassCache)] */) {
                    if ((state_4 & 0x400000) != 0 /* is SpecializationActive[HostObject.WriteHashEntry.doNull(HostObject, Object, Object)] */) {
                        if ((arg0Value.isNull())) {
                            WriteHashEntry.doNull(arg0Value, arg1Value, arg2Value);
                            return;
                        }
                    }
                    if ((state_4 & 0x800000) != 0 /* is SpecializationActive[HostObject.WriteHashEntry.doMap(HostObject, Object, Object, Node, HostClassCache, HostToTypeNode, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isMap(hostClassCache_))) {
                                    Node node__ = (this);
                                    WriteHashEntry.doMap(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_TO_HOST, INLINED_ERROR);
                                    return;
                                }
                            }
                        }
                    }
                    if ((state_4 & 0x1000000) != 0 /* is SpecializationActive[HostObject.WriteHashEntry.doNotMap(HostObject, Object, Object, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_1 = this.hostClassCache;
                            if (hostClassCache_1 != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isMap(hostClassCache_1)))) {
                                    WriteHashEntry.doNotMap(arg0Value, arg1Value, arg2Value, hostClassCache_1);
                                    return;
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeHashEntryAndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeHashEntryAndSpecialize(HostObject arg0Value, Object arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException {
                int state_4 = this.state_4_;
                if ((arg0Value.isNull())) {
                    state_4 = state_4 | 0x400000 /* add SpecializationActive[HostObject.WriteHashEntry.doNull(HostObject, Object, Object)] */;
                    this.state_4_ = state_4;
                    WriteHashEntry.doNull(arg0Value, arg1Value, arg2Value);
                    return;
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doMap(HostObject, Object, Object, Node, HostClassCache, HostToTypeNode, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((arg0Value.isMap(hostClassCache_))) {
                            node__ = (this);
                            if (this.hostClassCache == null) {
                                VarHandle.storeStoreFence();
                                this.hostClassCache = hostClassCache_;
                            }
                            state_4 = state_4 | 0x800000 /* add SpecializationActive[HostObject.WriteHashEntry.doMap(HostObject, Object, Object, Node, HostClassCache, HostToTypeNode, InlinedBranchProfile)] */;
                            this.state_4_ = state_4;
                            WriteHashEntry.doMap(arg0Value, arg1Value, arg2Value, node__, hostClassCache_, INLINED_TO_HOST, INLINED_ERROR);
                            return;
                        }
                    }
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = (arg0Value.getHostClassCache());
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("Specialization 'doNotMap(HostObject, Object, Object, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if ((!(arg0Value.isMap(hostClassCache_1)))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        state_4 = state_4 | 0x1000000 /* add SpecializationActive[HostObject.WriteHashEntry.doNotMap(HostObject, Object, Object, HostClassCache)] */;
                        this.state_4_ = state_4;
                        WriteHashEntry.doNotMap(arg0Value, arg1Value, arg2Value, hostClassCache_1);
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link RemoveHashEntry#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link RemoveHashEntry#doMap}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link RemoveHashEntry#doNotMap}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void removeHashEntry(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_4 = this.state_4_;
                if ((state_4 & 0xe000000) != 0 /* is SpecializationActive[HostObject.RemoveHashEntry.doNull(HostObject, Object)] || SpecializationActive[HostObject.RemoveHashEntry.doMap(HostObject, Object, Node, HostClassCache, HostToTypeNode, InlinedBranchProfile)] || SpecializationActive[HostObject.RemoveHashEntry.doNotMap(HostObject, Object, HostClassCache)] */) {
                    if ((state_4 & 0x2000000) != 0 /* is SpecializationActive[HostObject.RemoveHashEntry.doNull(HostObject, Object)] */) {
                        if ((arg0Value.isNull())) {
                            RemoveHashEntry.doNull(arg0Value, arg1Value);
                            return;
                        }
                    }
                    if ((state_4 & 0x4000000) != 0 /* is SpecializationActive[HostObject.RemoveHashEntry.doMap(HostObject, Object, Node, HostClassCache, HostToTypeNode, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isMap(hostClassCache_))) {
                                    Node node__ = (this);
                                    RemoveHashEntry.doMap(arg0Value, arg1Value, node__, hostClassCache_, INLINED_TO_HOST, INLINED_ERROR);
                                    return;
                                }
                            }
                        }
                    }
                    if ((state_4 & 0x8000000) != 0 /* is SpecializationActive[HostObject.RemoveHashEntry.doNotMap(HostObject, Object, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_1 = this.hostClassCache;
                            if (hostClassCache_1 != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isMap(hostClassCache_1)))) {
                                    RemoveHashEntry.doNotMap(arg0Value, arg1Value, hostClassCache_1);
                                    return;
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                removeHashEntryAndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void removeHashEntryAndSpecialize(HostObject arg0Value, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                int state_4 = this.state_4_;
                if ((arg0Value.isNull())) {
                    state_4 = state_4 | 0x2000000 /* add SpecializationActive[HostObject.RemoveHashEntry.doNull(HostObject, Object)] */;
                    this.state_4_ = state_4;
                    RemoveHashEntry.doNull(arg0Value, arg1Value);
                    return;
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doMap(HostObject, Object, Node, HostClassCache, HostToTypeNode, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((arg0Value.isMap(hostClassCache_))) {
                            node__ = (this);
                            if (this.hostClassCache == null) {
                                VarHandle.storeStoreFence();
                                this.hostClassCache = hostClassCache_;
                            }
                            state_4 = state_4 | 0x4000000 /* add SpecializationActive[HostObject.RemoveHashEntry.doMap(HostObject, Object, Node, HostClassCache, HostToTypeNode, InlinedBranchProfile)] */;
                            this.state_4_ = state_4;
                            RemoveHashEntry.doMap(arg0Value, arg1Value, node__, hostClassCache_, INLINED_TO_HOST, INLINED_ERROR);
                            return;
                        }
                    }
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = (arg0Value.getHostClassCache());
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("Specialization 'doNotMap(HostObject, Object, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if ((!(arg0Value.isMap(hostClassCache_1)))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        state_4 = state_4 | 0x8000000 /* add SpecializationActive[HostObject.RemoveHashEntry.doNotMap(HostObject, Object, HostClassCache)] */;
                        this.state_4_ = state_4;
                        RemoveHashEntry.doNotMap(arg0Value, arg1Value, hostClassCache_1);
                        return;
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link GetHashEntriesIterator#doNull}
             *     Activation probability: 0.00644
             *     With/without class size: 4/0 bytes
             *   Specialization {@link GetHashEntriesIterator#doMap}
             *     Activation probability: 0.00444
             *     With/without class size: 4/0 bytes
             *   Specialization {@link GetHashEntriesIterator#doNotMap}
             *     Activation probability: 0.00244
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Object getHashEntriesIterator(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_4 = this.state_4_;
                if ((state_4 & 0x70000000) != 0 /* is SpecializationActive[HostObject.GetHashEntriesIterator.doNull(HostObject)] || SpecializationActive[HostObject.GetHashEntriesIterator.doMap(HostObject, Node, HostClassCache, ToGuestValueNode, InlinedBranchProfile)] || SpecializationActive[HostObject.GetHashEntriesIterator.doNotMap(HostObject, HostClassCache)] */) {
                    if ((state_4 & 0x10000000) != 0 /* is SpecializationActive[HostObject.GetHashEntriesIterator.doNull(HostObject)] */) {
                        if ((arg0Value.isNull())) {
                            return GetHashEntriesIterator.doNull(arg0Value);
                        }
                    }
                    if ((state_4 & 0x20000000) != 0 /* is SpecializationActive[HostObject.GetHashEntriesIterator.doMap(HostObject, Node, HostClassCache, ToGuestValueNode, InlinedBranchProfile)] */) {
                        {
                            HostClassCache hostClassCache_ = this.hostClassCache;
                            if (hostClassCache_ != null) {
                                if ((!(arg0Value.isNull())) && (arg0Value.isMap(hostClassCache_))) {
                                    Node node__ = (this);
                                    return GetHashEntriesIterator.doMap(arg0Value, node__, hostClassCache_, INLINED_TO_GUEST, INLINED_ERROR);
                                }
                            }
                        }
                    }
                    if ((state_4 & 0x40000000) != 0 /* is SpecializationActive[HostObject.GetHashEntriesIterator.doNotMap(HostObject, HostClassCache)] */) {
                        {
                            HostClassCache hostClassCache_1 = this.hostClassCache;
                            if (hostClassCache_1 != null) {
                                if ((!(arg0Value.isNull())) && (!(arg0Value.isMap(hostClassCache_1)))) {
                                    return GetHashEntriesIterator.doNotMap(arg0Value, hostClassCache_1);
                                }
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getHashEntriesIteratorAndSpecialize(arg0Value);
            }

            private Object getHashEntriesIteratorAndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_4 = this.state_4_;
                if ((arg0Value.isNull())) {
                    state_4 = state_4 | 0x10000000 /* add SpecializationActive[HostObject.GetHashEntriesIterator.doNull(HostObject)] */;
                    this.state_4_ = state_4;
                    return GetHashEntriesIterator.doNull(arg0Value);
                }
                {
                    Node node__ = null;
                    if ((!(arg0Value.isNull()))) {
                        HostClassCache hostClassCache_;
                        HostClassCache hostClassCache__shared = this.hostClassCache;
                        if (hostClassCache__shared != null) {
                            hostClassCache_ = hostClassCache__shared;
                        } else {
                            hostClassCache_ = (arg0Value.getHostClassCache());
                            if (hostClassCache_ == null) {
                                throw new IllegalStateException("Specialization 'doMap(HostObject, Node, HostClassCache, ToGuestValueNode, InlinedBranchProfile)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                            }
                        }
                        if ((arg0Value.isMap(hostClassCache_))) {
                            node__ = (this);
                            if (this.hostClassCache == null) {
                                VarHandle.storeStoreFence();
                                this.hostClassCache = hostClassCache_;
                            }
                            state_4 = state_4 | 0x20000000 /* add SpecializationActive[HostObject.GetHashEntriesIterator.doMap(HostObject, Node, HostClassCache, ToGuestValueNode, InlinedBranchProfile)] */;
                            this.state_4_ = state_4;
                            return GetHashEntriesIterator.doMap(arg0Value, node__, hostClassCache_, INLINED_TO_GUEST, INLINED_ERROR);
                        }
                    }
                }
                if ((!(arg0Value.isNull()))) {
                    HostClassCache hostClassCache_1;
                    HostClassCache hostClassCache_1_shared = this.hostClassCache;
                    if (hostClassCache_1_shared != null) {
                        hostClassCache_1 = hostClassCache_1_shared;
                    } else {
                        hostClassCache_1 = (arg0Value.getHostClassCache());
                        if (hostClassCache_1 == null) {
                            throw new IllegalStateException("Specialization 'doNotMap(HostObject, HostClassCache)' contains a shared cache with name 'hostClassCache' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if ((!(arg0Value.isMap(hostClassCache_1)))) {
                        if (this.hostClassCache == null) {
                            VarHandle.storeStoreFence();
                            this.hostClassCache = hostClassCache_1;
                        }
                        state_4 = state_4 | 0x40000000 /* add SpecializationActive[HostObject.GetHashEntriesIterator.doNotMap(HostObject, HostClassCache)] */;
                        this.state_4_ = state_4;
                        return GetHashEntriesIterator.doNotMap(arg0Value, hostClassCache_1);
                    }
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @SuppressWarnings("static-method")
            private boolean isIdenticalOrUndefinedFallbackGuard_(int state_4, HostObject arg0Value, Object arg1Value) {
                if (!((state_4 & 0x80000000) != 0 /* is SpecializationActive[HostObject.IsIdenticalOrUndefined.doHostObject(HostObject, HostObject)] */) && arg1Value instanceof HostObject) {
                    return false;
                }
                return true;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsIdenticalOrUndefined#doHostObject}
             *     Activation probability: 0.00867
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsIdenticalOrUndefined#doOther}
             *     Activation probability: 0.00467
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            protected TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_4 = this.state_4_;
                int state_5 = this.state_5_;
                if (((state_4 & 0x80000000) != 0 /* is SpecializationActive[HostObject.IsIdenticalOrUndefined.doHostObject(HostObject, HostObject)] */ || (state_5 & 0b1) != 0 /* is SpecializationActive[HostObject.IsIdenticalOrUndefined.doOther(HostObject, Object)] */)) {
                    if ((state_4 & 0x80000000) != 0 /* is SpecializationActive[HostObject.IsIdenticalOrUndefined.doHostObject(HostObject, HostObject)] */ && arg1Value instanceof HostObject) {
                        HostObject arg1Value_ = (HostObject) arg1Value;
                        return IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                    }
                    if ((state_5 & 0b1) != 0 /* is SpecializationActive[HostObject.IsIdenticalOrUndefined.doOther(HostObject, Object)] */) {
                        if (isIdenticalOrUndefinedFallbackGuard_(state_4, arg0Value, arg1Value)) {
                            return IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isIdenticalOrUndefinedAndSpecialize(arg0Value, arg1Value);
            }

            private TriState isIdenticalOrUndefinedAndSpecialize(HostObject arg0Value, Object arg1Value) {
                int state_4 = this.state_4_;
                int state_5 = this.state_5_;
                if (arg1Value instanceof HostObject) {
                    HostObject arg1Value_ = (HostObject) arg1Value;
                    state_4 = state_4 | 0x80000000 /* add SpecializationActive[HostObject.IsIdenticalOrUndefined.doHostObject(HostObject, HostObject)] */;
                    this.state_4_ = state_4;
                    return IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                }
                state_5 = state_5 | 0b1 /* add SpecializationActive[HostObject.IsIdenticalOrUndefined.doOther(HostObject, Object)] */;
                this.state_5_ = state_5;
                return IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @Override
            public boolean hasMembers(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).hasMembers();
            }

            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).getMembers(includeInternal);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostObject#readMember(HostObject, String, Node, LookupFieldNode, ReadFieldNode, LookupMethodNode, LookupInnerClassNode, InlinedBranchProfile)}
             *     Activation probability: 0.01333
             *     With/without class size: 4/5 bytes
             * </pre>
             */
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                ReadMemberNode_ReadMemberData s0_ = this.readMemberNode__readMember_cache;
                if (s0_ != null) {
                    {
                        Node node__ = (s0_);
                        return arg0Value.readMember(arg1Value, node__, INLINED_READ_MEMBER_LOOKUP_FIELD, INLINED_READ_MEMBER_READ_FIELD, INLINED_READ_MEMBER_LOOKUP_METHOD, INLINED_READ_MEMBER_NODE__READ_MEMBER_LOOKUP_INNER_CLASS_, INLINED_READ_MEMBER_ERROR);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readMemberNode_AndSpecialize(HostObject arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                {
                    Node node__ = null;
                    ReadMemberNode_ReadMemberData s0_ = this.insert(new ReadMemberNode_ReadMemberData());
                    node__ = (s0_);
                    VarHandle.storeStoreFence();
                    this.readMemberNode__readMember_cache = s0_;
                    return arg0Value.readMember(arg1Value, node__, INLINED_READ_MEMBER_LOOKUP_FIELD, INLINED_READ_MEMBER_READ_FIELD, INLINED_READ_MEMBER_LOOKUP_METHOD, INLINED_READ_MEMBER_NODE__READ_MEMBER_LOOKUP_INNER_CLASS_, INLINED_READ_MEMBER_ERROR);
                }
            }

            @Override
            public boolean isMemberInsertable(Object receiver, String member) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).isMemberInsertable(member);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostObject#writeMember(HostObject, String, Object, Node, LookupFieldNode, WriteFieldNode, InlinedBranchProfile)}
             *     Activation probability: 0.01333
             *     With/without class size: 4/5 bytes
             * </pre>
             */
            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                WriteMemberNode_WriteMemberData s0_ = this.writeMemberNode__writeMember_cache;
                if (s0_ != null) {
                    {
                        Node node__ = (s0_);
                        arg0Value.writeMember(arg1Value, arg2Value, node__, INLINED_WRITE_MEMBER_LOOKUP_FIELD, INLINED_WRITE_MEMBER_NODE__WRITE_MEMBER_WRITE_FIELD_, INLINED_WRITE_MEMBER_ERROR);
                        return;
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeMemberNode_AndSpecialize(HostObject arg0Value, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                {
                    Node node__ = null;
                    WriteMemberNode_WriteMemberData s0_ = this.insert(new WriteMemberNode_WriteMemberData());
                    node__ = (s0_);
                    VarHandle.storeStoreFence();
                    this.writeMemberNode__writeMember_cache = s0_;
                    arg0Value.writeMember(arg1Value, arg2Value, node__, INLINED_WRITE_MEMBER_LOOKUP_FIELD, INLINED_WRITE_MEMBER_NODE__WRITE_MEMBER_WRITE_FIELD_, INLINED_WRITE_MEMBER_ERROR);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostObject#invokeMember(HostObject, String, Object[], Node, LookupMethodNode, HostExecuteNode, LookupFieldNode, ReadFieldNode, InteropLibrary, InlinedBranchProfile)}
             *     Activation probability: 0.01333
             *     With/without class size: 4/4 bytes
             * </pre>
             */
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_5 = this.state_5_;
                if ((state_5 & 0b10) != 0 /* is SpecializationActive[HostObject.invokeMember(HostObject, String, Object[], Node, LookupMethodNode, HostExecuteNode, LookupFieldNode, ReadFieldNode, InteropLibrary, InlinedBranchProfile)] */) {
                    {
                        InteropLibrary fieldValues__ = this.invokeMemberNode__invokeMember_fieldValues_;
                        if (fieldValues__ != null) {
                            Node node__ = (this);
                            return arg0Value.invokeMember(arg1Value, arg2Value, node__, INLINED_LOOKUP_METHOD, INLINED_HOST_EXECUTE, INLINED_LOOKUP_FIELD, INLINED_READ_FIELD, fieldValues__, INLINED_ERROR);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object invokeMemberNode_AndSpecialize(HostObject arg0Value, String arg1Value, Object[] arg2Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException, UnknownIdentifierException {
                int state_5 = this.state_5_;
                {
                    Node node__ = null;
                    node__ = (this);
                    InteropLibrary fieldValues__ = this.insert((INTEROP_LIBRARY_.createDispatched(5)));
                    Objects.requireNonNull(fieldValues__, "Specialization 'invokeMember(HostObject, String, Object[], Node, LookupMethodNode, HostExecuteNode, LookupFieldNode, ReadFieldNode, InteropLibrary, InlinedBranchProfile)' cache 'fieldValues' returned a 'null' default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns 'null'.");
                    VarHandle.storeStoreFence();
                    this.invokeMemberNode__invokeMember_fieldValues_ = fieldValues__;
                    state_5 = state_5 | 0b10 /* add SpecializationActive[HostObject.invokeMember(HostObject, String, Object[], Node, LookupMethodNode, HostExecuteNode, LookupFieldNode, ReadFieldNode, InteropLibrary, InlinedBranchProfile)] */;
                    this.state_5_ = state_5;
                    return arg0Value.invokeMember(arg1Value, arg2Value, node__, INLINED_LOOKUP_METHOD, INLINED_HOST_EXECUTE, INLINED_LOOKUP_FIELD, INLINED_READ_FIELD, fieldValues__, INLINED_ERROR);
                }
            }

            @Override
            public boolean isNull(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).isNull();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostObject#isExecutable(HostObject, Node, LookupFunctionalMethodNode)}
             *     Activation probability: 0.01333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isExecutable(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                {
                    Node node__ = (this);
                    return arg0Value.isExecutable(node__, INLINED_LOOKUP_FUNCTIONAL_METHOD);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostObject#execute(HostObject, Object[], Node, HostExecuteNode, LookupFunctionalMethodNode, InlinedBranchProfile)}
             *     Activation probability: 0.01333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                {
                    Node node__ = (this);
                    return arg0Value.execute(arg1Value, node__, INLINED_HOST_EXECUTE, INLINED_LOOKUP_FUNCTIONAL_METHOD, INLINED_ERROR);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostObject#isString(HostObject, Node, InlinedExactClassProfile)}
             *     Activation probability: 0.01333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isString(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                {
                    Node node__ = (this);
                    return arg0Value.isString(node__, INLINED_CLASS_PROFILE);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostObject#asString(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)}
             *     Activation probability: 0.01333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public String asString(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                int state_5 = this.state_5_;
                if ((state_5 & 0b100) != 0 /* is SpecializationActive[HostObject.asString(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */) {
                    {
                        InteropLibrary numbers_ = this.numbers;
                        if (numbers_ != null) {
                            Node node__ = (this);
                            InteropLibrary thisLibrary__ = (this);
                            return arg0Value.asString(node__, thisLibrary__, numbers_, INLINED_ERROR);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asStringNode_AndSpecialize(arg0Value);
            }

            private String asStringNode_AndSpecialize(HostObject arg0Value) throws UnsupportedMessageException {
                int state_5 = this.state_5_;
                {
                    InteropLibrary thisLibrary__ = null;
                    Node node__ = null;
                    node__ = (this);
                    thisLibrary__ = (this);
                    InteropLibrary numbers_;
                    InteropLibrary numbers__shared = this.numbers;
                    if (numbers__shared != null) {
                        numbers_ = numbers__shared;
                    } else {
                        numbers_ = this.insert((INTEROP_LIBRARY_.createDispatched(HostObject.LIMIT)));
                        if (numbers_ == null) {
                            throw new IllegalStateException("Specialization 'asString(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)' contains a shared cache with name 'strings' that returned a default value for the cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.numbers == null) {
                        VarHandle.storeStoreFence();
                        this.numbers = numbers_;
                    }
                    state_5 = state_5 | 0b100 /* add SpecializationActive[HostObject.asString(HostObject, Node, InteropLibrary, InteropLibrary, InlinedBranchProfile)] */;
                    this.state_5_ = state_5;
                    return arg0Value.asString(node__, thisLibrary__, numbers_, INLINED_ERROR);
                }
            }

            @Override
            public boolean isBoolean(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).isBoolean();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostObject#asBoolean(HostObject, Node, InlinedBranchProfile)}
             *     Activation probability: 0.01333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean asBoolean(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                {
                    Node node__ = (this);
                    return arg0Value.asBoolean(node__, INLINED_ERROR);
                }
            }

            @Override
            public boolean isDate(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).isDate();
            }

            @Override
            public LocalDate asDate(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).asDate();
            }

            @Override
            public boolean isTime(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).isTime();
            }

            @Override
            public LocalTime asTime(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).asTime();
            }

            @Override
            public boolean isTimeZone(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).isTimeZone();
            }

            @Override
            public ZoneId asTimeZone(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).asTimeZone();
            }

            @Override
            public Instant asInstant(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).asInstant();
            }

            @Override
            public boolean isDuration(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).isDuration();
            }

            @Override
            public Duration asDuration(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).asDuration();
            }

            @Override
            public boolean isException(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).isException();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostObject#getExceptionType(HostObject, Node, InlinedBranchProfile)}
             *     Activation probability: 0.01333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public ExceptionType getExceptionType(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                {
                    Node node__ = (this);
                    return arg0Value.getExceptionType(node__, INLINED_ERROR);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostObject#isExceptionIncompleteSource(HostObject, Node, InlinedBranchProfile)}
             *     Activation probability: 0.01333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isExceptionIncompleteSource(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                {
                    Node node__ = (this);
                    return arg0Value.isExceptionIncompleteSource(node__, INLINED_ERROR);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostObject#getExceptionExitStatus(HostObject, Node, InlinedBranchProfile)}
             *     Activation probability: 0.01333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public int getExceptionExitStatus(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                {
                    Node node__ = (this);
                    return arg0Value.getExceptionExitStatus(node__, INLINED_ERROR);
                }
            }

            @Override
            public boolean hasExceptionMessage(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).hasExceptionMessage();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostObject#getExceptionMessage(HostObject, Node, InlinedBranchProfile)}
             *     Activation probability: 0.01333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Object getExceptionMessage(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                {
                    Node node__ = (this);
                    return arg0Value.getExceptionMessage(node__, INLINED_ERROR);
                }
            }

            @Override
            public boolean hasExceptionCause(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).hasExceptionCause();
            }

            @Override
            public Object getExceptionCause(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).getExceptionCause();
            }

            @Override
            public boolean hasExceptionStackTrace(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).hasExceptionStackTrace();
            }

            @Override
            public Object getExceptionStackTrace(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).getExceptionStackTrace();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostObject#throwException(HostObject, Node, InlinedBranchProfile)}
             *     Activation probability: 0.01333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public RuntimeException throwException(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                {
                    Node node__ = (this);
                    return arg0Value.throwException(node__, INLINED_ERROR);
                }
            }

            @Override
            public boolean hasLanguage(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).hasLanguage();
            }

            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).getLanguage();
            }

            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).toDisplayString(allowSideEffects);
            }

            @Override
            public boolean hasMetaObject(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).hasMetaObject();
            }

            @Override
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).getMetaObject();
            }

            @Override
            public boolean isMetaObject(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).isMetaObject();
            }

            @Override
            public Object getMetaQualifiedName(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).getMetaQualifiedName();
            }

            @Override
            public Object getMetaSimpleName(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).getMetaSimpleName();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostObject#isMetaInstance(HostObject, Object, Node, InteropLibrary, InlinedBranchProfile)}
             *     Activation probability: 0.01333
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isMetaInstance(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostObject arg0Value = ((HostObject) arg0Value_);
                {
                    Node node__ = (this);
                    InteropLibrary library__ = (this);
                    return arg0Value.isMetaInstance(arg1Value, node__, library__, INLINED_ERROR);
                }
            }

            @Override
            public boolean hasMetaParents(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).hasMetaParents();
            }

            @Override
            public Object getMetaParents(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostObject) receiver)).getMetaParents();
            }

            @Override
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return HostObject.identityHashCode((((HostObject) receiver)));
            }

            @GeneratedBy(HostObject.class)
            @DenyReplace
            private static final class IsMemberReadableCachedData implements SpecializationDataNode {

                @CompilationFinal final IsMemberReadableCachedData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberReadable#doCached}
                 *   Parameter: boolean cachedStatic</pre>
                 */
                @CompilationFinal boolean cachedStatic_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberReadable#doCached}
                 *   Parameter: {@link Class} cachedClazz</pre>
                 */
                @CompilationFinal Class<?> cachedClazz_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberReadable#doCached}
                 *   Parameter: {@link String} cachedName</pre>
                 */
                @CompilationFinal String cachedName_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberReadable#doCached}
                 *   Parameter: boolean cachedReadable</pre>
                 */
                @CompilationFinal boolean cachedReadable_;

                IsMemberReadableCachedData(IsMemberReadableCachedData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(HostObject.class)
            @DenyReplace
            private static final class IsMemberModifiableCachedData implements SpecializationDataNode {

                @CompilationFinal final IsMemberModifiableCachedData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberModifiable#doCached}
                 *   Parameter: boolean cachedStatic</pre>
                 */
                @CompilationFinal boolean cachedStatic_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberModifiable#doCached}
                 *   Parameter: {@link Class} cachedClazz</pre>
                 */
                @CompilationFinal Class<?> cachedClazz_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberModifiable#doCached}
                 *   Parameter: {@link String} cachedName</pre>
                 */
                @CompilationFinal String cachedName_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberModifiable#doCached}
                 *   Parameter: boolean cachedModifiable</pre>
                 */
                @CompilationFinal boolean cachedModifiable_;

                IsMemberModifiableCachedData(IsMemberModifiableCachedData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(HostObject.class)
            @DenyReplace
            private static final class IsMemberInternalCachedData implements SpecializationDataNode {

                @CompilationFinal final IsMemberInternalCachedData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberInternal#doCached}
                 *   Parameter: boolean cachedStatic</pre>
                 */
                @CompilationFinal boolean cachedStatic_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberInternal#doCached}
                 *   Parameter: {@link Class} cachedClazz</pre>
                 */
                @CompilationFinal Class<?> cachedClazz_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberInternal#doCached}
                 *   Parameter: {@link String} cachedName</pre>
                 */
                @CompilationFinal String cachedName_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberInternal#doCached}
                 *   Parameter: boolean cachedInternal</pre>
                 */
                @CompilationFinal boolean cachedInternal_;

                IsMemberInternalCachedData(IsMemberInternalCachedData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(HostObject.class)
            @DenyReplace
            private static final class IsMemberInvocableCachedData implements SpecializationDataNode {

                @CompilationFinal final IsMemberInvocableCachedData next_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberInvocable#doCached}
                 *   Parameter: boolean cachedStatic</pre>
                 */
                @CompilationFinal boolean cachedStatic_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberInvocable#doCached}
                 *   Parameter: {@link Class} cachedClazz</pre>
                 */
                @CompilationFinal Class<?> cachedClazz_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberInvocable#doCached}
                 *   Parameter: {@link String} cachedName</pre>
                 */
                @CompilationFinal String cachedName_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link IsMemberInvocable#doCached}
                 *   Parameter: boolean cachedInvokable</pre>
                 */
                @CompilationFinal boolean cachedInvokable_;

                IsMemberInvocableCachedData(IsMemberInvocableCachedData next_) {
                    this.next_ = next_;
                }

            }
            @GeneratedBy(HostObject.class)
            @DenyReplace
            private static final class ReadMemberNode_ReadMemberData extends Node implements SpecializationDataNode {

                /**
                 * State Info: <pre>
                 *   0-1: InlinedCache
                 *        Specialization: {@link HostObject#readMember}
                 *        Parameter: {@link LookupInnerClassNode} lookupInnerClass
                 *        Inline method: {@link LookupInnerClassNodeGen#inline}
                 * </pre>
                 */
                @CompilationFinal @UnsafeAccessedField private int readMember_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link HostObject#readMember(HostObject, String, Node, LookupFieldNode, ReadFieldNode, LookupMethodNode, LookupInnerClassNode, InlinedBranchProfile)}
                 *   Parameter: {@link LookupInnerClassNode} lookupInnerClass
                 *   Inline method: {@link LookupInnerClassNodeGen#inline}
                 *   Inline field: {@link Object} field1</pre>
                 */
                @CompilationFinal @UnsafeAccessedField @SuppressWarnings("unused") private Object readMemberNode__readMember_lookupInnerClass__field1_;

                ReadMemberNode_ReadMemberData() {
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
            @GeneratedBy(HostObject.class)
            @DenyReplace
            private static final class WriteMemberNode_WriteMemberData extends Node implements SpecializationDataNode {

                /**
                 * State Info: <pre>
                 *   0-1: InlinedCache
                 *        Specialization: {@link HostObject#writeMember}
                 *        Parameter: {@link WriteFieldNode} writeField
                 *        Inline method: {@link WriteFieldNodeGen#inline}
                 * </pre>
                 */
                @CompilationFinal @UnsafeAccessedField private int writeMember_state_0_;
                /**
                 * Source Info: <pre>
                 *   Specialization: {@link HostObject#writeMember(HostObject, String, Object, Node, LookupFieldNode, WriteFieldNode, InlinedBranchProfile)}
                 *   Parameter: {@link WriteFieldNode} writeField
                 *   Inline method: {@link WriteFieldNodeGen#inline}
                 *   Inline field: {@link Node} field1</pre>
                 */
                @Child @UnsafeAccessedField @SuppressWarnings("unused") private Node writeMemberNode__writeMember_writeField__field1_;

                WriteMemberNode_WriteMemberData() {
                }

                @Override
                public NodeCost getCost() {
                    return NodeCost.NONE;
                }

                private static Lookup lookup_() {
                    return MethodHandles.lookup();
                }

            }
        }
        @GeneratedBy(HostObject.class)
        @DenyReplace
        private static final class Uncached extends InteropLibrary {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof HostObject) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof HostObject;
            }

            @Override
            public boolean isAdoptable() {
                return false;
            }

            @Override
            public NodeCost getCost() {
                return NodeCost.MEGAMORPHIC;
            }

            @TruffleBoundary
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return IsMemberReadable.doUncached(arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return IsMemberModifiable.doUncached(arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInternal(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return IsMemberInternal.doUncached(arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return IsMemberInvocable.doUncached(arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return IsArrayElementReadable.doNull(arg0Value, arg1Value);
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isArray((arg0Value.getHostClassCache())))) {
                    return IsArrayElementReadable.doArray(arg0Value, arg1Value, (arg0Value.getHostClassCache()));
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isList((arg0Value.getHostClassCache())))) {
                    return IsArrayElementReadable.doList(arg0Value, arg1Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()));
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isMapEntry((arg0Value.getHostClassCache())))) {
                    return IsArrayElementReadable.doMapEntry(arg0Value, arg1Value, (arg0Value.getHostClassCache()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isList((arg0Value.getHostClassCache())))) && (!(arg0Value.isArray((arg0Value.getHostClassCache())))) && (!(arg0Value.isMapEntry((arg0Value.getHostClassCache()))))) {
                    return IsArrayElementReadable.doNotArrayOrList(arg0Value, arg1Value, (arg0Value.getHostClassCache()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return IsArrayElementModifiable.doNull(arg0Value, arg1Value);
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isArray((arg0Value.getHostClassCache())))) {
                    return IsArrayElementModifiable.doArray(arg0Value, arg1Value, (arg0Value.getHostClassCache()));
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isList((arg0Value.getHostClassCache())))) {
                    return IsArrayElementModifiable.doList(arg0Value, arg1Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()));
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isMapEntry((arg0Value.getHostClassCache())))) {
                    return IsArrayElementModifiable.doMapEntry(arg0Value, arg1Value, (arg0Value.getHostClassCache()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isList((arg0Value.getHostClassCache())))) && (!(arg0Value.isArray((arg0Value.getHostClassCache())))) && (!(arg0Value.isMapEntry((arg0Value.getHostClassCache()))))) {
                    return IsArrayElementModifiable.doNotArrayOrList(arg0Value, arg1Value, (arg0Value.getHostClassCache()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return IsArrayElementInsertable.doNull(arg0Value, arg1Value);
                }
                if ((!(arg0Value.isNull()))) {
                    return IsArrayElementInsertable.doNonNull(arg0Value, arg1Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, InvalidArrayIndexException, UnsupportedTypeException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    WriteArrayElement.doNull(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isArray((arg0Value.getHostClassCache())))) {
                    WriteArrayElement.doArray(arg0Value, arg1Value, arg2Value, (this), (HostToTypeNodeGen.getUncached()), (arg0Value.getHostClassCache()), (ArraySetNodeGen.getUncached()), (InlinedBranchProfile.getUncached()));
                    return;
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isList((arg0Value.getHostClassCache())))) {
                    WriteArrayElement.doList(arg0Value, arg1Value, arg2Value, (this), (arg0Value.getHostClassCache()), (HostToTypeNodeGen.getUncached()), (InlinedBranchProfile.getUncached()));
                    return;
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isMapEntry((arg0Value.getHostClassCache())))) {
                    WriteArrayElement.doMapEntry(arg0Value, arg1Value, arg2Value, (this), (arg0Value.getHostClassCache()), (HostToTypeNodeGen.getUncached()), (InlinedBranchProfile.getUncached()));
                    return;
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isList((arg0Value.getHostClassCache())))) && (!(arg0Value.isArray((arg0Value.getHostClassCache())))) && (!(arg0Value.isMapEntry((arg0Value.getHostClassCache()))))) {
                    WriteArrayElement.doNotArrayOrList(arg0Value, arg1Value, arg2Value, (arg0Value.getHostClassCache()));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return IsArrayElementRemovable.doNull(arg0Value, arg1Value);
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isList((arg0Value.getHostClassCache())))) {
                    return IsArrayElementRemovable.doList(arg0Value, arg1Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isList((arg0Value.getHostClassCache()))))) {
                    return IsArrayElementRemovable.doOther(arg0Value, arg1Value, (arg0Value.getHostClassCache()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    RemoveArrayElement.doNull(arg0Value, arg1Value);
                    return;
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isList((arg0Value.getHostClassCache())))) {
                    RemoveArrayElement.doList(arg0Value, arg1Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()));
                    return;
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isList((arg0Value.getHostClassCache()))))) {
                    RemoveArrayElement.doOther(arg0Value, arg1Value, (arg0Value.getHostClassCache()));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean hasArrayElements(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return HasArrayElements.doNull(arg0Value);
                }
                if ((!(arg0Value.isNull()))) {
                    return HasArrayElements.doNotNull(arg0Value, (arg0Value.getHostClassCache()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return ReadArrayElement.doNull(arg0Value, arg1Value);
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isArray((arg0Value.getHostClassCache())))) {
                    return ReadArrayElement.doArray(arg0Value, arg1Value, (this), (ArrayGetNodeGen.getUncached()), (arg0Value.getHostClassCache()), (ToGuestValueNodeGen.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isList((arg0Value.getHostClassCache())))) {
                    return ReadArrayElement.doList(arg0Value, arg1Value, (this), (arg0Value.getHostClassCache()), (ToGuestValueNodeGen.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isMapEntry((arg0Value.getHostClassCache())))) {
                    return ReadArrayElement.doMapEntry(arg0Value, arg1Value, (this), (arg0Value.getHostClassCache()), (ToGuestValueNodeGen.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isArray((arg0Value.getHostClassCache())))) && (!(arg0Value.isList((arg0Value.getHostClassCache())))) && (!(arg0Value.isMapEntry((arg0Value.getHostClassCache()))))) {
                    return ReadArrayElement.doNotArrayOrList(arg0Value, arg1Value, (arg0Value.getHostClassCache()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return GetArraySize.doNull(arg0Value);
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isArray((arg0Value.getHostClassCache())))) {
                    return GetArraySize.doArray(arg0Value, (arg0Value.getHostClassCache()));
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isList((arg0Value.getHostClassCache())))) {
                    return GetArraySize.doList(arg0Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()));
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isMapEntry((arg0Value.getHostClassCache())))) {
                    return GetArraySize.doMapEntry(arg0Value, (arg0Value.getHostClassCache()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isArray((arg0Value.getHostClassCache())))) && (!(arg0Value.isList((arg0Value.getHostClassCache())))) && (!(arg0Value.isMapEntry((arg0Value.getHostClassCache()))))) {
                    return GetArraySize.doNotArrayOrList(arg0Value, (arg0Value.getHostClassCache()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public boolean hasBufferElements(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return HasBufferElements.doNull(arg0Value);
                }
                if ((!(arg0Value.isNull()))) {
                    return HasBufferElements.doNonNull(arg0Value, (arg0Value.getHostClassCache()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public boolean isBufferWritable(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return IsBufferWritable.doNull(arg0Value);
                }
                if ((!(arg0Value.isNull()))) {
                    return IsBufferWritable.doNonNull(arg0Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public long getBufferSize(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return GetBufferSize.doNull(arg0Value);
                }
                if ((!(arg0Value.isNull()))) {
                    return GetBufferSize.doNonNull(arg0Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public byte readBufferByte(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return ReadBufferByte.doNull(arg0Value, arg1Value);
                }
                if ((!(arg0Value.isNull()))) {
                    return ReadBufferByte.doNonNull(arg0Value, arg1Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()), (InlinedExactClassProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public void writeBufferByte(Object arg0Value_, long arg1Value, byte arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    WriteBufferByte.doNull(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if ((!(arg0Value.isNull()))) {
                    WriteBufferByte.doNonNull(arg0Value, arg1Value, arg2Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()), (InlinedExactClassProfile.getUncached()));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            @Override
            public short readBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return ReadBufferShort.doNull(arg0Value, arg1Value, arg2Value);
                }
                if ((!(arg0Value.isNull()))) {
                    return ReadBufferShort.doNonNull(arg0Value, arg1Value, arg2Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()), (InlinedExactClassProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            @Override
            public void writeBufferShort(Object arg0Value_, ByteOrder arg1Value, long arg2Value, short arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    WriteBufferShort.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
                if ((!(arg0Value.isNull()))) {
                    WriteBufferShort.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()), (InlinedExactClassProfile.getUncached()));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @TruffleBoundary
            @Override
            public int readBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return ReadBufferInt.doNull(arg0Value, arg1Value, arg2Value);
                }
                if ((!(arg0Value.isNull()))) {
                    return ReadBufferInt.doNonNull(arg0Value, arg1Value, arg2Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()), (InlinedExactClassProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            @Override
            public void writeBufferInt(Object arg0Value_, ByteOrder arg1Value, long arg2Value, int arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    WriteBufferInt.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
                if ((!(arg0Value.isNull()))) {
                    WriteBufferInt.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()), (InlinedExactClassProfile.getUncached()));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @TruffleBoundary
            @Override
            public long readBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return ReadBufferLong.doNull(arg0Value, arg1Value, arg2Value);
                }
                if ((!(arg0Value.isNull()))) {
                    return ReadBufferLong.doNonNull(arg0Value, arg1Value, arg2Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()), (InlinedExactClassProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            @Override
            public void writeBufferLong(Object arg0Value_, ByteOrder arg1Value, long arg2Value, long arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    WriteBufferLong.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
                if ((!(arg0Value.isNull()))) {
                    WriteBufferLong.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()), (InlinedExactClassProfile.getUncached()));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @TruffleBoundary
            @Override
            public float readBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return ReadBufferFloat.doNull(arg0Value, arg1Value, arg2Value);
                }
                if ((!(arg0Value.isNull()))) {
                    return ReadBufferFloat.doNonNull(arg0Value, arg1Value, arg2Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()), (InlinedExactClassProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            @Override
            public void writeBufferFloat(Object arg0Value_, ByteOrder arg1Value, long arg2Value, float arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    WriteBufferFloat.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
                if ((!(arg0Value.isNull()))) {
                    WriteBufferFloat.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()), (InlinedExactClassProfile.getUncached()));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @TruffleBoundary
            @Override
            public double readBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return ReadBufferDouble.doNull(arg0Value, arg1Value, arg2Value);
                }
                if ((!(arg0Value.isNull()))) {
                    return ReadBufferDouble.doNonNull(arg0Value, arg1Value, arg2Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()), (InlinedExactClassProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            @Override
            public void writeBufferDouble(Object arg0Value_, ByteOrder arg1Value, long arg2Value, double arg3Value) throws UnsupportedMessageException, InvalidBufferOffsetException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    WriteBufferDouble.doNull(arg0Value, arg1Value, arg2Value, arg3Value);
                    return;
                }
                if ((!(arg0Value.isNull()))) {
                    WriteBufferDouble.doNonNull(arg0Value, arg1Value, arg2Value, arg3Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()), (InlinedExactClassProfile.getUncached()));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null, null}, arg0Value, arg1Value, arg2Value, arg3Value);
            }

            @TruffleBoundary
            @Override
            public boolean isInstantiable(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((!(arg0Value.isClass()))) {
                    return IsInstantiable.doUnsupported(arg0Value);
                }
                if ((arg0Value.isArrayClass())) {
                    return IsInstantiable.doArrayCached(arg0Value);
                }
                if ((arg0Value.isDefaultClass())) {
                    return IsInstantiable.doObjectCached(arg0Value, (this), (LookupConstructorNodeGen.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public Object instantiate(Object arg0Value_, Object... arg1Value) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((!(arg0Value.isClass()))) {
                    return Instantiate.doUnsupported(arg0Value, arg1Value);
                }
                if ((arg0Value.isArrayClass())) {
                    return Instantiate.doArrayCached(arg0Value, arg1Value, (this), (INTEROP_LIBRARY_.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                if ((arg0Value.isDefaultClass())) {
                    return Instantiate.doObjectCached(arg0Value, arg1Value, (this), (LookupConstructorNodeGen.getUncached()), (HostExecuteNodeGen.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isNumber(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return IsNumber.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    return IsNumber.doBigInteger(arg0Value, (arg0Value.getHostClassCache()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                    return IsNumber.doOther(arg0Value, (this), (InlinedExactClassProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public boolean fitsInByte(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return FitsInByte.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    return FitsInByte.doBigInteger(arg0Value, (arg0Value.getHostClassCache()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                    return FitsInByte.doOther(arg0Value, (this), (INTEROP_LIBRARY_.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public boolean fitsInShort(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return FitsInShort.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    return FitsInShort.doBigInteger(arg0Value, (arg0Value.getHostClassCache()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                    return FitsInShort.doOther(arg0Value, (this), (INTEROP_LIBRARY_.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public boolean fitsInInt(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return FitsInInt.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    return FitsInInt.doBigInteger(arg0Value, (arg0Value.getHostClassCache()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                    return FitsInInt.doOther(arg0Value, (this), (INTEROP_LIBRARY_.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public boolean fitsInLong(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return FitsInLong.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    return FitsInLong.doBigInteger(arg0Value, (arg0Value.getHostClassCache()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                    return FitsInLong.doOther(arg0Value, (this), (INTEROP_LIBRARY_.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public boolean fitsInBigInteger(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return FitsInBigInteger.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    return FitsInBigInteger.doBigInteger(arg0Value, (arg0Value.getHostClassCache()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                    return FitsInBigInteger.doOther(arg0Value, (this), (INTEROP_LIBRARY_.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public boolean fitsInFloat(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return FitsInFloat.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    return FitsInFloat.doBigInteger(arg0Value, (arg0Value.getHostClassCache()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                    return FitsInFloat.doOther(arg0Value, (this), (INTEROP_LIBRARY_.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public boolean fitsInDouble(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return FitsInDouble.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    return FitsInDouble.doBigInteger(arg0Value, (arg0Value.getHostClassCache()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                    return FitsInDouble.doOther(arg0Value, (this), (INTEROP_LIBRARY_.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public byte asByte(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return AsByte.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    return AsByte.doBigInteger(arg0Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                    return AsByte.doOther(arg0Value, (this), (this), (INTEROP_LIBRARY_.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public short asShort(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return AsShort.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    return AsShort.doBigInteger(arg0Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                    return AsShort.doOther(arg0Value, (this), (this), (INTEROP_LIBRARY_.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public int asInt(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return AsInt.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    return AsInt.doBigInteger(arg0Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                    return AsInt.doOther(arg0Value, (this), (this), (INTEROP_LIBRARY_.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public long asLong(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return AsLong.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    return AsLong.doBigInteger(arg0Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                    return AsLong.doOther(arg0Value, (this), (this), (INTEROP_LIBRARY_.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public BigInteger asBigInteger(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return AsBigInteger.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    return AsBigInteger.doBigInteger(arg0Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                    return AsBigInteger.doOther(arg0Value, (this), (this), (INTEROP_LIBRARY_.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public float asFloat(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return AsFloat.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    return AsFloat.doBigInteger(arg0Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                    return AsFloat.doOther(arg0Value, (this), (this), (INTEROP_LIBRARY_.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public double asDouble(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return AsDouble.doNull(arg0Value);
                }
                if ((arg0Value.isBigInteger())) {
                    return AsDouble.doBigInteger(arg0Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isBigInteger()))) {
                    return AsDouble.doOther(arg0Value, (this), (this), (INTEROP_LIBRARY_.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public boolean hasIterator(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return HasIterator.doNull(arg0Value);
                }
                if ((!(arg0Value.isNull()))) {
                    return HasIterator.doNonNull(arg0Value, (arg0Value.getHostClassCache()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public Object getIterator(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return GetIterator.doNull(arg0Value);
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isArray((arg0Value.getHostClassCache())))) {
                    return GetIterator.doArray(arg0Value, (this), (arg0Value.getHostClassCache()), (ToGuestValueNodeGen.getUncached()));
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isIterable((arg0Value.getHostClassCache())))) {
                    return GetIterator.doIterable(arg0Value, (this), (arg0Value.getHostClassCache()), (ToGuestValueNodeGen.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isArray((arg0Value.getHostClassCache())))) && (!(arg0Value.isIterable((arg0Value.getHostClassCache()))))) {
                    return GetIterator.doNotArrayOrIterable(arg0Value, (arg0Value.getHostClassCache()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public boolean isIterator(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return IsIterator.doNull(arg0Value);
                }
                if ((!(arg0Value.isNull()))) {
                    return IsIterator.doNonNull(arg0Value, (arg0Value.getHostClassCache()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public boolean hasIteratorNextElement(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return HasIteratorNextElement.doNull(arg0Value);
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isIteratorLocal((arg0Value.getHostClassCache())))) {
                    return HasIteratorNextElement.doIterator(arg0Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isIteratorLocal((arg0Value.getHostClassCache()))))) {
                    return HasIteratorNextElement.doNotIterator(arg0Value, (arg0Value.getHostClassCache()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public Object getIteratorNextElement(Object arg0Value_) throws UnsupportedMessageException, StopIterationException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return GetIteratorNextElement.doNull(arg0Value);
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isIteratorLocal((arg0Value.getHostClassCache())))) {
                    return GetIteratorNextElement.doIterator(arg0Value, (this), (arg0Value.getHostClassCache()), (ToGuestValueNodeGen.getUncached()), (InlinedBranchProfile.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isIteratorLocal((arg0Value.getHostClassCache()))))) {
                    return GetIteratorNextElement.doNotIterator(arg0Value, (arg0Value.getHostClassCache()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public boolean hasHashEntries(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return HasHashEntries.doNull(arg0Value);
                }
                if ((!(arg0Value.isNull()))) {
                    return HasHashEntries.doNonNull(arg0Value, (arg0Value.getHostClassCache()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public long getHashSize(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return GetHashSize.doNull(arg0Value);
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isMap((arg0Value.getHostClassCache())))) {
                    return GetHashSize.doMap(arg0Value, (this), (arg0Value.getHostClassCache()), (InlinedBranchProfile.getUncached()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isMap((arg0Value.getHostClassCache()))))) {
                    return GetHashSize.doNotMap(arg0Value, (arg0Value.getHostClassCache()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public boolean isHashEntryReadable(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return IsHashEntryReadable.doNull(arg0Value, arg1Value);
                }
                if ((!(arg0Value.isNull()))) {
                    return IsHashEntryReadable.doNonNull(arg0Value, arg1Value, (this), (ContainsKeyNodeGen.getUncached()), (arg0Value.getHostClassCache()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isHashEntryModifiable(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return IsHashEntryReadable.doNull(arg0Value, arg1Value);
                }
                if ((!(arg0Value.isNull()))) {
                    return IsHashEntryReadable.doNonNull(arg0Value, arg1Value, (this), (ContainsKeyNodeGen.getUncached()), (arg0Value.getHostClassCache()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isHashEntryRemovable(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return IsHashEntryReadable.doNull(arg0Value, arg1Value);
                }
                if ((!(arg0Value.isNull()))) {
                    return IsHashEntryReadable.doNonNull(arg0Value, arg1Value, (this), (ContainsKeyNodeGen.getUncached()), (arg0Value.getHostClassCache()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public Object readHashValue(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return ReadHashValue.doNull(arg0Value, arg1Value);
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isMap((arg0Value.getHostClassCache())))) {
                    return ReadHashValue.doMap(arg0Value, arg1Value, (this), (arg0Value.getHostClassCache()), (HostToTypeNodeGen.getUncached()), (ToGuestValueNodeGen.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isMap((arg0Value.getHostClassCache()))))) {
                    return ReadHashValue.doNotMap(arg0Value, arg1Value, (arg0Value.getHostClassCache()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isHashEntryInsertable(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return IsHashEntryInsertable.doNull(arg0Value, arg1Value);
                }
                if ((!(arg0Value.isNull()))) {
                    return IsHashEntryInsertable.doNonNull(arg0Value, arg1Value, (this), (ContainsKeyNodeGen.getUncached()), (arg0Value.getHostClassCache()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public void writeHashEntry(Object arg0Value_, Object arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    WriteHashEntry.doNull(arg0Value, arg1Value, arg2Value);
                    return;
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isMap((arg0Value.getHostClassCache())))) {
                    WriteHashEntry.doMap(arg0Value, arg1Value, arg2Value, (this), (arg0Value.getHostClassCache()), (HostToTypeNodeGen.getUncached()), (InlinedBranchProfile.getUncached()));
                    return;
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isMap((arg0Value.getHostClassCache()))))) {
                    WriteHashEntry.doNotMap(arg0Value, arg1Value, arg2Value, (arg0Value.getHostClassCache()));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null, null}, arg0Value, arg1Value, arg2Value);
            }

            @TruffleBoundary
            @Override
            public void removeHashEntry(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    RemoveHashEntry.doNull(arg0Value, arg1Value);
                    return;
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isMap((arg0Value.getHostClassCache())))) {
                    RemoveHashEntry.doMap(arg0Value, arg1Value, (this), (arg0Value.getHostClassCache()), (HostToTypeNodeGen.getUncached()), (InlinedBranchProfile.getUncached()));
                    return;
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isMap((arg0Value.getHostClassCache()))))) {
                    RemoveHashEntry.doNotMap(arg0Value, arg1Value, (arg0Value.getHostClassCache()));
                    return;
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null, null}, arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public Object getHashEntriesIterator(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if ((arg0Value.isNull())) {
                    return GetHashEntriesIterator.doNull(arg0Value);
                }
                if ((!(arg0Value.isNull())) && (arg0Value.isMap((arg0Value.getHostClassCache())))) {
                    return GetHashEntriesIterator.doMap(arg0Value, (this), (arg0Value.getHostClassCache()), (ToGuestValueNodeGen.getUncached()), (InlinedBranchProfile.getUncached()));
                }
                if ((!(arg0Value.isNull())) && (!(arg0Value.isMap((arg0Value.getHostClassCache()))))) {
                    return GetHashEntriesIterator.doNotMap(arg0Value, (arg0Value.getHostClassCache()));
                }
                throw new UnsupportedSpecializationException(this, new Node[] {null}, arg0Value);
            }

            @TruffleBoundary
            @Override
            public TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                if (arg1Value instanceof HostObject) {
                    HostObject arg1Value_ = (HostObject) arg1Value;
                    return IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                }
                return IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .hasMembers();
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object receiver, boolean includeInternal) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .getMembers(includeInternal);
            }

            @TruffleBoundary
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.readMember(arg1Value, (this), (LookupFieldNodeGen.getUncached()), (ReadFieldNodeGen.getUncached()), (LookupMethodNodeGen.getUncached()), (LookupInnerClassNodeGen.getUncached()), (InlinedBranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInsertable(Object receiver, String member) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .isMemberInsertable(member);
            }

            @TruffleBoundary
            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                arg0Value.writeMember(arg1Value, arg2Value, (this), (LookupFieldNodeGen.getUncached()), (WriteFieldNodeGen.getUncached()), (InlinedBranchProfile.getUncached()));
                return;
            }

            @TruffleBoundary
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException, UnknownIdentifierException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.invokeMember(arg1Value, arg2Value, (this), (LookupMethodNodeGen.getUncached()), (HostExecuteNodeGen.getUncached()), (LookupFieldNodeGen.getUncached()), (ReadFieldNodeGen.getUncached()), (INTEROP_LIBRARY_.getUncached()), (InlinedBranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isNull(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .isNull();
            }

            @TruffleBoundary
            @Override
            public boolean isExecutable(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.isExecutable((this), (LookupFunctionalMethodNodeGen.getUncached()));
            }

            @TruffleBoundary
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedMessageException, UnsupportedTypeException, ArityException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.execute(arg1Value, (this), (HostExecuteNodeGen.getUncached()), (LookupFunctionalMethodNodeGen.getUncached()), (InlinedBranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isString(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.isString((this), (InlinedExactClassProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public String asString(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.asString((this), (this), (INTEROP_LIBRARY_.getUncached()), (InlinedBranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isBoolean(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .isBoolean();
            }

            @TruffleBoundary
            @Override
            public boolean asBoolean(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.asBoolean((this), (InlinedBranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isDate(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .isDate();
            }

            @TruffleBoundary
            @Override
            public LocalDate asDate(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .asDate();
            }

            @TruffleBoundary
            @Override
            public boolean isTime(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .isTime();
            }

            @TruffleBoundary
            @Override
            public LocalTime asTime(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .asTime();
            }

            @TruffleBoundary
            @Override
            public boolean isTimeZone(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .isTimeZone();
            }

            @TruffleBoundary
            @Override
            public ZoneId asTimeZone(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .asTimeZone();
            }

            @TruffleBoundary
            @Override
            public Instant asInstant(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .asInstant();
            }

            @TruffleBoundary
            @Override
            public boolean isDuration(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .isDuration();
            }

            @TruffleBoundary
            @Override
            public Duration asDuration(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .asDuration();
            }

            @TruffleBoundary
            @Override
            public boolean isException(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .isException();
            }

            @TruffleBoundary
            @Override
            public ExceptionType getExceptionType(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.getExceptionType((this), (InlinedBranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean isExceptionIncompleteSource(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.isExceptionIncompleteSource((this), (InlinedBranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public int getExceptionExitStatus(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.getExceptionExitStatus((this), (InlinedBranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean hasExceptionMessage(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .hasExceptionMessage();
            }

            @TruffleBoundary
            @Override
            public Object getExceptionMessage(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.getExceptionMessage((this), (InlinedBranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean hasExceptionCause(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .hasExceptionCause();
            }

            @TruffleBoundary
            @Override
            public Object getExceptionCause(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .getExceptionCause();
            }

            @TruffleBoundary
            @Override
            public boolean hasExceptionStackTrace(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .hasExceptionStackTrace();
            }

            @TruffleBoundary
            @Override
            public Object getExceptionStackTrace(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .getExceptionStackTrace();
            }

            @TruffleBoundary
            @Override
            public RuntimeException throwException(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.throwException((this), (InlinedBranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean hasLanguage(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .hasLanguage();
            }

            @TruffleBoundary
            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .getLanguage();
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .toDisplayString(allowSideEffects);
            }

            @TruffleBoundary
            @Override
            public boolean hasMetaObject(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .hasMetaObject();
            }

            @TruffleBoundary
            @Override
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .getMetaObject();
            }

            @TruffleBoundary
            @Override
            public boolean isMetaObject(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .isMetaObject();
            }

            @TruffleBoundary
            @Override
            public Object getMetaQualifiedName(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .getMetaQualifiedName();
            }

            @TruffleBoundary
            @Override
            public Object getMetaSimpleName(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .getMetaSimpleName();
            }

            @TruffleBoundary
            @Override
            public boolean isMetaInstance(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostObject arg0Value = ((HostObject) arg0Value_);
                return arg0Value.isMetaInstance(arg1Value, (this), (this), (InlinedBranchProfile.getUncached()));
            }

            @TruffleBoundary
            @Override
            public boolean hasMetaParents(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .hasMetaParents();
            }

            @TruffleBoundary
            @Override
            public Object getMetaParents(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostObject) receiver) .getMetaParents();
            }

            @TruffleBoundary
            @Override
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return HostObject.identityHashCode(((HostObject) receiver) );
            }

        }
    }
}
