// CheckStyle: start generated
package com.oracle.truffle.host;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.CompilerDirectives.CompilationFinal;
import com.oracle.truffle.api.CompilerDirectives.TruffleBoundary;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.InvalidArrayIndexException;
import com.oracle.truffle.api.interop.StopIterationException;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnknownKeyException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.interop.UnsupportedTypeException;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.utilities.TriState;
import com.oracle.truffle.host.HostProxy.IsIdenticalOrUndefined;
import java.lang.invoke.VarHandle;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;

@GeneratedBy(HostProxy.class)
@SuppressWarnings({"javadoc", "unused"})
final class HostProxyGen {

    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);
    private static final LibraryFactory<InteropLibrary> INTEROP_LIBRARY_ = LibraryFactory.resolve(InteropLibrary.class);

    static  {
        LibraryExport.register(HostProxy.class, new InteropLibraryExports());
    }

    private HostProxyGen() {
    }

    @GeneratedBy(HostProxy.class)
    private static final class InteropLibraryExports extends LibraryExport<InteropLibrary> {

        private InteropLibraryExports() {
            super(InteropLibrary.class, HostProxy.class, false, false, 0);
        }

        @Override
        protected InteropLibrary createUncached(Object receiver) {
            assert receiver instanceof HostProxy;
            InteropLibrary uncached = new Uncached();
            return uncached;
        }

        @Override
        protected InteropLibrary createCached(Object receiver) {
            assert receiver instanceof HostProxy;
            return new Cached();
        }

        @GeneratedBy(HostProxy.class)
        private static final class Cached extends InteropLibrary {

            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link IsIdenticalOrUndefined#doHostObject}
             *   1: SpecializationActive {@link IsIdenticalOrUndefined#doOther}
             *   2: SpecializationActive {@link HostProxy#isInstantiable(HostProxy, GuestToHostCodeCache)}
             *   3: SpecializationActive {@link HostProxy#instantiate(HostProxy, Object[], InteropLibrary, GuestToHostCodeCache)}
             *   4: SpecializationActive {@link HostProxy#isExecutable(HostProxy, GuestToHostCodeCache)}
             *   5: SpecializationActive {@link HostProxy#execute(HostProxy, Object[], InteropLibrary, GuestToHostCodeCache)}
             *   6: SpecializationActive {@link HostProxy#isPointer(HostProxy, GuestToHostCodeCache)}
             *   7: SpecializationActive {@link HostProxy#asPointer(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *   8: SpecializationActive {@link HostProxy#hasArrayElements(HostProxy, GuestToHostCodeCache)}
             *   9: SpecializationActive {@link HostProxy#readArrayElement(HostProxy, long, InteropLibrary, GuestToHostCodeCache)}
             *   10: SpecializationActive {@link HostProxy#writeArrayElement(HostProxy, long, Object, InteropLibrary, GuestToHostCodeCache)}
             *   11: SpecializationActive {@link HostProxy#removeArrayElement(HostProxy, long, InteropLibrary, GuestToHostCodeCache)}
             *   12: SpecializationActive {@link HostProxy#getArraySize(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *   13: SpecializationActive {@link HostProxy#isArrayElementExisting(HostProxy, long, InteropLibrary, GuestToHostCodeCache)}
             *   14: SpecializationActive {@link HostProxy#isArrayElementInsertable(HostProxy, long, InteropLibrary, GuestToHostCodeCache)}
             *   15: SpecializationActive {@link HostProxy#hasMembers(HostProxy, GuestToHostCodeCache)}
             *   16: SpecializationActive {@link HostProxy#getMembers(HostProxy, boolean, InteropLibrary, GuestToHostCodeCache)}
             *   17: SpecializationActive {@link HostProxy#readMember(HostProxy, String, InteropLibrary, GuestToHostCodeCache)}
             *   18: SpecializationActive {@link HostProxy#writeMember(HostProxy, String, Object, InteropLibrary, GuestToHostCodeCache)}
             *   19: SpecializationActive {@link HostProxy#invokeMember(HostProxy, String, Object[], InteropLibrary, InteropLibrary, GuestToHostCodeCache)}
             *   20: SpecializationActive {@link HostProxy#isMemberInvocable(HostProxy, String, InteropLibrary, InteropLibrary, GuestToHostCodeCache)}
             *   21: SpecializationActive {@link HostProxy#removeMember(HostProxy, String, InteropLibrary, GuestToHostCodeCache)}
             *   22: SpecializationActive {@link HostProxy#isMemberExisting(HostProxy, String, InteropLibrary, GuestToHostCodeCache)}
             *   23: SpecializationActive {@link HostProxy#isMemberInsertable(HostProxy, String, InteropLibrary, GuestToHostCodeCache)}
             *   24: SpecializationActive {@link HostProxy#isDate(HostProxy, GuestToHostCodeCache)}
             *   25: SpecializationActive {@link HostProxy#isTime(HostProxy, GuestToHostCodeCache)}
             *   26: SpecializationActive {@link HostProxy#isTimeZone(HostProxy, GuestToHostCodeCache)}
             *   27: SpecializationActive {@link HostProxy#asTimeZone(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *   28: SpecializationActive {@link HostProxy#asDate(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *   29: SpecializationActive {@link HostProxy#asTime(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *   30: SpecializationActive {@link HostProxy#asInstant(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *   31: SpecializationActive {@link HostProxy#isDuration(HostProxy, GuestToHostCodeCache)}
             * </pre>
             */
            @CompilationFinal private int state_0_;
            /**
             * State Info: <pre>
             *   0: SpecializationActive {@link HostProxy#asDuration(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *   1: SpecializationActive {@link HostProxy#hasIterator(HostProxy, GuestToHostCodeCache)}
             *   2: SpecializationActive {@link HostProxy#getIterator(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *   3: SpecializationActive {@link HostProxy#isIterator(HostProxy, GuestToHostCodeCache)}
             *   4: SpecializationActive {@link HostProxy#hasIteratorNextElement(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *   5: SpecializationActive {@link HostProxy#getIteratorNextElement(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *   6: SpecializationActive {@link HostProxy#hasHashEntries(HostProxy, GuestToHostCodeCache)}
             *   7: SpecializationActive {@link HostProxy#getHashSize(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *   8: SpecializationActive {@link HostProxy#isHashValueExisting(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)}
             *   9: SpecializationActive {@link HostProxy#readHashValue(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)}
             *   10: SpecializationActive {@link HostProxy#isHashEntryInsertable(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)}
             *   11: SpecializationActive {@link HostProxy#writeHashEntry(HostProxy, Object, Object, InteropLibrary, GuestToHostCodeCache)}
             *   12: SpecializationActive {@link HostProxy#removeHashEntry(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)}
             *   13: SpecializationActive {@link HostProxy#getHashEntriesIterator(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             * </pre>
             */
            @CompilationFinal private int state_1_;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HostProxy#isInstantiable}
             *   Parameter: {@link GuestToHostCodeCache} cache</pre>
             */
            @CompilationFinal private GuestToHostCodeCache cache;
            /**
             * Source Info: <pre>
             *   Specialization: {@link HostProxy#invokeMember}
             *   Parameter: {@link InteropLibrary} executables</pre>
             */
            @Child private InteropLibrary executables;

            protected Cached() {
            }

            @Override
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof HostProxy) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof HostProxy;
            }

            @SuppressWarnings("static-method")
            private boolean isIdenticalOrUndefinedFallbackGuard_(int state_0, HostProxy arg0Value, Object arg1Value) {
                if (!((state_0 & 0b1) != 0 /* is SpecializationActive[HostProxy.IsIdenticalOrUndefined.doHostObject(HostProxy, HostProxy)] */) && arg1Value instanceof HostProxy) {
                    return false;
                }
                return true;
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link IsIdenticalOrUndefined#doHostObject}
             *     Activation probability: 0.01275
             *     With/without class size: 4/0 bytes
             *   Specialization {@link IsIdenticalOrUndefined#doOther}
             *     Activation probability: 0.00686
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            protected TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b11) != 0 /* is SpecializationActive[HostProxy.IsIdenticalOrUndefined.doHostObject(HostProxy, HostProxy)] || SpecializationActive[HostProxy.IsIdenticalOrUndefined.doOther(HostProxy, Object)] */) {
                    if ((state_0 & 0b1) != 0 /* is SpecializationActive[HostProxy.IsIdenticalOrUndefined.doHostObject(HostProxy, HostProxy)] */ && arg1Value instanceof HostProxy) {
                        HostProxy arg1Value_ = (HostProxy) arg1Value;
                        return IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                    }
                    if ((state_0 & 0b10) != 0 /* is SpecializationActive[HostProxy.IsIdenticalOrUndefined.doOther(HostProxy, Object)] */) {
                        if (isIdenticalOrUndefinedFallbackGuard_(state_0, arg0Value, arg1Value)) {
                            return IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isIdenticalOrUndefinedAndSpecialize(arg0Value, arg1Value);
            }

            private TriState isIdenticalOrUndefinedAndSpecialize(HostProxy arg0Value, Object arg1Value) {
                int state_0 = this.state_0_;
                if (arg1Value instanceof HostProxy) {
                    HostProxy arg1Value_ = (HostProxy) arg1Value;
                    state_0 = state_0 | 0b1 /* add SpecializationActive[HostProxy.IsIdenticalOrUndefined.doHostObject(HostProxy, HostProxy)] */;
                    this.state_0_ = state_0;
                    return IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                }
                state_0 = state_0 | 0b10 /* add SpecializationActive[HostProxy.IsIdenticalOrUndefined.doOther(HostProxy, Object)] */;
                this.state_0_ = state_0;
                return IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#isInstantiable(HostProxy, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isInstantiable(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100) != 0 /* is SpecializationActive[HostProxy.isInstantiable(HostProxy, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            return arg0Value.isInstantiable(cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isInstantiableNode_AndSpecialize(arg0Value);
            }

            private boolean isInstantiableNode_AndSpecialize(HostProxy arg0Value) {
                int state_0 = this.state_0_;
                GuestToHostCodeCache cache_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = (arg0Value.context.getGuestToHostCache());
                    if (cache_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                state_0 = state_0 | 0b100 /* add SpecializationActive[HostProxy.isInstantiable(HostProxy, GuestToHostCodeCache)] */;
                this.state_0_ = state_0;
                return arg0Value.isInstantiable(cache_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#instantiate(HostProxy, Object[], InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Object instantiate(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000) != 0 /* is SpecializationActive[HostProxy.instantiate(HostProxy, Object[], InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.instantiate(arg1Value, library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return instantiateNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object instantiateNode_AndSpecialize(HostProxy arg0Value, Object[] arg1Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_0 = state_0 | 0b1000 /* add SpecializationActive[HostProxy.instantiate(HostProxy, Object[], InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_0_ = state_0;
                    return arg0Value.instantiate(arg1Value, library__, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#isExecutable(HostProxy, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isExecutable(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000) != 0 /* is SpecializationActive[HostProxy.isExecutable(HostProxy, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            return arg0Value.isExecutable(cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isExecutableNode_AndSpecialize(arg0Value);
            }

            private boolean isExecutableNode_AndSpecialize(HostProxy arg0Value) {
                int state_0 = this.state_0_;
                GuestToHostCodeCache cache_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = (arg0Value.context.getGuestToHostCache());
                    if (cache_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                state_0 = state_0 | 0b10000 /* add SpecializationActive[HostProxy.isExecutable(HostProxy, GuestToHostCodeCache)] */;
                this.state_0_ = state_0;
                return arg0Value.isExecutable(cache_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#execute(HostProxy, Object[], InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedTypeException, ArityException, UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000) != 0 /* is SpecializationActive[HostProxy.execute(HostProxy, Object[], InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.execute(arg1Value, library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return executeNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object executeNode_AndSpecialize(HostProxy arg0Value, Object[] arg1Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_0 = state_0 | 0b100000 /* add SpecializationActive[HostProxy.execute(HostProxy, Object[], InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_0_ = state_0;
                    return arg0Value.execute(arg1Value, library__, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#isPointer(HostProxy, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isPointer(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000) != 0 /* is SpecializationActive[HostProxy.isPointer(HostProxy, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            return arg0Value.isPointer(cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isPointerNode_AndSpecialize(arg0Value);
            }

            private boolean isPointerNode_AndSpecialize(HostProxy arg0Value) {
                int state_0 = this.state_0_;
                GuestToHostCodeCache cache_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = (arg0Value.context.getGuestToHostCache());
                    if (cache_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                state_0 = state_0 | 0b1000000 /* add SpecializationActive[HostProxy.isPointer(HostProxy, GuestToHostCodeCache)] */;
                this.state_0_ = state_0;
                return arg0Value.isPointer(cache_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#asPointer(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000) != 0 /* is SpecializationActive[HostProxy.asPointer(HostProxy, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.asPointer(library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asPointerNode_AndSpecialize(arg0Value);
            }

            private long asPointerNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_0 = state_0 | 0b10000000 /* add SpecializationActive[HostProxy.asPointer(HostProxy, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_0_ = state_0;
                    return arg0Value.asPointer(library__, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#hasArrayElements(HostProxy, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean hasArrayElements(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000000) != 0 /* is SpecializationActive[HostProxy.hasArrayElements(HostProxy, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            return arg0Value.hasArrayElements(cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasArrayElementsNode_AndSpecialize(arg0Value);
            }

            private boolean hasArrayElementsNode_AndSpecialize(HostProxy arg0Value) {
                int state_0 = this.state_0_;
                GuestToHostCodeCache cache_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = (arg0Value.context.getGuestToHostCache());
                    if (cache_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                state_0 = state_0 | 0b100000000 /* add SpecializationActive[HostProxy.hasArrayElements(HostProxy, GuestToHostCodeCache)] */;
                this.state_0_ = state_0;
                return arg0Value.hasArrayElements(cache_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#readArrayElement(HostProxy, long, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000000) != 0 /* is SpecializationActive[HostProxy.readArrayElement(HostProxy, long, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.readArrayElement(arg1Value, library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readArrayElementNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readArrayElementNode_AndSpecialize(HostProxy arg0Value, long arg1Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_0 = state_0 | 0b1000000000 /* add SpecializationActive[HostProxy.readArrayElement(HostProxy, long, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_0_ = state_0;
                    return arg0Value.readArrayElement(arg1Value, library__, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#writeArrayElement(HostProxy, long, Object, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, InvalidArrayIndexException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000000) != 0 /* is SpecializationActive[HostProxy.writeArrayElement(HostProxy, long, Object, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            arg0Value.writeArrayElement(arg1Value, arg2Value, library__, cache_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeArrayElementNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeArrayElementNode_AndSpecialize(HostProxy arg0Value, long arg1Value, Object arg2Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_0 = state_0 | 0b10000000000 /* add SpecializationActive[HostProxy.writeArrayElement(HostProxy, long, Object, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_0_ = state_0;
                    arg0Value.writeArrayElement(arg1Value, arg2Value, library__, cache_);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#removeArrayElement(HostProxy, long, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000000000) != 0 /* is SpecializationActive[HostProxy.removeArrayElement(HostProxy, long, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            arg0Value.removeArrayElement(arg1Value, library__, cache_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                removeArrayElementNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void removeArrayElementNode_AndSpecialize(HostProxy arg0Value, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                int state_0 = this.state_0_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_0 = state_0 | 0b100000000000 /* add SpecializationActive[HostProxy.removeArrayElement(HostProxy, long, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_0_ = state_0;
                    arg0Value.removeArrayElement(arg1Value, library__, cache_);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#getArraySize(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000000000) != 0 /* is SpecializationActive[HostProxy.getArraySize(HostProxy, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.getArraySize(library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getArraySizeNode_AndSpecialize(arg0Value);
            }

            private long getArraySizeNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_0 = state_0 | 0b1000000000000 /* add SpecializationActive[HostProxy.getArraySize(HostProxy, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_0_ = state_0;
                    return arg0Value.getArraySize(library__, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#isArrayElementExisting(HostProxy, long, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[HostProxy.isArrayElementExisting(HostProxy, long, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.isArrayElementExisting(arg1Value, library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isArrayElementExistingNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementExistingNode_AndSpecialize(HostProxy arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_0 = state_0 | 0b10000000000000 /* add SpecializationActive[HostProxy.isArrayElementExisting(HostProxy, long, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_0_ = state_0;
                    return arg0Value.isArrayElementExisting(arg1Value, library__, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#isArrayElementExisting(HostProxy, long, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[HostProxy.isArrayElementExisting(HostProxy, long, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.isArrayElementExisting(arg1Value, library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isArrayElementExistingNode_AndSpecialize(arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#isArrayElementExisting(HostProxy, long, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b10000000000000) != 0 /* is SpecializationActive[HostProxy.isArrayElementExisting(HostProxy, long, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.isArrayElementExisting(arg1Value, library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isArrayElementExistingNode_AndSpecialize(arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#isArrayElementInsertable(HostProxy, long, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b100000000000000) != 0 /* is SpecializationActive[HostProxy.isArrayElementInsertable(HostProxy, long, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.isArrayElementInsertable(arg1Value, library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isArrayElementInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isArrayElementInsertableNode_AndSpecialize(HostProxy arg0Value, long arg1Value) {
                int state_0 = this.state_0_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_0 = state_0 | 0b100000000000000 /* add SpecializationActive[HostProxy.isArrayElementInsertable(HostProxy, long, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_0_ = state_0;
                    return arg0Value.isArrayElementInsertable(arg1Value, library__, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#hasMembers(HostProxy, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean hasMembers(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0b1000000000000000) != 0 /* is SpecializationActive[HostProxy.hasMembers(HostProxy, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            return arg0Value.hasMembers(cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasMembersNode_AndSpecialize(arg0Value);
            }

            private boolean hasMembersNode_AndSpecialize(HostProxy arg0Value) {
                int state_0 = this.state_0_;
                GuestToHostCodeCache cache_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = (arg0Value.context.getGuestToHostCache());
                    if (cache_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                state_0 = state_0 | 0b1000000000000000 /* add SpecializationActive[HostProxy.hasMembers(HostProxy, GuestToHostCodeCache)] */;
                this.state_0_ = state_0;
                return arg0Value.hasMembers(cache_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#getMembers(HostProxy, boolean, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x10000) != 0 /* is SpecializationActive[HostProxy.getMembers(HostProxy, boolean, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.getMembers(arg1Value, library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getMembersNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object getMembersNode_AndSpecialize(HostProxy arg0Value, boolean arg1Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_0 = state_0 | 0x10000 /* add SpecializationActive[HostProxy.getMembers(HostProxy, boolean, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_0_ = state_0;
                    return arg0Value.getMembers(arg1Value, library__, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#readMember(HostProxy, String, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x20000) != 0 /* is SpecializationActive[HostProxy.readMember(HostProxy, String, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.readMember(arg1Value, library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readMemberNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readMemberNode_AndSpecialize(HostProxy arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                int state_0 = this.state_0_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_0 = state_0 | 0x20000 /* add SpecializationActive[HostProxy.readMember(HostProxy, String, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_0_ = state_0;
                    return arg0Value.readMember(arg1Value, library__, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#writeMember(HostProxy, String, Object, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x40000) != 0 /* is SpecializationActive[HostProxy.writeMember(HostProxy, String, Object, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            arg0Value.writeMember(arg1Value, arg2Value, library__, cache_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeMemberNode_AndSpecialize(HostProxy arg0Value, String arg1Value, Object arg2Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_0 = state_0 | 0x40000 /* add SpecializationActive[HostProxy.writeMember(HostProxy, String, Object, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_0_ = state_0;
                    arg0Value.writeMember(arg1Value, arg2Value, library__, cache_);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#invokeMember(HostProxy, String, Object[], InteropLibrary, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, ArityException, UnknownIdentifierException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x80000) != 0 /* is SpecializationActive[HostProxy.invokeMember(HostProxy, String, Object[], InteropLibrary, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        InteropLibrary executables_ = this.executables;
                        if (executables_ != null) {
                            GuestToHostCodeCache cache_ = this.cache;
                            if (cache_ != null) {
                                InteropLibrary library__ = (this);
                                return arg0Value.invokeMember(arg1Value, arg2Value, library__, executables_, cache_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return invokeMemberNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object invokeMemberNode_AndSpecialize(HostProxy arg0Value, String arg1Value, Object[] arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, ArityException, UnknownIdentifierException {
                int state_0 = this.state_0_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    InteropLibrary executables_;
                    InteropLibrary executables__shared = this.executables;
                    if (executables__shared != null) {
                        executables_ = executables__shared;
                    } else {
                        executables_ = this.insert((INTEROP_LIBRARY_.createDispatched(HostProxy.LIMIT)));
                        if (executables_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.executables == null) {
                        VarHandle.storeStoreFence();
                        this.executables = executables_;
                    }
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_0 = state_0 | 0x80000 /* add SpecializationActive[HostProxy.invokeMember(HostProxy, String, Object[], InteropLibrary, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_0_ = state_0;
                    return arg0Value.invokeMember(arg1Value, arg2Value, library__, executables_, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#isMemberInvocable(HostProxy, String, InteropLibrary, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x100000) != 0 /* is SpecializationActive[HostProxy.isMemberInvocable(HostProxy, String, InteropLibrary, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        InteropLibrary executables_ = this.executables;
                        if (executables_ != null) {
                            GuestToHostCodeCache cache_ = this.cache;
                            if (cache_ != null) {
                                InteropLibrary library__ = (this);
                                return arg0Value.isMemberInvocable(arg1Value, library__, executables_, cache_);
                            }
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberInvocableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInvocableNode_AndSpecialize(HostProxy arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    InteropLibrary executables_;
                    InteropLibrary executables__shared = this.executables;
                    if (executables__shared != null) {
                        executables_ = executables__shared;
                    } else {
                        executables_ = this.insert((INTEROP_LIBRARY_.createDispatched(HostProxy.LIMIT)));
                        if (executables_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.executables == null) {
                        VarHandle.storeStoreFence();
                        this.executables = executables_;
                    }
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_0 = state_0 | 0x100000 /* add SpecializationActive[HostProxy.isMemberInvocable(HostProxy, String, InteropLibrary, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_0_ = state_0;
                    return arg0Value.isMemberInvocable(arg1Value, library__, executables_, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#removeMember(HostProxy, String, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x200000) != 0 /* is SpecializationActive[HostProxy.removeMember(HostProxy, String, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            arg0Value.removeMember(arg1Value, library__, cache_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                removeMemberNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void removeMemberNode_AndSpecialize(HostProxy arg0Value, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                int state_0 = this.state_0_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_0 = state_0 | 0x200000 /* add SpecializationActive[HostProxy.removeMember(HostProxy, String, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_0_ = state_0;
                    arg0Value.removeMember(arg1Value, library__, cache_);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#isMemberExisting(HostProxy, String, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x400000) != 0 /* is SpecializationActive[HostProxy.isMemberExisting(HostProxy, String, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.isMemberExisting(arg1Value, library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberExistingNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberExistingNode_AndSpecialize(HostProxy arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_0 = state_0 | 0x400000 /* add SpecializationActive[HostProxy.isMemberExisting(HostProxy, String, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_0_ = state_0;
                    return arg0Value.isMemberExisting(arg1Value, library__, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#isMemberExisting(HostProxy, String, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x400000) != 0 /* is SpecializationActive[HostProxy.isMemberExisting(HostProxy, String, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.isMemberExisting(arg1Value, library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberExistingNode_AndSpecialize(arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#isMemberExisting(HostProxy, String, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x400000) != 0 /* is SpecializationActive[HostProxy.isMemberExisting(HostProxy, String, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.isMemberExisting(arg1Value, library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberExistingNode_AndSpecialize(arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#isMemberInsertable(HostProxy, String, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x800000) != 0 /* is SpecializationActive[HostProxy.isMemberInsertable(HostProxy, String, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.isMemberInsertable(arg1Value, library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isMemberInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isMemberInsertableNode_AndSpecialize(HostProxy arg0Value, String arg1Value) {
                int state_0 = this.state_0_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_0 = state_0 | 0x800000 /* add SpecializationActive[HostProxy.isMemberInsertable(HostProxy, String, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_0_ = state_0;
                    return arg0Value.isMemberInsertable(arg1Value, library__, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#isDate(HostProxy, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isDate(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x1000000) != 0 /* is SpecializationActive[HostProxy.isDate(HostProxy, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            return arg0Value.isDate(cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isDateNode_AndSpecialize(arg0Value);
            }

            private boolean isDateNode_AndSpecialize(HostProxy arg0Value) {
                int state_0 = this.state_0_;
                GuestToHostCodeCache cache_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = (arg0Value.context.getGuestToHostCache());
                    if (cache_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                state_0 = state_0 | 0x1000000 /* add SpecializationActive[HostProxy.isDate(HostProxy, GuestToHostCodeCache)] */;
                this.state_0_ = state_0;
                return arg0Value.isDate(cache_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#isTime(HostProxy, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isTime(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x2000000) != 0 /* is SpecializationActive[HostProxy.isTime(HostProxy, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            return arg0Value.isTime(cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isTimeNode_AndSpecialize(arg0Value);
            }

            private boolean isTimeNode_AndSpecialize(HostProxy arg0Value) {
                int state_0 = this.state_0_;
                GuestToHostCodeCache cache_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = (arg0Value.context.getGuestToHostCache());
                    if (cache_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                state_0 = state_0 | 0x2000000 /* add SpecializationActive[HostProxy.isTime(HostProxy, GuestToHostCodeCache)] */;
                this.state_0_ = state_0;
                return arg0Value.isTime(cache_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#isTimeZone(HostProxy, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isTimeZone(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x4000000) != 0 /* is SpecializationActive[HostProxy.isTimeZone(HostProxy, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            return arg0Value.isTimeZone(cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isTimeZoneNode_AndSpecialize(arg0Value);
            }

            private boolean isTimeZoneNode_AndSpecialize(HostProxy arg0Value) {
                int state_0 = this.state_0_;
                GuestToHostCodeCache cache_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = (arg0Value.context.getGuestToHostCache());
                    if (cache_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                state_0 = state_0 | 0x4000000 /* add SpecializationActive[HostProxy.isTimeZone(HostProxy, GuestToHostCodeCache)] */;
                this.state_0_ = state_0;
                return arg0Value.isTimeZone(cache_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#asTimeZone(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public ZoneId asTimeZone(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x8000000) != 0 /* is SpecializationActive[HostProxy.asTimeZone(HostProxy, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.asTimeZone(library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asTimeZoneNode_AndSpecialize(arg0Value);
            }

            private ZoneId asTimeZoneNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_0 = state_0 | 0x8000000 /* add SpecializationActive[HostProxy.asTimeZone(HostProxy, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_0_ = state_0;
                    return arg0Value.asTimeZone(library__, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#asDate(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public LocalDate asDate(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x10000000) != 0 /* is SpecializationActive[HostProxy.asDate(HostProxy, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.asDate(library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asDateNode_AndSpecialize(arg0Value);
            }

            private LocalDate asDateNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_0 = state_0 | 0x10000000 /* add SpecializationActive[HostProxy.asDate(HostProxy, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_0_ = state_0;
                    return arg0Value.asDate(library__, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#asTime(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public LocalTime asTime(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x20000000) != 0 /* is SpecializationActive[HostProxy.asTime(HostProxy, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.asTime(library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asTimeNode_AndSpecialize(arg0Value);
            }

            private LocalTime asTimeNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_0 = state_0 | 0x20000000 /* add SpecializationActive[HostProxy.asTime(HostProxy, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_0_ = state_0;
                    return arg0Value.asTime(library__, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#asInstant(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Instant asInstant(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x40000000) != 0 /* is SpecializationActive[HostProxy.asInstant(HostProxy, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.asInstant(library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asInstantNode_AndSpecialize(arg0Value);
            }

            private Instant asInstantNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                int state_0 = this.state_0_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_0 = state_0 | 0x40000000 /* add SpecializationActive[HostProxy.asInstant(HostProxy, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_0_ = state_0;
                    return arg0Value.asInstant(library__, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#isDuration(HostProxy, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isDuration(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_0 = this.state_0_;
                if ((state_0 & 0x80000000) != 0 /* is SpecializationActive[HostProxy.isDuration(HostProxy, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            return arg0Value.isDuration(cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isDurationNode_AndSpecialize(arg0Value);
            }

            private boolean isDurationNode_AndSpecialize(HostProxy arg0Value) {
                int state_0 = this.state_0_;
                GuestToHostCodeCache cache_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = (arg0Value.context.getGuestToHostCache());
                    if (cache_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                state_0 = state_0 | 0x80000000 /* add SpecializationActive[HostProxy.isDuration(HostProxy, GuestToHostCodeCache)] */;
                this.state_0_ = state_0;
                return arg0Value.isDuration(cache_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#asDuration(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Duration asDuration(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0b1) != 0 /* is SpecializationActive[HostProxy.asDuration(HostProxy, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.asDuration(library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return asDurationNode_AndSpecialize(arg0Value);
            }

            private Duration asDurationNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                int state_1 = this.state_1_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_1 = state_1 | 0b1 /* add SpecializationActive[HostProxy.asDuration(HostProxy, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_1_ = state_1;
                    return arg0Value.asDuration(library__, cache_);
                }
            }

            @Override
            public boolean hasLanguage(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostProxy) receiver)).hasLanguage();
            }

            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostProxy) receiver)).getLanguage();
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostProxy) receiver)).toDisplayString(allowSideEffects);
            }

            @Override
            public boolean hasMetaObject(Object receiver) {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostProxy) receiver)).hasMetaObject();
            }

            @Override
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return (((HostProxy) receiver)).getMetaObject();
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#hasIterator(HostProxy, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean hasIterator(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0b10) != 0 /* is SpecializationActive[HostProxy.hasIterator(HostProxy, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            return arg0Value.hasIterator(cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasIteratorNode_AndSpecialize(arg0Value);
            }

            private boolean hasIteratorNode_AndSpecialize(HostProxy arg0Value) {
                int state_1 = this.state_1_;
                GuestToHostCodeCache cache_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = (arg0Value.context.getGuestToHostCache());
                    if (cache_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                state_1 = state_1 | 0b10 /* add SpecializationActive[HostProxy.hasIterator(HostProxy, GuestToHostCodeCache)] */;
                this.state_1_ = state_1;
                return arg0Value.hasIterator(cache_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#getIterator(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Object getIterator(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0b100) != 0 /* is SpecializationActive[HostProxy.getIterator(HostProxy, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.getIterator(library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getIteratorNode_AndSpecialize(arg0Value);
            }

            private Object getIteratorNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                int state_1 = this.state_1_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_1 = state_1 | 0b100 /* add SpecializationActive[HostProxy.getIterator(HostProxy, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_1_ = state_1;
                    return arg0Value.getIterator(library__, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#isIterator(HostProxy, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isIterator(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0b1000) != 0 /* is SpecializationActive[HostProxy.isIterator(HostProxy, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            return arg0Value.isIterator(cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isIteratorNode_AndSpecialize(arg0Value);
            }

            private boolean isIteratorNode_AndSpecialize(HostProxy arg0Value) {
                int state_1 = this.state_1_;
                GuestToHostCodeCache cache_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = (arg0Value.context.getGuestToHostCache());
                    if (cache_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                state_1 = state_1 | 0b1000 /* add SpecializationActive[HostProxy.isIterator(HostProxy, GuestToHostCodeCache)] */;
                this.state_1_ = state_1;
                return arg0Value.isIterator(cache_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#hasIteratorNextElement(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean hasIteratorNextElement(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0b10000) != 0 /* is SpecializationActive[HostProxy.hasIteratorNextElement(HostProxy, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.hasIteratorNextElement(library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasIteratorNextElementNode_AndSpecialize(arg0Value);
            }

            private boolean hasIteratorNextElementNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                int state_1 = this.state_1_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_1 = state_1 | 0b10000 /* add SpecializationActive[HostProxy.hasIteratorNextElement(HostProxy, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_1_ = state_1;
                    return arg0Value.hasIteratorNextElement(library__, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#getIteratorNextElement(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Object getIteratorNextElement(Object arg0Value_) throws UnsupportedMessageException, StopIterationException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0b100000) != 0 /* is SpecializationActive[HostProxy.getIteratorNextElement(HostProxy, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.getIteratorNextElement(library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getIteratorNextElementNode_AndSpecialize(arg0Value);
            }

            private Object getIteratorNextElementNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                int state_1 = this.state_1_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_1 = state_1 | 0b100000 /* add SpecializationActive[HostProxy.getIteratorNextElement(HostProxy, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_1_ = state_1;
                    return arg0Value.getIteratorNextElement(library__, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#hasHashEntries(HostProxy, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean hasHashEntries(Object arg0Value_) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0b1000000) != 0 /* is SpecializationActive[HostProxy.hasHashEntries(HostProxy, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            return arg0Value.hasHashEntries(cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return hasHashEntriesNode_AndSpecialize(arg0Value);
            }

            private boolean hasHashEntriesNode_AndSpecialize(HostProxy arg0Value) {
                int state_1 = this.state_1_;
                GuestToHostCodeCache cache_;
                GuestToHostCodeCache cache__shared = this.cache;
                if (cache__shared != null) {
                    cache_ = cache__shared;
                } else {
                    cache_ = (arg0Value.context.getGuestToHostCache());
                    if (cache_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.cache == null) {
                    VarHandle.storeStoreFence();
                    this.cache = cache_;
                }
                state_1 = state_1 | 0b1000000 /* add SpecializationActive[HostProxy.hasHashEntries(HostProxy, GuestToHostCodeCache)] */;
                this.state_1_ = state_1;
                return arg0Value.hasHashEntries(cache_);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#getHashSize(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public long getHashSize(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0b10000000) != 0 /* is SpecializationActive[HostProxy.getHashSize(HostProxy, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.getHashSize(library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getHashSizeNode_AndSpecialize(arg0Value);
            }

            private long getHashSizeNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                int state_1 = this.state_1_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_1 = state_1 | 0b10000000 /* add SpecializationActive[HostProxy.getHashSize(HostProxy, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_1_ = state_1;
                    return arg0Value.getHashSize(library__, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#isHashValueExisting(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isHashEntryReadable(Object arg0Value_, Object arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0b100000000) != 0 /* is SpecializationActive[HostProxy.isHashValueExisting(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.isHashValueExisting(arg1Value, library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isHashValueExistingNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isHashValueExistingNode_AndSpecialize(HostProxy arg0Value, Object arg1Value) {
                int state_1 = this.state_1_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_1 = state_1 | 0b100000000 /* add SpecializationActive[HostProxy.isHashValueExisting(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_1_ = state_1;
                    return arg0Value.isHashValueExisting(arg1Value, library__, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#isHashValueExisting(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isHashEntryModifiable(Object arg0Value_, Object arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0b100000000) != 0 /* is SpecializationActive[HostProxy.isHashValueExisting(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.isHashValueExisting(arg1Value, library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isHashValueExistingNode_AndSpecialize(arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#isHashValueExisting(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isHashEntryRemovable(Object arg0Value_, Object arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0b100000000) != 0 /* is SpecializationActive[HostProxy.isHashValueExisting(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.isHashValueExisting(arg1Value, library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isHashValueExistingNode_AndSpecialize(arg0Value, arg1Value);
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#readHashValue(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Object readHashValue(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0b1000000000) != 0 /* is SpecializationActive[HostProxy.readHashValue(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.readHashValue(arg1Value, library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return readHashValueNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readHashValueNode_AndSpecialize(HostProxy arg0Value, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                int state_1 = this.state_1_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_1 = state_1 | 0b1000000000 /* add SpecializationActive[HostProxy.readHashValue(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_1_ = state_1;
                    return arg0Value.readHashValue(arg1Value, library__, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#isHashEntryInsertable(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public boolean isHashEntryInsertable(Object arg0Value_, Object arg1Value) {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0b10000000000) != 0 /* is SpecializationActive[HostProxy.isHashEntryInsertable(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.isHashEntryInsertable(arg1Value, library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return isHashEntryInsertableNode_AndSpecialize(arg0Value, arg1Value);
            }

            private boolean isHashEntryInsertableNode_AndSpecialize(HostProxy arg0Value, Object arg1Value) {
                int state_1 = this.state_1_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_1 = state_1 | 0b10000000000 /* add SpecializationActive[HostProxy.isHashEntryInsertable(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_1_ = state_1;
                    return arg0Value.isHashEntryInsertable(arg1Value, library__, cache_);
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#writeHashEntry(HostProxy, Object, Object, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void writeHashEntry(Object arg0Value_, Object arg1Value, Object arg2Value) throws UnsupportedMessageException, UnknownKeyException, UnsupportedTypeException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0b100000000000) != 0 /* is SpecializationActive[HostProxy.writeHashEntry(HostProxy, Object, Object, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            arg0Value.writeHashEntry(arg1Value, arg2Value, library__, cache_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                writeHashEntryNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
                return;
            }

            private void writeHashEntryNode_AndSpecialize(HostProxy arg0Value, Object arg1Value, Object arg2Value) throws UnsupportedMessageException {
                int state_1 = this.state_1_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_1 = state_1 | 0b100000000000 /* add SpecializationActive[HostProxy.writeHashEntry(HostProxy, Object, Object, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_1_ = state_1;
                    arg0Value.writeHashEntry(arg1Value, arg2Value, library__, cache_);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#removeHashEntry(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public void removeHashEntry(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0b1000000000000) != 0 /* is SpecializationActive[HostProxy.removeHashEntry(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            arg0Value.removeHashEntry(arg1Value, library__, cache_);
                            return;
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                removeHashEntryNode_AndSpecialize(arg0Value, arg1Value);
                return;
            }

            private void removeHashEntryNode_AndSpecialize(HostProxy arg0Value, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                int state_1 = this.state_1_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_1 = state_1 | 0b1000000000000 /* add SpecializationActive[HostProxy.removeHashEntry(HostProxy, Object, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_1_ = state_1;
                    arg0Value.removeHashEntry(arg1Value, library__, cache_);
                    return;
                }
            }

            /**
             * Debug Info: <pre>
             *   Specialization {@link HostProxy#getHashEntriesIterator(HostProxy, InteropLibrary, GuestToHostCodeCache)}
             *     Activation probability: 0.01961
             *     With/without class size: 4/0 bytes
             * </pre>
             */
            @Override
            public Object getHashEntriesIterator(Object arg0Value_) throws UnsupportedMessageException {
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                int state_1 = this.state_1_;
                if ((state_1 & 0b10000000000000) != 0 /* is SpecializationActive[HostProxy.getHashEntriesIterator(HostProxy, InteropLibrary, GuestToHostCodeCache)] */) {
                    {
                        GuestToHostCodeCache cache_ = this.cache;
                        if (cache_ != null) {
                            InteropLibrary library__ = (this);
                            return arg0Value.getHashEntriesIterator(library__, cache_);
                        }
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return getHashEntriesIteratorNode_AndSpecialize(arg0Value);
            }

            private Object getHashEntriesIteratorNode_AndSpecialize(HostProxy arg0Value) throws UnsupportedMessageException {
                int state_1 = this.state_1_;
                {
                    InteropLibrary library__ = null;
                    library__ = (this);
                    GuestToHostCodeCache cache_;
                    GuestToHostCodeCache cache__shared = this.cache;
                    if (cache__shared != null) {
                        cache_ = cache__shared;
                    } else {
                        cache_ = (arg0Value.context.getGuestToHostCache());
                        if (cache_ == null) {
                            throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                        }
                    }
                    if (this.cache == null) {
                        VarHandle.storeStoreFence();
                        this.cache = cache_;
                    }
                    state_1 = state_1 | 0b10000000000000 /* add SpecializationActive[HostProxy.getHashEntriesIterator(HostProxy, InteropLibrary, GuestToHostCodeCache)] */;
                    this.state_1_ = state_1;
                    return arg0Value.getHashEntriesIterator(library__, cache_);
                }
            }

            @TruffleBoundary
            @Override
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                assert assertAdopted();
                return HostProxy.identityHashCode((((HostProxy) receiver)));
            }

        }
        @GeneratedBy(HostProxy.class)
        @DenyReplace
        private static final class Uncached extends InteropLibrary implements UnadoptableNode {

            protected Uncached() {
            }

            @Override
            @TruffleBoundary
            public boolean accepts(Object receiver) {
                assert !(receiver instanceof HostProxy) || DYNAMIC_DISPATCH_LIBRARY_.getUncached().dispatch(receiver) == null : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof HostProxy;
            }

            @TruffleBoundary
            @Override
            public TriState isIdenticalOrUndefined(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                if (arg1Value instanceof HostProxy) {
                    HostProxy arg1Value_ = (HostProxy) arg1Value;
                    return IsIdenticalOrUndefined.doHostObject(arg0Value, arg1Value_);
                }
                return IsIdenticalOrUndefined.doOther(arg0Value, arg1Value);
            }

            @TruffleBoundary
            @Override
            public boolean isInstantiable(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.isInstantiable((arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public Object instantiate(Object arg0Value_, Object... arg1Value) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.instantiate(arg1Value, (this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean isExecutable(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.isExecutable((arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public Object execute(Object arg0Value_, Object... arg1Value) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.execute(arg1Value, (this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean isPointer(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.isPointer((arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public long asPointer(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.asPointer((this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean hasArrayElements(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.hasArrayElements((arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public Object readArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.readArrayElement(arg1Value, (this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public void writeArrayElement(Object arg0Value_, long arg1Value, Object arg2Value) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                arg0Value.writeArrayElement(arg1Value, arg2Value, (this), (arg0Value.context.getGuestToHostCache()));
                return;
            }

            @TruffleBoundary
            @Override
            public void removeArrayElement(Object arg0Value_, long arg1Value) throws UnsupportedMessageException, InvalidArrayIndexException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                arg0Value.removeArrayElement(arg1Value, (this), (arg0Value.context.getGuestToHostCache()));
                return;
            }

            @TruffleBoundary
            @Override
            public long getArraySize(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.getArraySize((this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementReadable(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.isArrayElementExisting(arg1Value, (this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementModifiable(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.isArrayElementExisting(arg1Value, (this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementRemovable(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.isArrayElementExisting(arg1Value, (this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean isArrayElementInsertable(Object arg0Value_, long arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.isArrayElementInsertable(arg1Value, (this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean hasMembers(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.hasMembers((arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public Object getMembers(Object arg0Value_, boolean arg1Value) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.getMembers(arg1Value, (this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public Object readMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.readMember(arg1Value, (this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public void writeMember(Object arg0Value_, String arg1Value, Object arg2Value) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                arg0Value.writeMember(arg1Value, arg2Value, (this), (arg0Value.context.getGuestToHostCache()));
                return;
            }

            @TruffleBoundary
            @Override
            public Object invokeMember(Object arg0Value_, String arg1Value, Object... arg2Value) throws UnsupportedMessageException, UnsupportedTypeException, ArityException, UnknownIdentifierException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.invokeMember(arg1Value, arg2Value, (this), (INTEROP_LIBRARY_.getUncached()), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInvocable(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.isMemberInvocable(arg1Value, (this), (INTEROP_LIBRARY_.getUncached()), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public void removeMember(Object arg0Value_, String arg1Value) throws UnsupportedMessageException, UnknownIdentifierException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                arg0Value.removeMember(arg1Value, (this), (arg0Value.context.getGuestToHostCache()));
                return;
            }

            @TruffleBoundary
            @Override
            public boolean isMemberReadable(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.isMemberExisting(arg1Value, (this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberModifiable(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.isMemberExisting(arg1Value, (this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberRemovable(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.isMemberExisting(arg1Value, (this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean isMemberInsertable(Object arg0Value_, String arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.isMemberInsertable(arg1Value, (this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean isDate(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.isDate((arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean isTime(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.isTime((arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean isTimeZone(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.isTimeZone((arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public ZoneId asTimeZone(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.asTimeZone((this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public LocalDate asDate(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.asDate((this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public LocalTime asTime(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.asTime((this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public Instant asInstant(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.asInstant((this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean isDuration(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.isDuration((arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public Duration asDuration(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.asDuration((this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean hasLanguage(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostProxy) receiver) .hasLanguage();
            }

            @TruffleBoundary
            @Override
            public Class<? extends TruffleLanguage<?>> getLanguage(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostProxy) receiver) .getLanguage();
            }

            @TruffleBoundary
            @Override
            public Object toDisplayString(Object receiver, boolean allowSideEffects) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostProxy) receiver) .toDisplayString(allowSideEffects);
            }

            @TruffleBoundary
            @Override
            public boolean hasMetaObject(Object receiver) {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostProxy) receiver) .hasMetaObject();
            }

            @TruffleBoundary
            @Override
            public Object getMetaObject(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return ((HostProxy) receiver) .getMetaObject();
            }

            @TruffleBoundary
            @Override
            public boolean hasIterator(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.hasIterator((arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public Object getIterator(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.getIterator((this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean isIterator(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.isIterator((arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean hasIteratorNextElement(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.hasIteratorNextElement((this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public Object getIteratorNextElement(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.getIteratorNextElement((this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean hasHashEntries(Object arg0Value_) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.hasHashEntries((arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public long getHashSize(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.getHashSize((this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean isHashEntryReadable(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.isHashValueExisting(arg1Value, (this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean isHashEntryModifiable(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.isHashValueExisting(arg1Value, (this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean isHashEntryRemovable(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.isHashValueExisting(arg1Value, (this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public Object readHashValue(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.readHashValue(arg1Value, (this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public boolean isHashEntryInsertable(Object arg0Value_, Object arg1Value) {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.isHashEntryInsertable(arg1Value, (this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public void writeHashEntry(Object arg0Value_, Object arg1Value, Object arg2Value) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                arg0Value.writeHashEntry(arg1Value, arg2Value, (this), (arg0Value.context.getGuestToHostCache()));
                return;
            }

            @TruffleBoundary
            @Override
            public void removeHashEntry(Object arg0Value_, Object arg1Value) throws UnsupportedMessageException, UnknownKeyException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                arg0Value.removeHashEntry(arg1Value, (this), (arg0Value.context.getGuestToHostCache()));
                return;
            }

            @TruffleBoundary
            @Override
            public Object getHashEntriesIterator(Object arg0Value_) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(arg0Value_) : "Invalid library usage. Library does not accept given receiver.";
                HostProxy arg0Value = ((HostProxy) arg0Value_);
                return arg0Value.getHashEntriesIterator((this), (arg0Value.context.getGuestToHostCache()));
            }

            @TruffleBoundary
            @Override
            public int identityHashCode(Object receiver) throws UnsupportedMessageException {
                // declared: true
                assert this.accepts(receiver) : "Invalid library usage. Library does not accept given receiver.";
                return HostProxy.identityHashCode(((HostProxy) receiver) );
            }

        }
    }
}
