/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.query.dsl.impl;

import org.hibernate.search.analyzer.spi.ScopedAnalyzerReference;
import org.hibernate.search.engine.integration.impl.ExtendedSearchIntegrator;
import org.hibernate.search.engine.spi.DocumentBuilderIndexedEntity;
import org.hibernate.search.engine.spi.EntityIndexBinding;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.spi.IndexedTypeIdentifier;

public class QueryBuildingContext {
    private final ExtendedSearchIntegrator factory;
    private final DocumentBuilderIndexedEntity documentBuilder;
    private final ScopedAnalyzerReference originalAnalyzerReference;
    private final ScopedAnalyzerReference queryAnalyzerReference;
    private final IndexedTypeIdentifier entityType;

    public QueryBuildingContext(ExtendedSearchIntegrator factory, ScopedAnalyzerReference originalAnalyzerReference, ScopedAnalyzerReference queryAnalyzerReference, IndexedTypeIdentifier indexBoundType) {
        this.factory = factory;
        this.originalAnalyzerReference = originalAnalyzerReference;
        this.queryAnalyzerReference = queryAnalyzerReference;
        this.entityType = indexBoundType;
        EntityIndexBinding indexBinding = factory.getIndexBinding(indexBoundType);
        if (indexBinding == null) {
            throw new AssertionFailure("Class is not indexed: " + indexBoundType);
        }
        this.documentBuilder = indexBinding.getDocumentBuilder();
    }

    public ExtendedSearchIntegrator getExtendedSearchIntegrator() {
        return this.factory;
    }

    public DocumentBuilderIndexedEntity getDocumentBuilder() {
        return this.documentBuilder;
    }

    public ScopedAnalyzerReference getOriginalAnalyzerReference() {
        return this.originalAnalyzerReference;
    }

    public ScopedAnalyzerReference getQueryAnalyzerReference() {
        return this.queryAnalyzerReference;
    }

    public IndexedTypeIdentifier getEntityType() {
        return this.entityType;
    }
}

