/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.analyzer.definition.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.Map;
import java.util.TreeMap;
import org.hibernate.search.analyzer.definition.impl.LuceneAnalysisDefinitionRegistry;
import org.hibernate.search.annotations.AnalyzerDef;
import org.hibernate.search.annotations.NormalizerDef;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

public class SimpleLuceneAnalysisDefinitionRegistry
implements LuceneAnalysisDefinitionRegistry {
    private static final Log log = LoggerFactory.make(MethodHandles.lookup());
    private final Map<String, AnalyzerDef> analyzerDefinitions = new TreeMap<String, AnalyzerDef>();
    private final Map<String, NormalizerDef> normalizerDefinitions = new TreeMap<String, NormalizerDef>();

    public SimpleLuceneAnalysisDefinitionRegistry() {
    }

    public SimpleLuceneAnalysisDefinitionRegistry(Map<String, AnalyzerDef> analyzerDefinitions, Map<String, NormalizerDef> normalizerDefinitions) {
        this.analyzerDefinitions.putAll(analyzerDefinitions);
        this.normalizerDefinitions.putAll(normalizerDefinitions);
    }

    @Override
    public void register(String name, AnalyzerDef definition) {
        AnalyzerDef previous = this.analyzerDefinitions.putIfAbsent(name, definition);
        if (previous != null && previous != definition) {
            throw log.analyzerDefinitionNamingConflict(name);
        }
    }

    @Override
    public void register(String name, NormalizerDef definition) {
        NormalizerDef previous = this.normalizerDefinitions.putIfAbsent(name, definition);
        if (previous != null && previous != definition) {
            throw log.normalizerDefinitionNamingConflict(name);
        }
    }

    @Override
    public AnalyzerDef getAnalyzerDefinition(String name) {
        return this.analyzerDefinitions.get(name);
    }

    @Override
    public NormalizerDef getNormalizerDefinition(String name) {
        return this.normalizerDefinitions.get(name);
    }

    public Map<String, AnalyzerDef> getAnalyzerDefinitions() {
        return Collections.unmodifiableMap(this.analyzerDefinitions);
    }

    public Map<String, NormalizerDef> getNormalizerDefinitions() {
        return Collections.unmodifiableMap(this.normalizerDefinitions);
    }
}

