/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial;

import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.hibernate.search.bridge.LuceneOptions;
import org.hibernate.search.bridge.spi.FieldMetadataBuilder;
import org.hibernate.search.bridge.spi.FieldType;
import org.hibernate.search.spatial.SpatialFieldBridge;
import org.hibernate.search.spatial.impl.SpatialNumericDocValueField;

public class SpatialFieldBridgeByRange
extends SpatialFieldBridge {
    public SpatialFieldBridgeByRange() {
    }

    public SpatialFieldBridgeByRange(String latitudeField, String longitudeField) {
        super(latitudeField, longitudeField);
    }

    @Override
    public void configureFieldMetadata(String name, FieldMetadataBuilder builder) {
        super.configureFieldMetadata(name, builder);
        builder.field(this.latitudeIndexedFieldName, FieldType.DOUBLE);
        builder.field(this.longitudeIndexedFieldName, FieldType.DOUBLE);
    }

    @Override
    public void set(String name, Object value, Document document, LuceneOptions luceneOptions) {
        if (value != null) {
            Double latitude = this.getLatitude(value);
            Double longitude = this.getLongitude(value);
            if (latitude != null && longitude != null) {
                luceneOptions.addNumericFieldToDocument(this.latitudeIndexedFieldName, latitude, document);
                luceneOptions.addNumericFieldToDocument(this.longitudeIndexedFieldName, longitude, document);
                SpatialNumericDocValueField latitudeDocValuesField = new SpatialNumericDocValueField(this.latitudeIndexedFieldName, latitude);
                document.add((IndexableField)latitudeDocValuesField);
                SpatialNumericDocValueField longitudeDocValuesField = new SpatialNumericDocValueField(this.longitudeIndexedFieldName, longitude);
                document.add((IndexableField)longitudeDocValuesField);
            }
        }
    }
}

