/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spatial.impl;

import java.io.IOException;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.search.SimpleFieldComparator;
import org.apache.lucene.util.Bits;
import org.hibernate.search.spatial.impl.CoordinateHelper;
import org.hibernate.search.spatial.impl.Point;
import org.hibernate.search.spatial.impl.SpatialHelper;

public final class DistanceComparator
extends SimpleFieldComparator<Double> {
    private final Point center;
    private final String latitudeField;
    private final String longitudeField;
    private double[] distances;
    private Bits docsWithLatitude;
    private Bits docsWithLongitude;
    private NumericDocValues latitudeValues;
    private NumericDocValues longitudeValues;
    private Double bottomDistance;
    private Double topValue;

    public DistanceComparator(Point center, int numHits, String fieldName) {
        this.center = center;
        this.distances = new double[numHits];
        this.latitudeField = SpatialHelper.formatLatitude(fieldName);
        this.longitudeField = SpatialHelper.formatLongitude(fieldName);
    }

    public int compare(int slot1, int slot2) {
        return Double.compare(this.distances[slot1], this.distances[slot2]);
    }

    public void setBottom(int slot) {
        this.bottomDistance = this.distances[slot];
    }

    public void setTopValue(Double value) {
        this.topValue = value;
    }

    public int compareBottom(int doc) throws IOException {
        return Double.compare(this.bottomDistance, this.distanceTo(doc));
    }

    private double distanceTo(int doc) {
        if (this.docsWithLatitude.get(doc) && this.docsWithLongitude.get(doc)) {
            return this.center.getDistanceTo(CoordinateHelper.coordinate(this.latitudeValues, doc), CoordinateHelper.coordinate(this.longitudeValues, doc));
        }
        return Double.MAX_VALUE;
    }

    public int compareTop(int doc) throws IOException {
        if (this.topValue == null) {
            return 1;
        }
        double distanceTo = this.distanceTo(doc);
        return Double.compare(distanceTo, this.topValue);
    }

    public void copy(int slot, int doc) throws IOException {
        this.distances[slot] = this.distanceTo(doc);
    }

    public void doSetNextReader(LeafReaderContext context) throws IOException {
        LeafReader atomicReader = context.reader();
        this.docsWithLatitude = DocValues.getDocsWithField((LeafReader)atomicReader, (String)this.latitudeField);
        this.docsWithLongitude = DocValues.getDocsWithField((LeafReader)atomicReader, (String)this.longitudeField);
        this.latitudeValues = DocValues.getNumeric((LeafReader)atomicReader, (String)this.latitudeField);
        this.longitudeValues = DocValues.getNumeric((LeafReader)atomicReader, (String)this.longitudeField);
    }

    public Double value(int slot) {
        return this.distances[slot];
    }
}

