/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.dsl.embedded.impl;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.infinispan.encoding.DataConversion;
import org.infinispan.factories.annotations.Inject;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.marshall.core.EncoderRegistry;
import org.infinispan.notifications.Listener;
import org.infinispan.notifications.cachelistener.CacheEntryListenerInvocation;
import org.infinispan.notifications.cachelistener.CacheNotifier;
import org.infinispan.notifications.cachelistener.CacheNotifierImpl;
import org.infinispan.notifications.cachelistener.EventWrapper;
import org.infinispan.notifications.cachelistener.annotation.CacheEntriesEvicted;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryActivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryCreated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryExpired;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryInvalidated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryLoaded;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryModified;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryPassivated;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryRemoved;
import org.infinispan.notifications.cachelistener.annotation.CacheEntryVisited;
import org.infinispan.notifications.cachelistener.event.CacheEntryEvent;
import org.infinispan.notifications.cachelistener.event.Event;
import org.infinispan.notifications.cachelistener.event.impl.EventImpl;
import org.infinispan.notifications.cachelistener.filter.CacheEventConverter;
import org.infinispan.notifications.cachelistener.filter.CacheEventFilter;
import org.infinispan.notifications.cachelistener.filter.DelegatingCacheEntryListenerInvocation;
import org.infinispan.notifications.cachelistener.filter.FilterIndexingServiceProvider;
import org.infinispan.notifications.cachelistener.filter.IndexedFilter;
import org.infinispan.objectfilter.FilterCallback;
import org.infinispan.objectfilter.FilterSubscription;
import org.infinispan.objectfilter.Matcher;

public abstract class BaseJPAFilterIndexingServiceProvider
implements FilterIndexingServiceProvider {
    private final ConcurrentMap<Matcher, FilteringListenerInvocation<?, ?>> filteringInvocations = new ConcurrentHashMap(4);
    private CacheNotifierImpl cacheNotifier;
    private ClusteringDependentLogic clusteringDependentLogic;

    @Inject
    protected void injectDependencies(CacheNotifier cacheNotifier, ClusteringDependentLogic clusteringDependentLogic, EncoderRegistry encoderRegistry) {
        this.cacheNotifier = (CacheNotifierImpl)cacheNotifier;
        this.clusteringDependentLogic = clusteringDependentLogic;
    }

    public void start() {
    }

    public void stop() {
        Collection invocations = this.filteringInvocations.values();
        this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryActivated.class).removeAll(invocations);
        this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryCreated.class).removeAll(invocations);
        this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryInvalidated.class).removeAll(invocations);
        this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryLoaded.class).removeAll(invocations);
        this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryModified.class).removeAll(invocations);
        this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryPassivated.class).removeAll(invocations);
        this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryRemoved.class).removeAll(invocations);
        this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryVisited.class).removeAll(invocations);
        this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntriesEvicted.class).removeAll(invocations);
        this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryExpired.class).removeAll(invocations);
        this.filteringInvocations.clear();
    }

    public <K, V> DelegatingCacheEntryListenerInvocation<K, V> interceptListenerInvocation(CacheEntryListenerInvocation<K, V> invocation) {
        return new DelegatingCacheEntryListenerInvocationImpl<K, V>(invocation);
    }

    public <K, V> void registerListenerInvocations(boolean isClustered, boolean isPrimaryOnly, boolean filterAndConvert, IndexedFilter<?, ?, ?> indexedFilter, Map<Class<? extends Annotation>, List<DelegatingCacheEntryListenerInvocation<K, V>>> listeners, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        Matcher matcher = this.getMatcher(indexedFilter);
        String queryString = this.getQueryString(indexedFilter);
        Map<String, Object> namedParameters = this.getNamedParameters(indexedFilter);
        boolean isDeltaFilter = this.isDelta(indexedFilter);
        this.addFilteringInvocationForMatcher(matcher, keyDataConversion, valueDataConversion);
        Object[] eventTypes = new Event.Type[listeners.keySet().size()];
        int i = 0;
        for (Class<? extends Annotation> annotation : listeners.keySet()) {
            eventTypes[i++] = this.getEventTypeFromAnnotation(annotation);
        }
        Callback<K, V> callback = new Callback<K, V>(matcher, isClustered, isPrimaryOnly, filterAndConvert, listeners);
        callback.subscription = matcher.registerFilter(queryString, namedParameters, callback, isDeltaFilter, eventTypes);
    }

    private Event.Type getEventTypeFromAnnotation(Class<? extends Annotation> annotation) {
        if (annotation == CacheEntryCreated.class) {
            return Event.Type.CACHE_ENTRY_CREATED;
        }
        if (annotation == CacheEntryModified.class) {
            return Event.Type.CACHE_ENTRY_MODIFIED;
        }
        if (annotation == CacheEntryRemoved.class) {
            return Event.Type.CACHE_ENTRY_REMOVED;
        }
        if (annotation == CacheEntryActivated.class) {
            return Event.Type.CACHE_ENTRY_ACTIVATED;
        }
        if (annotation == CacheEntryInvalidated.class) {
            return Event.Type.CACHE_ENTRY_INVALIDATED;
        }
        if (annotation == CacheEntryLoaded.class) {
            return Event.Type.CACHE_ENTRY_LOADED;
        }
        if (annotation == CacheEntryPassivated.class) {
            return Event.Type.CACHE_ENTRY_PASSIVATED;
        }
        if (annotation == CacheEntryVisited.class) {
            return Event.Type.CACHE_ENTRY_VISITED;
        }
        if (annotation == CacheEntriesEvicted.class) {
            return Event.Type.CACHE_ENTRY_EVICTED;
        }
        if (annotation == CacheEntryExpired.class) {
            return Event.Type.CACHE_ENTRY_EXPIRED;
        }
        return null;
    }

    private void addFilteringInvocationForMatcher(Matcher matcher, DataConversion keyDataConversion, DataConversion valueDataConversion) {
        FilteringListenerInvocation filteringInvocation;
        if (!this.filteringInvocations.containsKey(matcher) && this.filteringInvocations.putIfAbsent(matcher, filteringInvocation = new FilteringListenerInvocation(matcher, keyDataConversion, valueDataConversion)) == null) {
            this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryActivated.class).add(filteringInvocation);
            this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryCreated.class).add(filteringInvocation);
            this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryInvalidated.class).add(filteringInvocation);
            this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryLoaded.class).add(filteringInvocation);
            this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryModified.class).add(filteringInvocation);
            this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryPassivated.class).add(filteringInvocation);
            this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryRemoved.class).add(filteringInvocation);
            this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryVisited.class).add(filteringInvocation);
            this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntriesEvicted.class).add(filteringInvocation);
            this.cacheNotifier.getListenerCollectionForAnnotation(CacheEntryExpired.class).add(filteringInvocation);
        }
    }

    protected abstract Matcher getMatcher(IndexedFilter<?, ?, ?> var1);

    protected abstract String getQueryString(IndexedFilter<?, ?, ?> var1);

    protected abstract Map<String, Object> getNamedParameters(IndexedFilter<?, ?, ?> var1);

    protected abstract boolean isDelta(IndexedFilter<?, ?, ?> var1);

    protected abstract <K, V> void matchEvent(EventWrapper<K, V, CacheEntryEvent<K, V>> var1, Matcher var2);

    protected abstract Object makeFilterResult(Object var1, Object var2, Object var3, Object var4, Object[] var5, Comparable[] var6);

    private class FilteringListenerInvocation<K, V>
    implements CacheEntryListenerInvocation<K, V> {
        private final Matcher matcher;
        private final DataConversion keyDataConversion;
        private final DataConversion valueDataConversion;

        private FilteringListenerInvocation(Matcher matcher, DataConversion keyDataConversion, DataConversion valueDataConversion) {
            this.matcher = matcher;
            this.keyDataConversion = keyDataConversion;
            this.valueDataConversion = valueDataConversion;
        }

        public Object getTarget() {
            return BaseJPAFilterIndexingServiceProvider.this;
        }

        public void invoke(Event<K, V> event) {
        }

        public void invoke(EventWrapper<K, V, CacheEntryEvent<K, V>> event, boolean isLocalNodePrimaryOwner) {
            BaseJPAFilterIndexingServiceProvider.this.matchEvent(event, this.matcher);
        }

        public void invokeNoChecks(EventWrapper<K, V, CacheEntryEvent<K, V>> event, boolean skipQueue, boolean skipConverter, boolean needsConvert) {
        }

        public boolean isClustered() {
            return false;
        }

        public boolean isSync() {
            return true;
        }

        public UUID getIdentifier() {
            return null;
        }

        public Listener.Observation getObservation() {
            return Listener.Observation.BOTH;
        }

        public Class<? extends Annotation> getAnnotation() {
            return null;
        }

        public CacheEventFilter<? super K, ? super V> getFilter() {
            return null;
        }

        public <C> CacheEventConverter<? super K, ? super V, C> getConverter() {
            return null;
        }

        public Set<Class<? extends Annotation>> getFilterAnnotations() {
            return null;
        }

        public DataConversion getKeyDataConversion() {
            return this.keyDataConversion;
        }

        public DataConversion getValueDataConversion() {
            return this.valueDataConversion;
        }

        public boolean useStorageFormat() {
            return true;
        }
    }

    private class DelegatingCacheEntryListenerInvocationImpl<K, V>
    extends DelegatingCacheEntryListenerInvocation<K, V> {
        protected Callback<K, V> callback;

        DelegatingCacheEntryListenerInvocationImpl(CacheEntryListenerInvocation<K, V> invocation) {
            super(invocation);
        }

        public void unregister() {
            if (this.callback != null) {
                this.callback.unregister();
            }
        }
    }

    private class Callback<K, V>
    implements FilterCallback {
        private final boolean isClustered;
        private final boolean isPrimaryOnly;
        private final boolean filterAndConvert;
        private final DelegatingCacheEntryListenerInvocation<K, V>[] activated_invocations;
        private final DelegatingCacheEntryListenerInvocation<K, V>[] created_invocations;
        private final DelegatingCacheEntryListenerInvocation<K, V>[] invalidated_invocations;
        private final DelegatingCacheEntryListenerInvocation<K, V>[] loaded_invocations;
        private final DelegatingCacheEntryListenerInvocation<K, V>[] modified_invocations;
        private final DelegatingCacheEntryListenerInvocation<K, V>[] passivated_invocations;
        private final DelegatingCacheEntryListenerInvocation<K, V>[] removed_invocations;
        private final DelegatingCacheEntryListenerInvocation<K, V>[] visited_invocations;
        private final DelegatingCacheEntryListenerInvocation<K, V>[] evicted_invocations;
        private final DelegatingCacheEntryListenerInvocation<K, V>[] expired_invocations;
        private final Matcher matcher;
        protected volatile FilterSubscription subscription;

        Callback(Matcher matcher, boolean isClustered, boolean isPrimaryOnly, boolean filterAndConvert, Map<Class<? extends Annotation>, List<DelegatingCacheEntryListenerInvocation<K, V>>> listeners) {
            this.matcher = matcher;
            this.isClustered = isClustered;
            this.isPrimaryOnly = isPrimaryOnly;
            this.filterAndConvert = filterAndConvert;
            this.activated_invocations = this.makeArray(listeners, CacheEntryActivated.class);
            this.created_invocations = this.makeArray(listeners, CacheEntryCreated.class);
            this.invalidated_invocations = this.makeArray(listeners, CacheEntryInvalidated.class);
            this.loaded_invocations = this.makeArray(listeners, CacheEntryLoaded.class);
            this.modified_invocations = this.makeArray(listeners, CacheEntryModified.class);
            this.passivated_invocations = this.makeArray(listeners, CacheEntryPassivated.class);
            this.removed_invocations = this.makeArray(listeners, CacheEntryRemoved.class);
            this.visited_invocations = this.makeArray(listeners, CacheEntryVisited.class);
            this.evicted_invocations = this.makeArray(listeners, CacheEntriesEvicted.class);
            this.expired_invocations = this.makeArray(listeners, CacheEntryExpired.class);
        }

        private DelegatingCacheEntryListenerInvocation<K, V>[] makeArray(Map<Class<? extends Annotation>, List<DelegatingCacheEntryListenerInvocation<K, V>>> listeners, Class<? extends Annotation> eventType) {
            DelegatingCacheEntryListenerInvocation[] invocationsArray;
            List<DelegatingCacheEntryListenerInvocation<K, V>> invocations = listeners.get(eventType);
            if (invocations == null) {
                return null;
            }
            for (DelegatingCacheEntryListenerInvocation di : invocationsArray = invocations.toArray(new DelegatingCacheEntryListenerInvocation[invocations.size()])) {
                ((DelegatingCacheEntryListenerInvocationImpl)di).callback = this;
            }
            return invocationsArray;
        }

        void unregister() {
            FilterSubscription s = this.subscription;
            if (s != null) {
                this.matcher.unregisterFilter(s);
                this.subscription = null;
            }
        }

        public void onFilterResult(Object userContext, Object eventType, Object instance, Object[] projection, Comparable[] sortProjection) {
            DelegatingCacheEntryListenerInvocation<K, V>[] invocations;
            EventWrapper eventWrapper = (EventWrapper)userContext;
            CacheEntryEvent event = (CacheEntryEvent)eventWrapper.getEvent();
            if (event.isPre() && this.isClustered || this.isPrimaryOnly && !BaseJPAFilterIndexingServiceProvider.this.clusteringDependentLogic.getCacheTopology().getDistribution(eventWrapper.getKey()).isPrimary()) {
                return;
            }
            switch (event.getType()) {
                case CACHE_ENTRY_ACTIVATED: {
                    invocations = this.activated_invocations;
                    break;
                }
                case CACHE_ENTRY_CREATED: {
                    invocations = this.created_invocations;
                    break;
                }
                case CACHE_ENTRY_INVALIDATED: {
                    invocations = this.invalidated_invocations;
                    break;
                }
                case CACHE_ENTRY_LOADED: {
                    invocations = this.loaded_invocations;
                    break;
                }
                case CACHE_ENTRY_MODIFIED: {
                    invocations = this.modified_invocations;
                    break;
                }
                case CACHE_ENTRY_PASSIVATED: {
                    invocations = this.passivated_invocations;
                    break;
                }
                case CACHE_ENTRY_REMOVED: {
                    invocations = this.removed_invocations;
                    break;
                }
                case CACHE_ENTRY_VISITED: {
                    invocations = this.visited_invocations;
                    break;
                }
                case CACHE_ENTRY_EVICTED: {
                    invocations = this.evicted_invocations;
                    break;
                }
                case CACHE_ENTRY_EXPIRED: {
                    invocations = this.expired_invocations;
                    break;
                }
                default: {
                    return;
                }
            }
            boolean conversionDone = false;
            for (DelegatingCacheEntryListenerInvocation<K, V> invocation : invocations) {
                if (!invocation.getObservation().shouldInvoke(event.isPre())) continue;
                if (!conversionDone) {
                    if (this.filterAndConvert && event instanceof EventImpl) {
                        EventImpl eventImpl = (EventImpl)event;
                        EventImpl clone = eventImpl.clone();
                        clone.setValue(BaseJPAFilterIndexingServiceProvider.this.makeFilterResult(userContext, eventType, event.getKey(), projection == null ? instance : null, projection, sortProjection));
                        event = clone;
                    }
                    conversionDone = true;
                }
                invocation.invokeNoChecks(new EventWrapper(event.getKey(), (Event)event), false, this.filterAndConvert, true);
            }
        }
    }
}

