/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.query.impl.massindex;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.SearchIntegrator;
import org.hibernate.search.spi.impl.PojoIndexedTypeIdentifier;
import org.infinispan.AdvancedCache;
import org.infinispan.Cache;
import org.infinispan.CacheStream;
import org.infinispan.commons.dataconversion.ByteArrayWrapper;
import org.infinispan.commons.dataconversion.IdentityWrapper;
import org.infinispan.commons.marshall.AbstractExternalizer;
import org.infinispan.commons.time.TimeService;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.container.entries.CacheEntry;
import org.infinispan.context.Flag;
import org.infinispan.distexec.DistributedCallable;
import org.infinispan.encoding.DataConversion;
import org.infinispan.filter.AcceptAllKeyValueFilter;
import org.infinispan.filter.CacheFilters;
import org.infinispan.filter.KeyValueFilter;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.metadata.Metadata;
import org.infinispan.query.backend.KeyTransformationHandler;
import org.infinispan.query.impl.ComponentRegistryUtils;
import org.infinispan.query.impl.externalizers.ExternalizerIds;
import org.infinispan.query.impl.massindex.IndexUpdater;
import org.infinispan.query.impl.massindex.SecurityActions;

public final class IndexWorker
implements DistributedCallable<Object, Object, Void> {
    private final IndexedTypeIdentifier indexedType;
    private final boolean flush;
    private final boolean clean;
    private final boolean primaryOwner;
    private final Set<Object> everywhereKeys;
    private Cache<Object, Object> cache;
    private IndexUpdater indexUpdater;
    private Set<Object> keys = new HashSet<Object>();
    private ClusteringDependentLogic clusteringDependentLogic;
    private DataConversion valueDataConversion;
    private DataConversion keyDataConversion;

    IndexWorker(IndexedTypeIdentifier indexedType, boolean flush, boolean clean, boolean primaryOwner, Set<Object> everywhereKeys) {
        this.indexedType = indexedType;
        this.flush = flush;
        this.clean = clean;
        this.primaryOwner = primaryOwner;
        this.everywhereKeys = everywhereKeys;
    }

    public void setEnvironment(Cache<Object, Object> cache, Set<Object> inputKeys) {
        AdvancedCache unwrapped = SecurityActions.getUnwrappedCache(cache).getAdvancedCache();
        this.cache = unwrapped.getCacheConfiguration().memory().storageType() == StorageType.OBJECT ? unwrapped.withWrapping(ByteArrayWrapper.class, IdentityWrapper.class) : cache;
        SearchIntegrator searchIntegrator = ComponentRegistryUtils.getSearchIntegrator(unwrapped);
        KeyTransformationHandler keyTransformationHandler = ComponentRegistryUtils.getKeyTransformationHandler(unwrapped);
        TimeService timeService = ComponentRegistryUtils.getTimeService(unwrapped);
        this.indexUpdater = new IndexUpdater(searchIntegrator, keyTransformationHandler, timeService);
        this.clusteringDependentLogic = SecurityActions.getClusteringDependentLogic(unwrapped);
        if (this.everywhereKeys != null) {
            this.keys.addAll(this.everywhereKeys);
        }
        if (inputKeys != null) {
            this.keys.addAll(inputKeys);
        }
        this.keyDataConversion = unwrapped.getKeyDataConversion();
        this.valueDataConversion = unwrapped.getValueDataConversion();
    }

    private void preIndex() {
        if (this.clean) {
            this.indexUpdater.purge(this.indexedType);
        }
    }

    private void postIndex() {
        this.indexUpdater.waitForAsyncCompletion();
        if (this.flush) {
            this.indexUpdater.flush(this.indexedType);
        }
    }

    private KeyValueFilter getFilter() {
        return this.primaryOwner ? new PrimaryOwnersKeyValueFilter() : AcceptAllKeyValueFilter.getInstance();
    }

    private Object extractValue(Object storageValue) {
        return this.valueDataConversion.extractIndexable(storageValue);
    }

    public Void call() {
        if (this.keys == null || this.keys.size() == 0) {
            this.preIndex();
            KeyValueFilter filter = this.getFilter();
            Throwable throwable = null;
            try (CacheStream stream = this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.CACHE_MODE_LOCAL}).cacheEntrySet().stream();){
                Iterator iterator = stream.filter(CacheFilters.predicate((KeyValueFilter)filter)).iterator();
                while (iterator.hasNext()) {
                    CacheEntry next = (CacheEntry)iterator.next();
                    Object value = this.extractValue(next.getValue());
                    if (value == null || !value.getClass().equals(this.indexedType.getPojoType())) continue;
                    this.indexUpdater.updateIndex(next.getKey(), value);
                }
            }
            catch (Throwable iterator) {
                Throwable throwable2 = iterator;
                throw iterator;
            }
            this.postIndex();
        } else {
            HashSet classSet = new HashSet();
            for (Object object : this.keys) {
                Object value = this.extractValue(this.cache.get(object));
                if (value == null) continue;
                this.indexUpdater.updateIndex(object, value);
                classSet.add(value.getClass());
            }
            for (Class clazz : classSet) {
                this.indexUpdater.flush(PojoIndexedTypeIdentifier.convertFromLegacy((Class)clazz));
            }
        }
        return null;
    }

    private class PrimaryOwnersKeyValueFilter
    implements KeyValueFilter<Object, Object> {
        private PrimaryOwnersKeyValueFilter() {
        }

        public boolean accept(Object key, Object value, Metadata metadata) {
            return IndexWorker.this.clusteringDependentLogic.getCacheTopology().getDistribution(IndexWorker.this.keyDataConversion.toStorage(key)).isPrimary();
        }
    }

    public static final class Externalizer
    extends AbstractExternalizer<IndexWorker> {
        public Set<Class<? extends IndexWorker>> getTypeClasses() {
            return Collections.singleton(IndexWorker.class);
        }

        public void writeObject(ObjectOutput output, IndexWorker worker) throws IOException {
            output.writeObject(PojoIndexedTypeIdentifier.convertToLegacy((IndexedTypeIdentifier)worker.indexedType));
            output.writeBoolean(worker.flush);
            output.writeBoolean(worker.clean);
            output.writeBoolean(worker.primaryOwner);
            output.writeObject(worker.everywhereKeys);
        }

        public IndexWorker readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            Class indexedClass = (Class)input.readObject();
            boolean flush = input.readBoolean();
            boolean clean = input.readBoolean();
            boolean primaryOwner = input.readBoolean();
            Set everywhereKeys = (Set)input.readObject();
            return new IndexWorker(PojoIndexedTypeIdentifier.convertFromLegacy((Class)indexedClass), flush, clean, primaryOwner, everywhereKeys);
        }

        public Integer getId() {
            return ExternalizerIds.INDEX_WORKER;
        }
    }
}

