/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.server.hotrod.tx.table.functions;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.Set;
import org.infinispan.commons.marshall.AdvancedExternalizer;
import org.infinispan.functional.EntryView;
import org.infinispan.functional.MetaParam;
import org.infinispan.server.hotrod.tx.table.CacheXid;
import org.infinispan.server.hotrod.tx.table.Status;
import org.infinispan.server.hotrod.tx.table.TxState;
import org.infinispan.server.hotrod.tx.table.functions.TxFunction;
import org.infinispan.transaction.xa.GlobalTransaction;

public class CreateStateFunction
extends TxFunction {
    public static final AdvancedExternalizer<CreateStateFunction> EXTERNALIZER = new Externalizer();
    private final GlobalTransaction globalTransaction;
    private final long timeout;
    private final boolean recoverable;

    public CreateStateFunction(GlobalTransaction globalTransaction, boolean recoverable, long timeout) {
        this.globalTransaction = globalTransaction;
        this.recoverable = recoverable;
        this.timeout = timeout;
    }

    @Override
    public Byte apply(EntryView.ReadWriteEntryView<CacheXid, TxState> view) {
        if (view.find().isEmpty()) {
            view.set((Object)new TxState(this.globalTransaction, this.recoverable, this.timeout, this.timeService), new MetaParam.Writable[0]);
            return Status.OK.value;
        }
        if (((TxState)view.get()).isSameAs(this.globalTransaction, this.recoverable, this.timeout)) {
            view.set((Object)((TxState)view.get()), new MetaParam.Writable[0]);
            return Status.OK.value;
        }
        return Status.ERROR.value;
    }

    public String toString() {
        return "CreateStateFunction{globalTransaction=" + String.valueOf(this.globalTransaction) + ", timeout=" + this.timeout + ", recoverable=" + this.recoverable + "}";
    }

    private static class Externalizer
    implements AdvancedExternalizer<CreateStateFunction> {
        private Externalizer() {
        }

        public Set<Class<? extends CreateStateFunction>> getTypeClasses() {
            return Collections.singleton(CreateStateFunction.class);
        }

        public Integer getId() {
            return 1116;
        }

        public void writeObject(ObjectOutput output, CreateStateFunction object) throws IOException {
            output.writeObject(object.globalTransaction);
            output.writeBoolean(object.recoverable);
            output.writeLong(object.timeout);
        }

        public CreateStateFunction readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return new CreateStateFunction((GlobalTransaction)input.readObject(), input.readBoolean(), input.readLong());
        }
    }
}

