/*
 * Decompiled with CFR 0.152.
 */
package org.jacoco.cli.internal.core.internal.analysis.filter;

import java.util.HashMap;
import java.util.Map;
import org.jacoco.cli.internal.asm.tree.AbstractInsnNode;
import org.jacoco.cli.internal.asm.tree.FieldInsnNode;
import org.jacoco.cli.internal.asm.tree.MethodInsnNode;
import org.jacoco.cli.internal.asm.tree.MethodNode;
import org.jacoco.cli.internal.asm.tree.TypeInsnNode;
import org.jacoco.cli.internal.asm.tree.VarInsnNode;

abstract class AbstractMatcher {
    final Map<String, VarInsnNode> vars = new HashMap<String, VarInsnNode>();
    AbstractInsnNode cursor;

    AbstractMatcher() {
    }

    final void firstIsALoad0(MethodNode methodNode) {
        this.cursor = methodNode.instructions.getFirst();
        this.skipNonOpcodes();
        if (this.cursor != null && this.cursor.getOpcode() == 25 && ((VarInsnNode)this.cursor).var == 0) {
            return;
        }
        this.cursor = null;
    }

    final void nextIsType(int opcode, String desc) {
        this.nextIs(opcode);
        if (this.cursor == null) {
            return;
        }
        if (((TypeInsnNode)this.cursor).desc.equals(desc)) {
            return;
        }
        this.cursor = null;
    }

    final void nextIsInvoke(int opcode, String owner, String name, String descriptor) {
        this.nextIs(opcode);
        if (this.cursor == null) {
            return;
        }
        MethodInsnNode m = (MethodInsnNode)this.cursor;
        if (owner.equals(m.owner) && name.equals(m.name) && descriptor.equals(m.desc)) {
            return;
        }
        this.cursor = null;
    }

    final void nextIsField(int opcode, String owner, String name, String descriptor) {
        this.nextIs(opcode);
        if (this.cursor == null) {
            return;
        }
        FieldInsnNode f = (FieldInsnNode)this.cursor;
        if (owner.equals(f.owner) && name.equals(f.name) && descriptor.equals(f.desc)) {
            return;
        }
        this.cursor = null;
    }

    final void nextIsVar(int opcode, String name) {
        this.nextIs(opcode);
        if (this.cursor == null) {
            return;
        }
        VarInsnNode actual = (VarInsnNode)this.cursor;
        VarInsnNode expected = this.vars.get(name);
        if (expected == null) {
            this.vars.put(name, actual);
        } else if (expected.var != actual.var) {
            this.cursor = null;
        }
    }

    final void nextIsSwitch() {
        this.next();
        if (this.cursor == null) {
            return;
        }
        switch (this.cursor.getOpcode()) {
            case 170: 
            case 171: {
                return;
            }
        }
        this.cursor = null;
    }

    final void nextIs(int opcode) {
        this.next();
        if (this.cursor == null) {
            return;
        }
        if (this.cursor.getOpcode() != opcode) {
            this.cursor = null;
        }
    }

    final void next() {
        if (this.cursor == null) {
            return;
        }
        this.cursor = this.cursor.getNext();
        this.skipNonOpcodes();
    }

    final void skipNonOpcodes() {
        this.cursor = AbstractMatcher.skipNonOpcodes(this.cursor);
    }

    static AbstractInsnNode skipNonOpcodes(AbstractInsnNode cursor) {
        while (cursor != null && (cursor.getType() == 14 || cursor.getType() == 8 || cursor.getType() == 15)) {
            cursor = cursor.getNext();
        }
        return cursor;
    }
}

