/*
 * Decompiled with CFR 0.152.
 */
package org.javasimon.console;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.javasimon.Manager;
import org.javasimon.SimonManager;
import org.javasimon.console.Action;
import org.javasimon.console.ActionBinding;
import org.javasimon.console.ActionContext;
import org.javasimon.console.ActionException;
import org.javasimon.console.SimonConsolePlugin;
import org.javasimon.console.SimonConsolePluginManager;
import org.javasimon.console.SimpleActionBinding;
import org.javasimon.console.action.ClearAction;
import org.javasimon.console.action.DetailHtmlAction;
import org.javasimon.console.action.DetailJsonAction;
import org.javasimon.console.action.ErrorAction;
import org.javasimon.console.action.ListJsonAction;
import org.javasimon.console.action.PluginsJsonAction;
import org.javasimon.console.action.RedirectAction;
import org.javasimon.console.action.ResourceAction;
import org.javasimon.console.action.TableCsvAction;
import org.javasimon.console.action.TableHtmlAction;
import org.javasimon.console.action.TableJsonAction;
import org.javasimon.console.action.TreeJsonAction;
import org.javasimon.console.action.TreeXmlAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SimonConsoleRequestProcessor {
    private static Logger LOGGER = LoggerFactory.getLogger(SimonConsoleRequestProcessor.class);
    public static final String ROOT_PATH = "/index.html";
    public static final String TREE_PATH = "/tree.html";
    public static final String DETAIL_PATH = "/detail.html";
    private String urlPrefix;
    private Manager manager = SimonManager.manager();
    private final List<ActionBinding> actionBindings = new ArrayList<ActionBinding>();
    private final SimonConsolePluginManager pluginManager = new SimonConsolePluginManager();

    public SimonConsoleRequestProcessor(String urlPrefix) {
        this.urlPrefix = urlPrefix == null ? "" : urlPrefix.trim();
    }

    public final void addActionBinding(ActionBinding actionBinding) {
        this.actionBindings.add(actionBinding);
    }

    public final <T extends Action> void addSimpleActionBinding(String actionPath, Class<T> actionClass) {
        this.addActionBinding(new SimpleActionBinding<T>(actionPath, actionClass));
    }

    public void addResourceActionBinding(final String actionPath, final String resourcePath) {
        this.addActionBinding(new ActionBinding(){

            @Override
            public boolean supports(ActionContext actionContext) {
                return actionContext.getPath().equals(actionPath);
            }

            public Action create(ActionContext actionContext) {
                return new ResourceAction(actionContext, resourcePath);
            }
        });
    }

    protected final ActionBinding findActionBinding(ActionContext actionContext) {
        for (ActionBinding actionBinding : this.actionBindings) {
            if (!actionBinding.supports(actionContext)) continue;
            return actionBinding;
        }
        return null;
    }

    protected void initActionBindings() {
        this.addActionBinding(new ActionBinding<Action>(){

            @Override
            public boolean supports(ActionContext actionContext) {
                return actionContext.getPath().isEmpty();
            }

            @Override
            public Action create(ActionContext actionContext) {
                return new RedirectAction(actionContext.getRequest().getContextPath() + SimonConsoleRequestProcessor.this.urlPrefix + SimonConsoleRequestProcessor.ROOT_PATH, actionContext);
            }
        });
        this.addResourceActionBinding("/", ROOT_PATH);
        this.addResourceActionBinding(ROOT_PATH, ROOT_PATH);
        this.addResourceActionBinding(TREE_PATH, TREE_PATH);
        this.addResourceActionBinding(DETAIL_PATH, DETAIL_PATH);
        this.addActionBinding(new ActionBinding<Action>(){
            private final String pathPrefix = "/resource";

            @Override
            public boolean supports(ActionContext actionContext) {
                return actionContext.getPath().startsWith("/resource");
            }

            @Override
            public Action create(ActionContext actionContext) {
                return new ResourceAction(actionContext, actionContext.getPath().substring("/resource".length()));
            }
        });
        this.addSimpleActionBinding("/data/table.json", TableJsonAction.class);
        this.addSimpleActionBinding("/data/list.json", ListJsonAction.class);
        this.addSimpleActionBinding("/data/tree.json", TreeJsonAction.class);
        this.addSimpleActionBinding("/data/table.json", TableJsonAction.class);
        this.addSimpleActionBinding("/data/table.html", TableHtmlAction.class);
        this.addSimpleActionBinding("/data/table.csv", TableCsvAction.class);
        this.addSimpleActionBinding("/data/tree.xml", TreeXmlAction.class);
        this.addSimpleActionBinding("/data/clear", ClearAction.class);
        this.addSimpleActionBinding("/data/detail.html", DetailHtmlAction.class);
        this.addSimpleActionBinding("/data/detail.json", DetailJsonAction.class);
        this.addSimpleActionBinding("/data/plugins.json", PluginsJsonAction.class);
        for (ActionBinding actionBinding : this.pluginManager.getActionBindings()) {
            this.addActionBinding(actionBinding);
        }
        if (LOGGER.isDebugEnabled()) {
            StringBuilder logBuilder;
            if (!this.pluginManager.getPlugins().isEmpty()) {
                logBuilder = new StringBuilder();
                for (SimonConsolePlugin plugin : this.pluginManager.getPlugins()) {
                    logBuilder.append(plugin.getId()).append(':').append(plugin.getClass().getName()).append(' ');
                }
                LOGGER.debug(logBuilder.append("plugins registered").toString());
            }
            logBuilder = new StringBuilder();
            for (ActionBinding actionBinding : this.actionBindings) {
                if (!(actionBinding instanceof SimpleActionBinding)) continue;
                SimpleActionBinding simpleActionBinding = (SimpleActionBinding)actionBinding;
                logBuilder.append(this.urlPrefix).append(simpleActionBinding.getPath()).append(':').append(simpleActionBinding.getActionClass().getName()).append(' ');
            }
            LOGGER.debug(logBuilder.append("actions bound").toString());
        }
    }

    protected void processRequest(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String path = request.getRequestURI().substring(request.getContextPath().length() + this.urlPrefix.length());
        ActionContext actionContext = new ActionContext(request, response, path);
        actionContext.setManager(this.manager);
        actionContext.setPluginManager(this.pluginManager);
        this.processContext(actionContext);
    }

    protected void processContext(ActionContext actionContext) throws ServletException, IOException {
        Action action = null;
        try {
            ActionBinding actionBinding = this.findActionBinding(actionContext);
            if (actionBinding != null) {
                action = (Action)actionBinding.create(actionContext);
            }
            if (action == null) {
                throw new ActionException("No action bound to path " + actionContext.getPath());
            }
            action.readParameters();
            action.execute();
        }
        catch (ActionException actionException) {
            try {
                ErrorAction errorAction = new ErrorAction(actionContext);
                errorAction.setError(actionException);
                errorAction.execute();
            }
            catch (ActionException actionException1) {
                throw new ServletException((Throwable)actionException);
            }
        }
    }

    public String getUrlPrefix() {
        return this.urlPrefix;
    }

    public Manager getManager() {
        return this.manager;
    }

    public void setManager(Manager manager) {
        this.manager = manager;
    }

    public SimonConsolePluginManager getPluginManager() {
        return this.pluginManager;
    }

    public static SimonConsoleRequestProcessor create(String urlPrefix, Manager manager, String pluginClasses) {
        SimonConsoleRequestProcessor requestProcessor = new SimonConsoleRequestProcessor(urlPrefix);
        if (manager != null) {
            requestProcessor.setManager(manager);
        }
        if (pluginClasses != null) {
            requestProcessor.getPluginManager().addPlugins(pluginClasses);
        }
        requestProcessor.initActionBindings();
        return requestProcessor;
    }
}

