/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.maven.shared.properties;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.codehaus.plexus.util.IOUtil;
import org.jboss.maven.shared.properties.PropertiesException;

public class PropertiesHelper {
    private PropertiesHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties loadPropertyFile(File propfile) {
        if (!propfile.exists()) {
            throw new PropertiesException("unable to locate specified prop file [" + propfile.toString() + "]");
        }
        Properties props = new Properties();
        if (propfile.exists()) {
            try {
                FileInputStream inStream = new FileInputStream(propfile);
                try {
                    props.load(inStream);
                }
                finally {
                    IOUtil.close((InputStream)inStream);
                }
            }
            catch (IOException ioe) {
                throw new PropertiesException("unable to load properties file [" + propfile + "]");
            }
        }
        Enumeration<?> n = props.propertyNames();
        while (n.hasMoreElements()) {
            String k = (String)n.nextElement();
            props.setProperty(k, PropertiesHelper.getInterpolatedPropertyValue(k, props));
        }
        return props;
    }

    public static String getInterpolatedPropertyValue(String key, Properties props) {
        int idx;
        String v = props.getProperty(key);
        String ret = "";
        while ((idx = v.indexOf("${")) >= 0) {
            ret = ret + v.substring(0, idx);
            int idx2 = (v = v.substring(idx + 2)).indexOf(125);
            if (idx2 < 0) break;
            String nk = v.substring(0, idx2);
            v = v.substring(idx2 + 1);
            String nv = props.getProperty(nk);
            if (nv == null) {
                nv = System.getProperty(nk);
            }
            if (nv == null || nv.equals(key)) {
                ret = ret + "${" + nk + "}";
                continue;
            }
            v = nv + v;
        }
        return ret + v;
    }
}

