/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.api;

import org.jboss.shrinkwrap.resolver.api.Invokable;
import org.jboss.shrinkwrap.resolver.api.ResolverSystem;
import org.jboss.shrinkwrap.resolver.api.SecurityActions;

final class ResolverSystemFactory {
    private static final String CLASS_NAME_SERVICELOADER = "org.jboss.shrinkwrap.resolver.spi.loader.ServiceLoader";
    private static final String CLASS_NAME_SPISERVICELOADER = "org.jboss.shrinkwrap.resolver.spi.loader.SpiServiceLoader";
    private static final String CLASS_NAME_SERVICEREGISTRY = "org.jboss.shrinkwrap.resolver.spi.loader.ServiceRegistry";
    private static final String METHOD_NAME_ONLY_ONE = "onlyOne";
    private static final String METHOD_NAME_REGISTER = "register";

    private ResolverSystemFactory() {
        throw new UnsupportedOperationException("No instances permitted");
    }

    static <RESOLVERSYSTEMTYPE extends ResolverSystem> RESOLVERSYSTEMTYPE createFromUserView(Class<RESOLVERSYSTEMTYPE> userViewClass) throws IllegalArgumentException {
        return ResolverSystemFactory.createFromUserView(userViewClass, SecurityActions.getThreadContextClassLoader());
    }

    static <RESOLVERSYSTEMTYPE extends ResolverSystem> RESOLVERSYSTEMTYPE createFromUserView(Class<RESOLVERSYSTEMTYPE> userViewClass, ClassLoader cl) {
        assert (userViewClass != null) : "user view class must be specified";
        assert (cl != null) : "ClassLoader must be specified";
        Object spiServiceLoader = new Invokable(cl, CLASS_NAME_SPISERVICELOADER).invokeConstructor(new Class[]{ClassLoader.class}, new Object[]{cl});
        Object serviceLoader = new Invokable(cl, CLASS_NAME_SPISERVICELOADER).invokeMethod(METHOD_NAME_ONLY_ONE, new Class[]{Class.class, Class.class}, spiServiceLoader, new Object[]{Invokable.loadClass(cl, CLASS_NAME_SPISERVICELOADER), spiServiceLoader.getClass()});
        Object serviceRegistry = new Invokable(cl, CLASS_NAME_SERVICEREGISTRY).invokeConstructor(new Class[]{Invokable.loadClass(cl, CLASS_NAME_SERVICELOADER)}, new Object[]{serviceLoader});
        new Invokable(cl, serviceRegistry.getClass()).invokeMethod(METHOD_NAME_REGISTER, new Class[]{serviceRegistry.getClass()}, null, new Object[]{serviceRegistry});
        Object userViewObject = new Invokable(cl, serviceRegistry.getClass()).invokeMethod(METHOD_NAME_ONLY_ONE, new Class[]{Class.class}, serviceRegistry, new Object[]{userViewClass});
        return (RESOLVERSYSTEMTYPE)((ResolverSystem)userViewClass.cast(userViewObject));
    }
}

