/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.text.MessageFormat;
import java.util.Collection;
import org.jboss.shrinkwrap.resolver.api.CoordinateParseException;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolveStageBase;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolveWithRangeSupportStageBase;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStageBase;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencies;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenWorkingSessionContainer;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

public abstract class ResolveStageBaseImpl<RESOLVESTAGETYPE extends MavenResolveStageBase<RESOLVESTAGETYPE, STRATEGYSTAGETYPE, FORMATSTAGETYPE>, STRATEGYSTAGETYPE extends MavenStrategyStageBase<STRATEGYSTAGETYPE, FORMATSTAGETYPE>, FORMATSTAGETYPE extends MavenFormatStage>
implements MavenResolveStageBase<RESOLVESTAGETYPE, STRATEGYSTAGETYPE, FORMATSTAGETYPE>,
MavenResolveWithRangeSupportStageBase,
MavenWorkingSessionContainer {
    private static final MavenDependencyExclusion[] TYPESAFE_EXCLUSIONS_ARRAY = new MavenDependencyExclusion[0];
    private final MavenWorkingSession session;

    public ResolveStageBaseImpl(MavenWorkingSession session) {
        Validate.stateNotNull(session, "Maven Working session must not be null");
        this.session = session;
    }

    @Override
    public MavenWorkingSession getMavenWorkingSession() {
        return this.session;
    }

    public final STRATEGYSTAGETYPE resolve() throws IllegalStateException {
        return this.createStrategyStage();
    }

    public final STRATEGYSTAGETYPE resolve(String coordinate) throws IllegalArgumentException {
        MavenDependency dep = this.resolveDependency(coordinate);
        this.addDependency(dep);
        return this.resolve();
    }

    public final STRATEGYSTAGETYPE resolve(String ... coordinates) throws IllegalArgumentException {
        this.addDependencies(coordinates);
        return this.resolve();
    }

    public final RESOLVESTAGETYPE addDependency(MavenDependency dependency) throws IllegalArgumentException {
        if (dependency == null) {
            throw new IllegalArgumentException("dependency must be specified");
        }
        MavenDependency resolved = this.resolveDependency(dependency);
        this.session.getDependenciesForResolution().add(resolved);
        return this.covariantReturn();
    }

    public final RESOLVESTAGETYPE addDependencies(MavenDependency ... dependencies) throws IllegalArgumentException {
        if (dependencies == null || dependencies.length == 0) {
            throw new IllegalArgumentException("At least one coordinate must be specified");
        }
        for (MavenDependency dependency : dependencies) {
            if (dependency == null) {
                throw new IllegalArgumentException("null dependency not permitted");
            }
            MavenDependency resolved = this.resolveDependency(dependency);
            this.session.getDependenciesForResolution().add(resolved);
        }
        return this.covariantReturn();
    }

    public STRATEGYSTAGETYPE resolve(Collection<String> canonicalForms) throws IllegalArgumentException, ResolutionException, CoordinateParseException {
        if (canonicalForms == null) {
            throw new IllegalArgumentException("canonical forms must be provided");
        }
        for (String canonicalForm : canonicalForms) {
            MavenDependency dep = this.resolveDependency(canonicalForm);
            this.addDependency(dep);
        }
        return this.resolve();
    }

    public RESOLVESTAGETYPE addDependencies(Collection<MavenDependency> dependencies) throws IllegalArgumentException {
        if (dependencies == null) {
            throw new IllegalArgumentException("dependencies must be provided");
        }
        for (MavenDependency dep : dependencies) {
            this.addDependency(dep);
        }
        return this.covariantReturn();
    }

    private RESOLVESTAGETYPE addDependencies(String ... coordinates) throws CoordinateParseException, IllegalArgumentException {
        if (coordinates == null || coordinates.length == 0) {
            throw new IllegalArgumentException("At least one coordinate must be specified");
        }
        for (String coordinate : coordinates) {
            if (coordinate == null || coordinate.isEmpty()) {
                throw new IllegalArgumentException("null dependency not permitted");
            }
            MavenDependency dependency = this.resolveDependency(coordinate);
            this.session.getDependenciesForResolution().add(dependency);
        }
        return this.covariantReturn();
    }

    private MavenDependency resolveDependency(String coordinate) {
        assert (coordinate != null && !coordinate.isEmpty()) : "Coordinate is required";
        MavenCoordinate newCoordinate = MavenCoordinates.createCoordinate((String)coordinate);
        MavenDependency declared = MavenDependencies.createDependency((MavenCoordinate)newCoordinate, null, (boolean)false, (MavenDependencyExclusion[])new MavenDependencyExclusion[0]);
        MavenDependency resolved = this.resolveDependency(declared);
        return resolved;
    }

    private MavenDependency resolveDependency(MavenDependency declared) {
        String resolvedVersion = this.resolveVersion(declared);
        MavenCoordinate newCoordinate = MavenCoordinates.createCoordinate((String)declared.getGroupId(), (String)declared.getArtifactId(), (String)resolvedVersion, (PackagingType)declared.getPackaging(), (String)declared.getClassifier());
        MavenDependency dependency = MavenDependencies.createDependency((MavenCoordinate)newCoordinate, (ScopeType)declared.getScope(), (boolean)declared.isOptional(), (MavenDependencyExclusion[])declared.getExclusions().toArray(TYPESAFE_EXCLUSIONS_ARRAY));
        return dependency;
    }

    protected String resolveVersion(MavenDependency dependency) throws IllegalArgumentException {
        String declaredVersion = dependency.getVersion();
        if (Validate.isNullOrEmpty(declaredVersion)) {
            throw new ResolutionException(MessageFormat.format("Unable to get version for dependency specified by {0}:, it was either null or empty.", dependency.toCanonicalForm()));
        }
        return declaredVersion;
    }

    private RESOLVESTAGETYPE covariantReturn() {
        return (RESOLVESTAGETYPE)((MavenResolveStageBase)this.getActualClass().cast(this));
    }

    protected abstract STRATEGYSTAGETYPE createStrategyStage();

    protected abstract Class<RESOLVESTAGETYPE> getActualClass();
}

