/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.sqlparser.impl.util;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SqlParserUtils {
    private static final Log logger = LogFactory.getLog(SqlParserUtils.class);
    public static final Pattern MB_PLACEHOLDER = Pattern.compile("(#\\{[^}]+})|(\\$\\{[^}]+})");
    public static final String MB_PREFIX = "__MB_PARAM_";
    public static final String MB_SUFFIX = "__";

    public static String maskMyBatisPlaceholders(String text, Map<String, String> tokenToRaw) {
        return SqlParserUtils.maskMyBatisPlaceholders(text, tokenToRaw, "");
    }

    public static String maskMyBatisPlaceholders(String text, Map<String, String> tokenToRaw, String customMaskKey) {
        logger.debug((Object)("[Mybatis\u66ff\u6362\u5360\u4f4d\u7b26] maskMyBatisPlaceholders: " + text));
        if (text == null || text.isEmpty()) {
            return text;
        }
        if (customMaskKey == null || customMaskKey.isEmpty()) {
            customMaskKey = "";
        }
        Matcher m = MB_PLACEHOLDER.matcher(text);
        StringBuffer sb = new StringBuffer();
        int idx = 0;
        while (m.find()) {
            String raw = m.group();
            String token = MB_PREFIX + customMaskKey + idx + MB_SUFFIX;
            tokenToRaw.put(token, raw);
            m.appendReplacement(sb, Matcher.quoteReplacement("'" + token + "'"));
            ++idx;
        }
        m.appendTail(sb);
        logger.debug((Object)("[Mybatis\u66ff\u6362\u5360\u4f4d\u7b26] maskMyBatisPlaceholders result: " + sb.toString()));
        return sb.toString();
    }

    public static String restoreMyBatisPlaceholders(String sql, Map<String, String> tokenToRaw) {
        logger.debug((Object)("[Mybatis\u5360\u4f4d\u7b26\u8fd8\u539f] restoreMyBatisPlaceholders: " + sql));
        if (sql == null || tokenToRaw == null || tokenToRaw.isEmpty()) {
            return sql;
        }
        String out = sql;
        for (Map.Entry<String, String> e : tokenToRaw.entrySet()) {
            out = out.replace("'" + e.getKey() + "'", e.getValue());
        }
        logger.debug((Object)("[Mybatis\u5360\u4f4d\u7b26\u8fd8\u539f] restoreMyBatisPlaceholders result: " + out));
        return out;
    }
}

