/*
 * Decompiled with CFR 0.152.
 */
package org.jeecgframework.minidao.sqlparser.impl.util.v49;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.GreaterThan;
import net.sf.jsqlparser.expression.operators.relational.GreaterThanEquals;
import net.sf.jsqlparser.expression.operators.relational.InExpression;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.MinorThan;
import net.sf.jsqlparser.expression.operators.relational.MinorThanEquals;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.ParenthesedSelect;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SetOperationList;
import org.jeecgframework.minidao.sqlparser.impl.util.SqlParserUtils;

public class JSqlParserAddWhereHelper49 {
    public static String addWhereCondition(String sql, String condition) {
        if (sql == null || condition == null || condition.trim().isEmpty()) {
            return sql;
        }
        LinkedHashMap<String, String> mbMap = new LinkedHashMap<String, String>();
        String maskedCondition = SqlParserUtils.maskMyBatisPlaceholders(condition, mbMap);
        LinkedHashMap<String, String> sqlMbMap = new LinkedHashMap<String, String>();
        sql = SqlParserUtils.maskMyBatisPlaceholders(sql, sqlMbMap, "_SQL_");
        try {
            Statement statement = CCJSqlParserUtil.parse((String)sql, parser -> {
                CCJSqlParser cfr_ignored_0 = (CCJSqlParser)parser.withSquareBracketQuotation(true);
            });
            if (statement instanceof Select) {
                Select selectStmt = (Select)statement;
                if (selectStmt instanceof PlainSelect) {
                    PlainSelect plainSelect = (PlainSelect)selectStmt;
                    Expression conditionExpression = CCJSqlParserUtil.parseCondExpression((String)maskedCondition);
                    Expression whereExpression = plainSelect.getWhere();
                    if (whereExpression != null) {
                        plainSelect.setWhere((Expression)new AndExpression(whereExpression, conditionExpression));
                    } else {
                        plainSelect.setWhere(conditionExpression);
                    }
                    sql = SqlParserUtils.restoreMyBatisPlaceholders(selectStmt.toString(), mbMap);
                } else if (selectStmt instanceof SetOperationList) {
                    SetOperationList setOperationList = (SetOperationList)selectStmt;
                    PlainSelect outer = new PlainSelect();
                    ParenthesedSelect sub = new ParenthesedSelect().withSelect((Select)setOperationList);
                    sub.setAlias(new Alias("tmp_query"));
                    outer.setFromItem((FromItem)sub);
                    outer.addSelectItems(new Expression[]{new AllColumns()});
                    Expression conditionExpression = CCJSqlParserUtil.parseCondExpression((String)maskedCondition);
                    outer.setWhere(conditionExpression);
                    sql = SqlParserUtils.restoreMyBatisPlaceholders(outer.toString(), mbMap);
                } else if (statement instanceof ParenthesedSelect) {
                    ParenthesedSelect ps = (ParenthesedSelect)statement;
                    if (ps.getPlainSelect() != null) {
                        PlainSelect inner = ps.getPlainSelect();
                        Expression conditionExpression = CCJSqlParserUtil.parseCondExpression((String)maskedCondition);
                        Expression whereExpression = inner.getWhere();
                        if (whereExpression != null) {
                            inner.setWhere((Expression)new AndExpression(whereExpression, conditionExpression));
                        } else {
                            inner.setWhere(conditionExpression);
                        }
                        sql = SqlParserUtils.restoreMyBatisPlaceholders(ps.toString(), mbMap);
                    } else {
                        PlainSelect outer = new PlainSelect();
                        if (ps.getAlias() == null) {
                            ps.setAlias(new Alias("tmp_query"));
                        }
                        outer.setFromItem((FromItem)ps);
                        outer.addSelectItems(new Expression[]{new AllColumns()});
                        Expression conditionExpression = CCJSqlParserUtil.parseCondExpression((String)maskedCondition);
                        outer.setWhere(conditionExpression);
                        sql = SqlParserUtils.restoreMyBatisPlaceholders(outer.toString(), mbMap);
                    }
                } else {
                    sql = SqlParserUtils.restoreMyBatisPlaceholders(selectStmt.toString(), mbMap);
                }
            }
            sql = SqlParserUtils.restoreMyBatisPlaceholders(sql, sqlMbMap);
            return sql;
        }
        catch (JSQLParserException e) {
            throw new RuntimeException("SQL \u89e3\u6790\u5931\u8d25\uff0c\u65e0\u6cd5\u6dfb\u52a0 WHERE \u6761\u4ef6", e);
        }
    }

    public static String addWhereCondition(String sql, String field, Object value, String operator) {
        String vs;
        Matcher m;
        if (sql == null || field == null || field.trim().isEmpty() || operator == null || operator.trim().isEmpty()) {
            return sql;
        }
        boolean hasMbValue = false;
        String mbToken = null;
        String mbValueRaw = null;
        if (value instanceof String && (m = SqlParserUtils.MB_PLACEHOLDER.matcher(vs = (String)value)).find()) {
            hasMbValue = true;
            mbValueRaw = vs;
            mbToken = "__MB_PARAM_0__";
        }
        try {
            Statement statement = CCJSqlParserUtil.parse((String)sql, parser -> {
                CCJSqlParser cfr_ignored_0 = (CCJSqlParser)parser.withSquareBracketQuotation(true);
            });
            if (statement instanceof Select) {
                Select selectStmt = (Select)statement;
                if (selectStmt instanceof PlainSelect) {
                    PlainSelect plainSelect = (PlainSelect)selectStmt;
                    Column column = new Column(field);
                    StringValue valueExpression = hasMbValue ? new StringValue("'" + mbToken + "'") : JSqlParserAddWhereHelper49.createValueExpression(value);
                    Expression conditionExpression = JSqlParserAddWhereHelper49.createComparisonExpression((Expression)column, (Expression)valueExpression, operator);
                    Expression whereExpression = plainSelect.getWhere();
                    if (whereExpression != null) {
                        plainSelect.setWhere((Expression)new AndExpression(whereExpression, conditionExpression));
                    } else {
                        plainSelect.setWhere(conditionExpression);
                    }
                    String out = plainSelect.toString();
                    return hasMbValue ? out.replace("'" + mbToken + "'", mbValueRaw) : out;
                }
                if (selectStmt instanceof SetOperationList) {
                    SetOperationList setOperationList = (SetOperationList)selectStmt;
                    PlainSelect outer = new PlainSelect();
                    ParenthesedSelect sub = new ParenthesedSelect().withSelect((Select)setOperationList);
                    sub.setAlias(new Alias("tmp_query"));
                    outer.setFromItem((FromItem)sub);
                    outer.addSelectItems(new Expression[]{new AllColumns()});
                    Column column = new Column(field);
                    StringValue valueExpression = hasMbValue ? new StringValue("'" + mbToken + "'") : JSqlParserAddWhereHelper49.createValueExpression(value);
                    Expression conditionExpression = JSqlParserAddWhereHelper49.createComparisonExpression((Expression)column, (Expression)valueExpression, operator);
                    outer.setWhere(conditionExpression);
                    String out = outer.toString();
                    return hasMbValue ? out.replace("'" + mbToken + "'", mbValueRaw) : out;
                }
                if (statement instanceof ParenthesedSelect) {
                    ParenthesedSelect ps = (ParenthesedSelect)statement;
                    if (ps.getPlainSelect() != null) {
                        PlainSelect inner = ps.getPlainSelect();
                        Column column = new Column(field);
                        StringValue valueExpression = hasMbValue ? new StringValue("'" + mbToken + "'") : JSqlParserAddWhereHelper49.createValueExpression(value);
                        Expression conditionExpression = JSqlParserAddWhereHelper49.createComparisonExpression((Expression)column, (Expression)valueExpression, operator);
                        Expression whereExpression = inner.getWhere();
                        if (whereExpression != null) {
                            inner.setWhere((Expression)new AndExpression(whereExpression, conditionExpression));
                        } else {
                            inner.setWhere(conditionExpression);
                        }
                        String out = ps.toString();
                        return hasMbValue ? out.replace("'" + mbToken + "'", mbValueRaw) : out;
                    }
                    PlainSelect outer = new PlainSelect();
                    if (ps.getAlias() == null) {
                        ps.setAlias(new Alias("tmp_query"));
                    }
                    outer.setFromItem((FromItem)ps);
                    outer.addSelectItems(new Expression[]{new AllColumns()});
                    Column column = new Column(field);
                    StringValue valueExpression = hasMbValue ? new StringValue("'" + mbToken + "'") : JSqlParserAddWhereHelper49.createValueExpression(value);
                    Expression conditionExpression = JSqlParserAddWhereHelper49.createComparisonExpression((Expression)column, (Expression)valueExpression, operator);
                    outer.setWhere(conditionExpression);
                    String out = outer.toString();
                    return hasMbValue ? out.replace("'" + mbToken + "'", mbValueRaw) : out;
                }
                return selectStmt.toString();
            }
            return sql;
        }
        catch (JSQLParserException e) {
            throw new RuntimeException("SQL \u89e3\u6790\u5931\u8d25\uff0c\u65e0\u6cd5\u6dfb\u52a0 WHERE \u6761\u4ef6", e);
        }
    }

    private static Expression createValueExpression(Object value) {
        if (value == null) {
            return new NullValue();
        }
        if (value instanceof Number) {
            if (value instanceof Integer || value instanceof Long) {
                return new LongValue(((Number)value).longValue());
            }
            return new DoubleValue(value.toString());
        }
        if (value instanceof Boolean) {
            boolean boolValue = (Boolean)value;
            return new StringValue("'" + boolValue + "'");
        }
        String strValue = value.toString().replace("'", "''");
        return new StringValue("'" + strValue + "'");
    }

    private static Expression createComparisonExpression(Expression left, Expression right, String operator) {
        switch (operator = operator.trim().toLowerCase()) {
            case "=": {
                EqualsTo equalsTo = new EqualsTo();
                equalsTo.setLeftExpression(left);
                equalsTo.setRightExpression(right);
                return equalsTo;
            }
            case ">": {
                GreaterThan gt = new GreaterThan();
                gt.setLeftExpression(left);
                gt.setRightExpression(right);
                return gt;
            }
            case ">=": {
                GreaterThanEquals gte = new GreaterThanEquals();
                gte.setLeftExpression(left);
                gte.setRightExpression(right);
                return gte;
            }
            case "<": {
                MinorThan lt = new MinorThan();
                lt.setLeftExpression(left);
                lt.setRightExpression(right);
                return lt;
            }
            case "<=": {
                MinorThanEquals lte = new MinorThanEquals();
                lte.setLeftExpression(left);
                lte.setRightExpression(right);
                return lte;
            }
            case "!=": 
            case "<>": {
                NotEqualsTo notEqualsTo = new NotEqualsTo();
                notEqualsTo.setLeftExpression(left);
                notEqualsTo.setRightExpression(right);
                return notEqualsTo;
            }
            case "like": {
                LikeExpression like = new LikeExpression();
                like.setLeftExpression(left);
                like.setRightExpression(right);
                return like;
            }
            case "not like": {
                LikeExpression notLike = new LikeExpression();
                notLike.setLeftExpression(left);
                notLike.setRightExpression(right);
                notLike.setNot(true);
                return notLike;
            }
            case "in": {
                if (right instanceof StringValue) {
                    String inValues = right.toString().replace("'", "");
                    String[] values = inValues.split(",");
                    ArrayList<StringValue> expressions = new ArrayList<StringValue>();
                    for (String value : values) {
                        expressions.add(new StringValue("'" + value.trim() + "'"));
                    }
                    InExpression inExpression = new InExpression();
                    inExpression.setLeftExpression(left);
                    inExpression.setRightExpression((Expression)new ExpressionList(expressions));
                    return inExpression;
                }
                EqualsTo fallbackEquals = new EqualsTo();
                fallbackEquals.setLeftExpression(left);
                fallbackEquals.setRightExpression(right);
                return fallbackEquals;
            }
        }
        EqualsTo defaultEquals = new EqualsTo();
        defaultEquals.setLeftExpression(left);
        defaultEquals.setRightExpression(right);
        return defaultEquals;
    }

    private static String buildCondition(String field, Object value, String operator) {
        StringBuilder condition = new StringBuilder();
        condition.append(field).append(" ").append(operator).append(" ");
        if (value == null) {
            condition.append("NULL");
        } else if (value instanceof Number || value instanceof Boolean) {
            condition.append(value);
        } else {
            String strValue = value.toString().replace("'", "''");
            condition.append("'").append(strValue).append("'");
        }
        return condition.toString();
    }
}

