/*
 * Decompiled with CFR 0.152.
 */
package jodd.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.ArrayList;
import jodd.io.IOUtil;
import jodd.io.UnicodeInputStream;
import jodd.net.URLDecoder;
import jodd.util.DigestEngine;
import jodd.util.StringUtil;
import jodd.util.SystemUtil;

public class FileUtil {
    public static String tempFilePrefix = "jodd-";
    private static final String MSG_NOT_A_DIRECTORY = "Not a directory: ";
    private static final String MSG_CANT_CREATE = "Can't create: ";
    private static final String MSG_NOT_FOUND = "Not found: ";
    private static final String MSG_NOT_A_FILE = "Not a file: ";
    private static final String MSG_UNABLE_TO_DELETE = "Unable to delete: ";
    private static final int ZERO = 0;
    private static final int NEGATIVE_ONE = -1;
    private static final String FILE_PROTOCOL = "file";
    private static final String USER_HOME = "~";

    public static File file(String fileName) {
        fileName = StringUtil.replace(fileName, USER_HOME, SystemUtil.info().getHomeDir());
        return new File(fileName);
    }

    private static File file(File parent, String fileName) {
        return new File(parent, fileName);
    }

    public static boolean equals(String one, String two) {
        return FileUtil.equals(FileUtil.file(one), FileUtil.file(two));
    }

    public static boolean equals(File one, File two) {
        try {
            one = one.getCanonicalFile();
            two = two.getCanonicalFile();
        }
        catch (IOException ignore) {
            return false;
        }
        return one.equals(two);
    }

    public static File toFile(URL url) {
        String fileName = FileUtil.toFileName(url);
        if (fileName == null) {
            return null;
        }
        return FileUtil.file(fileName);
    }

    public static URL toURL(File file) throws MalformedURLException {
        return file.toURI().toURL();
    }

    public static String toFileName(URL url) {
        if (url == null || !url.getProtocol().equals(FILE_PROTOCOL)) {
            return null;
        }
        String filename = url.getFile().replace('/', File.separatorChar);
        return URLDecoder.decode(filename, FileUtil.encoding());
    }

    public static File toContainerFile(URL url) {
        String protocol = url.getProtocol();
        if (protocol.equals(FILE_PROTOCOL)) {
            return FileUtil.toFile(url);
        }
        String path = url.getPath();
        return new File(URI.create(path.substring(0, path.lastIndexOf("!/"))));
    }

    public static boolean isExistingFile(File file) {
        return file != null && file.exists() && file.isFile();
    }

    public static boolean isExistingFolder(File folder) {
        return folder != null && folder.exists() && folder.isDirectory();
    }

    public static File mkdirs(String dirs) throws IOException {
        return FileUtil.mkdirs(FileUtil.file(dirs));
    }

    public static File mkdirs(File dirs) throws IOException {
        if (dirs.exists()) {
            FileUtil.checkIsDirectory(dirs);
            return dirs;
        }
        return FileUtil.checkCreateDirectory(dirs);
    }

    public static File mkdir(String dir) throws IOException {
        return FileUtil.mkdir(FileUtil.file(dir));
    }

    public static File mkdir(File dir) throws IOException {
        if (dir.exists()) {
            FileUtil.checkIsDirectory(dir);
            return dir;
        }
        return FileUtil.checkCreateDirectory(dir);
    }

    public static void touch(String file) throws IOException {
        FileUtil.touch(FileUtil.file(file));
    }

    public static void touch(File file) throws IOException {
        if (!file.exists()) {
            IOUtil.close(new FileOutputStream(file, false));
        }
        file.setLastModified(System.currentTimeMillis());
    }

    public static void copyFile(String srcFile, String destFile) throws IOException {
        FileUtil.copyFile(FileUtil.file(srcFile), FileUtil.file(destFile));
    }

    public static void copyFile(File srcFile, File destFile) throws IOException {
        FileUtil.checkFileCopy(srcFile, destFile);
        FileUtil._copyFile(srcFile, destFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _copyFile(File srcFile, File destFile) throws IOException {
        if (destFile.exists() && destFile.isDirectory()) {
            throw new IOException("Destination '" + destFile + "' is a directory");
        }
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            input = new FileInputStream(srcFile);
            output = new FileOutputStream(destFile, false);
            IOUtil.copy((InputStream)input, output);
        }
        catch (Throwable throwable) {
            IOUtil.close(output);
            IOUtil.close(input);
            throw throwable;
        }
        IOUtil.close(output);
        IOUtil.close(input);
        if (srcFile.length() != destFile.length()) {
            throw new IOException("Copy file failed of '" + srcFile + "' to '" + destFile + "' due to different sizes");
        }
        destFile.setLastModified(srcFile.lastModified());
    }

    public static File copyFileToDir(String srcFile, String destDir) throws IOException {
        return FileUtil.copyFileToDir(FileUtil.file(srcFile), FileUtil.file(destDir));
    }

    public static File copyFileToDir(File srcFile, File destDir) throws IOException {
        FileUtil.checkExistsAndDirectory(destDir);
        File destFile = FileUtil.file(destDir, srcFile.getName());
        FileUtil.copyFile(srcFile, destFile);
        return destFile;
    }

    public static void copyDir(String srcDir, String destDir) throws IOException {
        FileUtil.copyDir(FileUtil.file(srcDir), FileUtil.file(destDir));
    }

    public static void copyDir(File srcDir, File destDir) throws IOException {
        FileUtil.checkDirCopy(srcDir, destDir);
        FileUtil._copyDirectory(srcDir, destDir);
    }

    private static void _copyDirectory(File srcDir, File destDir) throws IOException {
        if (destDir.exists()) {
            FileUtil.checkIsDirectory(destDir);
        } else {
            FileUtil.checkCreateDirectory(destDir);
            destDir.setLastModified(srcDir.lastModified());
        }
        File[] files = srcDir.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of: " + srcDir);
        }
        IOException exception = null;
        for (File file : files) {
            File destFile = FileUtil.file(destDir, file.getName());
            try {
                if (file.isDirectory()) {
                    FileUtil._copyDirectory(file, destFile);
                    continue;
                }
                FileUtil._copyFile(file, destFile);
            }
            catch (IOException ioex) {
                exception = ioex;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static File moveFile(String srcFile, String destFile) throws IOException {
        return FileUtil.moveFile(FileUtil.file(srcFile), FileUtil.file(destFile));
    }

    public static File moveFile(File srcFile, File destFile) throws IOException {
        FileUtil.checkFileCopy(srcFile, destFile);
        FileUtil._moveFile(srcFile, destFile);
        return destFile;
    }

    private static void _moveFile(File srcFile, File destFile) throws IOException {
        boolean rename;
        if (destFile.exists()) {
            FileUtil.checkIsFile(destFile);
            destFile.delete();
        }
        if (!(rename = srcFile.renameTo(destFile))) {
            FileUtil._copyFile(srcFile, destFile);
            srcFile.delete();
        }
    }

    public static File moveFileToDir(String srcFile, String destDir) throws IOException {
        return FileUtil.moveFileToDir(FileUtil.file(srcFile), FileUtil.file(destDir));
    }

    public static File moveFileToDir(File srcFile, File destDir) throws IOException {
        FileUtil.checkExistsAndDirectory(destDir);
        return FileUtil.moveFile(srcFile, FileUtil.file(destDir, srcFile.getName()));
    }

    public static File moveDir(String srcDir, String destDir) throws IOException {
        return FileUtil.moveDir(FileUtil.file(srcDir), FileUtil.file(destDir));
    }

    public static File moveDir(File srcDir, File destDir) throws IOException {
        FileUtil.checkDirCopy(srcDir, destDir);
        FileUtil._moveDirectory(srcDir, destDir);
        return destDir;
    }

    private static void _moveDirectory(File srcDest, File destDir) throws IOException {
        boolean rename;
        if (destDir.exists()) {
            FileUtil.checkIsDirectory(destDir);
            destDir = FileUtil.file(destDir, destDir.getName());
            destDir.mkdir();
        }
        if (!(rename = srcDest.renameTo(destDir))) {
            FileUtil._copyDirectory(srcDest, destDir);
            FileUtil.deleteDir(srcDest);
        }
    }

    public static void deleteFile(String destFile) throws IOException {
        FileUtil.deleteFile(FileUtil.file(destFile));
    }

    public static void deleteFile(File destFile) throws IOException {
        FileUtil.checkIsFile(destFile);
        FileUtil.checkDeleteSuccessful(destFile);
    }

    public static void deleteDir(String destDir) throws IOException {
        FileUtil.deleteDir(FileUtil.file(destDir));
    }

    public static void deleteDir(File destDir) throws IOException {
        FileUtil.cleanDir(destDir);
        FileUtil.checkDeleteSuccessful(destDir);
    }

    public static void cleanDir(String dest) throws IOException {
        FileUtil.cleanDir(FileUtil.file(dest));
    }

    public static void cleanDir(File destDir) throws IOException {
        FileUtil.checkExists(destDir);
        FileUtil.checkIsDirectory(destDir);
        File[] files = destDir.listFiles();
        if (files == null) {
            throw new IOException("Failed to list contents of: " + destDir);
        }
        IOException exception = null;
        for (File file : files) {
            try {
                if (file.isDirectory()) {
                    FileUtil.deleteDir(file);
                    continue;
                }
                file.delete();
            }
            catch (IOException ioex) {
                exception = ioex;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    public static char[] readUTFChars(String fileName) throws IOException {
        return FileUtil.readUTFChars(FileUtil.file(fileName));
    }

    public static char[] readUTFChars(File file) throws IOException {
        FileUtil.checkExists(file);
        FileUtil.checkIsFile(file);
        UnicodeInputStream in = FileUtil.unicodeInputStreamOf(file);
        try {
            char[] cArray = IOUtil.readChars((InputStream)in, FileUtil.detectEncoding(in));
            return cArray;
        }
        finally {
            IOUtil.close(in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static char[] readChars(File file, Charset encoding) throws IOException {
        FileUtil.checkExists(file);
        FileUtil.checkIsFile(file);
        InputStream in = FileUtil.streamOf(file, encoding);
        try {
            char[] cArray = IOUtil.readChars(in, encoding);
            return cArray;
        }
        finally {
            IOUtil.close(in);
        }
    }

    public static char[] readChars(String fileName) throws IOException {
        return FileUtil.readChars(fileName, FileUtil.encoding());
    }

    public static char[] readChars(File file) throws IOException {
        return FileUtil.readChars(file, FileUtil.encoding());
    }

    public static char[] readChars(String fileName, Charset encoding) throws IOException {
        return FileUtil.readChars(FileUtil.file(fileName), encoding);
    }

    public static void writeChars(File dest, char[] data) throws IOException {
        FileUtil.writeChars(dest, data, FileUtil.encoding());
    }

    public static void writeChars(String dest, char[] data) throws IOException {
        FileUtil.writeChars(FileUtil.file(dest), data);
    }

    public static void writeChars(String dest, char[] data, Charset encoding) throws IOException {
        FileUtil.writeChars(FileUtil.file(dest), data, encoding);
    }

    public static void writeChars(File dest, char[] data, Charset encoding) throws IOException {
        FileUtil.outChars(dest, data, encoding, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void outChars(File dest, char[] data, Charset encoding, boolean append) throws IOException {
        if (dest.exists()) {
            FileUtil.checkIsFile(dest);
        }
        BufferedWriter out = new BufferedWriter(IOUtil.outputStreamWriterOf(new FileOutputStream(dest, append), encoding));
        try {
            out.write(data);
        }
        finally {
            IOUtil.close(out);
        }
    }

    public static String readUTFString(String fileName) throws IOException {
        return FileUtil.readUTFString(FileUtil.file(fileName));
    }

    public static String readUTFString(File file) throws IOException {
        UnicodeInputStream in = FileUtil.unicodeInputStreamOf(file);
        try {
            String string = IOUtil.copy((InputStream)in, FileUtil.detectEncoding(in)).toString();
            return string;
        }
        finally {
            IOUtil.close(in);
        }
    }

    public static String readUTFString(InputStream inputStream) throws IOException {
        String string;
        UnicodeInputStream in = null;
        try {
            in = new UnicodeInputStream(inputStream, null);
            string = IOUtil.copy((InputStream)in, FileUtil.detectEncoding(in)).toString();
        }
        catch (Throwable throwable) {
            IOUtil.close(in);
            throw throwable;
        }
        IOUtil.close(in);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readString(File file, Charset encoding) throws IOException {
        FileUtil.checkExists(file);
        FileUtil.checkIsFile(file);
        InputStream in = FileUtil.streamOf(file, encoding);
        try {
            String string = IOUtil.copy(in, encoding).toString();
            return string;
        }
        finally {
            IOUtil.close(in);
        }
    }

    public static String readString(String source) throws IOException {
        return FileUtil.readString(source, FileUtil.encoding());
    }

    public static String readString(String source, Charset encoding) throws IOException {
        return FileUtil.readString(FileUtil.file(source), encoding);
    }

    public static String readString(File source) throws IOException {
        return FileUtil.readString(source, FileUtil.encoding());
    }

    public static void writeString(String dest, String data) throws IOException {
        FileUtil.writeString(FileUtil.file(dest), data, FileUtil.encoding());
    }

    public static void writeString(String dest, String data, Charset encoding) throws IOException {
        FileUtil.writeString(FileUtil.file(dest), data, encoding);
    }

    public static void writeString(File dest, String data) throws IOException {
        FileUtil.writeString(dest, data, FileUtil.encoding());
    }

    public static void writeString(File dest, String data, Charset encoding) throws IOException {
        FileUtil.outString(dest, data, encoding, false);
    }

    public static void appendString(String dest, String data) throws IOException {
        FileUtil.appendString(FileUtil.file(dest), data);
    }

    public static void appendString(String dest, String data, Charset encoding) throws IOException {
        FileUtil.appendString(FileUtil.file(dest), data, encoding);
    }

    public static void appendString(File dest, String data) throws IOException {
        FileUtil.appendString(dest, data, FileUtil.encoding());
    }

    public static void appendString(File dest, String data, Charset encoding) throws IOException {
        FileUtil.outString(dest, data, encoding, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void outString(File dest, String data, Charset encoding, boolean append) throws IOException {
        if (dest.exists()) {
            FileUtil.checkIsFile(dest);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dest, append);
            out.write(data.getBytes(encoding));
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close(out);
    }

    public static void writeStream(String dest, InputStream in) throws IOException {
        FileUtil.writeStream(FileUtil.file(dest), in);
    }

    public static void writeStream(File dest, InputStream in) throws IOException {
        FileUtil.writeStream(new FileOutputStream(dest, false), in);
    }

    public static void writeStream(FileOutputStream out, InputStream in) throws IOException {
        try {
            IOUtil.copy(in, out);
        }
        finally {
            IOUtil.close(out);
        }
    }

    public static String[] readLines(String source) throws IOException {
        return FileUtil.readLines(source, FileUtil.encoding());
    }

    public static String[] readLines(String source, Charset encoding) throws IOException {
        return FileUtil.readLines(FileUtil.file(source), encoding);
    }

    public static String[] readLines(File source) throws IOException {
        return FileUtil.readLines(source, FileUtil.encoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String[] readLines(File file, Charset encoding) throws IOException {
        FileUtil.checkExists(file);
        FileUtil.checkIsFile(file);
        ArrayList<String> list = new ArrayList<String>();
        InputStream in = FileUtil.streamOf(file, encoding);
        try {
            String strLine;
            BufferedReader br = new BufferedReader(IOUtil.inputStreamReadeOf(in, encoding));
            while ((strLine = br.readLine()) != null) {
                list.add(strLine);
            }
        }
        finally {
            IOUtil.close(in);
        }
        return list.toArray(new String[0]);
    }

    public static byte[] readBytes(String file) throws IOException {
        return FileUtil.readBytes(FileUtil.file(file));
    }

    public static byte[] readBytes(File file) throws IOException {
        return FileUtil.readBytes(file, -1);
    }

    public static byte[] readBytes(File file, int count) throws IOException {
        FileUtil.checkExists(file);
        FileUtil.checkIsFile(file);
        long numToRead = file.length();
        if (numToRead >= Integer.MAX_VALUE) {
            throw new IOException("File is larger then max array size");
        }
        if (count > -1 && (long)count < numToRead) {
            numToRead = count;
        }
        byte[] bytes = new byte[(int)numToRead];
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        randomAccessFile.readFully(bytes);
        randomAccessFile.close();
        return bytes;
    }

    public static void writeBytes(String dest, byte[] data) throws IOException {
        FileUtil.writeBytes(FileUtil.file(dest), data);
    }

    public static void writeBytes(File dest, byte[] data) throws IOException {
        FileUtil.writeBytes(dest, data, 0, data.length);
    }

    public static void writeBytes(String dest, byte[] data, int off, int len) throws IOException {
        FileUtil.writeBytes(FileUtil.file(dest), data, off, len);
    }

    public static void writeBytes(File dest, byte[] data, int off, int len) throws IOException {
        FileUtil.outBytes(dest, data, off, len, false);
    }

    public static void appendBytes(String dest, byte[] data) throws IOException {
        FileUtil.appendBytes(FileUtil.file(dest), data);
    }

    public static void appendBytes(String dest, byte[] data, int off, int len) throws IOException {
        FileUtil.appendBytes(FileUtil.file(dest), data, off, len);
    }

    public static void appendBytes(File dest, byte[] data) throws IOException {
        FileUtil.appendBytes(dest, data, 0, data.length);
    }

    public static void appendBytes(File dest, byte[] data, int off, int len) throws IOException {
        FileUtil.outBytes(dest, data, off, len, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void outBytes(File dest, byte[] data, int off, int len, boolean append) throws IOException {
        if (dest.exists()) {
            FileUtil.checkIsFile(dest);
        }
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(dest, append);
            out.write(data, off, len);
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close(out);
    }

    public static boolean compare(String file1, String file2) throws IOException {
        return FileUtil.compare(FileUtil.file(file1), FileUtil.file(file2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean compare(File one, File two) throws IOException {
        boolean bl;
        boolean file1Exists = one.exists();
        if (file1Exists != two.exists()) {
            return false;
        }
        if (!file1Exists) {
            return true;
        }
        if (!one.isFile() || !two.isFile()) {
            throw new IOException("Only files can be compared");
        }
        if (one.length() != two.length()) {
            return false;
        }
        if (FileUtil.equals(one, two)) {
            return true;
        }
        FileInputStream input1 = null;
        FileInputStream input2 = null;
        try {
            input1 = new FileInputStream(one);
            input2 = new FileInputStream(two);
            bl = IOUtil.compare(input1, input2);
        }
        catch (Throwable throwable) {
            IOUtil.close(input1);
            IOUtil.close(input2);
            throw throwable;
        }
        IOUtil.close(input1);
        IOUtil.close(input2);
        return bl;
    }

    public static boolean isOlder(String file, String reference) {
        return FileUtil.isOlder(FileUtil.file(file), FileUtil.file(reference));
    }

    public static boolean isNewer(String file, String reference) {
        return FileUtil.isNewer(FileUtil.file(file), FileUtil.file(reference));
    }

    public static boolean isNewer(File file, File reference) {
        FileUtil.checkReferenceExists(reference);
        return FileUtil.isNewer(file, reference.lastModified());
    }

    public static boolean isOlder(File file, File reference) {
        FileUtil.checkReferenceExists(reference);
        return FileUtil.isOlder(file, reference.lastModified());
    }

    public static boolean isNewer(File file, long timeMillis) {
        return file.exists() && file.lastModified() > timeMillis;
    }

    public static boolean isNewer(String file, long timeMillis) {
        return FileUtil.isNewer(FileUtil.file(file), timeMillis);
    }

    public static boolean isOlder(File file, long timeMillis) {
        return file.exists() && file.lastModified() < timeMillis;
    }

    public static boolean isOlder(String file, long timeMillis) {
        return FileUtil.isOlder(FileUtil.file(file), timeMillis);
    }

    public static void copy(String src, String dest) throws IOException {
        FileUtil.copy(FileUtil.file(src), FileUtil.file(dest));
    }

    public static void copy(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            FileUtil.copyDir(src, dest);
            return;
        }
        if (dest.isDirectory()) {
            FileUtil.copyFileToDir(src, dest);
            return;
        }
        FileUtil.copyFile(src, dest);
    }

    public static void move(String src, String dest) throws IOException {
        FileUtil.move(FileUtil.file(src), FileUtil.file(dest));
    }

    public static void move(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            FileUtil.moveDir(src, dest);
            return;
        }
        if (dest.isDirectory()) {
            FileUtil.moveFileToDir(src, dest);
            return;
        }
        FileUtil.moveFile(src, dest);
    }

    public static void delete(String dest) throws IOException {
        FileUtil.delete(FileUtil.file(dest));
    }

    public static void delete(File dest) throws IOException {
        if (dest.isDirectory()) {
            FileUtil.deleteDir(dest);
            return;
        }
        FileUtil.deleteFile(dest);
    }

    public static boolean isAncestor(File ancestor, File file, boolean strict) {
        File parent;
        File file2 = parent = strict ? FileUtil.getParentFile(file) : file;
        while (parent != null) {
            if (parent.equals(ancestor)) {
                return true;
            }
            parent = FileUtil.getParentFile(parent);
        }
        return false;
    }

    public static File getParentFile(File file) {
        int skipCount = 0;
        File parentFile = file;
        while (true) {
            if ((parentFile = parentFile.getParentFile()) == null) {
                return null;
            }
            if (".".equals(parentFile.getName())) continue;
            if ("..".equals(parentFile.getName())) {
                ++skipCount;
                continue;
            }
            if (skipCount <= 0) break;
            --skipCount;
        }
        return parentFile;
    }

    public static boolean isFilePathAcceptable(File file, FileFilter fileFilter) {
        do {
            if (fileFilter == null || fileFilter.accept(file)) continue;
            return false;
        } while ((file = file.getParentFile()) != null);
        return true;
    }

    public static File createTempDirectory() throws IOException {
        return FileUtil.createTempDirectory(tempFilePrefix, null);
    }

    public static File createTempDirectory(String prefix, String suffix) throws IOException {
        return FileUtil.createTempDirectory(prefix, suffix, null);
    }

    public static File createTempDirectory(String prefix, String suffix, File tempDir) throws IOException {
        File file = FileUtil.createTempFile(prefix, suffix, tempDir);
        file.delete();
        file.mkdir();
        return file;
    }

    public static File createTempFile() throws IOException {
        return FileUtil.createTempFile(tempFilePrefix, null, null, true);
    }

    public static File createTempFile(String prefix, String suffix, File tempDir, boolean create) throws IOException {
        File file = FileUtil.createTempFile(prefix, suffix, tempDir);
        file.delete();
        if (create) {
            file.createNewFile();
        }
        return file;
    }

    public static File createTempFile(String prefix, String suffix, File tempDir) throws IOException {
        int exceptionsCount = 0;
        while (true) {
            try {
                return File.createTempFile(prefix, suffix, tempDir).getCanonicalFile();
            }
            catch (IOException ioex) {
                if (++exceptionsCount < 50) continue;
                throw ioex;
            }
            break;
        }
    }

    @Deprecated
    public static boolean isSymlink(File file) {
        return Files.isSymbolicLink(file.toPath());
    }

    public static String md5(File file) throws IOException {
        return DigestEngine.md5().digestString(file);
    }

    public static String sha256(File file) throws IOException {
        return DigestEngine.sha256().digestString(file);
    }

    public static String sha512(File file) throws IOException {
        return DigestEngine.sha512().digestString(file);
    }

    public static boolean isBinary(File file) throws IOException {
        byte[] bytes;
        for (byte b : bytes = FileUtil.readBytes(file, 128)) {
            if (b >= 32 || b == 9 || b == 10 || b == 13) continue;
            return true;
        }
        return false;
    }

    private static UnicodeInputStream unicodeInputStreamOf(File file) throws IOException {
        FileUtil.checkExists(file);
        FileUtil.checkIsFile(file);
        return FileUtil.unicodeInputStreamOf(new FileInputStream(file), null);
    }

    private static UnicodeInputStream unicodeInputStreamOf(InputStream input, Charset targetEncoding) {
        return new UnicodeInputStream(input, targetEncoding);
    }

    private static InputStream streamOf(File file, Charset encoding) throws IOException {
        InputStream in = new FileInputStream(file);
        if (encoding.name().startsWith("UTF")) {
            in = FileUtil.unicodeInputStreamOf(in, encoding);
        }
        return in;
    }

    private static Charset detectEncoding(UnicodeInputStream in) {
        Charset encoding = in.getDetectedEncoding();
        if (encoding == null) {
            encoding = StandardCharsets.UTF_8;
        }
        return encoding;
    }

    private static void checkExists(File file) throws FileNotFoundException {
        if (!file.exists()) {
            throw new FileNotFoundException(MSG_NOT_FOUND + file);
        }
    }

    private static void checkReferenceExists(File file) throws IllegalArgumentException {
        try {
            FileUtil.checkExists(file);
        }
        catch (FileNotFoundException e) {
            throw new IllegalArgumentException("Reference file not found: " + file);
        }
    }

    private static void checkIsFile(File file) throws IOException {
        if (!file.isFile()) {
            throw new IOException(MSG_NOT_A_FILE + file);
        }
    }

    private static void checkIsDirectory(File dir) throws IOException {
        if (!dir.isDirectory()) {
            throw new IOException(MSG_NOT_A_DIRECTORY + dir);
        }
    }

    private static void checkExistsAndDirectory(File dir) throws IOException {
        if (dir.exists()) {
            FileUtil.checkIsDirectory(dir);
        }
    }

    private static File checkCreateDirectory(File dir) throws IOException {
        if (!dir.mkdirs()) {
            throw new IOException(MSG_CANT_CREATE + dir);
        }
        return dir;
    }

    private static void checkDeleteSuccessful(File dir) throws IOException {
        if (!dir.delete()) {
            throw new IOException(MSG_UNABLE_TO_DELETE + dir);
        }
    }

    private static void checkDirCopy(File srcDir, File destDir) throws IOException {
        FileUtil.checkExists(srcDir);
        FileUtil.checkIsDirectory(srcDir);
        if (FileUtil.equals(srcDir, destDir)) {
            throw new IOException("Source '" + srcDir + "' and destination '" + destDir + "' are equal");
        }
    }

    private static void checkFileCopy(File srcFile, File destFile) throws IOException {
        FileUtil.checkExists(srcFile);
        FileUtil.checkIsFile(srcFile);
        if (FileUtil.equals(srcFile, destFile)) {
            throw new IOException("Files '" + srcFile + "' and '" + destFile + "' are equal");
        }
        File destParent = destFile.getParentFile();
        if (destParent != null && !destParent.exists()) {
            FileUtil.checkCreateDirectory(destParent);
        }
    }

    private static Charset encoding() {
        return StandardCharsets.UTF_8;
    }
}

