/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.jcseg.analyzer;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.analysis.Tokenizer;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeFactory;
import org.lionsoul.jcseg.ISegment;
import org.lionsoul.jcseg.analyzer.JcsegTokenizer;
import org.lionsoul.jcseg.dic.ADictionary;
import org.lionsoul.jcseg.dic.DictionaryFactory;
import org.lionsoul.jcseg.segmenter.SegmenterConfig;

public class JcsegTokenizerFactory
extends TokenizerFactory {
    public final ISegment.Type type;
    public final SegmenterConfig config;
    public final ADictionary dic;

    public JcsegTokenizerFactory(Map<String, String> args) throws IOException {
        super(args);
        this.type = ISegment.Type.fromString((String)args.get("mode"));
        this.config = new SegmenterConfig(true);
        for (Map.Entry<String, String> entry : args.entrySet()) {
            if (!entry.getKey().startsWith("jcseg_")) continue;
            this.config.set(entry.getKey().replace("jcseg_", "jcseg."), entry.getValue());
        }
        this.dic = DictionaryFactory.createSingletonDictionary((SegmenterConfig)this.config);
    }

    public SegmenterConfig getTaskConfig() {
        return this.config;
    }

    public ADictionary getDict() {
        return this.dic;
    }

    public Tokenizer create(AttributeFactory factory) {
        try {
            return new JcsegTokenizer(this.type, this.config, this.dic);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

