/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.util.HashMap;
import java.util.Map;
import liquibase.Liquibase;
import liquibase.changelog.ChangeLogParameters;
import liquibase.command.CommandScope;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.liquibase.maven.plugins.AbstractLiquibaseChangeLogMojo;
import org.liquibase.maven.property.PropertyElement;

public class LiquibaseRollbackOneChangeSetMojo
extends AbstractLiquibaseChangeLogMojo {
    @PropertyElement
    protected String changeSetId;
    @PropertyElement
    protected String changeSetAuthor;
    @PropertyElement
    protected String changeSetPath;
    @PropertyElement
    protected String force;
    @PropertyElement
    protected String rollbackScript;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        this.commandName = "rollbackOneChangeSet";
        super.execute();
    }

    @Override
    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "Changeset ID:     " + this.changeSetId));
        this.getLog().info((CharSequence)(indent + "Changeset Author: " + this.changeSetAuthor));
        this.getLog().info((CharSequence)(indent + "Changeset Path:   " + this.changeSetPath));
        this.getLog().info((CharSequence)(indent + "Rollback script:   " + this.rollbackScript));
    }

    @Override
    protected void performLiquibaseTask(Liquibase liquibase) throws LiquibaseException {
        super.performLiquibaseTask(liquibase);
        Database database = liquibase.getDatabase();
        CommandScope liquibaseCommand = new CommandScope(new String[]{"internalRollbackOneChangeSet"});
        Map<String, Object> argsMap = this.getCommandArgsObjectMap(liquibase);
        ChangeLogParameters clp = new ChangeLogParameters(database);
        argsMap.put("changeLogParameters", clp);
        if (this.force == null || this.force != null && !Boolean.parseBoolean(this.force)) {
            throw new LiquibaseException("Invalid value for --force.  You must specify 'liquibase.force=true' to use rollbackOneChangeSet.");
        }
        argsMap.put("force", Boolean.TRUE);
        argsMap.put("liquibase", liquibase);
        for (Map.Entry<String, Object> entry : argsMap.entrySet()) {
            liquibaseCommand.addArgumentValue(entry.getKey(), entry.getValue());
        }
        liquibaseCommand.execute();
    }

    private Map<String, Object> getCommandArgsObjectMap(Liquibase liquibase) throws LiquibaseException {
        Database database = liquibase.getDatabase();
        HashMap<String, Object> argsMap = new HashMap<String, Object>();
        argsMap.put("changeSetId", this.changeSetId);
        argsMap.put("changeSetAuthor", this.changeSetAuthor);
        argsMap.put("changeSetPath", this.changeSetPath);
        argsMap.put("force", this.force);
        argsMap.put("rollbackScript", this.rollbackScript);
        argsMap.put("changeLogFile", this.changeLogFile);
        argsMap.put("database", database);
        argsMap.put("changeLog", liquibase.getDatabaseChangeLog());
        argsMap.put("resourceAccessor", liquibase.getResourceAccessor());
        return argsMap;
    }
}

