/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.callback;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.AttributeKey;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.UUID;
import org.mockserver.callback.WebSocketClientRegistry;
import org.mockserver.exception.ExceptionHandler;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.mock.HttpStateHandler;

@ChannelHandler.Sharable
public class CallbackWebSocketServerHandler
extends ChannelInboundHandlerAdapter {
    private static final AttributeKey<Boolean> CHANNEL_UPGRADED_FOR_CALLBACK_WEB_SOCKET = AttributeKey.valueOf((String)"CHANNEL_UPGRADED_FOR_CALLBACK_WEB_SOCKET");
    private static final String UPGRADE_CHANNEL_FOR_CALLBACK_WEB_SOCKET_URI = "/_mockserver_callback_websocket";
    private WebSocketServerHandshaker handshaker;
    private WebSocketClientRegistry webSocketClientRegistry;
    private final MockServerLogger mockServerLogger;

    public CallbackWebSocketServerHandler(HttpStateHandler httpStateHandler) {
        this.webSocketClientRegistry = httpStateHandler.getWebSocketClientRegistry();
        this.mockServerLogger = httpStateHandler.getMockServerLogger();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        boolean release = true;
        try {
            if (msg instanceof FullHttpRequest && ((FullHttpRequest)msg).uri().equals(UPGRADE_CHANNEL_FOR_CALLBACK_WEB_SOCKET_URI)) {
                this.upgradeChannel(ctx, (FullHttpRequest)msg);
                ctx.channel().attr(CHANNEL_UPGRADED_FOR_CALLBACK_WEB_SOCKET).set((Object)true);
            } else if (ctx.channel().attr(CHANNEL_UPGRADED_FOR_CALLBACK_WEB_SOCKET).get() != null && ((Boolean)ctx.channel().attr(CHANNEL_UPGRADED_FOR_CALLBACK_WEB_SOCKET).get()).booleanValue() && msg instanceof WebSocketFrame) {
                this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
            } else {
                release = false;
                ctx.fireChannelRead(msg);
            }
        }
        finally {
            if (release) {
                ReferenceCountUtil.release((Object)msg);
            }
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) {
        ctx.flush();
    }

    private void upgradeChannel(final ChannelHandlerContext ctx, FullHttpRequest httpRequest) {
        this.handshaker = new WebSocketServerHandshakerFactory("ws://" + httpRequest.headers().get("Host") + UPGRADE_CHANNEL_FOR_CALLBACK_WEB_SOCKET_URI, null, true, Integer.MAX_VALUE).newHandshaker((HttpRequest)httpRequest);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse((Channel)ctx.channel());
        } else {
            final String clientId = UUID.randomUUID().toString();
            this.handshaker.handshake(ctx.channel(), httpRequest, new DefaultHttpHeaders().add("X-CLIENT-REGISTRATION-ID", (Object)clientId), ctx.channel().newPromise()).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    CallbackWebSocketServerHandler.this.webSocketClientRegistry.registerClient(clientId, ctx);
                }
            });
        }
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame frame) {
        if (frame instanceof CloseWebSocketFrame) {
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)frame.retain());
        } else if (frame instanceof TextWebSocketFrame) {
            this.webSocketClientRegistry.receivedTextWebSocketFrame((TextWebSocketFrame)frame);
        } else if (frame instanceof PingWebSocketFrame) {
            ctx.write((Object)new PongWebSocketFrame(frame.content().retain()));
        } else {
            throw new UnsupportedOperationException(String.format("%s frame types not supported", frame.getClass().getName()));
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (ExceptionHandler.shouldNotIgnoreException(cause)) {
            this.mockServerLogger.error("web socket server caught exception", cause);
        }
        ctx.close();
    }
}

