/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.proxy.socks;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.socks.SocksAddressType;
import io.netty.handler.codec.socks.SocksCmdRequest;
import io.netty.handler.codec.socks.SocksCmdResponse;
import io.netty.handler.codec.socks.SocksCmdStatus;
import io.netty.handler.codec.socks.SocksMessageEncoder;
import io.netty.handler.ssl.SslHandler;
import org.mockserver.lifecycle.LifeCycle;
import org.mockserver.logging.MockServerLogger;
import org.mockserver.proxy.relay.RelayConnectHandler;

@ChannelHandler.Sharable
public final class SocksConnectHandler
extends RelayConnectHandler<SocksCmdRequest> {
    public SocksConnectHandler(LifeCycle server, MockServerLogger mockServerLogger, String host, int port) {
        super(server, mockServerLogger, host, port);
    }

    @Override
    protected void removeCodecSupport(ChannelHandlerContext ctx) {
        ChannelPipeline pipeline = ctx.pipeline();
        this.removeHandler(pipeline, SslHandler.class);
        this.removeHandler(pipeline, HttpServerCodec.class);
        this.removeHandler(pipeline, HttpContentDecompressor.class);
        this.removeHandler(pipeline, HttpObjectAggregator.class);
        this.removeHandler(pipeline, SocksMessageEncoder.class);
        this.removeHandler(pipeline, (ChannelHandler)this);
    }

    @Override
    protected Object successResponse(Object request) {
        if (request != null && request instanceof SocksCmdRequest) {
            return new SocksCmdResponse(SocksCmdStatus.SUCCESS, ((SocksCmdRequest)request).addressType(), ((SocksCmdRequest)request).host(), ((SocksCmdRequest)request).port());
        }
        return new SocksCmdResponse(SocksCmdStatus.SUCCESS, SocksAddressType.UNKNOWN);
    }

    @Override
    protected Object failureResponse(Object request) {
        if (request != null && request instanceof SocksCmdRequest) {
            return new SocksCmdResponse(SocksCmdStatus.FAILURE, ((SocksCmdRequest)request).addressType(), ((SocksCmdRequest)request).host(), ((SocksCmdRequest)request).port());
        }
        return new SocksCmdResponse(SocksCmdStatus.FAILURE, SocksAddressType.UNKNOWN);
    }
}

