/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.validation;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.molgenis.data.DataService;
import org.molgenis.data.DatabaseAction;
import org.molgenis.data.Entity;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.data.validation.ConstraintViolation;
import org.molgenis.data.validation.EntityAttributesValidator;
import org.molgenis.data.validation.EntityValidator;
import org.molgenis.data.validation.ExpressionValidator;
import org.molgenis.data.validation.MolgenisValidationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultEntityValidator
implements EntityValidator {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultEntityValidator.class);
    private final DataService dataService;
    private final EntityAttributesValidator entityAttributesValidator;
    private final ExpressionValidator expressionValidator;

    public DefaultEntityValidator(DataService dataService, EntityAttributesValidator entityAttributesValidator, ExpressionValidator expressionValidator) {
        this.dataService = dataService;
        this.entityAttributesValidator = entityAttributesValidator;
        this.expressionValidator = Objects.requireNonNull(expressionValidator);
    }

    @Override
    public void validate(Iterable<? extends Entity> entities, EntityType meta, DatabaseAction dbAction) {
        Set<ConstraintViolation> violations = this.checkNotNull(entities, meta);
        violations.addAll(this.checkUniques(entities, meta, dbAction));
        long rownr = 0L;
        for (Entity entity : entities) {
            ++rownr;
            Set<ConstraintViolation> entityViolations = this.entityAttributesValidator.validate(entity, meta);
            for (ConstraintViolation entityViolation : entityViolations) {
                entityViolation.setRowNr(rownr);
                violations.add(entityViolation);
            }
        }
        if (!violations.isEmpty()) {
            LOG.info("Validation violations:" + violations);
            throw new MolgenisValidationException(violations);
        }
    }

    private Set<ConstraintViolation> checkNotNull(Iterable<? extends Entity> entities, EntityType meta) {
        LinkedHashSet violations = Sets.newLinkedHashSet();
        for (Attribute attr : meta.getAtomicAttributes()) {
            if (attr.isNillable() || attr.equals(meta.getIdAttribute()) || attr.isAuto()) continue;
            long rowNr = 0L;
            for (Entity entity : entities) {
                ++rowNr;
                if (!this.mustDoNotNullCheck(meta, attr, entity) || entity.get(attr.getName()) != null) continue;
                String message = String.format("The attribute '%s' of entity '%s' with key '%s' can not be null.", attr.getName(), meta.getId(), entity.getString(meta.getLabelAttribute().getName()));
                violations.add(new ConstraintViolation(message, rowNr));
            }
        }
        return violations;
    }

    public boolean mustDoNotNullCheck(EntityType entityType, Attribute attr, Entity entity) {
        return !StringUtils.isNotBlank((CharSequence)attr.getVisibleExpression()) || this.expressionValidator.resolveBooleanExpression(attr.getVisibleExpression(), entity);
    }

    private Set<ConstraintViolation> checkUniques(Iterable<? extends Entity> entities, EntityType meta, DatabaseAction dbAction) {
        LinkedHashSet violations = Sets.newLinkedHashSet();
        for (Attribute attr : meta.getAtomicAttributes()) {
            String entityTypeId;
            long l;
            if (!attr.isUnique() || attr.equals(meta.getIdAttribute()) || attr.equals(meta.getLabelAttribute()) && dbAction == DatabaseAction.ADD_UPDATE_EXISTING) continue;
            ArrayList values = Lists.newArrayList();
            for (Entity entity : entities) {
                Object value = entity.get(attr.getName());
                values.add(value);
            }
            if (values.isEmpty() || (l = this.dataService.count(entityTypeId = meta.getId(), new QueryImpl().in(attr.getName(), (Iterable)values))) <= 0L) continue;
            long found = 0L;
            Iterator<? extends Entity> it = entities.iterator();
            while (it.hasNext() && found < l) {
                Entity entity = it.next();
                Object value = entity.get(attr.getName());
                Entity existing = this.dataService.findOne(entityTypeId, new QueryImpl().eq(attr.getName(), value));
                if (existing == null) continue;
                if (dbAction == null && !this.idEquals(entity, existing, meta) || dbAction != null && dbAction == DatabaseAction.ADD) {
                    String message = String.format("The attribute '%s' of entity '%s' with key '%s' must be unique, but the value '%s' already exists.", attr.getName(), meta.getId(), entity.getString(meta.getLabelAttribute().getName()), value);
                    violations.add(new ConstraintViolation(message));
                }
                ++found;
            }
        }
        return violations;
    }

    private boolean idEquals(Entity e1, Entity e2, EntityType meta) {
        if (meta.getIdAttribute() != null) {
            String id1 = e1.getString(meta.getIdAttribute().getName());
            String id2 = e2.getString(meta.getIdAttribute().getName());
            if (id1 != null && id2 != null && id1.equals(id2)) {
                return true;
            }
        }
        return false;
    }
}

