/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.validation;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.support.AttributeUtils;
import org.molgenis.data.support.EntityTypeUtils;
import org.molgenis.data.validation.ConstraintViolation;
import org.molgenis.data.validation.DefaultValueReferenceValidator;
import org.molgenis.data.validation.MolgenisValidationException;
import org.springframework.stereotype.Component;

@Component
class DefaultValueReferenceValidatorImpl
implements DefaultValueReferenceValidator {
    private final DataService dataService;

    DefaultValueReferenceValidatorImpl(DataService dataService) {
        this.dataService = Objects.requireNonNull(dataService);
    }

    @Override
    public void validateEntityNotReferenced(Entity entity) {
        this.validateEntityNotReferencedById(entity.getIdValue(), entity.getEntityType());
    }

    @Override
    public Stream<Entity> validateEntitiesNotReferenced(Stream<Entity> entityStream, EntityType entityType) {
        Multimap<String, Attribute> defaultValueMap = this.getDefaultValueMap(entityType);
        return entityStream.filter(entity -> {
            this.validateEntityNotReferenced(entity.getIdValue(), entityType, defaultValueMap);
            return true;
        });
    }

    @Override
    public void validateEntityNotReferencedById(Object entityId, EntityType entityType) {
        this.validateEntityNotReferenced(entityId, entityType, this.getDefaultValueMap(entityType));
    }

    @Override
    public Stream<Object> validateEntitiesNotReferencedById(Stream<Object> entityIdStream, EntityType entityType) {
        Multimap<String, Attribute> defaultValueMap = this.getDefaultValueMap(entityType);
        return entityIdStream.filter(entityId -> {
            this.validateEntityNotReferenced(entityId, entityType, defaultValueMap);
            return true;
        });
    }

    private void validateEntityNotReferenced(Object entityId, EntityType entityType, Multimap<String, Attribute> defaultValueMultiMap) {
        if (defaultValueMultiMap.containsKey((Object)DefaultValueReferenceValidatorImpl.toAttributeDefaultValue(entityId))) {
            Collection attributes = defaultValueMultiMap.get((Object)DefaultValueReferenceValidatorImpl.toAttributeDefaultValue(entityId));
            throw new MolgenisValidationException(new ConstraintViolation(String.format("'%s' with id '%s' is referenced as default value by attribute(s): '%s'", entityType.getLabel(), entityId.toString(), attributes.stream().map(Attribute::getName).collect(Collectors.joining(", ")))));
        }
    }

    @Override
    public void validateEntityTypeNotReferenced(EntityType entityType) {
        if (!this.getDefaultValueMap(entityType).isEmpty()) {
            throw new MolgenisValidationException(new ConstraintViolation(String.format("'%s' entities are referenced as default value by attributes", entityType.getLabel())));
        }
    }

    private Multimap<String, Attribute> getDefaultValueMap(EntityType entityType) {
        LinkedHashMultimap defaultValueMultiMap = LinkedHashMultimap.create();
        this.dataService.query("sys_md_Attribute", Attribute.class).eq("refEntityType", entityType.getIdValue()).and().not().eq("defaultValue", null).findAll().forEach(arg_0 -> DefaultValueReferenceValidatorImpl.lambda$getDefaultValueMap$3((Multimap)defaultValueMultiMap, arg_0));
        return defaultValueMultiMap;
    }

    private static String toAttributeDefaultValue(Object id) {
        return id.toString();
    }

    private static /* synthetic */ void lambda$getDefaultValueMap$3(Multimap defaultValueMultiMap, Attribute attribute) {
        if (EntityTypeUtils.isSingleReferenceType((Attribute)attribute)) {
            Entity defaultEntityValue2 = (Entity)AttributeUtils.getDefaultTypedValue((Attribute)attribute);
            defaultValueMultiMap.put((Object)defaultEntityValue2.getIdValue().toString(), (Object)attribute);
        } else if (EntityTypeUtils.isMultipleReferenceType((Attribute)attribute)) {
            Iterable defaultEntitiesValue = (Iterable)AttributeUtils.getDefaultTypedValue((Attribute)attribute);
            defaultEntitiesValue.forEach(defaultEntityValue -> defaultValueMultiMap.put((Object)defaultEntityValue.getIdValue().toString(), (Object)attribute));
        }
    }
}

