/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.validation;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.molgenis.data.Entity;
import org.molgenis.js.magma.JsMagmaScriptEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExpressionValidator {
    private static final Logger LOG = LoggerFactory.getLogger(ExpressionValidator.class);
    private final JsMagmaScriptEvaluator jsMagmaScriptEvaluator;

    public ExpressionValidator(JsMagmaScriptEvaluator jsMagmaScriptEvaluator) {
        this.jsMagmaScriptEvaluator = Objects.requireNonNull(jsMagmaScriptEvaluator);
    }

    boolean resolveBooleanExpression(String expression, Entity entity) {
        return this.resolveBooleanExpressions(Collections.singletonList(expression), entity).get(0);
    }

    List<Boolean> resolveBooleanExpressions(List<String> expressions, Entity entity) {
        if (expressions.isEmpty()) {
            return Collections.emptyList();
        }
        return this.jsMagmaScriptEvaluator.eval(expressions, entity).stream().map(this::convertToBoolean).collect(Collectors.toList());
    }

    private Boolean convertToBoolean(Object value) {
        return Optional.ofNullable(value).map(Object::toString).map(Boolean::valueOf).orElse(null);
    }
}

