/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.validation;

import java.util.stream.Collectors;
import org.everit.json.schema.Schema;
import org.everit.json.schema.SchemaException;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.validation.ConstraintViolation;
import org.molgenis.data.validation.MolgenisValidationException;
import org.springframework.stereotype.Component;

@Component
public class JsonValidator {
    public Schema loadSchema(String schema) {
        try {
            JSONObject rawSchema = new JSONObject(new JSONTokener(schema));
            return SchemaLoader.load((JSONObject)rawSchema);
        }
        catch (SchemaException | JSONException e) {
            throw new MolgenisDataException("Failed to load JSON schema", e);
        }
    }

    public void validate(String json, Schema schema) {
        try {
            schema.validate((Object)new JSONObject(json));
        }
        catch (ValidationException validationException) {
            throw new MolgenisValidationException(validationException.getAllMessages().stream().map(ConstraintViolation::new).collect(Collectors.toSet()));
        }
    }

    public void validate(String json, String schemaJson) {
        Schema schema = this.loadSchema(schemaJson);
        this.validate(json, schema);
    }
}

