/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.validation;

import java.util.Objects;
import java.util.stream.Stream;
import org.molgenis.data.AbstractRepositoryDecorator;
import org.molgenis.data.Entity;
import org.molgenis.data.Query;
import org.molgenis.data.Repository;
import org.molgenis.data.validation.QueryValidator;

public class QueryValidationRepositoryDecorator<E extends Entity>
extends AbstractRepositoryDecorator<E> {
    private final QueryValidator queryValidator;

    public QueryValidationRepositoryDecorator(Repository<E> delegateRepository, QueryValidator queryValidator) {
        super(delegateRepository);
        this.queryValidator = Objects.requireNonNull(queryValidator);
    }

    public long count(Query<E> q) {
        this.queryValidator.validate(q, this.getEntityType());
        return super.count(q);
    }

    public Stream<E> findAll(Query<E> q) {
        this.queryValidator.validate(q, this.getEntityType());
        return super.findAll(q);
    }

    public E findOne(Query<E> q) {
        this.queryValidator.validate(q, this.getEntityType());
        return (E)super.findOne(q);
    }
}

