/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.validation;

import java.time.Instant;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityManager;
import org.molgenis.data.Query;
import org.molgenis.data.QueryRule;
import org.molgenis.data.QueryUtils;
import org.molgenis.data.UnknownAttributeException;
import org.molgenis.data.file.model.FileMeta;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.util.MolgenisDateFormat;
import org.molgenis.data.validation.ConstraintViolation;
import org.molgenis.data.validation.MolgenisValidationException;
import org.molgenis.util.UnexpectedEnumException;
import org.springframework.stereotype.Component;

@Component
public class QueryValidator {
    private final EntityManager entityManager;

    public QueryValidator(EntityManager entityManager) {
        this.entityManager = Objects.requireNonNull(entityManager);
    }

    public void validate(Query<? extends Entity> query, EntityType entityType) {
        query.getRules().forEach(queryRule -> this.validateQueryRule((QueryRule)queryRule, entityType));
    }

    private void validateQueryRule(QueryRule queryRule, EntityType entityType) {
        QueryRule.Operator operator = queryRule.getOperator();
        switch (operator) {
            case AND: 
            case NOT: 
            case OR: {
                break;
            }
            case EQUALS: 
            case FUZZY_MATCH: 
            case FUZZY_MATCH_NGRAM: 
            case GREATER: 
            case GREATER_EQUAL: 
            case LESS: 
            case LESS_EQUAL: 
            case LIKE: {
                Attribute attr = this.getQueryRuleAttribute(queryRule, entityType);
                Object value2 = this.toQueryRuleValue(queryRule.getValue(), attr);
                queryRule.setValue(value2);
                break;
            }
            case SEARCH: {
                Object queryRuleValue = queryRule.getValue();
                if (queryRuleValue == null || queryRuleValue instanceof String) break;
                queryRule.setValue((Object)queryRuleValue.toString());
                break;
            }
            case IN: 
            case RANGE: {
                Attribute attr = this.getQueryRuleAttribute(queryRule, entityType);
                Object queryRuleValue = queryRule.getValue();
                if (queryRuleValue == null) break;
                if (!(queryRuleValue instanceof Iterable)) {
                    throw new MolgenisValidationException(new ConstraintViolation(String.format("Query rule with operator [%s] value is of type [%s] instead of [Iterable]", operator, queryRuleValue.getClass().getSimpleName())));
                }
                Iterable queryRuleValues = (Iterable)queryRuleValue;
                List values = StreamSupport.stream(queryRuleValues.spliterator(), false).map(value -> this.toQueryRuleValue(value, attr)).collect(Collectors.toList());
                queryRule.setValue(values);
                break;
            }
            case DIS_MAX: 
            case NESTED: 
            case SHOULD: {
                queryRule.getNestedRules().forEach(nestedQueryRule -> this.validateQueryRule((QueryRule)nestedQueryRule, entityType));
                break;
            }
            default: {
                throw new UnexpectedEnumException((Enum)operator);
            }
        }
    }

    private Attribute getQueryRuleAttribute(QueryRule queryRule, EntityType entityType) {
        try {
            return QueryUtils.getQueryRuleAttribute((QueryRule)queryRule, (EntityType)entityType);
        }
        catch (UnknownAttributeException e) {
            throw new MolgenisValidationException(new ConstraintViolation(e.getMessage()));
        }
    }

    private Object toQueryRuleValue(Object queryRuleValue, Attribute attr) {
        Object value;
        AttributeType attrType = attr.getDataType();
        switch (attrType) {
            case BOOL: {
                value = QueryValidator.convertBool(attr, queryRuleValue);
                break;
            }
            case EMAIL: 
            case HTML: 
            case HYPERLINK: 
            case SCRIPT: 
            case STRING: 
            case TEXT: {
                value = QueryValidator.convertString(attr, queryRuleValue);
                break;
            }
            case ENUM: {
                value = QueryValidator.convertEnum(attr, queryRuleValue);
                break;
            }
            case CATEGORICAL: 
            case XREF: 
            case CATEGORICAL_MREF: 
            case MREF: 
            case ONE_TO_MANY: {
                value = this.convertRef(attr, queryRuleValue);
                break;
            }
            case DATE: {
                value = QueryValidator.convertDate(attr, queryRuleValue);
                break;
            }
            case DATE_TIME: {
                value = QueryValidator.convertDateTime(attr, queryRuleValue);
                break;
            }
            case DECIMAL: {
                value = QueryValidator.convertDecimal(attr, queryRuleValue);
                break;
            }
            case FILE: {
                value = this.convertFile(attr, queryRuleValue);
                break;
            }
            case INT: {
                value = QueryValidator.convertInt(attr, queryRuleValue);
                break;
            }
            case LONG: {
                value = QueryValidator.convertLong(attr, queryRuleValue);
                break;
            }
            case COMPOUND: {
                throw new MolgenisValidationException(new ConstraintViolation(String.format("Attribute [%s] type [%s] is not allowed", attr.getName(), attrType.toString())));
            }
            default: {
                throw new UnexpectedEnumException((Enum)attrType);
            }
        }
        return value;
    }

    private static String convertEnum(Attribute attr, Object value) {
        String stringValue;
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            stringValue = (String)value;
        } else if (value instanceof Enum) {
            stringValue = value.toString();
        } else {
            throw new MolgenisValidationException(new ConstraintViolation(String.format("Attribute [%s] value is of type [%s] instead of [%s] or [%s]", attr.getName(), value.getClass().getSimpleName(), String.class.getSimpleName(), Enum.class.getSimpleName())));
        }
        if (!attr.getEnumOptions().contains(stringValue)) {
            throw new MolgenisValidationException(new ConstraintViolation(String.format("Attribute [%s] value [%s] is not a valid enum option", attr.getName(), stringValue)));
        }
        return stringValue;
    }

    private static Long convertLong(Attribute attr, Object value) {
        Long longValue;
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            try {
                longValue = Long.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new MolgenisValidationException(new ConstraintViolation(String.format("Attribute [%s] value [%s] cannot be converter to type [%s]", attr.getName(), value, Long.class.getSimpleName())));
            }
        } else if (value instanceof Number) {
            longValue = ((Number)value).longValue();
        } else {
            throw new MolgenisValidationException(new ConstraintViolation(String.format("Attribute [%s] value is of type [%s] instead of [%s] or [%s]", attr.getName(), value.getClass().getSimpleName(), String.class.getSimpleName(), Number.class.getSimpleName())));
        }
        return longValue;
    }

    private static Integer convertInt(Attribute attr, Object value) {
        Integer integerValue;
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            try {
                integerValue = Integer.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new MolgenisValidationException(new ConstraintViolation(String.format("Attribute [%s] value [%s] cannot be converter to type [%s]", attr.getName(), value, Integer.class.getSimpleName())));
            }
        } else if (value instanceof Number) {
            integerValue = ((Number)value).intValue();
        } else {
            throw new MolgenisValidationException(new ConstraintViolation(String.format("Attribute [%s] value is of type [%s] instead of [%s] or [%s]", attr.getName(), value.getClass().getSimpleName(), String.class.getSimpleName(), Number.class.getSimpleName())));
        }
        return integerValue;
    }

    private FileMeta convertFile(Attribute attr, Object paramValue) {
        Entity entity = this.convertRef(attr, paramValue);
        if (entity == null) {
            return null;
        }
        if (!(entity instanceof FileMeta)) {
            throw new MolgenisValidationException(new ConstraintViolation(String.format("Attribute [%s] value is of type [%s] instead of [%s]", attr.getName(), entity.getClass().getSimpleName(), FileMeta.class.getSimpleName())));
        }
        return (FileMeta)entity;
    }

    private static Double convertDecimal(Attribute attr, Object value) {
        Double doubleValue;
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            try {
                doubleValue = Double.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new MolgenisValidationException(new ConstraintViolation(String.format("Attribute [%s] value [%s] cannot be converter to type [%s]", attr.getName(), value, Double.class.getSimpleName())));
            }
        } else if (value instanceof Number) {
            doubleValue = ((Number)value).doubleValue();
        } else {
            throw new MolgenisValidationException(new ConstraintViolation(String.format("Attribute [%s] value is of type [%s] instead of [%s] or [%s]", attr.getName(), value.getClass().getSimpleName(), String.class.getSimpleName(), Number.class.getSimpleName())));
        }
        return doubleValue;
    }

    private static Instant convertDateTime(Attribute attr, Object value) {
        Instant dateValue;
        if (value instanceof Instant) {
            return (Instant)value;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String paramStrValue = (String)value;
            try {
                dateValue = MolgenisDateFormat.parseInstant((String)paramStrValue);
            }
            catch (DateTimeParseException e) {
                throw new MolgenisValidationException(new ConstraintViolation(String.format("Failed to parse attribute [%s] value [%s] as datetime. Valid datetime format is [YYYY-MM-DDThh:mm:ssZ]", attr.getName(), paramStrValue)));
            }
        } else {
            throw new MolgenisValidationException(new ConstraintViolation(String.format("Attribute [%s] value is of type [%s] instead of [%s] or [%s]", attr.getName(), value.getClass().getSimpleName(), String.class.getSimpleName(), Instant.class.getSimpleName())));
        }
        return dateValue;
    }

    private static LocalDate convertDate(Attribute attr, Object value) {
        LocalDate dateValue;
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            String paramStrValue = (String)value;
            try {
                dateValue = MolgenisDateFormat.parseLocalDate((String)paramStrValue);
            }
            catch (DateTimeParseException e) {
                throw new MolgenisValidationException(new ConstraintViolation(String.format("Failed to parse attribute [%s] value [%s] as date. Valid date format is [YYYY-MM-DD].", attr.getName(), paramStrValue)));
            }
        } else {
            throw new MolgenisValidationException(new ConstraintViolation(String.format("Attribute [%s] value is of type [%s] instead of [%s] or [%s].", attr.getName(), value.getClass().getSimpleName(), LocalDate.class.getSimpleName(), String.class.getSimpleName())));
        }
        return dateValue;
    }

    private Entity convertRef(Attribute attr, Object value) {
        if (value instanceof Entity) {
            return (Entity)value;
        }
        if (value == null) {
            return null;
        }
        Object idValue = this.toQueryRuleValue(value, attr.getRefEntity().getIdAttribute());
        return this.entityManager.getReference(attr.getRefEntity(), idValue);
    }

    private static String convertString(Attribute attr, Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Boolean convertBool(Attribute attr, Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value == null) {
            return null;
        }
        if (!(value instanceof String)) throw new MolgenisValidationException(new ConstraintViolation(String.format("Attribute [%s] value is of type [%s] instead of [%s] or [%s]", attr.getName(), value.getClass().getSimpleName(), String.class.getSimpleName(), Boolean.class.getSimpleName())));
        String stringValue = (String)value;
        if (stringValue.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return true;
        }
        if (!stringValue.equalsIgnoreCase(Boolean.FALSE.toString())) throw new MolgenisValidationException(new ConstraintViolation(String.format("Attribute [%s] value [%s] cannot be converter to type [%s]", attr.getName(), value, Boolean.class.getSimpleName())));
        return false;
    }
}

