/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.validation;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.molgenis.data.AbstractRepositoryDecorator;
import org.molgenis.data.DataConverter;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.Fetch;
import org.molgenis.data.Query;
import org.molgenis.data.Repository;
import org.molgenis.data.RepositoryCapability;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.support.EntityTypeUtils;
import org.molgenis.data.support.QueryImpl;
import org.molgenis.data.validation.ConstraintViolation;
import org.molgenis.data.validation.DefaultValueReferenceValidator;
import org.molgenis.data.validation.EntityAttributesValidator;
import org.molgenis.data.validation.MolgenisValidationException;
import org.molgenis.util.HugeMap;
import org.molgenis.util.HugeSet;

public class RepositoryValidationDecorator
extends AbstractRepositoryDecorator<Entity> {
    private final DataService dataService;
    private final EntityAttributesValidator entityAttributesValidator;
    private final DefaultValueReferenceValidator defaultValueReferenceValidator;

    public RepositoryValidationDecorator(DataService dataService, Repository<Entity> delegateRepository, EntityAttributesValidator entityAttributesValidator, DefaultValueReferenceValidator defaultValueReferenceValidator) {
        super(delegateRepository);
        this.dataService = Objects.requireNonNull(dataService);
        this.entityAttributesValidator = Objects.requireNonNull(entityAttributesValidator);
        this.defaultValueReferenceValidator = defaultValueReferenceValidator;
    }

    public void update(Entity entity) {
        try (ValidationResource validationResource = new ValidationResource();){
            this.validate(entity, validationResource, ValidationMode.UPDATE);
        }
        this.delegate().update(entity);
    }

    public void update(Stream<Entity> entities) {
        try (ValidationResource validationResource = new ValidationResource();){
            entities = this.validate(entities, validationResource, ValidationMode.UPDATE);
            this.delegate().update(entities);
        }
    }

    public void add(Entity entity) {
        try (ValidationResource validationResource = new ValidationResource();){
            this.validate(entity, validationResource, ValidationMode.ADD);
        }
        this.delegate().add(entity);
    }

    public Integer add(Stream<Entity> entities) {
        try (ValidationResource validationResource = new ValidationResource();){
            entities = this.validate(entities, validationResource, ValidationMode.ADD);
            Integer n = this.delegate().add(entities);
            return n;
        }
    }

    public void delete(Entity entity) {
        this.defaultValueReferenceValidator.validateEntityNotReferenced(entity);
        this.delegate().delete(entity);
    }

    public void deleteById(Object id) {
        this.defaultValueReferenceValidator.validateEntityNotReferencedById(id, this.getEntityType());
        this.delegate().deleteById(id);
    }

    public void deleteAll() {
        this.defaultValueReferenceValidator.validateEntityTypeNotReferenced(this.getEntityType());
        this.delegate().deleteAll();
    }

    public void delete(Stream<Entity> entities) {
        this.delegate().delete(this.defaultValueReferenceValidator.validateEntitiesNotReferenced(entities, this.getEntityType()));
    }

    public void deleteAll(Stream<Object> ids) {
        this.delegate().deleteAll(this.defaultValueReferenceValidator.validateEntitiesNotReferencedById(ids, this.getEntityType()));
    }

    private Stream<Entity> validate(Stream<Entity> entities, ValidationResource validationResource, ValidationMode validationMode) {
        this.initValidation(validationResource, validationMode);
        ValidationProfile validationProfile = new ValidationProfile().invoke();
        return entities.filter(entity -> {
            this.validate((Entity)entity, validationResource, validationMode, validationProfile);
            return true;
        });
    }

    private void validate(Entity entity, ValidationResource validationResource, ValidationMode validationMode) {
        this.initValidation(validationResource, validationMode);
        this.validate(entity, validationResource, validationMode, new ValidationProfile().invoke());
    }

    private void validate(Entity entity, ValidationResource validationResource, ValidationMode validationMode, ValidationProfile validationProfile) {
        validationResource.incrementRow();
        this.validateEntityValueTypes(entity, validationResource);
        if (validationResource.hasViolations()) {
            throw new MolgenisValidationException(validationResource.getViolations());
        }
        if (validationProfile.isValidateRequired()) {
            this.validateEntityValueRequired(entity, validationResource);
        }
        if (validationProfile.isValidateUniqueness()) {
            this.validateEntityValueUniqueness(entity, validationResource, validationMode);
        }
        this.validateEntityValueReferences(entity, validationResource);
        if (validationProfile.isValidateReadonly() && validationMode == ValidationMode.UPDATE) {
            this.validateEntityValueReadOnly(entity, validationResource);
        }
        if (validationResource.hasViolations()) {
            throw new MolgenisValidationException(validationResource.getViolations());
        }
    }

    private void initValidation(ValidationResource validationResource, ValidationMode validationMode) {
        this.initRequiredValueValidation(validationResource);
        this.initReferenceValidation(validationResource);
        this.initUniqueValidation(validationResource);
        if (validationMode == ValidationMode.UPDATE) {
            this.initReadonlyValidation(validationResource);
        }
    }

    private void initRequiredValueValidation(ValidationResource validationResource) {
        if (!this.getCapabilities().contains(RepositoryCapability.VALIDATE_NOTNULL_CONSTRAINT)) {
            List<Attribute> requiredValueAttrs = StreamSupport.stream(this.getEntityType().getAtomicAttributes().spliterator(), false).filter(attr -> !attr.isNillable() && attr.getExpression() == null).collect(Collectors.toList());
            validationResource.setRequiredValueAttrs(requiredValueAttrs);
        }
    }

    private void initReferenceValidation(ValidationResource validationResource) {
        List<Attribute> refAttrs;
        if (!this.getCapabilities().contains(RepositoryCapability.VALIDATE_REFERENCE_CONSTRAINT)) {
            refAttrs = StreamSupport.stream(this.getEntityType().getAtomicAttributes().spliterator(), false).filter(attr -> EntityTypeUtils.isReferenceType((Attribute)attr) && attr.getExpression() == null).collect(Collectors.toList());
        } else {
            String backend = this.dataService.getMeta().getBackend(this.getEntityType()).getName();
            refAttrs = StreamSupport.stream(this.getEntityType().getAtomicAttributes().spliterator(), false).filter(attr -> EntityTypeUtils.isReferenceType((Attribute)attr) && attr.getExpression() == null && this.isDifferentBackend(backend, (Attribute)attr)).collect(Collectors.toList());
        }
        if (!refAttrs.isEmpty()) {
            HashMap<String, HugeSet<Object>> refEntitiesIds = new HashMap<String, HugeSet<Object>>();
            refAttrs.forEach(refAttr -> {
                EntityType refEntityType = refAttr.getRefEntity();
                String refEntityName = refEntityType.getId();
                HugeSet refEntityIds = (HugeSet)refEntitiesIds.get(refEntityName);
                if (refEntityIds == null) {
                    refEntityIds = new HugeSet();
                    refEntitiesIds.put(refEntityName, refEntityIds);
                    Query q = new QueryImpl().fetch(new Fetch().field(refEntityType.getIdAttribute().getName()));
                    Iterator it = this.dataService.findAll(refEntityName, q).iterator();
                    while (it.hasNext()) {
                        refEntityIds.add(((Entity)it.next()).getIdValue());
                    }
                }
            });
            validationResource.setRefEntitiesIds(refEntitiesIds);
        }
        validationResource.setSelfReferencing(refAttrs.stream().anyMatch(refAttr -> refAttr.getRefEntity().getId().equals(this.getEntityType().getId())));
        validationResource.setRefAttrs(refAttrs);
    }

    private boolean isDifferentBackend(String backend, Attribute attr) {
        EntityType refEntity = attr.getRefEntity();
        String refEntityBackend = this.dataService.getMeta().getBackend(refEntity).getName();
        return !backend.equals(refEntityBackend);
    }

    private void initUniqueValidation(ValidationResource validationResource) {
        if (!this.getCapabilities().contains(RepositoryCapability.VALIDATE_UNIQUE_CONSTRAINT)) {
            List<Attribute> uniqueAttrs = StreamSupport.stream(this.getEntityType().getAtomicAttributes().spliterator(), false).filter(attr -> attr.isUnique() && attr.getExpression() == null).collect(Collectors.toList());
            if (!uniqueAttrs.isEmpty()) {
                HashMap<String, HugeMap<Object, Object>> uniqueAttrsValues = new HashMap<String, HugeMap<Object, Object>>();
                Fetch fetch = new Fetch();
                uniqueAttrs.forEach(uniqueAttr -> {
                    uniqueAttrsValues.put(uniqueAttr.getName(), new HugeMap());
                    fetch.field(uniqueAttr.getName());
                });
                Query q = new QueryImpl().fetch(fetch);
                this.delegate().findAll(q).forEach(entity -> uniqueAttrs.forEach(uniqueAttr -> {
                    HugeMap uniqueAttrValues = (HugeMap)uniqueAttrsValues.get(uniqueAttr.getName());
                    Object attrValue = entity.get(uniqueAttr.getName());
                    if (attrValue != null) {
                        if (EntityTypeUtils.isSingleReferenceType((Attribute)uniqueAttr)) {
                            attrValue = ((Entity)attrValue).getIdValue();
                        }
                        uniqueAttrValues.put(attrValue, entity.getIdValue());
                    }
                }));
                validationResource.setUniqueAttrsValues(uniqueAttrsValues);
            }
            validationResource.setUniqueAttrs(uniqueAttrs);
        }
    }

    private void initReadonlyValidation(ValidationResource validationResource) {
        if (!this.getCapabilities().contains(RepositoryCapability.VALIDATE_READONLY_CONSTRAINT)) {
            String idAttrName = this.getEntityType().getIdAttribute().getName();
            List<Attribute> readonlyAttrs = StreamSupport.stream(this.getEntityType().getAtomicAttributes().spliterator(), false).filter(attr -> attr.isReadOnly() && attr.getExpression() == null && !attr.isMappedBy() && !attr.getName().equals(idAttrName)).collect(Collectors.toList());
            validationResource.setReadonlyAttrs(readonlyAttrs);
        }
    }

    private void validateEntityValueRequired(Entity entity, ValidationResource validationResource) {
        validationResource.getRequiredValueAttrs().forEach(nonNillableAttr -> {
            Object value = entity.get(nonNillableAttr.getName());
            if (value == null || EntityTypeUtils.isMultipleReferenceType((Attribute)nonNillableAttr) && !entity.getEntities(nonNillableAttr.getName()).iterator().hasNext()) {
                ConstraintViolation constraintViolation = new ConstraintViolation(String.format("The attribute '%s' of entity '%s' can not be null.", nonNillableAttr.getName(), this.getName()), Long.valueOf(validationResource.getRow()));
                validationResource.addViolation(constraintViolation);
            }
        });
    }

    private void validateEntityValueTypes(Entity entity, ValidationResource validationResource) {
        Set<ConstraintViolation> attrViolations = this.entityAttributesValidator.validate(entity, this.getEntityType());
        if (attrViolations != null && !attrViolations.isEmpty()) {
            attrViolations.forEach(validationResource::addViolation);
        }
    }

    private void validateEntityValueUniqueness(Entity entity, ValidationResource validationResource, ValidationMode validationMode) {
        validationResource.getUniqueAttrs().forEach(uniqueAttr -> {
            Object attrValue = entity.get(uniqueAttr.getName());
            if (attrValue != null) {
                if (EntityTypeUtils.isSingleReferenceType((Attribute)uniqueAttr)) {
                    attrValue = ((Entity)attrValue).getIdValue();
                }
                HugeMap<Object, Object> uniqueAttrValues = validationResource.getUniqueAttrsValues().get(uniqueAttr.getName());
                Object existingEntityId = uniqueAttrValues.get(attrValue);
                if (validationMode == ValidationMode.ADD && existingEntityId != null || validationMode == ValidationMode.UPDATE && existingEntityId != null && !existingEntityId.equals(entity.getIdValue())) {
                    ConstraintViolation constraintViolation = new ConstraintViolation(String.format("Duplicate value '%s' for unique attribute '%s' from entity '%s'", attrValue, uniqueAttr.getName(), this.getName()), Long.valueOf(validationResource.getRow()));
                    validationResource.addViolation(constraintViolation);
                } else {
                    uniqueAttrValues.put(attrValue, entity.getIdValue());
                }
            }
        });
    }

    private void validateEntityValueReferences(Entity entity, ValidationResource validationResource) {
        validationResource.getRefAttrs().forEach(refAttr -> {
            Entity refEntity;
            HugeSet<Object> refEntityIds = validationResource.getRefEntitiesIds().get(refAttr.getRefEntity().getId());
            Collection<Object> refEntities = EntityTypeUtils.isSingleReferenceType((Attribute)refAttr) ? ((refEntity = entity.getEntity(refAttr.getName())) != null ? Collections.singleton(refEntity) : Collections.emptyList()) : entity.getEntities(refAttr.getName());
            for (Entity refEntity2 : refEntities) {
                boolean selfReference;
                if (refEntityIds.contains(refEntity2.getIdValue()) || (selfReference = entity.getEntityType().getId().equals(refAttr.getRefEntity().getId())) && entity.getIdValue().equals(refEntity2.getIdValue())) continue;
                String message = String.format("Unknown xref value '%s' for attribute '%s' of entity '%s'.", DataConverter.toString((Object)refEntity2.getIdValue()), refAttr.getName(), this.getName());
                ConstraintViolation constraintViolation = new ConstraintViolation(message, Long.valueOf(validationResource.getRow()));
                validationResource.addViolation(constraintViolation);
            }
            if (validationResource.isSelfReferencing()) {
                validationResource.addRefEntityId(this.getName(), entity.getIdValue());
            }
        });
    }

    private void validateEntityValueReadOnly(Entity entity, ValidationResource validationResource) {
        if (validationResource.getReadonlyAttrs().isEmpty()) {
            return;
        }
        Entity entityToUpdate = this.findOneById(entity.getIdValue());
        validationResource.getReadonlyAttrs().forEach(readonlyAttr -> {
            List value = entity.get(readonlyAttr.getName());
            List existingValue = entityToUpdate.get(readonlyAttr.getName());
            if (EntityTypeUtils.isSingleReferenceType((Attribute)readonlyAttr)) {
                if (value != null) {
                    value = ((Entity)value).getIdValue();
                }
                if (existingValue != null) {
                    existingValue = ((Entity)existingValue).getIdValue();
                }
            } else if (EntityTypeUtils.isMultipleReferenceType((Attribute)readonlyAttr)) {
                value = StreamSupport.stream(entity.getEntities(readonlyAttr.getName()).spliterator(), false).map(Entity::getIdValue).collect(Collectors.toList());
                existingValue = StreamSupport.stream(entityToUpdate.getEntities(readonlyAttr.getName()).spliterator(), false).map(Entity::getIdValue).collect(Collectors.toList());
            }
            if (value != null && existingValue != null && !((Object)value).equals(existingValue)) {
                validationResource.addViolation(new ConstraintViolation(String.format("The attribute '%s' of entity '%s' can not be changed it is readonly.", readonlyAttr.getName(), this.getName()), Long.valueOf(validationResource.getRow())));
            }
        });
    }

    private class ValidationProfile {
        private boolean validateRequired;
        private boolean validateUniqueness;
        private boolean validateReadonly;

        private ValidationProfile() {
        }

        boolean isValidateRequired() {
            return this.validateRequired;
        }

        boolean isValidateUniqueness() {
            return this.validateUniqueness;
        }

        boolean isValidateReadonly() {
            return this.validateReadonly;
        }

        public ValidationProfile invoke() {
            this.validateRequired = !RepositoryValidationDecorator.this.getCapabilities().contains(RepositoryCapability.VALIDATE_NOTNULL_CONSTRAINT);
            this.validateUniqueness = !RepositoryValidationDecorator.this.getCapabilities().contains(RepositoryCapability.VALIDATE_UNIQUE_CONSTRAINT);
            this.validateReadonly = !RepositoryValidationDecorator.this.getCapabilities().contains(RepositoryCapability.VALIDATE_READONLY_CONSTRAINT);
            return this;
        }
    }

    private static class ValidationResource
    implements AutoCloseable {
        private AtomicInteger rowNr = new AtomicInteger();
        private List<Attribute> requiredValueAttrs;
        private List<Attribute> refAttrs;
        private Map<String, HugeSet<Object>> refEntitiesIds;
        private List<Attribute> uniqueAttrs;
        private Map<String, HugeMap<Object, Object>> uniqueAttrsValues;
        private List<Attribute> readonlyAttrs;
        private boolean selfReferencing;
        private Set<ConstraintViolation> violations;

        public int getRow() {
            return this.rowNr.get();
        }

        public void incrementRow() {
            this.rowNr.incrementAndGet();
        }

        public List<Attribute> getRequiredValueAttrs() {
            return this.requiredValueAttrs != null ? Collections.unmodifiableList(this.requiredValueAttrs) : Collections.emptyList();
        }

        public void setRequiredValueAttrs(List<Attribute> requiredValueAttrs) {
            this.requiredValueAttrs = requiredValueAttrs;
        }

        public List<Attribute> getRefAttrs() {
            return Collections.unmodifiableList(this.refAttrs);
        }

        public void setRefAttrs(List<Attribute> refAttrs) {
            this.refAttrs = refAttrs;
        }

        public Map<String, HugeSet<Object>> getRefEntitiesIds() {
            return this.refEntitiesIds != null ? Collections.unmodifiableMap(this.refEntitiesIds) : Collections.emptyMap();
        }

        public void setRefEntitiesIds(Map<String, HugeSet<Object>> refEntitiesIds) {
            this.refEntitiesIds = refEntitiesIds;
        }

        public void addRefEntityId(String name, Object idValue) {
            HugeSet<Object> refEntityIds = this.refEntitiesIds.get(name);
            if (refEntityIds != null) {
                refEntityIds.add(idValue);
            }
        }

        public List<Attribute> getUniqueAttrs() {
            return this.uniqueAttrs != null ? Collections.unmodifiableList(this.uniqueAttrs) : Collections.emptyList();
        }

        public void setUniqueAttrs(List<Attribute> uniqueAttrs) {
            this.uniqueAttrs = uniqueAttrs;
        }

        public Map<String, HugeMap<Object, Object>> getUniqueAttrsValues() {
            return this.uniqueAttrsValues != null ? Collections.unmodifiableMap(this.uniqueAttrsValues) : Collections.emptyMap();
        }

        public void setUniqueAttrsValues(Map<String, HugeMap<Object, Object>> uniqueAttrsValues) {
            this.uniqueAttrsValues = uniqueAttrsValues;
        }

        public List<Attribute> getReadonlyAttrs() {
            return this.readonlyAttrs != null ? Collections.unmodifiableList(this.readonlyAttrs) : Collections.emptyList();
        }

        public void setReadonlyAttrs(List<Attribute> readonlyAttrs) {
            this.readonlyAttrs = readonlyAttrs;
        }

        public void setSelfReferencing(boolean selfReferencing) {
            this.selfReferencing = selfReferencing;
        }

        public boolean isSelfReferencing() {
            return this.selfReferencing;
        }

        public boolean hasViolations() {
            return this.violations != null && !this.violations.isEmpty();
        }

        public void addViolation(ConstraintViolation constraintViolation) {
            if (this.violations == null) {
                this.violations = new LinkedHashSet<ConstraintViolation>();
            }
            this.violations.add(constraintViolation);
        }

        public Set<ConstraintViolation> getViolations() {
            return this.violations != null ? Collections.unmodifiableSet(this.violations) : Collections.emptySet();
        }

        @Override
        public void close() {
            if (this.refEntitiesIds != null) {
                for (HugeSet<Object> hugeSet : this.refEntitiesIds.values()) {
                    try {
                        hugeSet.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (this.uniqueAttrsValues != null) {
                for (HugeMap hugeMap : this.uniqueAttrsValues.values()) {
                    try {
                        hugeMap.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    private static enum ValidationMode {
        ADD,
        UPDATE;

    }
}

