/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.validation.meta;

import java.util.Objects;
import java.util.stream.Stream;
import org.molgenis.data.AbstractRepositoryDecorator;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.validation.meta.AttributeValidator;

public class AttributeRepositoryValidationDecorator
extends AbstractRepositoryDecorator<Attribute> {
    private final AttributeValidator attributeValidator;

    public AttributeRepositoryValidationDecorator(Repository<Attribute> delegateRepository, AttributeValidator attributeValidator) {
        super(delegateRepository);
        this.attributeValidator = Objects.requireNonNull(attributeValidator);
    }

    public void update(Attribute attr) {
        this.attributeValidator.validate(attr, AttributeValidator.ValidationMode.UPDATE);
        this.delegate().update((Entity)attr);
    }

    public void update(Stream<Attribute> attrs) {
        this.delegate().update(attrs.filter(attr -> {
            this.attributeValidator.validate((Attribute)attr, AttributeValidator.ValidationMode.UPDATE);
            return true;
        }));
    }

    public void add(Attribute attr) {
        this.attributeValidator.validate(attr, AttributeValidator.ValidationMode.ADD);
        this.delegate().add((Entity)attr);
    }

    public Integer add(Stream<Attribute> attrs) {
        return this.delegate().add(attrs.filter(attr -> {
            this.attributeValidator.validate((Attribute)attr, AttributeValidator.ValidationMode.ADD);
            return true;
        }));
    }
}

