/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.validation.meta;

import com.google.common.collect.Iterables;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hibernate.validator.internal.constraintvalidators.EmailValidator;
import org.molgenis.data.DataService;
import org.molgenis.data.Entity;
import org.molgenis.data.EntityManager;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.Sort;
import org.molgenis.data.meta.AttributeType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.support.AttributeUtils;
import org.molgenis.data.support.EntityTypeUtils;
import org.molgenis.data.util.EntityUtils;
import org.molgenis.data.validation.ConstraintViolation;
import org.molgenis.data.validation.MolgenisValidationException;
import org.molgenis.data.validation.meta.NameValidator;
import org.molgenis.util.UnexpectedEnumException;
import org.springframework.stereotype.Component;

@Component
public class AttributeValidator {
    private final DataService dataService;
    private final EntityManager entityManager;
    private final EmailValidator emailValidator;
    private static EnumMap<AttributeType, EnumSet<AttributeType>> DATA_TYPE_ALLOWED_TRANSITIONS = new EnumMap(AttributeType.class);

    public AttributeValidator(DataService dataService, EntityManager entityManager) {
        this.dataService = Objects.requireNonNull(dataService);
        this.entityManager = Objects.requireNonNull(entityManager);
        this.emailValidator = new EmailValidator();
    }

    public void validate(Attribute attr, ValidationMode validationMode) {
        AttributeValidator.validateName(attr);
        this.validateDefaultValue(attr, validationMode == ValidationMode.ADD || validationMode == ValidationMode.UPDATE);
        AttributeValidator.validateParent(attr);
        AttributeValidator.validateChildren(attr);
        switch (validationMode) {
            case ADD: 
            case ADD_SKIP_ENTITY_VALIDATION: {
                AttributeValidator.validateAdd(attr);
                break;
            }
            case UPDATE: 
            case UPDATE_SKIP_ENTITY_VALIDATION: {
                Attribute currentAttr = (Attribute)this.dataService.findOneById("sys_md_Attribute", (Object)attr.getIdentifier(), Attribute.class);
                AttributeValidator.validateUpdate(attr, currentAttr);
                break;
            }
            default: {
                throw new UnexpectedEnumException((Enum)validationMode);
            }
        }
    }

    private static void validateParent(Attribute attr) {
        if (attr.getParent() != null && attr.getParent().getDataType() != AttributeType.COMPOUND) {
            throw new MolgenisDataException(String.format("Parent attribute [%s] of attribute [%s] is not of type compound", attr.getParent().getName(), attr.getName()));
        }
    }

    private static void validateChildren(Attribute attr) {
        boolean childrenIsNullOrEmpty;
        boolean bl = childrenIsNullOrEmpty = attr.getChildren() == null || Iterables.isEmpty((Iterable)attr.getChildren());
        if (!childrenIsNullOrEmpty && attr.getDataType() != AttributeType.COMPOUND) {
            throw new MolgenisDataException(String.format("Attribute [%s] is not of type COMPOUND and can therefor not have children", attr.getName()));
        }
    }

    private static void validateAdd(Attribute newAttr) {
        AttributeValidator.validateMappedBy(newAttr, newAttr.getMappedBy());
        AttributeValidator.validateOrderBy(newAttr, newAttr.getOrderBy());
    }

    private static void validateUpdate(Attribute newAttr, Attribute currentAttr) {
        Sort newOrderBy;
        Sort currentOrderBy;
        AttributeType newDataType;
        AttributeType currentDataType = currentAttr.getDataType();
        if (!Objects.equals(currentDataType, newDataType = newAttr.getDataType())) {
            AttributeValidator.validateUpdateDataType(currentDataType, newDataType);
            if (newAttr.isInversedBy()) {
                throw new MolgenisDataException(String.format("Attribute data type change not allowed for bidirectional attribute [%s]", newAttr.getName()));
            }
        }
        if (!Objects.equals(currentOrderBy = currentAttr.getOrderBy(), newOrderBy = newAttr.getOrderBy())) {
            AttributeValidator.validateOrderBy(newAttr, newOrderBy);
        }
    }

    void validateDefaultValue(Attribute attr, boolean validateEntityReferences) {
        String value = attr.getDefaultValue();
        if (value != null) {
            Object typedValue;
            if (attr.isUnique()) {
                throw new MolgenisDataException("Unique attribute " + attr.getName() + " cannot have default value");
            }
            if (attr.getExpression() != null) {
                throw new MolgenisDataException("Computed attribute " + attr.getName() + " cannot have default value");
            }
            AttributeType fieldType = attr.getDataType();
            if (fieldType.getMaxLength() != null && (long)value.length() > fieldType.getMaxLength()) {
                throw new MolgenisDataException("Default value for attribute [" + attr.getName() + "] exceeds the maximum length for datatype " + attr.getDataType().name());
            }
            if (fieldType == AttributeType.EMAIL) {
                this.checkEmail(value);
            }
            if (fieldType == AttributeType.HYPERLINK) {
                AttributeValidator.checkHyperlink(value);
            }
            if (fieldType == AttributeType.ENUM) {
                AttributeValidator.checkEnum(attr, value);
            }
            try {
                typedValue = EntityUtils.getTypedValue((String)value, (Attribute)attr, (EntityManager)this.entityManager);
            }
            catch (NumberFormatException e) {
                throw new MolgenisValidationException(new ConstraintViolation(String.format("Invalid default value [%s] for data type [%s]", value, attr.getDataType())));
            }
            if (validateEntityReferences) {
                if (EntityTypeUtils.isSingleReferenceType((Attribute)attr)) {
                    Entity refEntity = (Entity)typedValue;
                    EntityType refEntityType = attr.getRefEntity();
                    if (this.dataService.query(refEntityType.getId()).eq(refEntityType.getIdAttribute().getName(), refEntity.getIdValue()).count() == 0L) {
                        throw new MolgenisValidationException(new ConstraintViolation(String.format("Default value [%s] refers to an unknown entity", value)));
                    }
                } else if (EntityTypeUtils.isMultipleReferenceType((Attribute)attr)) {
                    Iterable refEntitiesValue = (Iterable)typedValue;
                    EntityType refEntityType = attr.getRefEntity();
                    if (this.dataService.query(refEntityType.getId()).in(refEntityType.getIdAttribute().getName(), (Iterable)StreamSupport.stream(refEntitiesValue.spliterator(), false).map(Entity::getIdValue).collect(Collectors.toList())).count() < (long)Iterables.size((Iterable)refEntitiesValue)) {
                        throw new MolgenisValidationException(new ConstraintViolation(String.format("Default value [%s] refers to one or more unknown entities", value)));
                    }
                }
            }
        }
    }

    private void checkEmail(String value) {
        if (!this.emailValidator.isValid((CharSequence)value, null)) {
            throw new MolgenisDataException("Default value [" + value + "] is not a valid email address");
        }
    }

    private static void checkEnum(Attribute attr, String value) {
        List enumOptions;
        if (value != null && !(enumOptions = attr.getEnumOptions()).contains(value)) {
            throw new MolgenisDataException("Invalid default value [" + value + "] for enum [" + attr.getName() + "] value must be one of " + enumOptions.toString());
        }
    }

    private static void checkHyperlink(String value) {
        try {
            new URI(value);
        }
        catch (URISyntaxException e) {
            throw new MolgenisDataException("Default value [" + value + "] is not a valid hyperlink.");
        }
    }

    private static void validateName(Attribute attr) {
        String name = attr.getName();
        if (!(name.equals("sys_md_Attribute") || name.equals("sys_md_EntityType") || name.equals("sys_md_Package"))) {
            try {
                NameValidator.validateAttributeName(attr.getName());
            }
            catch (MolgenisDataException e) {
                throw new MolgenisValidationException(new ConstraintViolation(e.getMessage()));
            }
        }
    }

    private static void validateMappedBy(Attribute attr, Attribute mappedByAttr) {
        if (mappedByAttr != null) {
            if (!EntityTypeUtils.isSingleReferenceType((Attribute)mappedByAttr)) {
                throw new MolgenisDataException(String.format("Invalid mappedBy attribute [%s] data type [%s].", mappedByAttr.getName(), mappedByAttr.getDataType()));
            }
            Attribute refAttr = attr.getRefEntity().getAttribute(mappedByAttr.getName());
            if (refAttr == null) {
                throw new MolgenisDataException(String.format("mappedBy attribute [%s] is not part of entity [%s].", mappedByAttr.getName(), attr.getRefEntity().getId()));
            }
        }
    }

    private static void validateOrderBy(Attribute attr, Sort orderBy) {
        EntityType refEntity;
        if (orderBy != null && (refEntity = attr.getRefEntity()) != null) {
            for (Sort.Order orderClause : orderBy) {
                String refAttrName = orderClause.getAttr();
                if (refEntity.getAttribute(refAttrName) != null) continue;
                throw new MolgenisDataException(String.format("Unknown entity [%s] attribute [%s] referred to by entity [%s] attribute [%s] sortBy [%s]", refEntity.getId(), refAttrName, attr.getEntityType().getId(), attr.getName(), orderBy.toSortString()));
            }
        }
    }

    private static void validateUpdateDataType(AttributeType currentDataType, AttributeType newDataType) {
        EnumSet<AttributeType> allowedDatatypes = DATA_TYPE_ALLOWED_TRANSITIONS.get(currentDataType);
        if (!allowedDatatypes.contains(newDataType)) {
            throw new MolgenisDataException(String.format("Attribute data type update from [%s] to [%s] not allowed, allowed types are %s", currentDataType.toString(), newDataType.toString(), allowedDatatypes.toString()));
        }
    }

    static {
        Set allowedIdAttributeTypes = AttributeUtils.getValidIdAttributeTypes();
        DATA_TYPE_ALLOWED_TRANSITIONS.put(AttributeType.BOOL, EnumSet.of(AttributeType.STRING, AttributeType.TEXT, AttributeType.INT));
        DATA_TYPE_ALLOWED_TRANSITIONS.put(AttributeType.DATE, EnumSet.of(AttributeType.STRING, AttributeType.TEXT, AttributeType.DATE_TIME));
        DATA_TYPE_ALLOWED_TRANSITIONS.put(AttributeType.DATE_TIME, EnumSet.of(AttributeType.STRING, AttributeType.TEXT, AttributeType.DATE));
        DATA_TYPE_ALLOWED_TRANSITIONS.put(AttributeType.DECIMAL, EnumSet.of(AttributeType.STRING, AttributeType.TEXT, AttributeType.INT, AttributeType.LONG, AttributeType.ENUM));
        DATA_TYPE_ALLOWED_TRANSITIONS.put(AttributeType.INT, EnumSet.of(AttributeType.STRING, new AttributeType[]{AttributeType.TEXT, AttributeType.DECIMAL, AttributeType.LONG, AttributeType.BOOL, AttributeType.ENUM}));
        DATA_TYPE_ALLOWED_TRANSITIONS.put(AttributeType.LONG, EnumSet.of(AttributeType.STRING, AttributeType.TEXT, AttributeType.INT, AttributeType.DECIMAL, AttributeType.ENUM));
        DATA_TYPE_ALLOWED_TRANSITIONS.put(AttributeType.EMAIL, EnumSet.of(AttributeType.STRING, AttributeType.TEXT));
        DATA_TYPE_ALLOWED_TRANSITIONS.put(AttributeType.HYPERLINK, EnumSet.of(AttributeType.STRING, AttributeType.TEXT));
        DATA_TYPE_ALLOWED_TRANSITIONS.put(AttributeType.HTML, EnumSet.of(AttributeType.STRING, AttributeType.TEXT, AttributeType.SCRIPT));
        DATA_TYPE_ALLOWED_TRANSITIONS.put(AttributeType.CATEGORICAL, EnumSet.of(AttributeType.STRING, AttributeType.INT, AttributeType.LONG, AttributeType.XREF));
        DATA_TYPE_ALLOWED_TRANSITIONS.put(AttributeType.XREF, EnumSet.of(AttributeType.STRING, AttributeType.INT, AttributeType.LONG, AttributeType.CATEGORICAL));
        DATA_TYPE_ALLOWED_TRANSITIONS.put(AttributeType.MREF, EnumSet.of(AttributeType.CATEGORICAL_MREF));
        DATA_TYPE_ALLOWED_TRANSITIONS.put(AttributeType.CATEGORICAL_MREF, EnumSet.of(AttributeType.MREF));
        DATA_TYPE_ALLOWED_TRANSITIONS.put(AttributeType.SCRIPT, EnumSet.of(AttributeType.STRING, AttributeType.TEXT));
        DATA_TYPE_ALLOWED_TRANSITIONS.put(AttributeType.STRING, EnumSet.of(AttributeType.BOOL, new AttributeType[]{AttributeType.DATE, AttributeType.DATE_TIME, AttributeType.DECIMAL, AttributeType.INT, AttributeType.LONG, AttributeType.HTML, AttributeType.SCRIPT, AttributeType.TEXT, AttributeType.ENUM, AttributeType.COMPOUND}));
        DATA_TYPE_ALLOWED_TRANSITIONS.put(AttributeType.TEXT, EnumSet.of(AttributeType.BOOL, new AttributeType[]{AttributeType.DATE, AttributeType.DATE_TIME, AttributeType.DECIMAL, AttributeType.INT, AttributeType.LONG, AttributeType.HTML, AttributeType.SCRIPT, AttributeType.STRING, AttributeType.ENUM, AttributeType.COMPOUND}));
        DATA_TYPE_ALLOWED_TRANSITIONS.put(AttributeType.ENUM, EnumSet.of(AttributeType.STRING, AttributeType.INT, AttributeType.LONG, AttributeType.TEXT));
        DATA_TYPE_ALLOWED_TRANSITIONS.put(AttributeType.COMPOUND, EnumSet.of(AttributeType.STRING));
        DATA_TYPE_ALLOWED_TRANSITIONS.put(AttributeType.ONE_TO_MANY, EnumSet.noneOf(AttributeType.class));
        DATA_TYPE_ALLOWED_TRANSITIONS.put(AttributeType.FILE, EnumSet.noneOf(AttributeType.class));
        EnumSet<AttributeType> referenceTypes = EnumSet.of(AttributeType.XREF, AttributeType.CATEGORICAL);
        DATA_TYPE_ALLOWED_TRANSITIONS.keySet().stream().filter(allowedIdAttributeTypes::contains).forEach(type -> DATA_TYPE_ALLOWED_TRANSITIONS.get(type).addAll(referenceTypes));
    }

    public static enum ValidationMode {
        ADD,
        ADD_SKIP_ENTITY_VALIDATION,
        UPDATE,
        UPDATE_SKIP_ENTITY_VALIDATION;

    }
}

