/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.validation.meta;

import java.util.Objects;
import java.util.stream.Stream;
import org.molgenis.data.AbstractRepositoryDecorator;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.validation.meta.EntityTypeValidator;

public class EntityTypeRepositoryValidationDecorator
extends AbstractRepositoryDecorator<EntityType> {
    private final EntityTypeValidator entityTypeValidator;

    public EntityTypeRepositoryValidationDecorator(Repository<EntityType> delegateRepository, EntityTypeValidator entityTypeValidator) {
        super(delegateRepository);
        this.entityTypeValidator = Objects.requireNonNull(entityTypeValidator);
    }

    public void update(EntityType entityType) {
        this.entityTypeValidator.validate(entityType);
        this.delegate().update((Entity)entityType);
    }

    public void update(Stream<EntityType> entities) {
        this.delegate().update(entities.filter(entityType -> {
            this.entityTypeValidator.validate((EntityType)entityType);
            return true;
        }));
    }

    public void add(EntityType entityType) {
        this.entityTypeValidator.validate(entityType);
        this.delegate().add((Entity)entityType);
    }

    public Integer add(Stream<EntityType> entities) {
        return this.delegate().add(entities.filter(entityType -> {
            this.entityTypeValidator.validate((EntityType)entityType);
            return true;
        }));
    }
}

