/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.validation.meta;

import com.google.common.collect.Multimap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.molgenis.data.DataService;
import org.molgenis.data.MolgenisDataException;
import org.molgenis.data.RepositoryCollection;
import org.molgenis.data.meta.MetaUtils;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.meta.system.SystemEntityTypeRegistry;
import org.molgenis.data.support.AttributeUtils;
import org.molgenis.data.util.EntityUtils;
import org.molgenis.data.validation.ConstraintViolation;
import org.molgenis.data.validation.MolgenisValidationException;
import org.molgenis.data.validation.meta.NameValidator;
import org.molgenis.util.stream.MultimapCollectors;
import org.springframework.stereotype.Component;

@Component
public class EntityTypeValidator {
    private final DataService dataService;
    private final SystemEntityTypeRegistry systemEntityTypeRegistry;

    public EntityTypeValidator(DataService dataService, SystemEntityTypeRegistry systemEntityTypeRegistry) {
        this.dataService = Objects.requireNonNull(dataService);
        this.systemEntityTypeRegistry = Objects.requireNonNull(systemEntityTypeRegistry);
    }

    public void validate(EntityType entityType) {
        EntityTypeValidator.validateEntityName(entityType);
        EntityTypeValidator.validateEntityLabel(entityType);
        this.validatePackage(entityType);
        EntityTypeValidator.validateExtends(entityType);
        EntityTypeValidator.validateOwnAttributes(entityType);
        Map ownAllAttrMap = StreamSupport.stream(entityType.getOwnAllAttributes().spliterator(), false).collect(Collectors.toMap(Attribute::getIdentifier, Function.identity(), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        EntityTypeValidator.validateOwnIdAttribute(entityType, ownAllAttrMap);
        EntityTypeValidator.validateOwnLabelAttribute(entityType, ownAllAttrMap);
        EntityTypeValidator.validateOwnLookupAttributes(entityType, ownAllAttrMap);
        this.validateBackend(entityType);
    }

    private void validateBackend(EntityType entityType) {
        String backendName = entityType.getBackend();
        RepositoryCollection repoCollection = this.dataService.getMeta().getBackend(backendName);
        if (repoCollection == null) {
            throw new MolgenisValidationException(new ConstraintViolation(String.format("Unknown backend [%s]", backendName)));
        }
    }

    private static void validateOwnLookupAttributes(EntityType entityType, Map<String, Attribute> ownAllAttrMap) {
        entityType.getOwnLookupAttributes().forEach(ownLookupAttr -> {
            Attribute ownAttr = (Attribute)ownAllAttrMap.get(ownLookupAttr.getIdentifier());
            if (ownAttr == null) {
                throw new MolgenisValidationException(new ConstraintViolation(String.format("Lookup attribute [%s] is not part of the entity attributes", ownLookupAttr.getName())));
            }
        });
    }

    private static void validateOwnLabelAttribute(EntityType entityType, Map<String, Attribute> ownAllAttrMap) {
        Attribute ownAttr;
        Attribute ownLabelAttr = entityType.getOwnLabelAttribute();
        if (ownLabelAttr != null && (ownAttr = ownAllAttrMap.get(ownLabelAttr.getIdentifier())) == null) {
            throw new MolgenisValidationException(new ConstraintViolation(String.format("Label attribute [%s] is not part of the entity attributes", ownLabelAttr.getName())));
        }
    }

    private static void validateOwnIdAttribute(EntityType entityType, Map<String, Attribute> ownAllAttrMap) {
        Attribute ownIdAttr = entityType.getOwnIdAttribute();
        if (ownIdAttr != null) {
            Attribute ownAttr = ownAllAttrMap.get(ownIdAttr.getIdentifier());
            if (ownAttr == null) {
                throw new MolgenisValidationException(new ConstraintViolation(String.format("Entity [%s] ID attribute [%s] is not part of the entity attributes", entityType.getId(), ownIdAttr.getName())));
            }
            if (!AttributeUtils.isIdAttributeTypeAllowed((Attribute)ownIdAttr)) {
                throw new MolgenisValidationException(new ConstraintViolation(String.format("Entity [%s] ID attribute [%s] type [%s] is not allowed", entityType.getId(), ownIdAttr.getName(), ownIdAttr.getDataType().toString())));
            }
            if (!ownIdAttr.isUnique()) {
                throw new MolgenisValidationException(new ConstraintViolation(String.format("Entity [%s] ID attribute [%s] is not a unique attribute", entityType.getId(), ownIdAttr.getName())));
            }
            if (ownIdAttr.isNillable()) {
                throw new MolgenisValidationException(new ConstraintViolation(String.format("Entity [%s] ID attribute [%s] is not a non-nillable attribute", entityType.getId(), ownIdAttr.getName())));
            }
        } else if (!entityType.isAbstract() && entityType.getIdAttribute() == null) {
            throw new MolgenisValidationException(new ConstraintViolation(String.format("Entity [%s] is missing required ID attribute", entityType.getId())));
        }
    }

    private static void validateOwnAttributes(EntityType entityType) {
        if (EntityUtils.asStream((Iterable)entityType.getAllAttributes()).collect(Collectors.toList()).isEmpty()) {
            throw new MolgenisValidationException(new ConstraintViolation(String.format("Entity [%s] does not contain any attributes. Did you use the correct package+entity name combination in both the entities as well as the attributes sheet?", entityType.getId())));
        }
        Multimap attrMultiMap = (Multimap)EntityUtils.asStream((Iterable)entityType.getAllAttributes()).collect(MultimapCollectors.toArrayListMultimap(Attribute::getName, Function.identity()));
        attrMultiMap.keySet().forEach(attrName -> {
            if (attrMultiMap.get(attrName).size() > 1) {
                throw new MolgenisValidationException(new ConstraintViolation(String.format("Entity [%s] contains multiple attributes with name [%s]", entityType.getId(), attrName)));
            }
        });
        EntityType extendsEntityType = entityType.getExtends();
        if (extendsEntityType != null) {
            Map extendsAllAttrMap = StreamSupport.stream(extendsEntityType.getAllAttributes().spliterator(), false).collect(Collectors.toMap(Attribute::getName, Function.identity(), (u, v) -> {
                throw new IllegalStateException(String.format("Duplicate key %s", u));
            }, LinkedHashMap::new));
            entityType.getOwnAllAttributes().forEach(attr -> {
                if (extendsAllAttrMap.containsKey(attr.getName())) {
                    throw new MolgenisValidationException(new ConstraintViolation(String.format("An attribute with name [%s] already exists in entity [%s] or one of its parents", attr.getName(), extendsEntityType.getId())));
                }
            });
        }
    }

    private static void validateExtends(EntityType entityType) {
        EntityType extendedEntityType;
        if (entityType.getExtends() != null && !(extendedEntityType = entityType.getExtends()).isAbstract()) {
            throw new MolgenisValidationException(new ConstraintViolation(String.format("EntityType [%s] is not abstract; EntityType [%s] can't extend it", entityType.getExtends().getId(), entityType.getId())));
        }
    }

    private static void validateEntityName(EntityType entityType) {
        String name = entityType.getId();
        if (!(name.equals("sys_md_Attribute") || name.equals("sys_md_EntityType") || name.equals("sys_md_Package"))) {
            try {
                NameValidator.validateEntityName(entityType.getId());
            }
            catch (MolgenisDataException e) {
                throw new MolgenisValidationException(new ConstraintViolation(e.getMessage()));
            }
        }
    }

    private static void validateEntityLabel(EntityType entityType) {
        String label = entityType.getLabel();
        if (label != null) {
            if (label.isEmpty()) {
                throw new MolgenisValidationException(new ConstraintViolation(String.format("Label of EntityType [%s] is empty", entityType.getId())));
            }
            if (label.trim().equals("")) {
                throw new MolgenisValidationException(new ConstraintViolation(String.format("Label of EntityType [%s] contains only white space", entityType.getId())));
            }
        }
    }

    private void validatePackage(EntityType entityType) {
        Package package_ = entityType.getPackage();
        if (package_ != null && MetaUtils.isSystemPackage((Package)package_) && !this.systemEntityTypeRegistry.hasSystemEntityType(entityType.getId())) {
            throw new MolgenisValidationException(new ConstraintViolation(String.format("Adding entity [%s] to system package [%s] is not allowed", entityType.getId(), entityType.getPackage().getId())));
        }
    }
}

