/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.validation.meta;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import org.molgenis.data.MolgenisDataException;

public class NameValidator {
    public static final Set<String> KEYWORDS = ImmutableSet.of((Object)"login", (Object)"logout", (Object)"csv", (Object)"base", (Object)"exist", (Object)"meta", (Object[])new String[]{"_idValue"});

    private static void checkForKeyword(String name) {
        if (KEYWORDS.contains(name) || KEYWORDS.contains(name.toUpperCase())) {
            throw new MolgenisDataException("Name [" + name + "] is not allowed because it is a reserved keyword.");
        }
    }

    public static void validateAttributeName(String name) {
        NameValidator.checkForKeyword(name);
        NameValidator.validateName(name);
        if (!name.matches("[a-zA-Z0-9_#]+(-[a-z]{2,3})??$")) {
            throw new MolgenisDataException("Invalid characters in: [" + name + "] Only letters (a-z, A-Z), digits (0-9), underscores (_) and hashes (#) are allowed.");
        }
    }

    public static void validateEntityName(String name) {
        NameValidator.checkForKeyword(name);
        NameValidator.validateName(name);
        NameValidator.checkForIllegalCharacters(name);
    }

    public static void validatePackageId(String name) {
        NameValidator.validateName(name);
        NameValidator.checkForIllegalCharacters(name);
    }

    private static void validateName(String name) {
        if (Character.isDigit(name.charAt(0))) {
            throw new MolgenisDataException("Invalid name: [" + name + "] Names must start with a letter.");
        }
    }

    private static void checkForIllegalCharacters(String name) {
        if (!name.matches("[a-zA-Z0-9_#]+(-[a-z]{2,3})??$")) {
            throw new MolgenisDataException("Invalid characters in: [" + name + "] Only letters (a-z, A-Z), digits (0-9), underscores(_) and hashes (#) are allowed.");
        }
    }
}

