/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.validation.meta;

import java.util.Objects;
import java.util.stream.Stream;
import org.molgenis.data.AbstractRepositoryDecorator;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.UnknownEntityException;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.validation.meta.PackageValidator;

public class PackageRepositoryValidationDecorator
extends AbstractRepositoryDecorator<Package> {
    private final PackageValidator packageValidator;

    public PackageRepositoryValidationDecorator(Repository<Package> delegateRepository, PackageValidator packageValidator) {
        super(delegateRepository);
        this.packageValidator = Objects.requireNonNull(packageValidator);
    }

    public void add(Package package_) {
        this.packageValidator.validate(package_);
        this.delegate().add((Entity)package_);
    }

    public Integer add(Stream<Package> packageStream) {
        return this.delegate().add(packageStream.filter(entityType -> {
            this.packageValidator.validate((Package)entityType);
            return true;
        }));
    }

    public void update(Package package_) {
        this.packageValidator.validate(package_);
        this.delegate().update((Entity)package_);
    }

    public void update(Stream<Package> packageStream) {
        this.delegate().update(packageStream.filter(entityType -> {
            this.packageValidator.validate((Package)entityType);
            return true;
        }));
    }

    public void delete(Package package_) {
        this.packageValidator.validate(package_);
        super.delete((Entity)package_);
    }

    public void delete(Stream<Package> packageStream) {
        this.delegate().delete(packageStream.filter(package_ -> {
            this.packageValidator.validate((Package)package_);
            return true;
        }));
    }

    public void deleteById(Object id) {
        Package package_ = (Package)this.findOneById(id);
        if (package_ == null) {
            throw new UnknownEntityException(String.format("Unknown package [%s]", id.toString()));
        }
        this.packageValidator.validate(package_);
        super.deleteById(id);
    }

    public void deleteAll() {
        this.iterator().forEachRemaining(this.packageValidator::validate);
        super.deleteAll();
    }

    public void deleteAll(Stream<Object> ids) {
        super.deleteAll(ids.map(arg_0 -> ((PackageRepositoryValidationDecorator)this).findOneById(arg_0)).filter(package_ -> {
            this.packageValidator.validate((Package)package_);
            return true;
        }).map(Package::getId));
    }
}

