/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.validation.meta;

import java.util.Objects;
import org.molgenis.data.meta.MetaUtils;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.meta.system.SystemPackageRegistry;
import org.molgenis.data.validation.ConstraintViolation;
import org.molgenis.data.validation.MolgenisValidationException;
import org.molgenis.data.validation.meta.NameValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class PackageValidator {
    private final SystemPackageRegistry systemPackageRegistry;
    private static final Logger LOG = LoggerFactory.getLogger(PackageValidator.class);

    public PackageValidator(SystemPackageRegistry systemPackageRegistry) {
        this.systemPackageRegistry = Objects.requireNonNull(systemPackageRegistry);
    }

    public void validate(Package package_) {
        this.validatePackageAllowed(package_);
        PackageValidator.validatePackageName(package_);
    }

    private void validatePackageAllowed(Package package_) {
        if (MetaUtils.isSystemPackage((Package)package_) && !this.systemPackageRegistry.containsPackage(package_)) {
            LOG.error("validatePackageAllowed, the system package registry does not contain package with id {} and label {}", (Object)package_.getId(), (Object)package_.getLabel());
            throw new MolgenisValidationException(new ConstraintViolation("Modifying system packages is not allowed"));
        }
    }

    private static void validatePackageName(Package package_) {
        NameValidator.validatePackageId(package_.getId());
    }
}

