/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.validation.meta;

import java.util.Objects;
import java.util.stream.Stream;
import org.molgenis.data.AbstractRepositoryDecorator;
import org.molgenis.data.Entity;
import org.molgenis.data.Repository;
import org.molgenis.data.meta.model.Tag;
import org.molgenis.data.validation.meta.TagValidator;

public class TagRepositoryValidationDecorator
extends AbstractRepositoryDecorator<Tag> {
    private final TagValidator tagValidator;

    public TagRepositoryValidationDecorator(Repository<Tag> delegateRepository, TagValidator tagValidator) {
        super(delegateRepository);
        this.tagValidator = Objects.requireNonNull(tagValidator);
    }

    public void update(Tag tag) {
        this.tagValidator.validate(tag);
        super.update((Entity)tag);
    }

    public void add(Tag tag) {
        this.tagValidator.validate(tag);
        super.add((Entity)tag);
    }

    public Integer add(Stream<Tag> tagStream) {
        return this.delegate().add(tagStream.filter(tag -> {
            this.tagValidator.validate((Tag)tag);
            return true;
        }));
    }

    public void update(Stream<Tag> tagStream) {
        this.delegate().update(tagStream.filter(entityType -> {
            this.tagValidator.validate((Tag)entityType);
            return true;
        }));
    }
}

