/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.validation.meta.model;

import java.util.Objects;
import org.molgenis.data.AbstractSystemRepositoryDecoratorFactory;
import org.molgenis.data.DataService;
import org.molgenis.data.Repository;
import org.molgenis.data.meta.AttributeRepositoryDecorator;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.data.meta.model.Attribute;
import org.molgenis.data.meta.model.AttributeMetadata;
import org.molgenis.data.meta.system.SystemEntityTypeRegistry;
import org.molgenis.data.security.meta.AttributeRepositorySecurityDecorator;
import org.molgenis.data.validation.meta.AttributeRepositoryValidationDecorator;
import org.molgenis.data.validation.meta.AttributeValidator;
import org.molgenis.security.core.PermissionService;
import org.springframework.stereotype.Component;

@Component
public class AttributeRepositoryDecoratorFactory
extends AbstractSystemRepositoryDecoratorFactory<Attribute, AttributeMetadata> {
    private final SystemEntityTypeRegistry systemEntityTypeRegistry;
    private final DataService dataService;
    private final PermissionService permissionService;
    private final AttributeValidator attributeValidator;

    public AttributeRepositoryDecoratorFactory(AttributeMetadata attributeMetadata, SystemEntityTypeRegistry systemEntityTypeRegistry, DataService dataService, PermissionService permissionService, AttributeValidator attributeValidator) {
        super((SystemEntityType)attributeMetadata);
        this.systemEntityTypeRegistry = Objects.requireNonNull(systemEntityTypeRegistry);
        this.dataService = Objects.requireNonNull(dataService);
        this.permissionService = Objects.requireNonNull(permissionService);
        this.attributeValidator = Objects.requireNonNull(attributeValidator);
    }

    public Repository<Attribute> createDecoratedRepository(Repository<Attribute> repository) {
        repository = new AttributeRepositoryDecorator(repository, this.dataService);
        repository = new AttributeRepositoryValidationDecorator((Repository<Attribute>)repository, this.attributeValidator);
        return new AttributeRepositorySecurityDecorator((Repository)repository, this.systemEntityTypeRegistry, this.permissionService);
    }
}

