/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.validation.meta.model;

import java.util.Objects;
import org.molgenis.data.AbstractSystemRepositoryDecoratorFactory;
import org.molgenis.data.DataService;
import org.molgenis.data.Repository;
import org.molgenis.data.meta.EntityTypeDependencyResolver;
import org.molgenis.data.meta.EntityTypeRepositoryDecorator;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.data.meta.model.EntityType;
import org.molgenis.data.meta.model.EntityTypeMetadata;
import org.molgenis.data.meta.system.SystemEntityTypeRegistry;
import org.molgenis.data.security.meta.EntityTypeRepositorySecurityDecorator;
import org.molgenis.data.validation.meta.EntityTypeRepositoryValidationDecorator;
import org.molgenis.data.validation.meta.EntityTypeValidator;
import org.molgenis.security.core.PermissionService;
import org.springframework.stereotype.Component;

@Component
public class EntityTypeRepositoryDecoratorFactory
extends AbstractSystemRepositoryDecoratorFactory<EntityType, EntityTypeMetadata> {
    private final DataService dataService;
    private final SystemEntityTypeRegistry systemEntityTypeRegistry;
    private final PermissionService permissionService;
    private final EntityTypeValidator entityTypeValidator;
    private final EntityTypeDependencyResolver entityTypeDependencyResolver;

    public EntityTypeRepositoryDecoratorFactory(DataService dataService, EntityTypeMetadata entityTypeMetadata, SystemEntityTypeRegistry systemEntityTypeRegistry, PermissionService permissionService, EntityTypeValidator entityTypeValidator, EntityTypeDependencyResolver entityTypeDependencyResolver) {
        super((SystemEntityType)entityTypeMetadata);
        this.dataService = Objects.requireNonNull(dataService);
        this.systemEntityTypeRegistry = Objects.requireNonNull(systemEntityTypeRegistry);
        this.permissionService = Objects.requireNonNull(permissionService);
        this.entityTypeValidator = Objects.requireNonNull(entityTypeValidator);
        this.entityTypeDependencyResolver = entityTypeDependencyResolver;
    }

    public Repository<EntityType> createDecoratedRepository(Repository<EntityType> repository) {
        repository = new EntityTypeRepositoryDecorator(repository, this.dataService, this.entityTypeDependencyResolver);
        repository = new EntityTypeRepositoryValidationDecorator((Repository<EntityType>)repository, this.entityTypeValidator);
        return new EntityTypeRepositorySecurityDecorator((Repository)repository, this.systemEntityTypeRegistry, this.permissionService, this.dataService);
    }
}

