/*
 * Decompiled with CFR 0.152.
 */
package org.molgenis.data.validation.meta.model;

import java.util.Objects;
import org.molgenis.data.AbstractSystemRepositoryDecoratorFactory;
import org.molgenis.data.DataService;
import org.molgenis.data.Repository;
import org.molgenis.data.meta.PackageRepositoryDecorator;
import org.molgenis.data.meta.SystemEntityType;
import org.molgenis.data.meta.model.Package;
import org.molgenis.data.meta.model.PackageMetadata;
import org.molgenis.data.validation.meta.PackageRepositoryValidationDecorator;
import org.molgenis.data.validation.meta.PackageValidator;
import org.springframework.stereotype.Component;

@Component
public class PackageRepositoryDecoratorFactory
extends AbstractSystemRepositoryDecoratorFactory<Package, PackageMetadata> {
    private final DataService dataService;
    private final PackageValidator packageValidator;

    public PackageRepositoryDecoratorFactory(PackageMetadata packageMetadata, DataService dataService, PackageValidator packageValidator) {
        super((SystemEntityType)packageMetadata);
        this.dataService = Objects.requireNonNull(dataService);
        this.packageValidator = Objects.requireNonNull(packageValidator);
    }

    public Repository<Package> createDecoratedRepository(Repository<Package> repository) {
        repository = new PackageRepositoryDecorator(repository, this.dataService);
        return new PackageRepositoryValidationDecorator((Repository<Package>)repository, this.packageValidator);
    }
}

