/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.insert.render;

import java.util.Optional;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.insert.render.FieldAndValue;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.util.ConstantMapping;
import org.mybatis.dynamic.sql.util.InsertMappingVisitor;
import org.mybatis.dynamic.sql.util.NullMapping;
import org.mybatis.dynamic.sql.util.PropertyMapping;
import org.mybatis.dynamic.sql.util.PropertyWhenPresentMapping;
import org.mybatis.dynamic.sql.util.StringConstantMapping;

public class ValuePhraseVisitor
extends InsertMappingVisitor<Optional<FieldAndValue>> {
    protected final RenderingStrategy renderingStrategy;

    public ValuePhraseVisitor(RenderingStrategy renderingStrategy) {
        this.renderingStrategy = renderingStrategy;
    }

    @Override
    public Optional<FieldAndValue> visit(NullMapping mapping) {
        return FieldAndValue.withFieldName(mapping.columnName()).withValuePhrase("null").buildOptional();
    }

    @Override
    public Optional<FieldAndValue> visit(ConstantMapping mapping) {
        return FieldAndValue.withFieldName(mapping.columnName()).withValuePhrase(mapping.constant()).buildOptional();
    }

    @Override
    public Optional<FieldAndValue> visit(StringConstantMapping mapping) {
        return FieldAndValue.withFieldName(mapping.columnName()).withValuePhrase("'" + mapping.constant() + "'").buildOptional();
    }

    @Override
    public Optional<FieldAndValue> visit(PropertyMapping mapping) {
        return FieldAndValue.withFieldName(mapping.columnName()).withValuePhrase(mapping.mapColumn(c -> this.calculateJdbcPlaceholder((SqlColumn<?>)c, mapping.property()))).buildOptional();
    }

    @Override
    public Optional<FieldAndValue> visit(PropertyWhenPresentMapping mapping) {
        if (mapping.shouldRender()) {
            return this.visit((PropertyMapping)mapping);
        }
        return Optional.empty();
    }

    private String calculateJdbcPlaceholder(SqlColumn<?> column, String parameterName) {
        return column.renderingStrategy().orElse(this.renderingStrategy).getFormattedJdbcPlaceholder(column, "record", parameterName);
    }
}

