/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.update.render;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.mybatis.dynamic.sql.SqlColumn;
import org.mybatis.dynamic.sql.render.RenderingStrategy;
import org.mybatis.dynamic.sql.render.TableAliasCalculator;
import org.mybatis.dynamic.sql.select.render.SelectRenderer;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.util.AbstractColumnMapping;
import org.mybatis.dynamic.sql.util.ColumnToColumnMapping;
import org.mybatis.dynamic.sql.util.ConstantMapping;
import org.mybatis.dynamic.sql.util.FragmentAndParameters;
import org.mybatis.dynamic.sql.util.NullMapping;
import org.mybatis.dynamic.sql.util.SelectMapping;
import org.mybatis.dynamic.sql.util.StringConstantMapping;
import org.mybatis.dynamic.sql.util.UpdateMappingVisitor;
import org.mybatis.dynamic.sql.util.ValueMapping;
import org.mybatis.dynamic.sql.util.ValueOrNullMapping;
import org.mybatis.dynamic.sql.util.ValueWhenPresentMapping;

public class SetPhraseVisitor
extends UpdateMappingVisitor<Optional<FragmentAndParameters>> {
    private final AtomicInteger sequence;
    private final RenderingStrategy renderingStrategy;

    public SetPhraseVisitor(AtomicInteger sequence, RenderingStrategy renderingStrategy) {
        this.sequence = Objects.requireNonNull(sequence);
        this.renderingStrategy = Objects.requireNonNull(renderingStrategy);
    }

    @Override
    public Optional<FragmentAndParameters> visit(NullMapping mapping) {
        return FragmentAndParameters.withFragment(mapping.columnName() + " = null").buildOptional();
    }

    @Override
    public Optional<FragmentAndParameters> visit(ConstantMapping mapping) {
        String fragment = mapping.columnName() + " = " + mapping.constant();
        return FragmentAndParameters.withFragment(fragment).buildOptional();
    }

    @Override
    public Optional<FragmentAndParameters> visit(StringConstantMapping mapping) {
        String fragment = mapping.columnName() + " = '" + mapping.constant() + "'";
        return FragmentAndParameters.withFragment(fragment).buildOptional();
    }

    @Override
    public <T> Optional<FragmentAndParameters> visit(ValueMapping<T> mapping) {
        return this.buildFragment(mapping, mapping.value());
    }

    @Override
    public <T> Optional<FragmentAndParameters> visit(ValueOrNullMapping<T> mapping) {
        return mapping.value().map(v -> this.buildFragment(mapping, v)).orElseGet(() -> FragmentAndParameters.withFragment(mapping.columnName() + " = null").buildOptional());
    }

    @Override
    public <T> Optional<FragmentAndParameters> visit(ValueWhenPresentMapping<T> mapping) {
        return mapping.value().flatMap(v -> this.buildFragment(mapping, v));
    }

    @Override
    public Optional<FragmentAndParameters> visit(SelectMapping mapping) {
        SelectStatementProvider selectStatement = ((SelectRenderer.Builder)((SelectRenderer.Builder)SelectRenderer.withSelectModel(mapping.selectModel()).withRenderingStrategy(this.renderingStrategy)).withSequence(this.sequence)).build().render();
        String fragment = mapping.columnName() + " = (" + selectStatement.getSelectStatement() + ")";
        return FragmentAndParameters.withFragment(fragment).withParameters(selectStatement.getParameters()).buildOptional();
    }

    @Override
    public Optional<FragmentAndParameters> visit(ColumnToColumnMapping mapping) {
        String setPhrase = mapping.columnName() + " = " + mapping.rightColumn().renderWithTableAlias(TableAliasCalculator.empty());
        return FragmentAndParameters.withFragment(setPhrase).buildOptional();
    }

    private <T> Optional<FragmentAndParameters> buildFragment(AbstractColumnMapping mapping, T value) {
        String mapKey = RenderingStrategy.formatParameterMapKey(this.sequence);
        String jdbcPlaceholder = mapping.mapColumn(c -> this.calculateJdbcPlaceholder((SqlColumn<?>)c, mapKey));
        String setPhrase = mapping.columnName() + " = " + jdbcPlaceholder;
        return FragmentAndParameters.withFragment(setPhrase).withParameter(mapKey, value).buildOptional();
    }

    private String calculateJdbcPlaceholder(SqlColumn<?> column, String parameterName) {
        return column.renderingStrategy().orElse(this.renderingStrategy).getFormattedJdbcPlaceholder(column, "parameters", parameterName);
    }
}

