/*
 * Decompiled with CFR 0.152.
 */
package org.mybatis.dynamic.sql.where.condition;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mybatis.dynamic.sql.AbstractListValueCondition;
import org.mybatis.dynamic.sql.Callback;
import org.mybatis.dynamic.sql.util.StringUtilities;

public class IsNotInCaseInsensitive
extends AbstractListValueCondition<String> {
    private static final IsNotInCaseInsensitive EMPTY = new IsNotInCaseInsensitive((Collection<String>)Collections.emptyList());

    public static IsNotInCaseInsensitive empty() {
        return EMPTY;
    }

    private IsNotInCaseInsensitive emptyWithCallback() {
        return new IsNotInCaseInsensitive((Collection<String>)Collections.emptyList(), this.emptyCallback);
    }

    protected IsNotInCaseInsensitive(Collection<String> values) {
        super(values);
    }

    protected IsNotInCaseInsensitive(Collection<String> values, Callback emptyCallback) {
        super(values, emptyCallback);
    }

    @Override
    public String renderCondition(String columnName, Stream<String> placeholders) {
        return "upper(" + columnName + ") " + placeholders.collect(Collectors.joining(",", "not in (", ")"));
    }

    public IsNotInCaseInsensitive withListEmptyCallback(Callback callback) {
        return new IsNotInCaseInsensitive(this.values, callback);
    }

    public IsNotInCaseInsensitive filter(Predicate<? super String> predicate) {
        return this.filterSupport(predicate, IsNotInCaseInsensitive::new, this, this::emptyWithCallback);
    }

    public IsNotInCaseInsensitive map(UnaryOperator<String> mapper) {
        return this.mapSupport(mapper, IsNotInCaseInsensitive::new, this::emptyWithCallback);
    }

    public static IsNotInCaseInsensitive of(String ... values) {
        return IsNotInCaseInsensitive.of(Arrays.asList(values));
    }

    public static IsNotInCaseInsensitive of(Collection<String> values) {
        return new IsNotInCaseInsensitive(values).map(StringUtilities::safelyUpperCase);
    }
}

